/*
  replacemsg_image.js - misc JS code for sys_replacemsg_image.c
  init Dec 2014 by Shuyu Sun
  Copyright Fortinet Ltd
*/

function replacemsgimg_handle_selection_change(q)
{
    var aElems = q.get_checked_rows();
    var enable_edit = false;

    qlist_handle_selection_change(q);

    if (aElems.length == 1)
    {
        var can_edit = parseInt(aElems[0].getAttribute("can_edit"));
        if (can_edit) enable_edit = true;
    }

    if (enable_edit == false)
    {
        qmenu_enable_button($j('#' + q.edit_btn_id), enable_edit, q);
    }
}
function qlist_dblclick_row(q, obj, ev) {
	if (q.dblclick_fn) {
		q.dblclick_fn(q, obj);
	} else if (q.create_edit) {
		var editable = q.can_edit_fn(q, obj);
		if (editable) q.edit_elem_fn(q, obj);
	}
}

function replacemsgimg_dblclick_fn(q, obj)
{
	// Only edit if can_edit=true
	if (parseInt(obj.getAttribute("can_edit")))
	{
		q.dblclick_fn = null;
		try
		{
			var newobj = null;
			qlist_dblclick_row(q, obj);
			q.dblclick_fn = replacemsgimg_dblclick_fn;
        }
        catch (e)
        {
            q.dblclick_fn = replacemsgimg_dblclick_fn;
            throw (e);
        }
    }
}

function replacemsgimage_return_click()
{
    window.location.href="/system/replacemsg/layout";
}
 
// replacemsgimage_onload - onload handler for the admin profile list page.
function replacemsgimage_onload()
{
    qlist_obj.create_new = to_create_new;
    qlist_obj.create_edit = has_non_readonly;
    qlist_obj.create_del = has_non_readonly;

    qlist_obj.handle_selection_change_fn = replacemsgimg_handle_selection_change;
    qlist_obj.dblclick_fn = replacemsgimg_dblclick_fn;
    qlist_setup("qlist", "/system/replacemsg/imagedlg", "/system/replacemsg/imagedlg", false);
}

addEvent(window, "load", replacemsgimage_onload);

