/*
  replacemsglist.js - Javascript code for replacement message
    and replace message group list pages
  init Jan 2012 by Joseph Tary
  FOS 5.0 Replacement Message Enhancements
  Copyright Fortinet Ltd
*/

/*global qlist_handle_selection_change, getQueryValue */

var replacemsglist = (function($) {
    "use strict";

    var modified_ico = {};
    var config = {
        "edit_url" : "/system/replacemsg/tableedit",
        "mode" : "simple",
        "group" : null
    };

    function setup_qlist(content) {
        var qlist_settings = {
            'columns': content.columns,
            'row_attr': content.row_attr,
            'source' : content.source,
            'mkey_selector': "msg-type",
            'handle_selection_change': qlist_onselect,
            'menu_items': qlist_menu(),
            'options': {
		'hide_checkboxes': true,
		'hide_default_buttons' : true,
		'sorting': false,
		'disable_context_menu': true
            },
            'default_sort': [{selector: 'label', direction: 'asc'}],
            'category': {
                'sorted': config["mode"] !== "simple",
                'collapsible': false
            },
            'format_fn' : {
                '*':first_row_selected,
                'message-modified' : function(element, column, config) {
                    var key = config['msg-type'];
                    var value = config[column.selector];
                    var style = "";

                    if (!config[column.selector]) {
                        style = "none";
                    }

                    modified_ico[key] = $("<span class=\"fa-enabled\"></span>")
                        .css("display", style);

                    return modified_ico[key];
                },
                'description' : function(element, column, config) {
                    return config[column.selector];
                }
            }
        };

        $("div#content").empty().qlist(qlist_settings);
    }
    function first_row_selected(element, column, config) {
        if(config.category == 1 && element.parent()[0].getAttribute("data-source-index") == 0){
            element.parent().toggleClass('selected' , true);
        }
    }
    function handle_view_mode_click(evt) {
        var mode = $(evt.target).val();
        change_view_mode(mode);

        return false;
    }

    function change_view_mode(mode) {
        var url = window.location.pathname + "?mode=" + mode;
        window.location.href = url;
    }

    function qlist_menu() {
        var menu = {};

        if (config.group == null || config.group == "default") {
            if(is_rw_admin){
                menu["mi_edit_new"] = {
                    'ctxt' : true,
                    "class" : "tool_edit",
                    "label" : $.getInfo("edit"),
                    "handler" : edit_retcode
                };            
            }
        }

        return menu;

        function edit_retcode(q, rows) {
            rows = q.get_checked_rows();
            var row = rows.length > 0 ? rows[0] : null;
            var url = "/system/replacemsg/tableedit_retcode";
            if (row) {
                var msg_type = $(row).attr("msg-type");
                var retcode = $(row).attr("retcode");
                url = url + "?mkey="+mkey+"&table_key="+msg_type;
            }
            window.parent.location.href = url;
        }
    }

    function qlist_onselect(q, rows) {
        qmenu_enable_button($("#mi_edit_new_qlist"), false, q);
        rows = q.get_checked_rows();
        var row = rows.length > 0 ? rows[0] : null;
        var url = config.edit_url;

        if (row) {
            var msg_type = $(row).attr("msg-type");
            var category = $(row).attr("category");
            if(msg_type == "url-block")
            {
                qmenu_enable_button($("#mi_edit_new_qlist"), true, q);
            }else{
                qmenu_enable_button($("#mi_edit_new_qlist"), false, q);
            }
            //url = url + [ category, msg_type ].join("/");
            url = url + "?mkey="+mkey+"&table_key="+msg_type;
        }

        if (typeof window.parent.frames["preview"] !== "undefined") {
            window.parent.frames["preview"].location.href = url;
        }        

        return qlist_handle_selection_change(q);
    }

    function init(params) {
        var mode = getQueryValue(window.location.href, "mode");
        config = $.extend({}, config, params);

        if (mode !== "") {
            config.mode = mode;
        }

        $.ajax({
            "url" : window.location.href,
            "data" : { "mode" : config.mode },
            "dataType" : "json",
            "success" : setup_qlist,
            "cache" : false
        });

        $("input[name=view_type]").click(handle_view_mode_click).prop("checked", function() {
                    return $(this).val() == config.mode;
                });
    }

    function toggle_modified_state(key, state) {
        if (key in modified_ico) {
            var ico = modified_ico[key];

            if (state === true) {
                $(ico).fadeIn("slow");
            } else {
                $(ico).fadeOut("slow");
            }
        }

        return state;
    }

    return {
        "init": init,
        "toggle_modified_state": toggle_modified_state
    };
})(jQuery);
