var replacemsgview = (function($) {
	var settings = {
		"max_length": 32768,
		"max_tag":32,
		"read_only": false,
		"editor_mode": "text/html",
		"is_default": false,
		"callback": null
	};
	var layout_selector = "#container";
	var layout;
	var menu;
	var editor;
	var editor_ready = $.Deferred();
	var is_dirty = false;
	var is_default = false;
	var usage_dsp = null;
	var toggle_list_default = function() {
		return false;
	};
	var preview_mask = null;

	function init(params) {
		settings = $.extend({}, settings, params);
		setup_layout();
		setup_qmenu(settings["read_only"]);
		setup_editor(settings["editor_mode"], settings["read_only"]);
		toggle_is_dirty(false);
		toggle_is_default(settings["is_default"]);
		if (typeof settings["callback"] === "function") {
			settings["callback"].apply(this);
		}
		if ("list" in window.parent.frames) {
			var list_view = window.parent.frames["list"];
			if (typeof list_view.replacemsglist == "object" && typeof list_view.replacemsglist.toggle_modified_state == "function") {
				toggle_list_default = list_view.replacemsglist.toggle_modified_state;
			}
		}
		preview_mask = $("<div id='preview_mask'></div>");
		$('#preview_pane').append(preview_mask).scroll(function(x, y, z) {
			$(preview_mask).css({
				"top": this.scrollTop + "px",
				"left": this.scrollLeft + "px",
			});
		});
		window.onbeforeunload = function() {
			if (is_dirty) {
				return $.getInfo("err_unsaved");
			}
		};
	}

	function update_length(val) {
		/* add this for tag limit*/
		var tag = val.match(/%%(\w+)(?:\:(.+?))?%%/g);
		var key,i,count;
		i=0;
		count = 0;
		while (tag && tag[i]) 
		{
			if (tag[i].indexOf("IMAGE") !== -1) {
				key = tag[i].replace(/%IMAGE:/, "");
				key = key.replace(/%/g, "");
				if(image_val[key]) count++;
			} else {
				key = tag[i].replace(/%/g, "");
				if(rep_val[key]) count++;
			}
			i++;
		}

		var over_limit_tag = count > settings["max_tag"];

		var over_limit = val.length > settings["max_length"];
		var usage_disp = $("#usage_display");
		if (usage_dsp === null) {
			usage_dsp = $("<div class=\"usage\"></div>").appendTo("#menu_pane");
		}
		size_msg = $("<span class=\"msg_info\"></span>").text($.getInfo("message_size") + ": " + val.length + "/" + settings["max_length"]).toggleClass("usage-over", over_limit);
		format_msg = $("<span class=\"msg_info\"></span>").text($.getInfo("message_format") + ": " + settings["editor_mode"]);
		var tag_msg = $("<span class=\"msg_info\"></span>").text($.getInfo("message_tag") + ": " + count + "/" + settings["max_tag"]).toggleClass("usage-over", over_limit_tag);
		usage_dsp.empty().append(format_msg).append(size_msg).append(tag_msg);
		menu.set_menu_button_state("menu-save", !over_limit&&!over_limit_tag, true);
	}

	function toggle_is_default(value) {
		if (typeof value == "undefined") {
			value == !is_default;
		}
		is_default = value;
		menu.set_menu_button_state("menu-revert", !is_default, true);
	}

	function toggle_is_dirty(value) {
		if (typeof value == "undefined") {
			value == !is_dirty;
		}
		is_dirty = value;
		menu.set_menu_button_state("menu-save", is_dirty, true);
	}

	function setup_editor(mode, read_only) {
		var delay;
		var buffer;
		buffer = $("#buffer").get(0);
		if (buffer) {
			editor = CodeMirror.fromTextArea(buffer, {
				mode: "htmlmixed",
				tabMode: 'indent',
				readOnly: read_only
			});
			editor.on("change", function() {
				clearTimeout(delay);
				delay = setTimeout(updatePreview, 300);
				toggle_is_dirty(true);
				toggle_is_default(false);
				update_length(editor.getValue());
			});
			editor.on("keyup", function(cm, event) {
				var pos = cm.getCursor(),
					$keycodes = $.ui.keyCode,
					is_valid_image = event.keyCode !== $keycodes.UP && event.keyCode !== $keycodes.DOWN && event.keyCode !== $keycodes.ESCAPE && event.keyCode !== $keycodes.LEFT && event.keyCode !== $keycodes.RIGHT,
					is_valid_text = is_valid_image && (event.keyCode !== $keycodes.ENTER),
					trigger = {
						"text": "%%",
						"image": "%%IMAGE:"
					},
					pre_text = {
						"line": pos.line,
						"ch": pos.ch - trigger["text"].length
					},
					pre_image = {
						"line": pos.line,
						"ch": pos.ch - trigger["image"].length
					};
				var trigger_keyword_text = cm.getRange(pre_text, pos),
					trigger_keyword_image = cm.getRange(pre_image, pos);
				if (trigger_keyword_text === trigger["text"] && is_valid_text) {
					showhintByType(cm, CodeMirror.hint.text, "text", rep_val, pos, "keyup");
				} else if ((trigger_keyword_image.toLowerCase() === trigger["image"].toLowerCase()) && is_valid_image) {
					showhintByType(cm, CodeMirror.hint.image, "image", image_val, pos, "keyup");
				}
			});
			if (mode != "text/plain") {
				editor.autoFormatRange(editor.posFromIndex(0), editor.posFromIndex(editor.getValue().length));
			} else {
				updatePreview();
			}
			update_length(editor.getValue());
			editor.setCursor(0, 0);
			setUpContextMenu(editor);
			initToolTip(editor);
			editor_ready.resolve();
		}

		function setUpContextMenu(cm) {
			var pos;
			var replacemsg_item_data = [{
				text: $.getInfo("insert_image"),
				onclick: {
					fn: showImageHint
				}
			}, {
				text: $.getInfo("insert_tag"),
				onclick: {
					fn: showTextHint
				}
			}];
			var replacemsg_contextmenu = new YAHOO.widget.ContextMenu("replacemsgcontextmenu", {
				trigger: "replacemsg_form",
				itemdata: replacemsg_item_data,
				lazyload: true
			});
			replacemsg_contextmenu.render("replacemsg_form");

			function showImageHint() {
				pos = cm.getCursor();
				showhintByType(cm, CodeMirror.hint.image, "image", image_val, pos, "contextmenu");
				cm.focus();
			}

			function showTextHint() {
				pos = cm.getCursor();
				showhintByType(cm, CodeMirror.hint.text, "text", rep_val, pos, "contextmenu");
				cm.focus();
			}
		}

		function showhintByType(cm, fn, type, obj, pos, event_type) {
			CodeMirror.showHint(cm, fn, getAutoCompleteConfig(obj, pos, type, event_type));
		}

		function getAutoCompleteConfig(obj, pos, type, event_type) {
			var sorted_keywords = Object.keys(obj),
				config_collection = [],
				description_key = "tag_desc_";
			sorted_keywords.sort();
			for (var i = 0; i < sorted_keywords.length; i++) {
				if (!obj[sorted_keywords[i]]) {
					continue;
				}
				var config = {};
				config.key = sorted_keywords[i];
				config.value = (type === "image") ? "data:image/png;base64," + obj[sorted_keywords[i]] : $.getInfo(description_key + sorted_keywords[i]);
				config.pos = pos;
				config.type = type;
				config.event = event_type;
				config_collection.push(config);
			}
			return config_collection;
		}

		function initToolTip(cm) {
			var key_idx = 0;
			cm.eachLine(function(line) {
				var mark_text_config = {
						className: "cm-replacemsg-keywords"
				},
				line_num = cm.getLineNumber(line),
				line_text = line.text,
				regexr = /%%\w+:?\w*%%/g,
				keywords = line_text.match(regexr);
				if (keywords) {
					for (var i = 0; i < keywords.length; i++) {
						var from = {},
							to = {};
						from.line = to.line = line_num;
						from.ch = line_text.indexOf(keywords[i]);
						to.ch = from.ch + keywords[i].length;
						mark_text_config.className = "cm-replacemsg-keywords";
						mark_text_config.className += " key_index" + key_idx;
						cm.markText(from, to, mark_text_config);
						key_idx++;
					}
				}
				/* add this for sph_  tips*/
				regexr = /sph_\w+/g;
				keywords = line_text.match(regexr);
				if (keywords in sph_val) {
					for (var i = 0; i < keywords.length; i++) {
						var from = {},
							to = {};
						from.line = to.line = line_num;
						from.ch = line_text.indexOf(keywords[i]);
						to.ch = from.ch + keywords[i].length;
						mark_text_config.className = "cm-replacemsg-keywords";
						mark_text_config.className += " key_index" + key_idx;
						cm.markText(from, to, mark_text_config);
						key_idx++;
					}
				}
			});
			mergeHighlighElement(cm);
			$('.CodeMirror-code').delegate(".cm-replacemsg-keywords", "mouseover", function(e) {
				var regexr = /%%\w+:?\w*%%/g,
					tag = $(this).text().match(regexr);
				var preview, key, value;
				if (tag) {
					if (tag[0].indexOf("IMAGE") !== -1) {
						key = tag[0].replace(/%IMAGE:/, "");
						key = key.replace(/%/g, "");
						value = "data:image/png;base64," + image_val[key];
						preview = document.createElement("div");
						preview.id = "cm-tag-preview";
						var preview_title = generateElement("div", "cm-tag-preview-title");
						var preview_sample = generateElement("div", "cm-tag-preview-sample");
						$(preview_title).text(key);
						$(preview_sample).text(escapeHTML(tag[0]));
						preview.appendChild(preview_title);
						if (isCanvasSupported()) {
							var preview_desc = generateElement("div", "cm-tag-preview-desc");
							resizeImage(value, renderCanvas, preview_desc);
							preview.appendChild(preview_desc);
						}
						preview.appendChild(preview_sample);
					} else {
						key = tag[0].replace(/%/g, "");
						value = $.getInfo("tag_desc_" + key);
						if(rep_val[key]){
							tag[0] = truncateString(rep_val[key], 150);
							preview = "<div id=\"cm-tag-preview\">" + "<div class=\"cm-tag-preview-title\">" + key + "</div>" + "<div class=\"cm-tag-preview-desc\">" + value + "</div>" + "<div class=\"cm-tag-preview-sample\">" + escapeHTML(tag[0]) + "</div>" + "</div>";
						}
					}
				}
				/* add this for sph_  tips*/
				regexr = /sph_\w+/g;
				tag = $(this).text().match(regexr);
				if (tag) {	
					key = tag[0].replace(/%/g, "");
					value = $.getInfo("tag_desc_" + key);
					if(sph_val[key]){
						tag[0] = truncateString(sph_val[key], 150);
						preview = "<div id=\"cm-tag-preview\">" + "<div class=\"cm-tag-preview-title\">" + key + "</div>" + "<div class=\"cm-tag-preview-desc\">" + value + "</div>" + "<div class=\"cm-tag-preview-sample\">" + escapeHTML(tag[0]) + "</div>" + "</div>";
					}
				}

				$("body").append(preview);
				$("#cm-tag-preview").css({
					"top": e.pageY + "px",
					"left": e.pageX + "px"
				}).show();
			});
			$('.CodeMirror-code').delegate(".cm-replacemsg-keywords", "mouseout", function() {
				$("#cm-tag-preview").remove();
			});

			function generateElement(type, class_name) {
				var elem = document.createElement(type);
				elem.className = class_name;
				return elem;
			}

			function resizeImage(url, callback, container) {
				var sourceImage = new Image();
				var canvas = document.createElement("canvas");
				sourceImage.onload = function() {
					var resized_demension = getResizedDemension(this.width, this.height, 150, 150);
					canvas.width = resized_demension.width;
					canvas.height = resized_demension.height;
					canvas.getContext("2d").drawImage(sourceImage, 0, 0, resized_demension.width, resized_demension.height);
					callback(canvas.toDataURL(), resized_demension.width, resized_demension.height, container);
				};
				sourceImage.src = url;
			}

			function renderCanvas(dataurl, width, height, container) {
				var img = new Image();
				var canvas = document.createElement("canvas");
				var parent_height = 64;
				img.onload = function() {
					canvas.width = width;
					canvas.height = height;
					canvas.style.paddingTop = (parent_height - height) / 2 + "px";
					canvas.getContext('2d').drawImage(img, 0, 0, width, height);
				};
				img.src = dataurl;
				container.appendChild(canvas);
			}

			function getResizedDemension(width, height, max_width, max_height) {
				var ratio = 0;
				if (width > max_width) {
					ratio = max_width / width;
					width = width * ratio;
					height = height * ratio;
				}
				if (height > max_height) {
					ratio = max_height / height;
					height = height * ratio;
					width = width * ratio;
				}
				return {
					"width": width,
					"height": height
				};
			}

			function truncateString(s, max_length) {
				if (s.length > max_length) {
					s = s.substring(0, max_length) + "..."
				}
				return s;
			}

			function isCanvasSupported() {
				var elem = document.createElement('canvas');
				return !!(elem.getContext && elem.getContext('2d'));
			}
		}

		function mergeHighlighElement(cm) {
			$('.CodeMirror-code').delegate("pre", "mouseover", function() {
				var class_name = "";
				$(this).find("span").each(function() {
					if ($(this).hasClass("cm-replacemsg-keywords")) {
						var class_list = this.className.split(/\s+/);
						class_name = class_list[2];
					}
				});
				if (class_name) {
					var selector_class_name = "." + class_name,
						$selector = $(selector_class_name);
					if ($selector.length > 1) {
						var keyword = "";
						first_match_elem = $selector[0];
						insert_index = $(this).find("span").index(first_match_elem);
						$selector.each(function() {
							keyword += $(this).text();
						});
						if (keyword) {
							var merge_highligh_elem = "<span class=\"cm-replacemsg-keywords\">" +
								keyword + "</span>";
							$(this).find(selector_class_name).remove();
							$(merge_highligh_elem).insertAfter($(this).find("span").eq(insert_index - 1));
						}
					}
				}
			});
		}

		function updatePreview() {
			var previewFrame = document.getElementById('preview');
			var previewPane = document.getElementById('preview_pane');
			var preview = previewFrame.contentDocument || previewFrame.contentWindow.document;
			var raw = editor.getValue();
			var raw = raw.replace(/<script[\s\S]*?>[\s\S]*?<\/script[\s\S]*?>/gi, function(m) {
				return "";
			});
			var finishCount = 0;
			var processed = raw.replace(/%%(\w+)(?:\:(.+?))?%%/ig, function(m, key, arg) {
				v = key in rep_val ? rep_val[key] : m;
				if (typeof v == "function") {
					return v(arg);
				}
				return v;
			});
			preview.open();
			preview.innerHTML = "";
			if (mode == "text/plain") {
				preview.write("<pre>");
			}
			preview.writeln(processed);
			if (mode == "text/plain") {
				preview.write("</pre>");
			}
			if (preview_mask === null) {}
			finish();

			function finish() {
				if (preview.body === null) {
					if (finishCount++ < 100) {
						setTimeout(finish, 10);
					}
				} else {
					$(previewFrame).height($(preview).height());
					$(previewFrame).width($(preview).width());
					preview.close();
				}
			}
		}
	}

	function setup_qmenu(read_only) {
		menu = (function() {
			var menu;
			var pane;
			var container;
			var buttons = [{
				'id': 'save',
				'readOnly': false,
				'text': $.getInfo('save'),
				'spriteClass': 'tool_enable',
				'click': {
					'fn': menu_save_handler
				}
			}, {
				'id': 'revert',
				'readOnly': false,
				'text': $.getInfo('restore'),
				'click': {
					'fn': menu_revert_handler
				}
			}];
			pane = $("#menu_pane").addClass("qlist_hdrbar");
			container = $("<div id=\"qlist_yui_menubar_container\"></div>").appendTo(pane);
			if (container.length > 0) {
				var qmenu = {
					'customize_menu_fn': build_menu
				};
				menu = qmenu_create_menubar("qlist_yui_menubar", qmenu, read_only);
				menu.render(container[0]);
			}

			function menu_save_handler() {
				var url = window.location.pathname;
				var form_data = $("#replacemsg_form").serializeArray();
				var post_data = [];
				for (i in form_data) {
					if (typeof form_data[i] !== "object") {
						continue;
					}
					if (form_data[i]["name"] === "buffer" && !is_default) {
						post_data.push({
							"name": "buffer",
							"value": editor.getValue()
						});
					}
					if (form_data[i]["name"] === "default_msg" && is_default) {
						post_data.push({
							"name": "buffer",
							"value": form_data[i].value
						});
						post_data.push({
							"name": "reset",
							"value": true
						});
					}
					if (!(form_data[i]["name"] in {
							"buffer": true,
							"default_msg": true
						})) {
						post_data.push(form_data[i]);
					}
				}
				set_menu_button_active("menu-save", true);
				$.post(url, post_data, save_success);
				return false;

				function save_success(result) {
					set_menu_button_active("menu-save", false);
					toggle_is_dirty(false);
					if(result.status == 0)
					{
						error_handler(result.msg_id, window.location.href);
					}else{						
						toggle_list_default(settings["msg_type"], !is_default);
						/*
						if (fweb.dialog().length) {
							dlg_close(is_default ? 'reset' : 'save');
						}
						*/				
					}

				}
			}

			function menu_revert_handler() {
				editor_ready.done(function() {
					var default_msg = $("input#default_msg");
					editor.setValue(default_msg.val());
					if (settings["editor_mode"] != "text/plain") {
						editor.autoFormatRange(editor.posFromIndex(0), editor.posFromIndex(editor.getValue().length));
					}
					toggle_is_dirty(true);
					toggle_is_default(true);
					return false;
				});
			}

			function set_menu_button_active(id, state) {
				var button = $('span.tool_sprite', '#' + id);
				button.toggleClass("tool_active", state);
			}

			function get_menu_button_state(id) {
				var item = menu.getItemById(id);
				if (item) {
					var disabled = item.cfg.getProperty("disabled");
					return !disabled;
				}
				return false;
			}

			function set_menu_button_state(id, state, show) {
				if (typeof show === 'undefined') {
					show = true;
				}
				var item = menu.getItemById(id);
				if (item) {
					item.cfg.setProperty("disabled", !state);
					$('#' + id).toggle(show);
				}
			}

			function build_menu(menu_items) {
				for (var i = 0; i < buttons.length; i++) {
					var config = buttons[i];
					var id = config['id'];
					if (typeof id === 'undefined') {
						continue;
					}
					if (read_only === true && config['readOnly'] === false) {
						continue;
					}
					var menu_item = {
						'spriteClass': 'tool_' + id,
						'ctxt': false,
						'text': $.getInfo(id)
					};
					config['id'] = 'menu-' + id;
					$.extend(menu_item, config);
					menu_items.push(Page.createMenuItem(menu_item));
				}
			}

			function error_handler(msg_id, url){
			        switch (msg_id){
			                case 0:
			                        document.location.href = url;
			                        break;
			                case -30:
			                        top.location.href = "/login";
			                        break;
			                case -37:
			                        document.location.href = "/noaccess?redir=" + url;
			                        break;
			                default :
			                        document.location.href = "/error2?msg=" + msg_id + "&url=" + encodeURIComponent(url);
			                        break;
			        }
			}
			return {
				"set_menu_button_state": set_menu_button_state,
				"get_menu_button_state": get_menu_button_state
			};
		})();
	}

	function setup_layout() {
		$("h1").remove();
		$("div.footer").detach().appendTo("div.dlg");
		layout_elem = $(layout_selector).layout({
			"defaults": {
				"spacing_open": 3,
				"spacing_closed": 3
			},
			"north": {
				"paneSelector": "#menu_pane",
				"size": 22,
				"resizable": false,
				"closable": false,
				"spacing_open": 0
			},
			"south": {
				"paneSelector": "div.footer",
				"size": 28
			},
			"center": {
				"paneSelector": "#preview_pane"
			},
			"east": {
				"paneSelector": "#edit_pane",
				"size": "37.5%",
				"resizable": true,
				"closable": false
			}
		});
	}

	function get_buffer() {
		return editor.getValue();
	}
	return {
		"init": init,
		"buffer": get_buffer
	};
})(jQuery);
