/*
  server_protection.js - misc JS code for waf_server_protection_rule.c
  init Mar 2011 by Jianjiang Yan
  GUI redesign project
  Copyright Fortinet Inc
*/
// server_protection_handle_selection_change - enable/disable the password button
// according to the current selection.
function server_protection_handle_selection_change(q)
{
    // Let the default handler handle the standard buttons.
    qlist_handle_selection_change(q);

    var aElems = q.get_checked_rows();
	
    if(!is_rw_admin)
    {
	qmenu_enable_button($("mi_view"), true, q);
	return;
    }

    if (aElems.length == 1 && parseInt(aElems[0].getAttribute("can_clone")) == 1)
    {
        qmenu_enable_button($("mi_view"), true, q);
        qmenu_enable_button($("mi_clone"), true, q);
        qmenu_enable_button($("mi_edit"), false, q);
        //qmenu_enable_button($("mi_del"), false, q);
    }else{
        qmenu_enable_button($("mi_view"), false, q);
        qmenu_enable_button($("mi_clone"), false, q);
        //qmenu_enable_button($("mi_edit"), true, q);
    }
}

// server_protection_menu - Override the default menubar to add buttons "Generate",
//             "Import", "View", "Download" and "Edit Commones".
function server_protection_menu(aItems)
{
    if (can_clone && is_rw_admin) {
        var mNew = Page.createMenuItem({id:"mi_view", spriteClass:"tool_view", ctxt:true,
                   text:server_protection_strtbl.view, click:{fn: server_protection_onclick_view} });
        aItems.push(mNew);
        var mNew = Page.createMenuItem({id:"mi_clone", spriteClass:"tool_clone", ctxt:true,
                   text:server_protection_strtbl.clone, click:{fn: server_protection_onclick_clone} });
        aItems.push(mNew);
    }
}
function server_protection_onclick_clone()
{   
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;

    var mkey = aElems[0].getAttribute("mkey");

    window.location.href = "/waf/server_protection/dlgcopy?mkey=" + mkey;
}
function server_protection_onclick_view()
{   
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;

    var mkey = aElems[0].getAttribute("mkey");

    window.location.href = "/waf/server_protection/dlg?mkey=" + mkey;
}
// server_protectionlist_onload - onload handler for the interface list page.
function server_protectionlist_onload()
{
    // Customize the qlist definition.
    qlist_obj.customize_menu_fn = server_protection_menu;
    qlist_obj.handle_selection_change_fn = server_protection_handle_selection_change;

    qlist_setup("qlist", "/waf/server_protection/dlg", "/waf/server_protection/dlg",false);
}
hlight_table('qlist', 1, 0, 'over');

addEvent(window, "load", server_protectionlist_onload);
