/*
  filter.js - core JS code for filter dialogs. Imported from fgt_display.c 
  init Jan. 2010 by J. Thompson
  GUI redesign project
  Copyright Fortinet Ltd
*/
var filter_settings = {};

function doOK(panel)
{
    var filterCookieArray = [];

    var err = 0;

    $j(panel).filterSection(
        function (flt) {
            if (!validate(flt)) {
                err = 1;
                return false;
            }
            var filter = flt2DisplayFilter(flt);
            filter.enable = flt.value && flt.value.join("").length ? filter.enable : 0;
            if (filter.enable)
                filterCookieArray = setDisplayFilter(filterCookieArray, filter);
        });

    if (err) return false;

    setCookie(filterCookieName, serializeArray(filterCookieArray));
    // reset to first page
    var url = setQueryValue(location.href, "start");
    window.location = setQueryValue(url, "expanded", $j("input[name=expanded]", panel).val());

    return false;
}

function XX_do_notify_parent()
{
    var tmp_obj = new Object();
    tmp_obj.filter_str = serializeArray(filterCookieArray);

    var pwnd = (window.opener ? window.opener : window.parent);

    // TODO: why does this cause IE to hang for a long time? (but not FF)
    pwnd.update_filter_string(tmp_obj.filter_str);
    tmp_obj.filter_str = null; tmp_obj = null;
}

function doClearAll()
{
    for (i = 0; i < filters.length; i++)
    {
        if (!filters[i]) continue;
        thisForm.elements.namedItem(filters[i].fieldName + "_enable").checked = false;
        enableFilter(filters[i].fieldName, false);
    }
}

function doClear()
{
    filterCookieArray = removeDisplayFilter(filterCookieArray, thisForm.field_name.value);

    if (filterCookieName == 'XX_notify_parent')
    {
        XX_do_notify_parent();
    }
    else
    {
        var wnd = window.opener || window.parent;
        setCookie(filterCookieName, serializeArray(filterCookieArray));

        wnd.location.reload();//assign("%s");
    }

    dlg_close();
}
// TODO: url_buf

// convert filter console object to local filter object
function flt2DisplayFilter(flt)
{
    var col;
    for (var i = 0; (col = filter_settings.columns[i]); i++)
        if (col[0] == flt.id) break;

    return new DisplayFilter(
            flt.id,
            col[2][0],
            col[2][1],
            1,
            flt.logic.NOT ? 1 : 0,
            flt.logic.RANGE ? 1 : 0,
            0,
            flt.value);
}

function validate(flt)
{
    var f = $j("form").get(0);
    var filter = flt2DisplayFilter(flt);

    var valueType;
    var fieldName;

    fieldName = filter.fieldName;
    valueType = filter.filterType;

    {
        switch (valueType) {

        case FIELD_TYPE_PORT : 
            var value_string;
            for (var i = 0; (value_string = filter.value[i]); i++)
            {
            value_string = value_string.replace(/\s*/g, "");

            if (!RegExpCommon.RANGE_INT.test(value_string))
            {
                alert(flt_lang.err_range_int);
                $j(f[fieldName+"_text_value"]).select().focus();
                return false;
            }

            var value_array = value_string.split("-");
            if (!(isNaN(parseInt(value_array[0])) || (parseInt(value_array[0]) >= 0) && (parseInt(value_array[0]) <= 65536)) || !(isNaN(parseInt(value_array[1])) || (parseInt(value_array[1]) >= 0) && (parseInt(value_array[1]) <= 65536)))
            {
                alert(flt_lang.err_integer);
                $j(f[fieldName+"_text_value"]).select().focus();
                return false;
            }

            if (parseInt(value_array[0]) > parseInt(value_array[1]))
            {
                alert(flt_lang.err_range);
                $j(f[fieldName+"_text_value"]).select().focus();
                return false;
            }

            }
            break;

        case FIELD_TYPE_INTEGER:
            var value_string;
            for (var i = 0; (value_string = filter.value[i]); i++)
            {
            value_string = value_string.replace(/\s*/g, "");

            if (!RegExpCommon.RANGE_INT.test(value_string))
            {
                alert(flt_lang.err_range_int);
                $j(f[fieldName+"_text_value"]).select().focus();
                return false;
            }

            var value_array = value_string.split("-");
            if (!(isNaN(parseInt(value_array[0])) || (parseInt(value_array[0]) >= 0) && (parseInt(value_array[0]) <= 4294967296)) || !(isNaN(parseInt(value_array[1])) || (parseInt(value_array[1]) >= 0) && (parseInt(value_array[1]) <= 4294967296)))
            {
                alert(flt_lang.err_integer_u32);
                $j(f[fieldName+"_text_value"]).select().focus();
                return false;
            }

            if (parseInt(value_array[0]) > parseInt(value_array[1]))
            {
                alert(flt_lang.err_range);
                $j(f[fieldName+"_text_value"]).select().focus();
                return false;
            }

            }
            break;

        case FIELD_TYPE_POLICY_ID : 
            var value_string;
            for (var i = 0; (value_string = filter.value[i]); i++)
            {
            value_string = value_string.replace(/\s*/g, "");

            if (!RegExpCommon.RANGE_INT.test(value_string))
            {
                alert(flt_lang.err_range_int);
                $j(f[fieldName+"_text_value"]).select().focus();
                return false;
            }
            var value_array = value_string.split("-");
            if (!(isNaN(parseInt(value_array[0])) || (parseInt(value_array[0]) >= 0) && (parseInt(value_array[0]) <= 50000)) || !(isNaN(parseInt(value_array[1])) || (parseInt(value_array[1]) >= 0) && (parseInt(value_array[1]) <= 50000)))
            {
                alert(flt_lang.err_policy_id);
                $j(f[fieldName+"_text_value"]).select().focus();
                return false;
            }

            if (parseInt(value_array[0]) > parseInt(value_array[1]))
            {
                alert(flt_lang.err_range);
                $j(f[fieldName+"_text_value"]).select().focus();
                return false;
            }

            }
            break;

        case FIELD_TYPE_EXPIRY:
            var value_string;
            for (var i = 0; (value_string = filter.value[i]); i++)
            {
            value_string = value_string.replace(/\s*/g, "");

            if (!RegExpCommon.RANGE_INT.test(value_string))
            {
                alert(flt_lang.err_range_int);
                displayFilter(fieldName);
                inputFields[i].select();
                inputFields[i].focus();
                return false;
            }

            var value_array = value_string.split("-");
            if (!(isNaN(parseInt(value_array[0])) || (parseInt(value_array[0]) >= 0) && (parseInt(value_array[0]) <= 604800)) || !(isNaN(parseInt(value_array[1])) || (parseInt(value_array[1]) >= 0) && (parseInt(value_array[1]) <= 604800)))
            {
                alert(flt_lang.err_range);
                $j(f[fieldName+"_text_value"]).select().focus();
                return false;
            }

            if (parseInt(value_array[0]) > parseInt(value_array[1]))
            {
                alert(flt_lang.err_expiry);
                $j(f[fieldName+"_text_value"]).select().focus();
                return false;
            }

            }
            break;

        // Validation of FIELD_TYPE_DATE_TIME.
        // The date & time format is :   yyyy/mm/dd hh:mm:ss
        // 1) '/' is the separator of date, because '-' is reserved for separator of range
        // 2) the format is very strict, because checking if start time is later than end time is done by regular  string comparision
        case FIELD_TYPE_DATE_TIME:
            var date_time_Regex = /^(([0-9]{4})\/(0[1-9]|[1][0-2])\/(0[1-9]|[1-2][0-9]|3[0-1]) ([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9]))?-(([0-9]{4})\/(0[1-9]|[1][0-2])\/(0[1-9]|[1-2][0-9]|3[0-1]) ([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9]))$|^((([0-9]{4})\/(0[1-9]|[1][0-2])\/(0[1-9]|[1-2][0-9]|3[0-1]) ([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9]))-?)$/;	       

            var value_string = filter.value[0].replace(/\s*/g, "");
            if (!date_time_Regex.test(value_string))
            {
                alert(flt_lang.err_date_time);
                $j(f[fieldName+"_from_value"]).select().focus();
                return false;
            }

            value_string = filter.value[1].replace(/\s*/g, "");
            if (!date_time_Regex.test(value_string))
            {
                alert(flt_lang.err_date_time);
                $j(f[fieldName+"_to_value"]).select().focus();
                return false;
            }

            var value_array = filter.value;
            if (typeof value_array[0] != "undefined" && typeof value_array[1] != "undefined" &&  value_array[0]!= "" &&  value_array[1]!= "" && value_array[0] > value_array[1])
            {
                alert(flt_lang.err_range_date_time);
                $j(f[fieldName+"_from_value"]).select().focus();
                return false;
            }
            break;

        case FIELD_TYPE_INTEGER_U64 : 
            var value_string;
            for (var i = 0; (value_string = filter.value[i]); i++)
            {
            value_string = value_string.replace(/\s*/g, "");

            if (!RegExpCommon.RANGE_INT.test(value_string))
            {
                alert(flt_lang.err_range_integer_u64);
                $j(f[fieldName+"_text_value"]).select().focus();
                return false;
            }

            var value_array = value_string.split("-");
            if (!(isNaN(parseInt(value_array[0])) || (parseInt(value_array[0]) >= 0) && (parseInt(value_array[0]) <= 1152921504606846976)) || !(isNaN(parseInt(value_array[1])) || (parseInt(value_array[1]) >= 0) && (parseInt(value_array[1]) <= 1152921504606846976)))
            {
                alert(flt_lang.err_integer_u64);
                $j(f[fieldName+"_text_value"]).select().focus();
                return false;
            }

            if (parseInt(value_array[0]) > parseInt(value_array[1]))
            {
                alert(flt_lang.err_range);
                $j(f[fieldName+"_text_value"]).select().focus();
                return false;
            }

            }
            break;

        case FIELD_TYPE_IP_HOST:
            var hostRegex = /^(([0-9][0-9]?|[0-1][0-9][0-9]|[2][0-4][0-9]|[2][5][0-5])\.){3}([0-9][0-9]?|[0-1][0-9][0-9]|[2][0-4][0-9]|[2][5][0-5])$/;
            var rangeRegex = /^((([0-9][0-9]?|[0-1][0-9][0-9]|[2][0-4][0-9]|[2][5][0-5])\.){3}([0-9][0-9]?|[0-1][0-9][0-9]|[2][0-4][0-9]|[2][5][0-5]))?-((([0-9][0-9]?|[0-1][0-9][0-9]|[2][0-4][0-9]|[2][5][0-5])\.){3}([0-9][0-9]?|[0-1][0-9][0-9]|[2][0-4][0-9]|[2][5][0-5]))?$/;
            var range2Regex = /^(([0-9][0-9]?|[0-1][0-9][0-9]|[2][0-4][0-9]|[2][5][0-5])\.){3}\[([0-9][0-9]?|[0-1][0-9][0-9]|[2][0-4][0-9]|[2][5][0-5])-([0-9][0-9]?|[0-1][0-9][0-9]|[2][0-4][0-9]|[2][5][0-5])\]$/;
            var ipv6Regex = /^\s*((([0-9A-Fa-f]{1,4}:){7}(([0-9A-Fa-f]{1,4})|:))|(([0-9A-Fa-f]{1,4}:){6}(:|((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})|(:[0-9A-Fa-f]{1,4})))|(([0-9A-Fa-f]{1,4}:){5}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]{1,4}){0,1}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){0,2}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){2}(:[0-9A-Fa-f]{1,4}){0,3}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:)(:[0-9A-Fa-f]{1,4}){0,4}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(:(:[0-9A-Fa-f]{1,4}){0,5}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})))(%.+)?\s*$/;

            var value_string;
            for (var i = 0; (value_string = filter.value[i]); i++)
            {
            value_string = value_string.replace(/\s*/g, "");

            if (hostRegex.test(value_string) || ipv6Regex.test(value_string))
            {
                break;
            }
            else if (rangeRegex.test(value_string))
            {
                var split_addr = value_string.split("-");
                if ((!split_addr[0] || !split_addr[1]) || dotted2num(split_addr[0]) <= dotted2num(split_addr[1]))
                {
                    break;
                }
                else
                {
                    alert(flt_lang.err_range);
                    $j(f[fieldName+"_text_value"]).select().focus();
                    return false;
                }
            }
            else if (range2Regex.test(value_string))
            {
                var pre = value_string.split("[");
                var first_second = pre[1].split("-");
                var lo = pre[0] + first_second[0];
                var second = first_second[1].split("]");
                var hi = pre[0] + second[0];

                if (dotted2num(lo) <= dotted2num(hi))
                {
                    filter.value = [lo, hi];
                    break;
                }
                else
                {
                    alert(flt_lang.err_range);
                    $j(f[fieldName+"_text_value"]).select().focus();
                    return false;
                }
            }

            alert(flt_lang.err_iphost);
            $j(f[fieldName+"_text_value"]).select().focus();
            return false;

            }
            break;

        case FIELD_TYPE_TIME:
            if (!RegExpCommon.TIME.test(flt.value[0])) {
                alert(flt_lang.err_date_time);
                $j("input[name="+fieldName+"_from_value]").select().focus();
                return false;
            }
            if (!RegExpCommon.TIME.test(flt.value[1])) {
                alert(flt_lang.err_date_time);
                $j("input[name="+fieldName+"_to_value]").select().focus();
                return false;
            }
            if (flt.logic.RANGE && flt.value[0] > flt.value[1])
            {
                alert(flt_lang.err_range);
                $j("input[name="+fieldName+"_from_value]").select().focus();
                return false;
            }
            break;

        case FIELD_TYPE_DATE:
            if (!RegExpCommon.DATE.test(flt.value[0])) {
                alert(flt_lang.err_date_time);
                $j("input[name="+fieldName+"_from_value]").select().focus();
                return false;
            }
            if (!RegExpCommon.DATE.test(flt.value[1])) {
                alert(flt_lang.err_date_time);
                $j("input[name="+fieldName+"_to_value]").select().focus();
                return false;
            }
            if (flt.logic.RANGE && flt.value[0] > flt.value[1])
            {
                alert(flt_lang.err_range);
                $j("input[name="+fieldName+"_from_value]").select().focus();
                return false;
            }
            break;
        }
    }
    return true;
}

function displayFilter(filterName)
{
    document.getElementById("row_" + currentFilter).style.display = 'none';
    document.getElementById("row_" + filterName).style.display = '';
    document.getElementById("option_" + filterName).selected = true;
    document.getElementById("filter_title").innerHTML = document.getElementById("option_" + filterName).text;

    currentFilter = filterName;
}

function enableFilter(filterName, enabled)
{
    document.getElementById("option_" + filterName).style.color = enabled ? activeColour : inactiveColour;
    disableElementsByName(document.getElementById("div_" + filterName), ["input", "select", "option"], "^" + filterName + "_", !enabled);
}

function DisplayFilter(fieldName, filterType, fieldType, enable, negate, contains, case_sensitive, value)
{
    this.fieldName = fieldName;
    this.filterType = filterType;
    this.fieldType = fieldType;
    this.enable = enable;
    this.contains = contains;
    this.negate = negate;
    this.case_sensitive = case_sensitive;
    this.value = value;
    this.toArray = function toArray() {
        var filterArray = new Array(this.fieldName, this.enable, this.negate, this.contains, this.case_sensitive, this.value);
        return filterArray;
    }
}

function getDisplayFilter(filterArray, fieldName)
{
    for (var i = 0; i < filterArray.length; i++)
    {
        if (filterArray[i][0] == fieldName)
        {
            return new DisplayFilter(fieldName, filterArray[i][1], filterArray[i][2], filterArray[i][3], filterArray[i][4], filterArray[i][5], filterArray[i][6]);
        }
    }

    return new DisplayFilter(fieldName, 1, 1, 0, 0, null, 0);
}

function setDisplayFilter(filterCookieArray, filter)
{
    if (!filter) return filterCookieArray;
    if (!filterCookieArray)
    {
        filterCookieArray = [];
    }

    for (var i = 0; i < filterCookieArray.length; i++)
    {
        if (filterCookieArray[i][0] == filter.fieldName)
        {
            filterCookieArray[i] = filter.toArray();
            return filterCookieArray;
        }
    }

    filterCookieArray[filterCookieArray.length] = filter.toArray();
    return filterCookieArray;
}

function removeDisplayFilter(filterCookieArray, fieldName)
{
    if (!filterCookieArray)
    {
        filterCookieArray = [];
    }

    for (var i = 0; i < filterCookieArray.length; i++)
    {
        if (filterCookieArray[i][0] == fieldName)
        {
            filterCookieArray.splice(i, 1);
            break;
        }
    }

    return filterCookieArray;
}

function dotted2num( dotted )
{
    var dots = dotted.split(".");
    var vdots = new Array( +dots[0], +dots[1], +dots[2], +dots[3] );

    // << operator assumes signed 32 bit, so we can't do << 24 without overflowing
    var vmask = (vdots[0] * (1<<24)) + (vdots[1] << 16) + (vdots[2] << 8) + vdots[3];

    return vmask;
}

// For filter options of 'multiple select' type, 
// adjust the width of 'xxx_value_add', 'xxx_value_list' and 'xxx_available_list' to ensure
//   1. all select options are wrapped in 'xxx_value_list' and 'xxx_available_list'
//   2. those 3 elements look consistent in a whole
function select_multiple_auto_size(field_name) 
{
    var available_list   = document.getElementsByName(field_name + '_available_list')[0];
    var value_list       = document.getElementsByName(field_name + '_value_list')[0];
    var value_add        = document.getElementsByName(field_name + '_value_add')[0];
    var max_offset_width = available_list.offsetWidth;
    var max_clt_width    = available_list.clientWidth;

    if(max_offset_width < value_list.offsetWidth)
    {
        max_offset_width = value_list.offsetWidth;
        max_clt_width    = value_list.clientWidth;
    }

    available_list.style.width = max_offset_width + 'px';
    value_list.style.width     = max_offset_width + 'px';
    value_add.style.width      = max_clt_width + 'px';

    return document.getElementById('row_' + field_name).offsetWidth;
}
               

// 1) adjust size of all the field options which support auto-sizing
// 2) adjust the popup window to such a size that it can hold the biggest element without having to show the horizontal scrollbar
function fields_auto_size() 
{
    var max_size = 0;
    var tmp_size = 0;
    var max_field_name='';
    var fieldname = '';

    for (var i = 0; i < auto_size_field_cbs.length; i++)
    {
        fieldname = auto_size_field_cbs[i].fieldname;
        displayFilter(fieldname);
        switch(auto_size_field_cbs[i].fieldtype)
        {
        case DISPLAY_FILTER_TYPE_SELECT_MULTIPLE:
            tmp_size = select_multiple_auto_size(fieldname);
            break;
        default:
            tmp_size = 0;
        }

        if (tmp_size > max_size) 
        {
            max_size = tmp_size;
            max_field_name = fieldname;
        }
    }

    if (max_size)
    {
        displayFilter(max_field_name);
        //resize_this_wnd_to_inner_dialog();
    }
}

// convert filter columns list to filter console column list
function fieldColumnParse(columns)
{
    filter_settings.columns = columns;

    var cols = [];

    var col;
    for (var i = 0; (col = columns[i]); i++) {
        var flt = {"key": col[0], "label": col[1], "selection": col[3], "validate": validate};

        switch (col[2][0]) {
            case FIELD_TYPE_DATE:
		if (typeof(flt.help) == "undefined") flt.help = flt_lang["format"] + ": " + $j.datepicker._defaults.dateFormat.replace("yy", "yyyy");
                flt.is = { "date": 1 };
            case FIELD_TYPE_TIME:
                if (typeof(flt.help) == "undefined") flt.help = flt_lang["format"] + ": hh:mm:ss";
            case FIELD_TYPE_DATE_TIME:
                if (typeof(flt.help) == "undefined") flt.help = flt_lang["format"] + ": yyyy-mm-dd hh:mm:ss";
            case FIELD_TYPE_PORT:
                flt.support = {"NOT": 1, "RANGE": 1};
                break;
            case FIELD_TYPE_INTEGER:
            case FIELD_TYPE_POLICY_ID:
            case FIELD_TYPE_IP_RANGE:
                if (typeof(flt.help) == "undefined") flt.help = flt_lang["helpRange"];
                flt.support = {"NOT": 1, "OR": 1, "RANGE": 1};
                break;
            default:
                if (!flt.selection && typeof(flt.help) == "undefined") flt.help = ""/*flt_lang["filter"]["helpText"]*/;
                flt.support = {"NOT": 1, "OR": col[2][1] == DISPLAY_FILTER_TYPE_SELECT_MULTIPLE, "AND": 1}
        }

        cols.push(flt);
    }

    return cols;
}

// covert current filter array to filter console array
function fieldFilterParse(filterArray)
{
    var flts = [];

    // filterArray = new Array(this.fieldName, this.enable, this.negate, this.contains, this.case_sensitive, this.value);
    var flt;
    for (var i = 0; (flt = filterArray[i]); i++) {
        flts.push({
            "id": flt[0],
            "logic": {
                "NOT": flt[2],
                "OR": flt[3] != true,
                "RANGE": flt[3]
            },
            "value": flt[5]
        });
    }

    return flts;
}

function filterLoadResource()
{
    var reg = {
        "en":     "",
        "GB2312": "zh-CN",
        "x-sjis": "ja",
        "euc-kr": "ko",
        "sp":     "es",
        "big5":   "zh-TW",
        "fr":     "fr",
        "po":     "pt"
    }[window.filterLang];
    // load date picker regional
    if (reg) {
        $j.addScript("/js/ui.datepicker-"+reg+".js");
        $j.datepicker.setDefaults($j.datepicker.regional[reg]);
    }
}

function filterSetup(tableId, columsArray, cookieName)
{
    filterLoadResource();
    // set filter column
    var filterCookieString = getCookie(cookieName);
    $j(tableId).filterConsole({
        "lang": {
                "heading": flt_lang["heading"],
                "ok": flt_lang["ok"],
                "apply": flt_lang["apply"],
                "cancel": flt_lang["cancel"],
                "from": flt_lang["from"],
                "to": flt_lang["to"],
                "format": flt_lang["format"],
                "value": flt_lang["value"],
                "change": flt_lang["change"],
                "fieldName": flt_lang["fieldName"],
                "input": flt_lang["input"],
                "select": "[ "+flt_lang["select"]+" ]",
                "addFilter": flt_lang["addFilter"],
                "clearFilter": flt_lang["clearFilter"],
                "rmHint": flt_lang["rmHint"],
                //"applied_tags": flt_lang["sysconftagsdlg"]["applied_tags"],
                //"tags_to_add": flt_lang["sysconftagsdlg"]["tags_to_add"],
                //"click_to_add": flt_lang["sysconftagsdlg"]["click_to_add"]
        },
        "columns": fieldColumnParse(columsArray),
        "filters": fieldFilterParse(deserializeArray(filterCookieString ? filterCookieString : "")),
        "expanded": filterExpaned,
        "action": doOK
    });
}
