/*
  signature.js - misc JS code for signature_group.c
  init Mar 2011 by Jianjiang Yan
  GUI redesign project
  Copyright Fortinet Inc
*/

// according to the current selection.
function signature_handle_selection_change(q)
{
    // Let the default handler handle the standard buttons.
    qlist_handle_selection_change(q);

    var aElems = q.get_checked_rows();

    qmenu_enable_button($("mi_wizard"), true, q);
    if(!is_rw_admin && aElems.length == 1)
    {
    	qmenu_enable_button($("mi_view"), true, q);
    	qmenu_enable_button($("mi_view_detail"), true, q);	
        return;
    }else if(!is_rw_admin){
    	qmenu_enable_button($("mi_view"), false, q);
    	qmenu_enable_button($("mi_view_detail"), false, q);	
        return;
    }

    if (aElems.length == 1)
    {
	   qmenu_enable_button($("mi_clone"), true, q);
        //qmenu_enable_button($("mi_edit"), true, q);
	    if (parseInt(aElems[0].getAttribute("can_view")) == 1)
	    {
    		qmenu_enable_button($("mi_view"), true, q);
    		qmenu_enable_button($("mi_edit"), false, q);
            qmenu_enable_button($("mi_detail"), false, q);
            qmenu_enable_button($("mi_view_detail"), true, q);
	    }else{
            qmenu_enable_button($("mi_view"), false, q);
	        qmenu_enable_button($("mi_edit"), true, q);
            qmenu_enable_button($("mi_detail"), true, q);
            qmenu_enable_button($("mi_view_detail"), false, q);
	    }
	   
    }else{
	   qmenu_enable_button($("mi_clone"), false, q);	
       qmenu_enable_button($("mi_edit"), false, q);
	   qmenu_enable_button($("mi_detail"), false, q);	
	   qmenu_enable_button($("mi_view"), false, q);
       qmenu_enable_button($("mi_view_detail"), false, q);
    }
}

// signature_menu - Override the default menubar to add buttons "Generate",
//             "Import", "View", "Download" and "Edit Commones".
function signature_menu(aItems)
{
    if (is_rw_admin) {
        var mNew = Page.createMenuItem({id:"mi_detail", spriteClass:"tool_append", ctxt:true,
                   text:signature_strtbl.detail, click:{fn: signature_onclick_detail} });
        aItems.push(mNew);        
        var mNew = Page.createMenuItem({id:"mi_clone", spriteClass:"tool_clone", ctxt:true,
                   text:signature_strtbl.clone, click:{fn: signature_onclick_clone} });
        aItems.push(mNew);
        var mDEL = Page.createMenuItem({id:"mi_del", spriteClass:"tool_delete", text:qed_strtbl.del, click:{fn: qlist_obj.delete_handler} });
        aItems.push(mDEL);
        var mNew = Page.createMenuItem({id:"mi_view", spriteClass:"tool_view", ctxt:true,
                   text:signature_strtbl.view, click:{fn: signature_onclick_view} });
        aItems.push(mNew);
    }
        var mNew = Page.createMenuItem({id:"mi_view_detail", spriteClass:"tool_append", ctxt:true,
                   text:signature_strtbl.view_detail, click:{fn: signature_onclick_detail} });
	aItems.push(mNew);    
	if (is_rw_admin) {
		var mNew = Page.createMenuItem({id:"mi_wizard", spriteClass:"tool_new", ctxt:false,
			text:signature_strtbl.wizard, click:{fn: signature_create_by_wizard} });
		aItems.unshift(mNew);
	}

}
function signature_onclick_view()
{   
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;

    var mkey = aElems[0].getAttribute("mkey");

    window.location.href = "/waf/signature_group/dlg?mkey=" + mkey + "&vdom=" + vdom;
}
function signature_onclick_clone()
{   
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;

    var mkey = aElems[0].getAttribute("mkey");

    window.location.href = "/waf/signature_group/dlgcopy?mkey=" + mkey + "&vdom=" + vdom;
}
function signature_onclick_detail()
{   
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;

    var mkey = aElems[0].getAttribute("mkey");

    window.location.href = "/signature/signature.html?mkey=" + mkey + "&vdom=" + vdom;
}
function signature_create_by_wizard()
{
	    window.location.href="/ng/wizard/main.html";
}

// signaturelist_onload - onload handler for the interface list page.
function signaturelist_onload()
{
    // Customize the qlist definition.
    qlist_obj.customize_menu_fn = signature_menu;
    qlist_obj.create_del = false;
    qlist_obj.handle_selection_change_fn = signature_handle_selection_change;
    qlist_del_url("/delete?vdom="+vdom);

    qlist_setup("qlist", "/waf/signature_group/dlg?vdom="+vdom, "/waf/signature_group/dlg?vdom="+vdom,false);
}
hlight_table('qlist', 1, 0, 'over');

addEvent(window, "load", signaturelist_onload);
