var signature = (function($) {
	'use strict';

	var colors =  ['#f32e2b', '#ffca5c', '#faffa5', '#d4fbff', ''];
	var bcolors = ['#d50000', '#e2a82e', '#d2ba00', '#7bcade', ''];
	var values = ['level_critical', 'level_high', 'level_medium', 'level_low', 'level_info'];
	var values_translated = $j.map(values,
		    function(value) { return $j.getInfo(value); });

	var threshold_turn = [2, 4, 5, 7, 10];
	function process_slide(elem, val) {
		var jthis = $j(elem);
		jthis.children('div').css({
			'background': colors[val],
			'border-color': bcolors[val]
		});
		var title = $j.getInfo(values[val])+"("+threshold_turn[val]+" "+$j.getInfo("points")+")";
		jthis.children('a').attr('title', threshold_turn[val]);
		$('.slider-label-text').html(title);
	}

	function get_score_field(elem) {
		var jthis = $j(elem);
		var score_id = jthis.attr('id').replace('-slider', '-score');
		return $j('#' + score_id);
	}

	function expand_format_fn(td, col, row_data) {
		var has_children = (row_data.id == 'score_setting') ? true:false;
        function get_base_level1_icon() {
            var value = '';
            value =  '<div class="expansion_base_parent"></div>';
            return value;
        }

        function get_expansion_icon() {
            var value = '';
            value = '<div class="expansion expansion_parent">' +
		    '<button type="button" class="compact-visual-toggle active" />' +
		    '</div>';
            return value;
        }

        var html = '<div class="expansion_container">';
        if(row_data.id  == '100000000' || row_data.id == 'score_setting'){
	        html += get_base_level1_icon();
	        html += get_expansion_icon();        	
        }

        td.css('min-width', '20px');
        return html + '</div>';		
	}

    function setup_expansion_trees() {
        function expand_children($parent_row, addOrRemove) {
            $parent_row.nextUntil(":not(.score_expansion)").andSelf().toggleClass("intf_expanded", addOrRemove);
        }
        function display_credit($parent)
        {
        	var tr = $j("#tr_ccdt");
			var css = tr.css("display");
			tr.css('display', (css == 'none') ? '' : 'none');
        }
        function display_score($parent)
        {
        	var tr = $j("#tr_sscope");
			var css = tr.css("display");
			tr.css('display', (css == 'none') ? '' : 'none');

			var tr = $j("#tr_sthres");
			var css = tr.css("display");
			tr.css('display', (css == 'none') ? '' : 'none');
        }
        var exps_btn = $.find(".expansion.expansion_parent");


        $(exps_btn).on("click", function(event) {
            var $parent_row = $(this).closest("tr.qlist_row");
            if($parent_row.attr('can_edit') === '0') return;
            var id = $parent_row.attr('data-row-handler-id');
	    $('.compact-visual-toggle', $parent_row).toggleClass('active');
            expand_children($parent_row);
            if(id == '100000000')
            	display_credit($parent_row);
            else
            	display_score($parent_row);

            event.stopPropagation();

        }).on("dblclick", function(event) {
            event.stopPropagation();
        })
    }

    function row_gen_fn(rowIndex, row_data) {
        /* jshint validthis: true */
        if (row_data.id  == '100000000' || row_data.id  == 'score_setting') {
            this.addClass('score_expansion');
            if(row_data.status == 'enable' || row_data.id  == 'score_setting') this.addClass('intf_expanded');
        }
    }

	function update_score_mode(check)
	{
		// show/hide score row settings
		$j('#tr_sscope').css('display', check ? '' : 'none');
		$j('#tr_sthres').css('display', check ? '' : 'none');
		$j('#main-class tr[data-row-handler-id=score_setting]').toggleClass("intf_expanded", check);
		$j('#main-class tr[data-row-handler-id=score_setting]').css('display', check ? '' : 'none');

		// show/hide score status column
		$j('#main-class td.score_status').css('display', check ? '' : 'none');
		//$j('#main-class td.__pseudo_expand').css('display', check ? '' : 'none');

		// show/hide score status column header
		var col_score = $j('tr.heading').children('th');
		var len = col_score.length;
		//col_score[0].style.display = check ? '' : 'none';
		col_score[len-1].style.display = check ? '' : 'none';
		
		var erase_only_text = $j.getInfo("erase_only");
		var alert_erase_text = $j.getInfo("alert_erase");
		var info_action_text = $j('#main-class tr[data-row-handler-id=080000000] span[data-name=action]').html();
		
		info_action_text = info_action_text.replace("&amp;", "&");
		
		if(info_action_text === erase_only_text || info_action_text === alert_erase_text)
		{
			$j('#main-class tr[data-row-handler-id=080000000] td.score_status div input').attr('checked',false);
//			$j('#main-class tr[data-row-handler-id=080000000] td.score_status div').removeClass('ez-checked');
			$j('#main-class tr[data-row-handler-id=080000000] td.score_status').css('display', 'none');
		}
	}

	function update_scoring_scope()
	{
		var val = $j('#scoring_scope').val();
		if(val == 3)
			$j('#http_session_tip').show();
		else
			$j('#http_session_tip').hide();
	}

	function DisableEnableForm(xForm,xHow){
		var objElems = xForm.elements;
		for(var i=0;i<objElems.length;i++){
			if (objElems[i].type != 'button') {
				objElems[i].disabled = xHow;
			}
		}
	    var comment = $j('.comment');
	  	for(var i = 0; i < comment.length; i++){
	       comment[i].disabled = xHow;
	  	}
	};

	function _main_class_onload($main_class)
	{
		$j("#main-class tr[data-row-handler-id=100000000]").after("<tr id='tr_ccdt' class='qlist_row'>"+
				'<td class="__pseudo_expand" style="min-width: 20px;"><div class="expansion_container"><div class="expansion_base_child_last"></div><div class="expansion expansion_child"></div></div></td><td style="text-align:left;">' +
				"<span style='margin-left: 16px; opacity: 1.0;'>" + $j.getInfo("cc_threshold") + "</span></td>" +
				"<td style='text-align: left;' colspan='7'><input type='text' id='credit_card_detection_threshold' name='credit_card_detection_threshold' maxlength='3' value='' /></td>" +
				"</tr>");

		$('.main-class-status', $main_class)./*ezMark().*/on('click', function() {
			var $parent = $(this).parents('tr');

			// Prevent disabled entries from using inline edit support.
			var can_edit = ($parent.attr('can_edit') === '1') ? '0' : '1';
			$parent.toggleClass('disabled').attr('can_edit', can_edit);

			$('.main-class-fpm-status', $parent).attr('disabled', (can_edit == '0')?true:false);
			$('.main-class-score-status', $parent).attr('disabled', (can_edit == '0')?true:false);

			var id = $parent.attr("data-row-handler-id");
			// hide/show credit card threshold
			if(id == '100000000')
			{
				var tr = $j("#tr_ccdt");								
				tr.css('display', (can_edit == '0') ? 'none' : '');	
				var css = tr.css("display");			
				$parent.toggleClass("intf_expanded",!(css == 'none'));
				if(css == 'none')
					$('.compact-visual-toggle', $parent).removeClass('active');
				else
					$('.compact-visual-toggle', $parent).addClass('active');
			}
		});

		// for score settings
		$j('#main-class tr[data-row-handler-id=score_setting]').attr('can_edit', 1);
		$j('#main-class tr[data-row-handler-id=score_setting]').after(
				'<tr id="tr_sthres" can_edit="0" class="qlist_row"><td class="__pseudo_expand" style="min-width: 20px;"><div class="expansion_container"><div class="expansion_base_child"></div><div class="expansion expansion_child"></div></div></td><td style="text-align: left">' + 
				'<span style="margin-left: 16px; opacity: 1.0;">' + $j.getInfo('score_threshold')+'</span></td><td colspan="7" style="text-align: left;">'+
				'<div style="width: 120px;">'+
				'<div id="threshold-slider" class="level-slider" data-default-level="2" style="width: 120px;">'+
				'<span class="slider-level-disable-text" style="display:none">Off</span>'+
				'</div>'+
				'<div>'+
				'<span class="slider-label-text" style="opacity: 1.0;"></span>'+
				'<input name="threshold-score" id="threshold-score" value=' + $j('#sthreshold').val() + ' type="hidden" />'+
				'</div>'+
				'</div>'+
				'</td></tr>'
				);
		$j('#main-class tr[id="tr_sthres"]').after(
				'<tr id="tr_sscope" can_edit="0" class="qlist_row"><td class="__pseudo_expand" style="min-width: 20px;"><div class="expansion_container"><div class="expansion_base_child_last"></div><div class="expansion expansion_child"></div></div></td><td style="text-align: left">' + 
				'<span style="margin-left: 16px; opacity: 1.0;">' + $j.getInfo('score_scope')+'</span></td><td colspan="7" style="text-align: left;">'+
				'<select id="scoring_scope" name="scoring_scope" style="width: 120px;" >'+
				'<option value="1">'+$j.getInfo('http_transaction')+'</option>'+
				'<option value="2">'+$j.getInfo('tcp_session')+'</option>'+
				'<option value="3">'+$j.getInfo('http_session')+'</option>'+
				'</select>'+
				'<span style="margin-left: 30px" id="http_session_tip">'+$j.getInfo('http_session_tip')+'</span>'+
				'</td></tr>'
				);

		// init slider component
		$j('div.level-slider').slider({
			range: 'max',
			max: 4,
			width: 120,
			slide: function(event, ui) {
				var val = ui.value;
				process_slide(this, val);
				var score_field = get_score_field(this);
				//score_field.val(val);
				score_field.attr('value', val);
			}
		}).each(function(n ,i) {
			var jthis = $j(this);
			var score_field = get_score_field(this);
			var val = score_field.val();
			jthis.slider("option", "value", val);
			process_slide(this, val);
		});

		// show/hide credit card threshold
		var st_ccdt = ($j('#main-class tr[data-row-handler-id=100000000]').attr('can_edit') === '1') ? '1':'0';
		$j("#tr_ccdt").css('display', (st_ccdt == '0') ? 'none' : '');
		$j("#credit_card_detection_threshold").val($j("#ccdt_val").val());
		$j('#scoring_scope').val($j('#sscope').val());

		$j('#scoring_scope').on('change', update_scoring_scope);
		update_scoring_scope();

//		$('.main-class-score-status', $main_class).ezMark();
		$('.main-class-score-status', $main_class).each(function() {
			var $parent = $(this).parents('tr');
			var can_edit = ($parent.attr('can_edit') === '1') ? '0' : '1';
			$(this).attr('disabled', (can_edit == '0')?false:true);
		});

//		$('.main-class-fpm-status', $main_class).ezMark();
		$('.main-class-fpm-status', $main_class).each(function() {
			var $parent = $(this).parents('tr');
			var can_edit = ($parent.attr('can_edit') === '1') ? '0':'1';
			$(this).attr('disabled', (can_edit == '0')?false:true);
		});

		$('td.block_period input[type=number]',
			$main_class).attr({
			'min': 1,
			'max': 3600
			});

		$j('#main-class_qlist_yui_menubar')[0].style.display = 'none';

		$('td.action select[data-name=action]', $main_class).on('change', function() {
			var $parent = $(this).parents('tr');
			var id = $parent.attr('data-row-handler-id');

			var val = ($(this).val());
			var $block = $('td.block_period input#main-class-'+id+'-block_period', $main_class);
			$block.attr('disabled', val === 'period_block' ? false: true);

			if(id === '080000000'){
				var ss_08 = $j('#main-class tr[data-row-handler-id=080000000] td.score_status div');
				if(val === 'erase_only' || val === 'alert_erase')
				{
					ss_08.find('input').attr('checked',false);
//					ss_08.removeClass('ez-checked');
				} 
				$j('#main-class tr[data-row-handler-id=080000000] td.score_status').css('display', (val === 'erase_only' || val === 'alert_erase') ? 'none' : '');
			}
		});

		$('td.block_period input', $main_class).each(function(){
			var $parent = $(this).parents('tr');
			var id = $parent.attr('data-row-handler-id');
			var action = $('td.action select', $parent)[0].value;
			$(this).attr('disabled', action === 'period_block' ? false: true);
		});

		/*
		$('#score_mode').ezMark().on('click', function(){
			var check = this.checked;

			update_score_mode(check);
		});
		*/
	
		//update_score_mode(document.getElementById('score_mode').checked);
		update_score_mode(false);
		
		var erase_only_text = $j.getInfo("erase_only");
		var alert_erase_text = $j.getInfo("alert_erase");
		var info_action_text = $j('#main-class tr[data-row-handler-id=080000000] span[data-name=action]').html();
		
		info_action_text = info_action_text.replace("&amp;", "&");

		if(info_action_text === erase_only_text || info_action_text === alert_erase_text)
		{
			$j('#main-class tr[data-row-handler-id=080000000] td.score_status div input').attr('checked',false);
//			$j('#main-class tr[data-row-handler-id=080000000] td.score_status div').removeClass('ez-checked');
			$j('#main-class tr[data-row-handler-id=080000000] td.score_status').css('display', 'none');
		}

		setup_expansion_trees.call(this);

		if (default_flag){
			DisableEnableForm(document.forms[0],true);
		}

	}

	function config_main_class()
	{
		var h = config_main_class.qlist_handlers;

		var $main_class = $('#main-class');
		var action_options = {
			'alert': {text:fgt_lang.alert},
			'alert_deny': {text: fgt_lang.alert_deny},
			'deny_no_log': {text: fgt_lang.deny_no_log},
			'period_block': {text: fgt_lang.period_block},
			'redirect': {text: fgt_lang.redirect},
			//'send_403': {text: fgt_lang.send_403_forbidden},
			'send_http_response': {text: fgt_lang.send_http_response},
		};

		var action_info_options = {
			'alert': {text:fgt_lang.alert},
			'alert_erase': {text: fgt_lang.alert_erase},
			'erase_only': {text: fgt_lang.erase_only},
			'redirect': {text: fgt_lang.redirect},
			'send_http_response': {text: fgt_lang.send_http_response},
		};

		var action_cc_options = {
			'alert': {text:fgt_lang.alert},
			'alert_deny': {text: fgt_lang.alert_deny},
			'deny_no_log': {text: fgt_lang.deny_no_log},
			'alert_erase': {text: fgt_lang.alert_erase},
			'period_block': {text: fgt_lang.period_block},
			'send_http_response': {text: fgt_lang.send_http_response},
		};

		var severity_options = {
			'High': {text: fgt_lang.High},
			'Medium': {text: fgt_lang.Medium},
			'Low': {text: fgt_lang.Low},
			'Info': {text: fgt_lang.Informative},
		};

		var qlist_setting = {
			'prefix': 'main-class',
			'columns': [
				{'selector': '__pseudo_expand', 'lang_key': ' ', 'fixed': true,
					'class': '__pseudo'
				},
				{'selector': 'name', 'lang_key': 'name'},
				{'selector': 'status', 'lang_key': 'status'},
				{'selector': 'fpm_status', 'lang_key': 'fpm_status'},
				{'selector': 'action', 'lang_key': 'action'},
				{'selector': 'block_period', 'lang_key': 'block_period', 'inline_type': 'number', 'validate': 'number required'},
				{'selector': 'severity', 'lang_key': 'severity', 'options': severity_options},
				{'selector': 'trigger', 'lang_key': 'trigger_policy', 'options': trigger_options},
				{'selector': 'score_status', 'lang_key': 'score_status'},
			],
			'options': {
				'hide_create_button': true,
				'hide_delete_button': true,
				'fixed_header': false,
				'css_layout': false
			},
			'format_fn': {
				'__pseudo_expand': expand_format_fn,
				'name': function(td, column, entry)
				{
					return entry.name
				},
				'status': function(td, column, entry) {
					if(entry.id == 'score_setting')
						return '';
					var $parent = td.parents(), can_edit = '1';
					var html = '<input type="checkbox" ' +
						'class="main-class-status toggle-switch" ' +
						' name="main-class" value="' + entry.id + '" id="main-class-status_' + entry.id + '"';
					if (entry.status == "enable") {
						html += ' checked="checked"';
					} else {
						$parent.addClass('disabled');
						can_edit = '0';
					}

					$parent.attr('can_edit', can_edit);

					html += ' /><label for="main-class-status_' + entry.id + '"></label>';

					return html;
				},
				'fpm_status': function(td, column, entry) {
					var html = '';
					if(entry.id != '030000000' && entry.id != '040000000')
						return '';

					html = '<input type="checkbox" ' +
						'class="main-class-fpm-status toggle-switch" ' + 
						' name="main-class-fpm-status" value="'+entry.id+'" id="main-class-fpm-status_' + entry.id + '"';

					if(entry.fpm_status == 'enable')
						html += ' checked="checked"';
					
					html += ' /><label for="main-class-fpm-status_' + entry.id + '"></label>';

					return html;
				},
				'score_status': function(td, column, entry) {
					if(entry.id == 'score_setting' || entry.id == '100000000')
						return '';
					var html = '';
					html = '<input type="checkbox" ' +
						'class="main-class-score-status toggle-switch" ' +
						' name="main-class-score-status" value="' + entry.id+'" id="main-class-score-status_' +entry.id + '"';

					if(entry.score_status == 'enable')
						html += ' checked="checked"';

					html += ' /><label for="main-class-score-status_' + entry.id + '"></label>';

					return html;
				},
				'action': function(td, column, entry) {
					td.addClass('inline');
					if(entry.id == '080000000')
						return h.select_format('action', entry, action_info_options, '', false);
					else if(entry.id == '100000000')
						return h.select_format('action', entry, action_cc_options, '', false);
					else
						return h.select_format('action', entry, action_options, '', false);
				},				
			},
			'row_gen': row_gen_fn,
			'callbacks': {
				'load': function() {
					_main_class_onload($main_class);
				}
			}
		};

		if(!h)
		{
			h = config_main_class.qlist_handlers = 
				new QListInlineHandlers($('[name="main_class_val"]'), 
						{read_only: !is_rw_admin});
		}

		$main_class.qlist(h.attach(qlist_setting));
	}

	function configure()
	{
		config_main_class();

		$('form').submit(function() {
			var result = $(this).valid() &&
			config_main_class.qlist_handlers.update_form();
		return result;
		}).validate({'onsubmit': false});
	}

	return {configure: configure};
})(jQuery);
