/*
  syscert.js - misc JS code for certificate***.c
  init Nov 2009 by Yanna Chen
  GUI redesign project
  Copyright Fortinet Ltd
*/


// cert_onclick_import - on_click handler for the import button.
function cert_onclick_import()
{
    // ctype: Certificat type
    // #define CERT_TYPE_CSR           0
    // #define CERT_TYPE_CER           1
    // #define CERT_TYPE_CA            2
    // #define CERT_TYPE_CRL           3
    // #define CERT_TYPE_KEY           4
    // #define CERT_TYPE_REMOTE        5
    // #define CERT_TYPE_INTER         6

    if (ctype == 0) // for csr and local certificate
        window.location.href = "/sys/cert_local/import?confirm=1";
    else if (ctype == 5)
        window.location.href = "/sys/cert_remote/import";
    else if (ctype == 2)
        window.location.href = "/system/caimport";
    else if (ctype == 3)
        window.location.href = "/system/cert_crl/import";
    else if (ctype == 6)
        window.location.href = "/system/interimport";
}

function cert_onclick_generate()
{
    window.location.href = "/sys/cert_local/dlg";
}

// cert_onclick_view - on_click handler for the view button.
function cert_onclick_view()
{
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;

    var mkey = aElems[0].getAttribute("mkey");

    window.location.href = "/sys/cert/view?q=" + ctype + "&seq=" + mkey;
}

function cert_onclick_download()
{
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;

    var mkey = aElems[0].getAttribute("mkey");
    var cert_type = aElems[0].getAttribute("cert_type");

    if (cert_type == "local")
        window.location.href = "/sys/cert_local/download?" + mkey + ".cer&msg=8&certname=" + mkey + "&session_id=" + session_id;
    else if (cert_type == "csr")
        window.location.href = "/sys/cert_local/download?" + mkey + ".csr&msg=9&certname=" + mkey + "&session_id=" + session_id;
    else if (cert_type == "remote")
        window.location.href = "/sys/cert_remote/download?" + mkey + ".cer&msg=26&certname=" + mkey;
    else if (cert_type == "ca")
        window.location.href = "/downloadfile/" + mkey + ".cer?msg=10&certname=" + mkey;
    else if (cert_type == "crl")
        window.location.href = "/downloadfile/" + mkey + ".crl?msg=25&certname=" + mkey;
}

function cert_onclick_config()
{
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;

    var mkey = aElems[0].getAttribute("mkey");

    window.location.href = "/sys/cert_local/comment?mkey=" + mkey;
}

// cert_handle_selection_change - enable/disable the password button
// according to the current selection.
function cert_handle_selection_change(q)
{
    // Let the default handler handle the standard buttons.
    qlist_handle_selection_change(q);

    var aElems = q.get_checked_rows();

    if (create_generate)
        qmenu_enable_button($("mi_generate"), true, q);
    qmenu_enable_button($("mi_import"), true, q);

    if (aElems.length == 1 && parseInt(aElems[0].getAttribute("can_view")))
        qmenu_enable_button($("mi_view"), true, q);
    else
        qmenu_enable_button($("mi_view"), false, q);

    if (aElems.length == 1 && parseInt(aElems[0].getAttribute("can_download")))
        qmenu_enable_button($("mi_download"), true, q);
    else
        qmenu_enable_button($("mi_download"), false, q);


    if (create_config) {
        if (aElems.length == 1 && parseInt(aElems[0].getAttribute("can_config")))
            qmenu_enable_button($("mi_config"), true, q);
        else
            qmenu_enable_button($("mi_config"), false, q);
    }
}

// cert_menu - Override the default menubar to add buttons "Generate",
//             "Import", "View", "Download" and "Edit Commones".
function cert_menu(aItems)
{
    if (create_generate && is_rw_admin) {
        var mNew = Page.createMenuItem({id:"mi_generate", spriteClass:"tool_clone", ctxt:false,
                   text:cert_strtbl.generate, click:{fn: cert_onclick_generate} });
        aItems.push(mNew);
    }

    if (is_rw_admin) {
        var mImport = Page.createMenuItem({id:"mi_import", spriteClass:"tool_import", ctxt:false,
                    text:cert_strtbl.importstr, click:{fn: cert_onclick_import} });
        aItems.push(mImport);
    }

    var mView = Page.createMenuItem({id:"mi_view", spriteClass:"tool_view", single_only:true,
                text:cert_strtbl.view, click:{fn: cert_onclick_view} });
    aItems.push(mView);
    if (create_download && is_rw_admin) {

	var mDownload = Page.createMenuItem({id:"mi_download", spriteClass:"tool_download", single_only:true,
		    text:cert_strtbl.download, click:{fn: cert_onclick_download} });
	aItems.push(mDownload);
    }

    if (create_config && is_rw_admin) {
        var mConfig = Page.createMenuItem({id:"mi_config", spriteClass:"tool_edit", single_only:true,
                    text:cert_strtbl.edit_comment, click:{fn: cert_onclick_config} });
        aItems.push(mConfig);
    }
}

// cert_onload - onload handler for the cert list page.
function cert_onload()
{
    qlist_obj.customize_menu_fn = cert_menu;
    qlist_obj.handle_selection_change_fn = cert_handle_selection_change;
    qlist_obj.enable_ref_col = ctype != 3;

    qlist_obj.create_new = false;
    qlist_obj.create_edit = create_edit;
    qlist_setup("qlist", null, create_edit ? edit_url : null,false);
}


hlight_table('qlist', 1, 0, 'over');

addEvent(window, "load", cert_onload);

