(function($, Omniselect){
	"use strict";
	var select_config = {
		monitor: {
			omniselect :{
				sources: ["ha.monitor"],
				singleSelect: false,
				preProcessSelected: true,
				sortFunction: fweb.util.sort.interfaceName
			},
		},
		// heartbeat:{
		// 	omniselect : {
		// 		sources: ["ha.heartbeat"],
		// 		singleSelect: false,
		// 		preProcessSelected: false,
		// 		sortFunction: fweb.util.sort.interfaceName,
		// 		maxSelectLength: 2
		// 	},
		// },
		// managementintf:{
		// 	omniselect : {
		// 		sources: ["ha.managementintf"],
		// 		singleSelect: false,
		// 		preProcessSelected: false,
		// 		sortFunction: fweb.util.sort.interfaceName
		// 	},
		// }
	};
	var heartbeat = {omniselect : {sources: ["ha.heartbeat"],singleSelect: false,preProcessSelected: false,sortFunction: fweb.util.sort.interfaceName,maxSelectLength: 2}};
	var managementintf = {omniselect : {sources: ["ha.managementintf"],singleSelect: false,preProcessSelected: false,sortFunction: fweb.util.sort.interfaceName}};
	if(hb_intface){
		select_config.heartbeat = heartbeat;

	}
	if(manager_intface){
		select_config.managementintf = managementintf;
	}
	var omniselects = {};
	var initSelects = {
		monitor: []
		// heartbeat: [],
		// managementintf:[]
	};
	if(hb_intface){
		initSelects.heartbeat = [];
	}
	if(manager_intface){
		initSelects.managementintf = [];
	}
	var createMonitorInterfaceSource = function(){
		return $.get("/system/ha/interface_json").then(function(result){
			var data = result.monitor;
			data.map(function(obj){
				if(obj.checked == true)
					initSelects.monitor.push(obj);	
			});
			return result.monitor;
		});
	};
	if(hb_intface){
		var createHeartbeatInterfaceSource = function(){
			return $.get("/system/ha/interface_json").then(function(result){
				var data = result.heartbeat;
				data.map(function(obj){
					if(obj.checked == true)
						initSelects.heartbeat.push(obj);	
				});
				return result.heartbeat;
			});
		};
	}
	if(manager_intface){
		var createManagementIntfInterfaceSource = function(){
			return $.get("/system/ha/interface_json").then(function(result){
				var data = result.managementintf;
				data.map(function(obj){
					if(obj.checked == true)
						initSelects.managementintf.push(obj);	
				});
				return result.managementintf;
			});
		};
	}
	function check_interface(){
		var selected_monitor = omniselects.monitor.getSelected();
		if(hb_intface){
			var selected_heartbeat = omniselects.heartbeat.getSelected();
		}
		if(manager_intface){
			var selected_managementintf = omniselects.managementintf.getSelected();
		}
		var flag = 0;

		if(hb_intface){
			selected_monitor.map(function(m){
				selected_heartbeat.map(function(h){
					if(m.name === h.name)
					{
						flag = -1;
						return;
					}
				});
			});
		}

		if(flag == -1)
		{
			alert($.getInfo("err_msg_interface"));
			return false;
		}
		if(hb_intface && selected_heartbeat.length === 0)
		{
			alert($.getInfo("need_heartbeat_interface"));
			return false;
		}
		return true;
	}
	function submit_handler(){
		var type = document.getElementById('ha_mode').value;
		if(type != 0 && type != 4)
		{
			var $elem_m = $("#ha_monitor_intf");
			var selected_members = {monitor: []};
			if(manager_intface){
				var $elem_management = $("#ha_management_intf");
				selected_members.managementintf = [];
			}
			if(hb_intface){
				selected_members.heartbeat = [];
			}
			var hidElem;
			var i = 0;

			Object.keys(omniselects).forEach(function(id){
				if((hb_intface && id == 'heartbeat') || id == 'monitor' || (manager_intface && id == 'managementintf')){
					var _select = omniselects[id].getSelected();
					_select.forEach(function(obj){
						selected_members[id].push(obj.name);
					});
				}
			});

			$elem_m.val(selected_members["monitor"]);
			if(manager_intface){
				$elem_management.val(selected_members["managementintf"]);
			}
			
			if(hb_intface){
			document.forms[0].hb_device.value = selected_members["heartbeat"][0];
			document.forms[0].hb_device2.value =( selected_members["heartbeat"].length >= 2) ? selected_members["heartbeat"][1] : "";
			}

			
			if(!check_interface())
			{
				return false;
			}	
		}

		
		document.forms[0].apply.value = 1;
		if(!form_check()) return false;
		// if(!check_multi_group_status()) return false;
		document.forms[0].submit();
	};

	function on_heartbeat_change(){
		var hb_selected = omniselects["heartbeat"].getSelected();
		if(hb_selected.length > 2)
		{
			alert($.getInfo("msg_hb_limit"));
			hb_selected.splice(2, 1);
		}
		omniselects.heartbeat.update({selected: hb_selected});
	}

	$(document).ready(function(){
		Omniselect.prototype.PANE_TITLE = $.getInfo("Select Entries");
		Omniselect.prototype.SOURCES['ha.monitor']= {
			data: createMonitorInterfaceSource, 
			aliasFor: "interface",
			tooltipNameLabel: $.getInfo("ha_mgmt_port")
		};
		if(hb_intface){
			Omniselect.prototype.SOURCES['ha.heartbeat']= {
				data: createHeartbeatInterfaceSource, 
				aliasFor: "interface",
				tooltipNameLabel: $.getInfo("ha_mgmt_port")
			};
		}
		if(manager_intface){
			Omniselect.prototype.SOURCES['ha.managementintf']= {
				data: createManagementIntfInterfaceSource, 
				aliasFor: "interface",
				tooltipNameLabel: $.getInfo("ha_mgmt_port")
			};
		}
		fweb.util.commonRegExp = fweb.util.patterns.commonRegExp;
		omniselects["monitor"] = $("#ha_monitor_interface").omniselect(select_config.monitor.omniselect).omniselect("getInstance");
		if(hb_intface){
			omniselects["heartbeat"] = $("#ha_heartbeat_interface").omniselect(select_config.heartbeat.omniselect).omniselect("getInstance");
		}
		if(manager_intface){
			omniselects["managementintf"] = $("#ha_mgmt_port_interface").omniselect(select_config.managementintf.omniselect).omniselect("getInstance");
		}

				
		if(hb_intface && !manager_intface){
			$.when(createMonitorInterfaceSource(), createHeartbeatInterfaceSource()).then(function(){
				omniselects.monitor.update({selected: initSelects.monitor});
				omniselects.heartbeat.update({selected: initSelects.heartbeat});
			});	
		}else if(manager_intface && !hb_intface){
			$.when(createMonitorInterfaceSource(), createManagementIntfInterfaceSource()).then(function(){
				omniselects.monitor.update({selected: initSelects.monitor});
				omniselects.managementintf.update({selected: initSelects.managementintf});
			});	
		}else if(manager_intface && hb_intface){
			$.when(createMonitorInterfaceSource(), createHeartbeatInterfaceSource(), createManagementIntfInterfaceSource()).then(function(){
				omniselects.monitor.update({selected: initSelects.monitor});
				omniselects.heartbeat.update({selected: initSelects.heartbeat});
				omniselects.managementintf.update({selected: initSelects.managementintf});
			});
		}else{
			$.when(createMonitorInterfaceSource()).then(function(){
				omniselects.monitor.update({selected: initSelects.monitor});
			});
		}

		$("#button_apply").click(function(){
			submit_handler();
		});
		if(hb_intface)
		{
			$("#ha_heartbeat_interface").on("change", on_heartbeat_change);
		}		
		var type = document.getElementById('ha_mode').value;
		chg_type(type);
	});
})(jQuery, Omniselect);
