/*
  sysstatus.js - JS code for sysstatus.c
  Copyright Fortinet Ltd
*/

/*globals Page,confirm,is_rw_admin,m_strtbl,qlist_create_del,qlist_create_edit,
qlist_create_new,qlist_obj,qlist_realign_floating_header,qmenu_create_menubar,
qmenu_enable_button,tab_cnt,tab_id,tab_max*/

function widget_onclick()
{
    dashboard.addContent.display();
}

var new_tab_id = "";

function dash_load_tab()
{
    if (new_tab_id && new_tab_id.length)
    {
        top.mainnav.nb_refresh_menu(new_tab_id);
    }
}

function dash_add_onclick()
{
    fweb.dialog(fweb.iframe("/system/status/tabs?action=create&dialog=1")).done(dash_load_tab);
}

function dash_edit_onclick()
{
    var url = "/system/status/tabs?action=change&dialog=1";
    url += ("&tab_id=" + tab_id);
    fweb.dialog(fweb.iframe(url)).done(dash_load_tab);
}

function dash_delete_onclick()
{
    if (!confirm(m_strtbl.confirm_delete_dash)) return;
    $j.post("/system/status/tabs", {"action":"delete", "tab_id": tab_id}, function(data) {
        if (!data || typeof data.ret === "undefined") return;
        if (data.ret === 0)
        {
            if (typeof data.tab_id !== "undefined")
            {
                //refresh the menu bar and set focus to specific menu
                top.mainnav.nb_refresh_menu("dashboard_tab_" + data.tab_id);
            }
        }
        else if (typeof data.err !== "undefined")
        {
            alert(data.err);
        }
    }, "json");
}

function dash_reset_onclick()
{
    var ret = parent.main.dashboard.addContent.reset();
    if (typeof ret !== "undefined" && ret === false) return;
    top.mainnav.nb_refresh_menu("dashboard_tab_1");
}
/*
function dashboard_page_setup()
{
    // disable widget if no tab
    qmenu_enable_button($j("#m_widget"), tab_cnt > 0);
    // if last tab, disable remove button
    qmenu_enable_button($j("#m_remove"), tab_id !== 1 && tab_cnt > 1);
    // if already 5 tabs, disable add button
    qmenu_enable_button($j("#m_new"), tab_cnt < tab_max);
}
*/
function dash_cust_menu(aItems)
{
    var mAct;

    // widget
    mAct = Page.createMenuItem({id: 'm_widget',
                                spriteClass:"tool_new",
                                text: m_strtbl.widget,
                                ctxt: false,
                                click: {fn: widget_onclick}});
    aItems.push(mAct);
/*
    // menu for dashboard operation
    var m_new = Page.createMenuItem({id: "m_new",
                                    ctxt: false,
                                    text: m_strtbl.adddash,
                                    click: { fn: dash_add_onclick }});

    var m_edit = Page.createMenuItem({id: "m_edit",
                                      ctxt: false,
                                      text: m_strtbl.editdash,
                                      click: { fn: dash_edit_onclick }});

    var m_rm = Page.createMenuItem({id: "m_remove",
                                    ctxt: false,
                                    text: m_strtbl.deldash,
                                    click: { fn: dash_delete_onclick }});

    var m_reset = Page.createMenuItem({id: 'm_reset',
                                       text: m_strtbl.rstdash,
                                       ctxt: false,
                                       click: { fn: dash_reset_onclick }});

    var submenu = [m_new, m_edit, m_rm, m_reset];

    // dashboard menu
    var m_dash = Page.createMenuItem({id: 'm_dashboard',
                                     spriteClass:"tool_edit",
                                     text: m_strtbl.dash,
                                     ctxt: false});

    m_dash.addSubMenu("dash_drop", submenu);

    aItems.push(m_dash);
*/
}

$j(document).ready(function()
{
    // init for creating the list
    qlist_create_new(false);
    qlist_create_edit(false);
    qlist_create_del(false);
    qlist_obj.customize_menu_fn = dash_cust_menu;

    //create the menu
    var menubar_container = document.getElementById("qlist_yui_menubar_container");
    var oMB = qmenu_create_menubar("qlist_yui_menubar", qlist_obj, is_rw_admin);
    oMB.render(menubar_container);
    // the widgets are added later, so make the menu bar visible always
    $j("#qlist_hdrbar").css("z-index", 1);
    //dashboard_page_setup();
    qlist_realign_floating_header();
});

