function toggle_display(item)
{
	var $item = $j(item);
	var display = $item.parents('tr').css('display');
	var shown = (display != 'none');
	var checked = $item.prop('checked');
	var name = $item.attr('name');
	var selector = ['.shown_on', name, 'enabled'].join('_');
	$j(selector).css('display', (shown && checked) ? '' : 'none');

	if (name == 'password_policy')
	{
		toggle_display('[name="character_requirements"]');
	}
}

function toggle_disable(item)
{
	var $item = $j(item);
	var checked = $item.prop('checked');
	var selector = ['.disable_on', $item.attr('name'), 'unchecked'].join('_');
	$j(selector).prop('disabled', !checked);
}

function check_password_policy()
{
	if ($j('[name="password_policy"]').prop('checked') == false)
		return true;
	
	var range_info_list = [{
		name: 'min_len',
		min: 8,
		max: 128
	}, {
		name: 'uppercase',
		min: 0,
		max: 128
	}, {
		name: 'lowercase',
		min: 0,
		max: 128
	}, {
		name: 'numbers',
		min: 0,
		max: 128
	}, {
		name: 'special',
		min: 0,
		max: 128
	}, {
		name: 'history_passwd_num',
		min: 1,
		max: 10
	}, {
		name: 'password_expiration',
		min: 1,
		max: 999
	}];
	
	var len = range_info_list.length;
	var i = 0;
	var range_info_obj, $elem;
	for (; i < len; i++)
	{
		range_info_obj = range_info_list[i];
		$elem = $j('[name="'+range_info_obj.name+'"]');

		if ($elem.prop('disabled') == true)
			continue;

		if (checkIntRange($elem[0], range_info_obj.min, range_info_obj.max, $j.getInfo(range_info_obj.name+'_invalid')) == false)
			return false;
	}

	return true;
}
