var Widgets = {};
!function($) {
    function seconds2time(seconds) {
        var d = new Date(1e3 * seconds);
        return d.getFullYear() > 1970 ? [$j.pad(d.getHours()), $j.pad(d.getMinutes()), $j.pad(d.getSeconds())].join(":") : [$j.pad(d.getUTCHours()), $j.pad(d.getUTCMinutes()), $j.pad(d.getSeconds())].join(":")
    }
    function gen_country_flag_icon_by_code(country_code, country_name) {
        var className;
        return country_code ? className = "country_flag country_" + country_code : "Reserved" === country_name && (className = "country_flag country_RESERVED"),
        "<span class='" + className + "' title='" + country_name + "'></span> "
    }
    function gen_country_flag_icon_by_id(country_id, country_name) {
        var low = 255 & country_id
          , high = country_id >> 8
          , className = "country_flag country_" + String.fromCharCode(low) + String.fromCharCode(high);
        return "<span class='" + className + "' title='" + country_name + "'></span> "
    }
    var threat_clsmap = {
        ips: "ips-sensor",
        inspect: "dlp-sensor",
        app: "application-list",
        malware: "av-profile",
        web: "webfilter-profile",
        geo: "icap-profile"
    }
      //FWB_CHANGE , level_idmap = ["low", "med", "high", "crit"];
      , level_idmap = ["off", "low", "medium", "high", "critical"];
    Widgets = {
        format_fn: {
            address: function(element, column, config) {
                $j(element).addClass("address");
                var html = ""
                  , address = config[column.selector];
                if (config.children && config.children.length > 1 && (address = '<span class="aggregate-session-addresses">' + $j.validator.format($j.getInfo("session-addresses"), config.children.length) + "</span>"),
                !address)
                    return "";
                if (config.username && "source" == config.report_by) {
                    var className = "fa-user-unauthenticated"
                      , title = null;
                    return "quarantined" === config.forticlient_status ? (className = "ftnt-forticlient-quarantined",
                    title = $.getInfo("FortiClient device quarantined")) : "auth" == config.username_source && (className = "fa-user-authenticated"),
                    html = byod_common.gen_fw_icon(className, config.username, title),
                    html + " (" + address + ")" + fweb.util.formatters.create_whois_lookup_anchor(address)
                }
                return "destination" == config.report_by && config.country_id && config.country_id > 2 && (html += gen_country_flag_icon_by_id(config.country_id, config.country)),
                config.resolved && config.resolved != address ? html + config.resolved + " (" + address + ")" + fweb.util.formatters.create_whois_lookup_anchor(address) : html + address + fweb.util.formatters.create_whois_lookup_anchor(address)
            },
            username: function(element, column, config) {
                var className = "device_nouser"
                  , userName = $j.getInfo("unknown");
                return config.username && (className = "fa-user-unauthenticated",
                "auth" == config.username_source && (className = "fa-user-authenticated"),
                userName = escapeHTML(config.username)),
                byod_common.gen_fw_icon(className, userName)
            },
            ip: function(element, column, config) {
                var html = ""
                  , address = config.address;
                return config.country_id && config.country_id > 2 && (html += gen_country_flag_icon_by_id(config.country_id, config.country)),
                config.resolved && config.resolved != address ? html + config.resolved + " (" + address + ")" : html + address
            },
            country: function(elmt, col, data) {
                var html = ""
                  , country_id = data.dstn
                  , country_code = data.dstcountry_code
                  , value = data[col.selector];
                return "undefined" != typeof country_id && country_id > 2 && (html += gen_country_flag_icon_by_id(country_id, value)),
                ("undefined" != typeof country_code || "Reserved" === value) && (html += gen_country_flag_icon_by_code(country_code, value)),
                html += $j.getInfo("traffic_to") + " " + $j.getInfo(value)
            },
            device: function(element, column, config) {
                $j(element).addClass("device");
                var device = config.device
                  , mac = config.mac;
                if (!mac && !device)
                    return "";
                device || (device = $j.getInfo("detecting"));
                var alias = config.alias ? config.alias : config.hostname;
                return byod_common.gen_fw_device_icon(mac, config.device, alias)
            },
            slider_comparison: function(element, column, config) {
                $j(element).addClass(column.selector);
                var value = config[column.selector]
                  , max = column.max
                  , slider_value = value / max * 100
                  , format_fn = column.format_fn || ConvertToGroups
                  , html = "<div class='ui-slider-comparison-caption'>" + format_fn(value) + "</div><div class='ui-slider-comparison'><div class='ui-slider-compare-one' data-slider-value='" + slider_value + "'></div></div>";
                return html
            },
            sessions: function(element, column, config) {
                $j(element).addClass("sessions");
                var slider_value = config.count / config.max_sessions * 100
                  , html = "<div class='ui-slider-comparison-caption'>" + ConvertToGroups(config.count) + "</div><div class='ui-slider-comparison'><div class='ui-slider-compare-one' data-slider-value='" + slider_value + "'></div></div>";
                return html
            },
            slider_comparison_two: function(element, column, config) {
                function value(col) {
                    return config[col]
                }
                function sum(result, value) {
                    return result + value
                }
                $j(element).addClass(column.selector + " slider-comparison-two");
                var values = column.selectors.map(value)
                  , total = values.reduce(sum)
                  , left_col = column.selectors[0]
                  , slider_value = (column.selectors[1],
                config[left_col] / total * 100)
                  , px_width = total / column.max * 100
                  , formatted = column.format_fn ? column.format_fn(total, values) : convertNumberToUnits(total)
                  , html = "<div class='ui-slider-comparison-caption'>" + formatted + "</div><div class='ui-slider-comparison'><div class='ui-slider-compare-two' data-slider-value='" + slider_value + "' style='width: " + px_width + "px;'></div></div>";
                return html
            },
            bytes: function(element, column, config) {
                $j(element).addClass("bytes");
                var total_bytes = config.tx_bytes + config.rx_bytes
                  , slider_value = config.tx_bytes / total_bytes * 100
                  , px_width = total_bytes / config.max_bytes * 100
                  , html = "<div class='ui-slider-comparison-caption'>" + convertNumberToUnits(total_bytes) + "</div><div class='ui-slider-comparison'><div class='ui-slider-compare-two' data-slider-value='" + slider_value + "' style='width: " + px_width + "px;'></div></div>";
                return html
            },
            apps: function(element, column, config) {
                var app, app_id, app_name, i, html = "", apps = config[column.selector] || [{
                    id: 0
                }], _len = apps.length;
                if (null == element) {
                    var filter_str = "";
                    for (i = 0; _len > i; i++)
                        app = apps[i],
                        filter_str += (app.name || $j.getInfo("unknown")) + "  " + app.id + "  ";
                    return filter_str
                }
                for ($j(element).addClass("apps fgd-apps-list"),
                i = 0; _len > i; i++)
                    app = apps[i],
                    app_id = app.id || 0,
                    app_name = app.name || app.id || $j.getInfo("unknown"),
                    html += fgd_common.gen_app_html(app_id, app_name, config);
                return html
            },
            pol: function(elmt, col, data) {
                $j(elmt).addClass("policy");
                var pid = data[col.selector] || "";
                return ["<a href='/p/firewall/policy/edit/", pid, "/?redir=/success'>", pid, "</a>"].join("")
            },
            utm: function(elmt, col, data) {
                var cls = threat_clsmap[data.type];
                return cls ? ["<span class='icon_fw ", cls, "'>", $j.getInfo(data[col.selector]), "</span>"].join("") : void 0
            },
            itime: function(elem, col, config) {
                return seconds2time(config[col.selector])
            },
            threatlevel: function(td, col, data) {
                var level = level_idmap[data[col.selector]];
                //FWB_CHANGE return ["<span class='legend ", level, "'>", $.getInfo(level), "</span>"].join("")
                return ["<span class='severity-label wide severity-", level, "'>", $.getInfo(level), "</span>"].join("")
            },
            threattype: function(td, col, data) {
                var cls = threat_clsmap[data.threat_utm_type || data.type];
                return cls ? ["<span class='icon_fw ", cls, "'>", $j.getInfo(data[col.selector]), "</span>"].join("") : void 0
            },
            threatname: function(td, col, data) {
                var type = data.threat_utm_type || data.type
                  , appid = data.attackid || data.appid || data.app;
                return "app" === type ? ($(td).addClass("apps"),
                fgd_common.gen_app_html(appid, data[col.selector], {})) : "inspect" === type || "malware" === type || "ips" === type || "web" === type ? Widgets.format_fn.threattype(td, col, data) : "geo" === type ? Widgets.format_fn.country(td, col, data) : void 0
            }
        },
        callbacks: {
            load: function(resolve_apps) {
                $j(".ui-slider-compare-one, .ui-slider-compare-two", this).each(function() {
                    $j(this).slider({
                        disabled: !0,
                        range: !0,
                        values: [0, $j(this).data("sliderValue")],
                        min: 0,
                        max: 100
                    })
                }),
                byod_common.setup_device_tooltips(),
                fgd_common.setup_tooltips("span.tooltip", "fromclass", resolve_apps)
            }
        }
    },
    Widgets.gen_country_flag_icon_by_code = gen_country_flag_icon_by_code,
    Widgets.gen_country_flag_icon_by_id = gen_country_flag_icon_by_id
}(jQuery);
