/*
  sysvdom.js - misc JS code for sysvirtualdomainlist.c
  init Dec 2009 by Yanna Chen
  GUI redesign project
  Copyright Fortinet Ltd
*/

function setManagement(new_mgmt_vd){
    if(mgmt_vd==new_mgmt_vd)return;
    var msg=vdom_strtbl.confirm_switch+new_mgmt_vd+'?';
    if(confirm(msg)){
        window.location.href="/system/vdom/list?action=2&mkey="+new_mgmt_vd;
    }
}

function vdom_onclick_setmgmt()
{
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;
    setManagement(aElems[0].getAttribute("mkey"));
}

function vdomlist_handle_selection_change(q)
{
    // Let the default handler handle the standard buttons.
    qlist_handle_selection_change(q);

    var aElems = q.get_checked_rows();
    var mgmt_st = true;

    if (aElems.length != 1 || aElems[0].getAttribute("mkey") == mgmt_vd ||
        parseInt(aElems[0].getAttribute("is_disabled"))) {
        mgmt_st = false;
    }

    qmenu_enable_button($j("#mi_mgmt"), mgmt_st, q);
}

// vdomlist_menu - Override the default menubar to add a "password" button.
function vdomlist_menu(aItems)
{
    if (!is_rw_admin)
        return;

    // Display the current management vdom in the menu item
    var mgmt_str = vdom_strtbl.setmgmt_str + ' [ ' + mgmt_vd + ' ]';
    Item = Page.createMenuItem({id:"mi_mgmt", spriteClass:"tool_enter",
           single_only:true, text:mgmt_str, click:{fn: vdom_onclick_setmgmt} });
    aItems.push(Item);
}

// vdomlist_onload - onload handler for the vdom list page.
function vdomlist_onload()
{
    //qlist_obj.customize_menu_fn=vdomlist_menu;
    qlist_obj.handle_selection_change_fn=vdomlist_handle_selection_change;
    qlist_obj.create_edit = false;
    //qlist_obj.create_new=create_new;
    //qlist_del_url("/system/vdom/list?action=3");
    qlist_setup("qlist","/system/vdom/dlg","/system/vdom/dlg",false);
    vdom_list=[];
    vdom_list.push("");	
    $j("#qlist tr").each(function(tr){
        var mkey=$j(this).attr("mkey");
        if(mkey){
            vdom_list.push(mkey);
        }
    });
	if(top.mainnav.vdoms.length !== vdom_list.length) refreshState();
//    top.mainnav.navbar_refresh_menu(vdom_list);
}

function refreshState()
{
	vdom_list=[];
	$j("#qlist tr").each(function(tr){
		var mkey=$j(this).attr("mkey");
		if(mkey){
		    vdom_list.push(mkey);
		}
	});
	var loc = window.location,
		origin = loc.origin || (loc.protocol + '//' + loc.host);
	var message = {
		messageType: 'refreshState',
        refreshMenuId: 'vdom',
		vdom_list: vdom_list		
	};

	top.mainnav.postMessage(message, origin);
}

function enterVdom(vdom) {
	var loc = window.location,
		origin = loc.origin || (loc.protocol + '//' + loc.host);
	var message = {
		messageType: 'enterVDOM',
		vdom: vdom
	};

	top.mainnav.postMessage(message, origin);
}


hlight_table('qlist', 1, 0, 'over');

addEvent(window, "load", vdomlist_onload);


