/*
  wad_website.js - misc JS code for wadgui_website.c
  init Mar 2011 by majingang
  GUI redesign project
  Copyright Fortinet Inc
*/

function wad_website_delete_elems(q,aElems){
	var url = "/delete?id=" + g_cmdb_table_id + "&type=" + ctype+"&session_id="+session_id;
	var len = aElems.length;
	for(var i=0;i<len;i++){
		var mkey = aElems[i].getAttribute("mkey");
		url += "&mkey=" + mkey;
	}
	$j.submitPOST(url);
}

function wad_website_edit_elems(){
    var q = qlist_obj; 
    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;
	var mkey = aElems[0].getAttribute("mkey");
	document.location='/wad/website/dlg?id=' + mkey;
}

function wad_website_view_elems(){
    var q = qlist_obj; 
    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;
	var mkey = aElems[0].getAttribute("mkey");
	document.location='/wad/website/view?id=' + mkey;
}

function wad_website_onclick_reset(){
    var q = qlist_obj; 
    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;
    var mkey = aElems[0].getAttribute("mkey");
	document.location='/wad/website/revlist?id=' + mkey;
}

function wad_website_onclick_refresh(){
	document.location='/wad/website/list'
}

function wad_website_handle_selection_change(q)
{
    // Let the default handler handle the standard buttons.
    qlist_handle_selection_change(q);

    var aElems = q.get_checked_rows();
    if(is_rw_admin==0){
		return;
    }

	if(aElems.length == 1 ){
		qmenu_enable_button($("mi_view"), true, q);
		qmenu_enable_button($("mi_edit"), true, q);
		qmenu_enable_button($("mi_revert"), true, q);
	}else{
		qmenu_enable_button($("mi_view"), false, q);
		qmenu_enable_button($("mi_edit"), false, q);
		qmenu_enable_button($("mi_revert"), false, q);		
	}	
	if(aElems.length == 0){
		qmenu_enable_button($("mi_del"), false, q);
	}else{
		qmenu_enable_button($("mi_del"), true, q);
	}
	qmenu_enable_button($("mi_retrieve"), true, q);
}

function wad_website_menu(aItems)
{
    if(is_rw_admin>0){
	var mNew = Page.createMenuItem({id:"mi_view", spriteClass:"tool_view", ctxt:true,
			   text:wad_website_strtbl.view, click:{fn: wad_website_view_elems}});
	aItems.push(mNew);
	var mNew = Page.createMenuItem({id:"mi_revert", spriteClass:"tool_revert", ctxt:true,
			   text:wad_website_strtbl.reset, click:{fn: wad_website_onclick_reset} });
	aItems.push(mNew);
    }
	var mNew = Page.createMenuItem({id:"mi_retrieve", spriteClass:"tool_retrieve", ctxt:false,
			   text:wad_website_strtbl.refresh, click:{fn: wad_website_onclick_refresh} });
	aItems.push(mNew);
}

function wad_website_onload()
{
    qlist_obj.handle_selection_change_fn = wad_website_handle_selection_change;
    qlist_obj.customize_menu_fn = wad_website_menu;
    // Customize the qlist definition.
	qlist_obj.delete_elems_fn = wad_website_delete_elems;
	qlist_obj.edit_elem_fn = wad_website_edit_elems;
    qlist_setup("qlist", "/wad/website/dlg", "/wad/website/dlg",false);
}
hlight_table('qlist', 1, 0, 'over');

addEvent(window, "load", wad_website_onload);
