/*
  waf_profile.js - misc JS code for waf_profile_inline.c waf_profile_offline.c waf_autolearn_profile.c
  init Mar 2011 by KaiLiu
  GUI redesign project
  Copyright Fortinet Inc

  type: inline  offline  autolearn  data_type_group  suspicious_url

*/
function waf_profile_handle_selection_change(q)
{
    // Let the default handler handle the standard buttons.
    qlist_handle_selection_change(q);

    var aElems = q.get_checked_rows();
    if(!is_rw_admin)
    {
	qmenu_enable_button($j("mi_view"), true, q);
	return;
    }

    if(aElems.length == 1 && parseInt(aElems[0].getAttribute("can_clone")) == 1)
	qmenu_enable_button($j("mi_clone"), true, q);
    else
	qmenu_enable_button($j("mi_clone"), false, q);

    if (aElems.length == 1 && parseInt(aElems[0].getAttribute("can_view")) == 1)
    {
        qmenu_enable_button($j("mi_view"), true, q);
        qmenu_enable_button($j("mi_edit"), false, q);
    }else{
        qmenu_enable_button($j("mi_view"), false, q);
//        qmenu_enable_button($j("mi_edit"), true, q);
    }
}

function waf_profile_menu(aItems)
{
    if (can_view && is_rw_admin) 
    {
        var mNew = Page.createMenuItem({id:"mi_view", spriteClass:"tool_view", ctxt:true,
                   text:waf_profile_strtbl.view, click:{fn: waf_profile_onclick_view} });
        aItems.push(mNew);
    }
    if(can_clone && is_rw_admin)
    {
        var mNew = Page.createMenuItem({id:"mi_clone", spriteClass:"tool_clone", ctxt:true,
                   text:waf_profile_strtbl.clone, click:{fn: waf_profile_onclick_clone} });
        aItems.push(mNew);
    }
}
function waf_profile_onclick_clone()
{   
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;

    var mkey = aElems[0].getAttribute("mkey");
    var type = aElems[0].getAttribute("type");

    if(type == "inline")
	window.location.href = "/waf/profile_inline/dlgcopy?mkey=" + mkey + "&vdom=" + vdom;
    else if(type == "offline")
	window.location.href = "/waf/profile_offline/dlgcopy?mkey=" + mkey + "&vdom=" + vdom;
    else if(type == "autolearn")
	window.location.href = "/waf/autolearning_profile/dlgcopy?mkey=" + mkey;
    else if(type == "data_type_group")
	window.location.href = "/prot/data_type_group/dlgcopy?mkey=" + mkey;
    else if(type == "suspicious_url")
	window.location.href = "/prot/suspicious_url_rule/dlgcopy?mkey=" + mkey;
    else if(type == "waf_custom_access_rule") {
	window.location.href = "/waf/custom_access_rule/dlgcopy?mkey=" + mkey + "&vdom=" + vdom;
    }
    else if(type == "waf_http_cons_expt"){
	window.location.href = "/waf/http_constraints_expt/dlgcopy?mkey=" + mkey + "&vdom=" + vdom;
    }
    else if(type == "waf_brute_force_login")
	window.location.href = "/waf/brute_force_login/dlgcopy?mkey=" + mkey + "&vdom=" + vdom;
    else if(type == "prot_health_check"){
	window.location.href = "/prot/health_check/dlgcopy?mkey=" + mkey;
    }
}
function waf_profile_onclick_view()
{   
	var q = qlist_obj; // It would be cleaner if we could derive this from the event.

	var aElems = q.get_checked_rows();
	if (aElems.length != 1) return;

	var mkey = aElems[0].getAttribute("mkey");
	var type = aElems[0].getAttribute("type");

    if(type == "inline")
	window.location.href = "/waf/profile_inline/dlgframe?mkey=" + mkey + "&vdom=" + vdom;
    else if(type == "offline")
	window.location.href = "/waf/profile_offline/dlgframe?mkey=" + mkey + "&vdom=" + vdom;
    else if(type == "autolearn")
	window.location.href = "/waf/autolearning_profile/dlg?mkey=" + mkey;
    else if(type == "data_type_group")
	window.location.href = "/prot/data_type_group/dlg?mkey=" + mkey;
    else if(type == "suspicious_url")
	window.location.href = "/prot/suspicious_url_rule/dlg?mkey=" + mkey;
    else if(type == "tcp_flood_prevention")
	window.location.href = "/waf/tcp_flood_prevention/dlg?mkey=" + mkey;
    else if(type == "real_browser_rule")
	window.location.href = "/waf/real_browser_rule/dlg?mkey=" + mkey;
    else if(type == "dos_pro_pol")
	window.location.href = "/waf/dos_pro_pol/dlg?mkey=" + mkey + "&vdom=" + vdom;
    else if(type == "http_conn_flood_check_rule")
	window.location.href = "/waf/malicious_ips/dlg?mkey=" + mkey;
    else if(type == "http_req_flood_pre_rule")
	window.location.href = "/waf/http_flood_prevention/dlg?mkey=" + mkey;
    else if(type == "layer4_access_limit_rule")
	window.location.href = "/waf/http_access_limit_rule/dlg?mkey=" + mkey;
    else if(type == "waf_custom_access_rule") 
	window.location.href = "/waf/custom_access_rule/dlg?mkey=" + mkey + "&vdom=" + vdom;
    else if(type == "waf_http_cons_expt")
	window.location.href = "/waf/http_constraints_expt/dlg?mkey=" + mkey + "&vdom=" + vdom;
    else if(type == "waf_brute_force_login")
	window.location.href = "/waf/brute_force_login/dlg?mkey=" + mkey + "&vdom=" + vdom;
    else if(type == "prot_health_check")
	window.location.href = "/prot/health_check/dlg?mkey=" + mkey;

}
function waf_profile_delete_elems(q,aElems){
	var url = "/delete?id=" + g_cmdb_table_id;
	var len = aElems.length;
	var type = aElems[0].getAttribute("type");
	for(var i=0;i<len;i++){
		var mkey = encodeURIComponent(aElems[i].getAttribute("mkey"));
		url += "&mkey=" + mkey;
	}	
	if(type == "waf_custom_access_rule" || type == "waf_http_cons_expt" || type == "inline" || type == "offline" || type == "waf_brute_force_login" || 
			type == "dos_pro_pol")
		url += "&session_id="+session_id + "&vdom=" + vdom;
	else
		url += "&session_id="+session_id;

	$j.submitPOST(url);
}

function waf_profile_list_onload()
{
    // Customize the qlist definition.
    qlist_obj.customize_menu_fn = waf_profile_menu;
    qlist_obj.handle_selection_change_fn = waf_profile_handle_selection_change;
    qlist_obj.delete_elems_fn = waf_profile_delete_elems;

    qlist_setup("qlist", edit_profile_url, edit_profile_url,false);
}
hlight_table('qlist', 1, 0, 'over');

addEvent(window, "load", waf_profile_list_onload);
