/*
  wvs_integration.js
  GUI redesign project
  Copyright Fortinet Inc
*/
var wvs_integration_delete_url = "";
var wvs_integration_mitigate_url = "";
var single_row = 0;                    /*the flag when select only one row*/
function  wvs_integration_delete_elems()
{  
	var q = qlist_obj;
	var aElems = q.get_checked_rows();

	var url = "/wvs/integration/list";
	url = qlist_url_append_arg(url, "delete_dlg", "1");
	wvs_integration_delete_url = "/wvs/integration/delete?session_id="+session_id;
	
	var len = aElems.length;
	for (var i=0; i<len; i++){
		var mkey = aElems[i].getAttribute("mkey");
		wvs_integration_delete_url += "&delete=" + mkey;
	}
	wij_display_modal_dlg(url, { "width": 404, "height": 208 });
}

function wvs_integration_handle_selection_change(q)
{
    var aElems = q.get_checked_rows();
    var i, cancel_flag = 0;
    
    	if(!is_rw_admin)
    	{
	    qmenu_enable_button($j("#mi_import"), false, q);
	    qmenu_enable_button($j("#mi_miti"), false, q);
	    qmenu_enable_button($j("#mi_cancel"), false, q);
	    qmenu_enable_button($j("#mi_del"), false, q);
	    return;
    	}
    	if(aElems.length == 0){
	    qmenu_enable_button($j("#mi_miti"), false, q);
	    qmenu_enable_button($j("#mi_cancel"), false, q);
	    qmenu_enable_button($j("#mi_del"), false, q);
	}
	else if(aElems.length == 1)
	{
		qmenu_enable_button($j("#mi_del"), true, q);
		qmenu_enable_button($j("#mi_miti"), true, q);
		if(parseInt(aElems[0].getAttribute("can_cancel")) == 1)
			qmenu_enable_button($j("#mi_cancel"), true, q);
		else
			qmenu_enable_button($j("#mi_cancel"), false, q);
		single_row = 1;    
	}
	else {
		qmenu_enable_button($j("#mi_del"), true, q);
		qmenu_enable_button($j("#mi_miti"), true, q);
		for(i=0; i<aElems.length; i++)
		{
			if(parseInt(aElems[i].getAttribute("can_cancel")) == 1)
				cancel_flag = 1;
		}
		if(cancel_flag == 1)
			qmenu_enable_button($j("#mi_cancel"), true, q);
		else
			qmenu_enable_button($j("#mi_cancel"), false, q);
	}
}
function wvs_integration_onclick_import(){
	var form = document.forms[0];
	var url = "/wvs/integration/list";

	url = qlist_url_append_arg(url, "import", "1");
	
	wij_display_modal_dlg(url, { "width": 680, "height": 530 });
}

function wvs_integration_onclick_cancel(){
	var wvs_integration_cancel_url = "/wvs/integration/cancel?session_id=" + session_id;
	var q = qlist_obj;
	var aElems = q.get_checked_rows();
	var len=aElems.length;
	
	if (!confirm(logdisplay_texts.cancel_confirm)) {
		return;
	}
	for (var i=0; i<len; i++){
		var mkey = aElems[i].getAttribute("mkey");
		wvs_integration_cancel_url += "&item_id=" + mkey;
	}

	$j.submitPOST(wvs_integration_cancel_url);
}

function wvs_integration_onclick_miti(){
	var q = qlist_obj;
	var aElems = q.get_checked_rows();
	var url = "/wvs/integration/list";
	url = qlist_url_append_arg(url, "mitigate_dlg", "1");

	wvs_integration_mitigate_url = "/wvs/integration/mitigate?session_id="+session_id;

	var len = aElems.length;
	
	single_row = 0;

	if(len == 1)
	{
		single_row = 1;
		var mkey = aElems[0].getAttribute("mkey");
		url += "&item_id=" + mkey;
	}
	url = qlist_url_append_arg(url, "single_row", single_row);
	for (var i=0; i<len; i++){
		var mkey = aElems[i].getAttribute("mkey");
		wvs_integration_mitigate_url += "&item_id=" + mkey;
	}
	wij_display_modal_dlg(url, {"width": 600, "height": 380 });
}

function wvs_integration_menu(aItems)
{
	var mNew;

	if(is_rw_admin)
	{
		mNew = Page.createMenuItem({id:"mi_import", spriteClass:"tool_import", ctxt:true,
			text:wvs_integration_strtbl.scanner_import, click:{fn: wvs_integration_onclick_import} });
		aItems.unshift(mNew);

		mNew = Page.createMenuItem({id:"mi_del", spriteClass:"tool_delete", ctxt:true, 
			text:wvs_integration_strtbl.del, click:{fn: wvs_integration_delete_elems} } );
		aItems.push(mNew);

		mNew = Page.createMenuItem({id:"mi_miti", spriteClass:"tool_edit", ctxt:true,
			text:wvs_integration_strtbl.mitigate, click:{fn: wvs_integration_onclick_miti} });
		aItems.push(mNew);

		mNew = Page.createMenuItem({id:"mi_cancel", spriteClass:"tool_cancel", ctxt:true,
			text:wvs_integration_strtbl.cancel, click:{fn: wvs_integration_onclick_cancel} });
		aItems.push(mNew);
	}
}

function flt2LogFilter(flt)
{
	var col;
	for (var i = 0; (col = filter_settings.logColumns[i]); i++)
		if (col[0] == flt.id) break;

	return new LogFilter(
			flt.id,
			col[2],
			flt.logic.RANGE ? 1 : 0,
			flt.logic.NOT ? 1 : 0,
			flt.logic.RANGE ? flt.value[0] : "",
			flt.logic.RANGE ? flt.value[1] : "",
			flt.value);
}

function logfilterOK(panel)
{
	var logType = logdisplay_opts.type;
	var filter;
	var value_array;

	var filterCookieString = getCookie(filterCookieName);
	logFilterCookieArray = deserializeArray(filterCookieString ? filterCookieString : "");
	logFilterCookieArray[logType] = [];

	var err = 0;

	$j(panel).filterSection(
			function (flt) {
				if (!validate(flt)) {
					err = 1;
					return false;
				}
				if (flt.value && flt.value.join("").length) {
					logFilterCookieArray[logType] = setDisplayFilter(logFilterCookieArray[logType], flt2LogFilter(flt));
				}
			});

	if (err) return false;

	setCookie(filterCookieName, serializeArray(logFilterCookieArray));
	var form = document.forms[0];

	form.method = "POST";
	form.startline.value = 1;
	//form.log.value = unescape(form.log.value);
	form.submit();

	return false;
}

function LogFilter(fieldName, filterType, contains, negate, fromValue, toValue, valueList)
{
	this.fieldName = fieldName;
	this.filterType = filterType;
	this.contains = contains;
	this.negate = negate;
	this.fromValue = fromValue;
	this.toValue = toValue;
	this.valueList = valueList;

	this.toArray = function toArray() {
		var filterArray = new Array(this.fieldName, this.contains, this.negate, this.fromValue, this.toValue, this.valueList);
		return filterArray;
	}
}

function logdisplay_filter_setting()
{
	$j("#qlist_hdrrow").filterPopout();
}

function logfilterSetup(tableId, columnsArray, cookieName)
{
	// convert columns
	filter_settings.logColumns = columnsArray;
	var columns = [], col;
	for (var i = 0; (col = columnsArray[i]); i++) {
		if (col[0] == "pri" || col[0] == "utm_type")
			type = [col[2], DISPLAY_FILTER_TYPE_SELECT_MULTIPLE];
		else if (col[0] == "time")
			type = [FIELD_TYPE_TIME, 0];
		else if (col[0] == "date")
			type = [FIELD_TYPE_DATE, 0];
		else if (col[0] == "pri")
			type = [FIELD_TYPE_DATE, 0];
		else if (col[2] >= logdisplay_opts.LOG_FIELD_TYPE_UINT8 && col[2] <= logdisplay_opts.LOG_FIELD_TYPE_UINT32)
			type = [FIELD_TYPE_INTEGER, 0];
		else
			type = [col[2], 0];
		columns.push([col[0], col[1], type, col[3]]);
	}

	// parse cookie filter
	var logType = logdisplay_opts.type;
	var logFilterCookieString = getCookie(cookieName);
	var logFilterCookieArray = deserializeArray(logFilterCookieString ? logFilterCookieString : "");
	var logFilterArray = logFilterCookieArray[logType];
	if (!logFilterArray) logFilterArray = [];
	var flt;
	for (var i = 0; (flt = logFilterArray[i]); i++) {
		logFilterArray[i] = {
			"id": flt[0],
			"logic": {
				"NOT": flt[2],
				"OR": flt[1] != true,
				"RANGE": flt[1]
			},
			"value": flt[5] && flt[5].length ? flt[5] : [flt[3], flt[4]]
		};
	}

	// set filter column
	$j(tableId).filterConsole({
		"lang": {
			"heading": flt_lang["heading"],
		"ok": flt_lang["ok"],
		"apply": flt_lang["apply"],
		"cancel": flt_lang["cancel"],
		"from": flt_lang["from"],
		"to": flt_lang["to"],
		"format": flt_lang["format"],
		"value": flt_lang["value"],
		"change": flt_lang["change"],
		"fieldName": flt_lang["fieldName"],
		"input": flt_lang["input"],
		"select": "[ "+flt_lang["select"]+" ]",
		"addFilter": flt_lang["addFilter"],
		"clearFilter": flt_lang["clearFilter"],
		"rmHint": flt_lang["rmHint"]
		},
		"columns": fieldColumnParse(columns),
		"filters": logFilterArray,
		"expanded": filterExpaned,
		"action": logfilterOK
	});
}

function wvs_integrationlist_onload()
{
    // Customize the qlist definition.

    qlist_obj.customize_menu_fn = wvs_integration_menu;
    
    qlist_obj.create_del = false;
    
    qlist_obj.handle_selection_change_fn = wvs_integration_handle_selection_change;
    qlist_obj.create_new = false;
    qlist_obj.create_edit = false;
    //qlist_obj.delete_elems_fn = wvs_integration_delete_elems;
    qlist_setup("contentBody", "", "",false);

    $j('#qlist_right_menubar_container').append($j('#extra_right_hdr_items'));
    $j('#extra_right_hdr_items').css('visibility', 'visible');

    $j('#ftrtc').append($j('#paging_row'));
    $j('#paging_row').css('visibility', 'visible');

    $j("tr", "#contentBody").live("click", DetailsWindow.click);
    $j(document).keydown(DetailsWindow.keypress);

    if(typeof(filter_columns) != "undefined")
	    logfilterSetup("#qlist_hdrrow", filter_columns, filterCookieName);
    
    $j("td", "#contentBody").live("mouseover", function() {
	    var text = $j(this).text();

	    if (text != "") {
		    $j(this).attr("title", $j(this).text());
	    }
    });

    $j("#contentBody").addClass("oneline");

    var column_lang = {};

    if (document.forms[0] && document.forms[0].log) {
	    column_lang = fgt_lang[ document.forms[0].log.value ];
    }

    DetailsWindow.initialize({
	    "containerSelector" : "body",
	    "mainPanelSelector" : "#main_window",
	    "detailsPanelSelector" : "#log_details",
	    "detailsLocation" : "south",
	    "initialHidden" : logdisplay_opts.detail_panel_local == 0,
	    "formatCallbacks" : {
	    },
	    "rowData" : si_formatted,
	    "langOverride" : column_lang
    });
}
hlight_table('qlist', 1, 0, 'over');

addEvent(window, "load", wvs_integrationlist_onload);
