/*global escapeHTML, setQueryValue, fweb*/
/* exported DetailsWindow, FlexLayout */


var FlexLayout = (function($) {
    'use strict';
    var directions = {
        south: {
            size: 'height',
            scale: 1,
            coord: 'y'
        },
        east: {
            size: 'width',
            scale: 1,
            coord: 'x'
        },
        west: {
            size: 'width',
            scale: -1,
            coord: 'x'
        },
        north: {
            size: 'height',
            coord: 'y',
            scale: -1
        },
        center: {
            size: 'height',
            coord: 'y',
            scale: 0
        }
    };
    var clsHidden = 'layout-pane-hidden';
    /**
    * Implements the api for a jquery.layout but uses flexbox instead
    * if flexbox is not available, fallback on jquery.layout.
    * @TODO: move to a new file
    * @param {jQuery()} $target Target query selector that contains panes.
    * @param {Object} params {
    *   [pane]:{paneSelector:{String},
    *   [resizable: {Boolean}],
    *   [onresize_end: function(pane) {}],
    *   [onclose_end: function(pane) {}],
    *   [onopen_end: function(pane) {}],
    *   [initClosed: {Boolean}]}
    * } where [pane] is one of 'north','south','east','west','center'
    */
    function FlexLayout($target, params) {
        //{'center':{'paneSelector':'#main_window'},
        //'south':{'paneSelector':'#logview-details','resizable':true,
        //'togglerLength_open':0,'togglerLength_closed':0,
        //'onresize_end': function(){}}
        this.params = params;
        this.$target = $target;
        this.state = {};
        this.panes = Object.keys(params).reduce(get_panes.bind(this), {});
        //TODO: generalize this

        function get_panes(panes, name) {
            /* jshint validthis: true */
            var pane = this._initPane(name);
            if (pane) {
                panes[name] = pane;
            }
            return panes;
        }
    }
    FlexLayout.prototype = {
        $target: null,
        state: null,
        _initPane: function(name) {

            if (!(name in directions)) {
                return null;
            }
            var params = this.params[name],
                ps = params && params.paneSelector,
                $pane = ps && this.$target.find(ps);
            $pane.addClass('flex-layout');
            if (params.resizable) {

                params.resizer = this.$target.find('.flex-layout.ui-layout-resizer');
                if (!params.resizer.length) {
                    params.resizer = $('<div>', makeResizer(this));
                }
		/*
		if(log_type != 1){
			params.resizer.css("cursor", params.resizerCursor);
			params.resizer.css("width", "4px");
		
		
                	if (params.togglerContent_open) {
                    		params.resizer.append(makeToggler(this, params.togglerContent_open, 'open'));
                	}
                	if (params.togglerContent_closed) {
                    		params.resizer
                        		.append(makeToggler(this, params.togglerContent_closed, 'closed'));
                	}
		}*/
                $pane.before(params.resizer);
                if ($.support.transitionEvent) {
                    var animationEvent = 'transitionend.FlexLayout';
                    $pane.off(animationEvent).on(animationEvent, function() {
                        if (params.resizer) {
                            params.resizer.toggleClass('animating', false);
                        }
                    });
                }
                if (this.params.initClosed) {
                    this.hide(name);
                }
                this._resizeEnd(name, null, null, true);
            }
            return $pane.length ? $pane : null;
            function cancelDrag() { return false }
            function makeToggler(fl, content, state) {
                return $('<div>', {
                    addClass: 'ui-layout-toggler ui-layout-toggler-' + name +
                        ' ui-layout-toggler-' + state +
                        ' ui-layout-toggler-' + name + '-' + state,
                    title: $.getInfo(state === 'open' ? 'close' : 'open'),
                    append: $('<span>', {
                        addClass: 'content content-' + state,
                        append: content
                    }),
                    mousedown: function(event) {
                        event.stopPropagation();
                    },
                    click: function() {
                        fl.toggle(name);
                        fl._resizeEnd(name);
                    }
                }).on('dragstart', cancelDrag);
            }
            function makeResizer(fl) {
                var LMB = 1, DRAG_THRESHHOLD = 2, HIDE_THRESHHOLD = 50;
                return {
                    addClass: 'flex-layout ui-layout-resizer ui-layout-resizer-' + name,
                    mousedown: function(evt) {
                        if (evt.which === LMB) {
                            var hidden = $pane.hasClass(clsHidden),
                                distance = 0,
                                pos, size, end, showSize,
                                d = directions[name],
                                resizeLast = null;
                            resizeLast = {x: evt.pageX, y: evt.pageY};
                            immediate(true);
                            var $resizeCapture = $('<div>', {
                                    addClass: 'layout-resize-capture ' +
                                        'no-select flex-layout-resizing-' + name
                                })
                                .appendTo('body');
                            $resizeCapture.bind('mousemove',  function(evt) {
                                if (evt.which === LMB && resizeLast) {
                                    pos = {x: evt.pageX, y: evt.pageY};
                                    size = $pane[d.size]();
                                    if (size < HIDE_THRESHHOLD && !end) {
                                        $pane[d.size](null);
                                        $pane.toggleClass(clsHidden, true);
                                        end = pos[d.coord];
                                        hidden = true;
                                    } else {
                                        $pane[d.size](size + resizeLast[d.coord] - pos[d.coord]);
                                    }
                                    distance += d.scale *
                                        Math.abs(pos[d.coord] - resizeLast[d.coord]);
                                    resizeLast = pos;
                                    //calculate size based on pointer location hide (end)
                                    showSize = end && (end - pos[d.coord]) * d.scale;
                                    if (showSize > HIDE_THRESHHOLD &&
                                            showSize > 0) {
                                        $pane.toggleClass(clsHidden, false);
                                        $pane[d.size](showSize);
                                        end = null;
                                        hidden = false;
                                    }
                                } else {
                                    cancel();
                                }
                            }.bind(this));
                            $resizeCapture.bind('mouseup', cancel);
                        }
                        function cancel(evt) {
                            if (!evt || evt.which === LMB) {
                                $resizeCapture.remove();
                                resizeLast = null;

                                //handle click

                                if (evt && evt.which === LMB && distance < DRAG_THRESHHOLD) {
                                    fl.toggle(name);
                                    size = fl.state[name].size;
                                    hidden = null;
                                    immediate(false);
                                }

                                fl._resizeEnd(name, size, hidden);
                                immediate(false);
                            }
                        }
                        function immediate(value) {
                            $pane.toggleClass('immediate', value);
                            params.resizer.toggleClass('dragging', value);
                        }
                    }
                };
            }
        },
        _resizeEnd: function(name, size, hidden, silent) {
            var params = this.params[name],
                ps = params && params.paneSelector,
                $pane = ps && this.$target.find(ps),
                oldSize = this.state[name] && this.state[name].size;
            size = Math.round(size == null ? $pane[directions[name].size]() : size);
            hidden = hidden == null ? $pane.hasClass(clsHidden) : hidden;
            var wasClosed = this.state[name] && this.state[name].closed;
            if (hidden && this.state[name] && this.state[name].size) {
                size = this.state[name].size;
            }
            this.state[name] = {
                size: size,
                closed: hidden ? 1 : 0
            };
            if (params.resizer) {
                if ($.support.transitionEvent && !$pane.hasClass('immediate') &&
                        (oldSize !== undefined && oldSize !== size ||
                        wasClosed !== undefined && wasClosed !== hidden)) {
                    params.resizer.toggleClass('animating');
                }
                params.resizer.toggleClass('ui-layout-resizer-open ui-layout-resizer-' +
                    name + '-open', !hidden);
                params.resizer.toggleClass('ui-layout-resizer-closed ui-layout-resizer-' +
                    name + '-closed', hidden);
            }
            if (!silent) {
                if (wasClosed && !hidden && typeof params.onopen_end === 'function') {
                    params.onopen_end.call(null, name);
                } else if (!wasClosed && hidden && typeof params.onclose_end === 'function') {
                    params.onclose_end.call(null, name);
                } else if (typeof params.onresize_end === 'function') {
                    params.onresize_end.call(null, name);
                }
                //ensure center resize is called
                if (name !== 'center') {
                    this._resizeEnd('center');
                }
            }
        },
        sizePane: function(pane, size) {
            var $pane = this.getPane(pane);
            $pane[directions[pane].size](size);
        },
        show: function(pane) {
            this.toggle(pane, true);
        },
        open: function(pane) {
            this.show(pane);
        },
        hide: function(pane) {
            if (pane) {
                this.toggle(pane, false);
            } else {
                ['north', 'west', 'south', 'east'].forEach(this.hide.bind(this));
            }
        },
        toggle: function(pane, show) {
            var $pane = this.getPane(pane);
            if (show === undefined) {
                show = $pane.hasClass(clsHidden);
            }
            $pane.toggleClass(clsHidden, !show);
        },
        getPane: function(pane) {
            return this.$target.find(this.params[pane].paneSelector);
        }
    };
    return FlexLayout;
})(jQuery);

