
if (typeof (FOSGUI) === 'undefined') {
    FOSGUI = {};
}

// namespace
FOSGUI.WVSFormatter = (function ($) {

var level_idmap = ['low', 'med', 'high', 'crit'];

/**
 * Formatting callback for log entries
 * @callback formattingCallback
 * @param  {String} name The selector/key of the column
 * @param  {Object} row The source data of the row
 * @param  {Boolean} [content] If result will be used in displaying the qlist
 * @return {String|jQuery}
 */

//map of smart columns created below:
var smartColumnMap = {
    'app': ['dstport', 'proto', 'appid'],
    'dstip': ['dstport', 'dstcountry', 'dstip_hostname'],
    'srcip': ['srcmac', 'byod_name', 'byod_device', 'user']
};

//transform into a map from column selector to smart column selector
var scKeys = Object.keys(smartColumnMap);
scKeys.forEach(function(k) {
    smartColumnMap[k].forEach(function(col) {
        smartColumnMap[col] = k;
    });
    smartColumnMap[k] = k;
});

/**
 * Map of nonstandard format functions for displaying values in the log.
 * Used in the details window, qlist format_fn, and the archive data viewer
 * @type {Object.<string, formattingCallback>}
 */
var formatter = {
    'rel_time': function(name, row, content) {
        var value = row[name];
        var dt = fweb.util.localDateSeconds(value);
        // TODO: see why the FortiGate is using local time instead of UTC
        var result = $j.format_date_diff(dt);
        if (!content) {
            result += ' (' + value + ')';
        }

        return '<span title="' + dt.toLocaleString() + '">' + result + '</span>';
    },
    'severity': function(name, row, content) {
        var value = row[name]?row[name]:"";
        var sev = '';
        if (!content) {
            sev = value + ' ';
        }
        sev += '<img src="/images/' + value.toLowerCase() + '.png" title="' + value + '">&nbsp;';
        sev += '<nobr>' + $j.getInfo(value.toLowerCase()) + '</nobr>';
        return sev;
    },
    'miti_status': function(name, row, content) {
	var value = row[name]?row[name]:"";
	var html = '';
	if(!content) {
	    html = value + '';
	}
	if(value === 'Open')
		html += '<img src="/images/status_table.png" title="' + value +  '">&nbsp;';	
	else
		html += '<img src="/images/status_tb.png" title="' + value + '">&nbsp;';

	html += '<nobr>' + value + '</nobr>';
	return html;
    },
    'profile_name': function(name, row) {
	var url = row['profile_url']?row['profile_url']:"";
	var value = row[name]?row[name]:"";
	var html = '';

	if(url)
		html += '<a href="'+ url + '">' + value + '</a>';
	else 
		html += '<span>' + value + '</span>';

	return html;
    },
    'rule_name': function(name, row) {
	var url = row['rule_url']?row['rule_url']:"";
	var value = row[name]?row[name]:"";
	var html = '';

	if(url)
		html += '<a href="'+ url + '">' + value + '</a>';
	else 
		html += '<span>' + value + '</span>';
	
	return html;
    }
};

return {
        smartColumnMap: smartColumnMap,
        getFormatter: function () {
            return formatter;
        },
        format_fn_to: function(td, col, entry) {
            return formatter[col.selector](col.selector, entry, td);
        }
    }
})(jQuery);

