var qlist_prefix = 'qlist_wvs';
var now = new Date();
var param_filter = getQueryValue(window.location.search, 'filter');

var param_default_cols = getQueryValue(window.location.search, 'default_cols');

var qlist_columns_url = '/wvs/integration/column';

qlist_prefix += param_default_cols.replace(/,/, '_');

var filter_string = '[]';
var si_total_pages = wvs_ng.total_pages;
var si_current_page_num = 1;

var formatter = FOSGUI.WVSFormatter.getFormatter();

var last_session_id = 0;

function get_filter_disable_columns(columns) {
	'use strict';

	var LOG_FIELD_FCLD_FILTER = (1 << 2);
	var filter_disable_columns = ['#', 'rule_name'];

	return filter_disable_columns;
}

function details_window_selection_changed() {
    'use strict';
    //Re-apply the tooltips when details pane regenerated
    byod_common.setup_device_tooltips();
    //fgd_common.setup_tooltips('span.tooltip', 'fromclass', (resolve_apps === 'enable'));
}

var wvs_integration_delete_url = "";
var wvs_integration_mitigate_url = "";
var single_row = 0;                    /*the flag when select only one row*/

function wvs_integration_onclick_import(){
	var form = document.forms[0];
	var url = "/wvs/integration/dialog_import";

	wij_display_modal_dlg(url, { "width": 680, "height": 530 });
}

function wvs_integration_onclick_cancel(){
	var wvs_integration_cancel_url = "/wvs/integration/cancel?session_id=" + session_id;
	var q = qlist_obj;
	
	q.id = qlist_prefix + "-qlist";	
	
	var aElems = q.get_checked_rows();
	var len=aElems.length;

	if (!confirm($j.getInfo("cancel_confirm"))) {
		return;
	}
	for (var i=0; i<len; i++){
		var mkey = aElems[i].getAttribute("mkey");
		wvs_integration_cancel_url += "&item_id=" + mkey;
	}

	$j.submitPOST(wvs_integration_cancel_url);
}

function wvs_integration_onclick_miti(){
	var q = qlist_obj;
	q.id = qlist_prefix + "-qlist";	
	
	var aElems = q.get_checked_rows();
	var url = "/wvs/integration/dialog_miti";

	wvs_integration_mitigate_url = "/wvs/integration/mitigate?session_id="+session_id;

	var len = aElems.length;
	
	single_row = 0;

	if(len == 1)
	{
		single_row = 1;
		var mkey = aElems[0].getAttribute("mkey");
		//url += "?item_id=" + mkey;
		url = qlist_url_append_arg(url, "item_id", mkey);
	}
	url = qlist_url_append_arg(url, "single_row", single_row);
	for (var i=0; i<len; i++){
		var mkey = aElems[i].getAttribute("mkey");
		wvs_integration_mitigate_url += "&item_id=" + mkey;
	}
	wij_display_modal_dlg(url, {"width": 600, "height": 380 });
}

function  wvs_integration_delete_elems()
{  
	var q = qlist_obj;
	q.id = qlist_prefix + "-qlist";	
	
	var aElems = q.get_checked_rows();

	var url = "/wvs/integration/dialog_delete";
	
	wvs_integration_delete_url = "/wvs/integration/delete?session_id="+session_id;
	
	var len = aElems.length;
	for (var i=0; i<len; i++){
		var mkey = aElems[i].getAttribute("mkey");
		wvs_integration_delete_url += "&delete=" + mkey;
	}
	wij_display_modal_dlg(url, { "width": 404, "height": 208 });
}

function new_content_cb(content) {
    'use strict';
    now = new Date(Date.parse(content.now));
   
    DetailsWindow.initialize({
	    "containerSelector" : "body",
	    "mainPanelSelector" : "#main_window",
            "contentBodySelector" : "#contentHead table.qlist",
	    'detailsPanelSelector': '#wvs-details',
	    "initialHidden" : false,
	    "detailsLocation" : "south",
	    "formatCallbacks" : {
	    },
	    "rowData" : content.source 
    });
}

function wvs_integration_onload(filter)
{
	'use strict';
	var arg_filter = filter;
	var json_path = '/wvs/integration/listjson';
	//var json_path = '/waf/device_manage/json';

	filter = filter ? JSON.stringify(filter) : param_filter;
	json_path = setQueryValue(json_path, 'filter', filter);
	json_path = setQueryValue(json_path, 'aggregate', wvs_ng.aggregate);

	function single_arg_filter(arg) {return arg}
	
	wvs_ng.ready = $j.when($j.getJSON(json_path).then(single_arg_filter), wvs_ng.columns).then(
	function(content, column) {
		var $contentHead = $j('#contentHead').empty();
		if (content.status === 'error') {
			$j.alert($j.getInfo(content.error_code));
		}
		content.is_fortiview = false;
		content.is_all_session = false;

		wvs_ng.total_pages = Math.ceil(content.total_sz / wvs_ng.aggregate);
		si_total_pages = wvs_ng.total_pages;

		$j(window).off('message.qlistsource')
		.on('message.qlistsource', function(event) {
			event = event.originalEvent || event;
			var data = event.data;
			if (event.origin !== window.location.origin || !data.get) {
				return;
			}
			if (data.get === 'qlist.source' && data.id) {
				event.source.postMessage({put: data.get, value: content.source, id: data.id},
					window.location.origin);
			}
		});
		
		function search_completed() {
			return content.completed >= 100;
		}

		now = new Date(Date.parse(content.now));

		function is_col(col_name) {
			return function(col) {
				return col.selector === col_name;
			};
		}
		
		var filter_str = getParams({'filter': ''}).filter;
		if (filter_str) {
			var filter_obj = JSON.parse(filter_str);
			for (var i = 0, len = filter_obj.length; i < len; ++i) {
				var col = filter_obj[i].id;
				if (column.default_columns.indexOf(col) === -1 &&
						column.columns.some(is_col(col))) {
							column.default_columns.push(col);
						}
			}
		}

		function replace(expr, new_val) {
			return function(val) { return val.replace(expr, new_val) };
		}
		function in_arr(arr) {
			return function(val) { return arr.indexOf(val) !== -1 };
		}
		function not(fn) { return function(val) { return !fn(val) } }

		var add_cols = [];

		if (param_default_cols) {
			var remove_ex = /^-/;
			var remove_test = remove_ex.test.bind(remove_ex);
			var cols = param_default_cols.split(',');
			add_cols = cols
				.filter(not(remove_test));
			var rm_cols = cols.filter(remove_test)
				.map(replace(remove_ex, ''));
			column.default_columns = column.default_columns
				.filter(not(in_arr(rm_cols)))
				.concat(add_cols.filter(
							not(in_arr(column.default_columns))
						       ));
		}
		function col_order(cols, prop) {
			return function sort(a, b) {
				return index(prop ? a[prop] : a) - index(prop ? b[prop] : b);
			};
			function index(value) {
				value = cols.indexOf(value);
				return value > -1 ? value : Number.MAX_VALUE;
			}
		}

		function lang_order(a, b) {
			return $j.sortCompareText(
				$j.getInfo(a.lang_key),
				$j.getInfo(b.lang_key)
			);
		}
		last_session_id = content.session_id;
		
		var qlist_settings = {
			source: content.source,
			columns: column.columns
				.sort(lang_order)
				.sort(col_order(add_cols, 'selector')),
			default_columns: column.default_columns,
			checkboxes: {
				enabled: false,
				hide_disabled: false
			},
			categories: ['rel_time_format', 'name'],
			sort_categories_fn: null,
			options: {
				hide_default_buttons: true,
				disable_context_menu: true,
				resizable_columns:false,
				fixed_footer: true,
				resize_to_parent: false,
				css_layout: true
			},
			checkboxes: {
				enabled: false,
				hide_disabled: false
			},
			column_filters: {
				enabled: false,
				value: JSON.parse(filter),
				highlight: { enabled: true},
				// disable default filtering
				filter_fn: null,
				server_side_reload: function() {
					wvs_integration_onload(arg_filter);
				}
			},
			row_attr: [
				{selector: '#', name: 'mkey'},
			],
			format_fn: {
				// set default to escape all outputs prevent XSS Injection
				'*': function(td, col, entry) {
					return escapeHTML(entry[col.selector]);
				}
			},
			paging: {
				enabled: true,
				server_side: true,
				total_lines: content.total_lines,
				completed: search_completed,
				last_page_button: true,
				page_lines: content.total_lines,
				fetch: function(page_num, cb) {
					if (content.session_id !== last_session_id) {
						return;
					}
					var path = json_path;
					var startline = (page_num-1)*(wvs_ng.aggregate) + 1;
					if(startline < 1) startline = 1;
					
					path = setQueryValue(path, 'session_id', content.session_id);
					path = setQueryValue(path, 'startline', startline);
					path = setQueryValue(path, 'offset', wvs_ng.offset);
					path = setQueryValue(path, 'aggregate', wvs_ng.aggregate);
					if (page_num !== content.page_num) {
						content.page_num = page_num;
						content.source.length = 0;
					} else {
						path = setQueryValue(path, 'fetched', content.source.length);
					}
					/* this for filter change page info*/
					var raw_path = decodeURI(json_path);
					var filter_start = raw_path.indexOf('logic"%3A{"is');
					var filter_end = raw_path.indexOf('id"%3A"');
					var is_filter = (raw_path.substring(filter_start,filter_end).indexOf('rel_time') != -1 )?true:false;
					wvs_ng.showLoading();
					$j.getJSON(path, function(data) {
						wvs_ng.hideLoading();
						content.completed = data.completed;
						//The call order is critical, because cb updates DOM
						cb(data);
						$j.merge(content.source, data.source);
						content.total_lines = data.total_lines;
						if (!$j('tr.selected', '#contentHead').length) {
							new_content_cb(content);
						}
						
						$j('#contentHead').qlist('reload');
						
						if(is_filter) changePageText(data.source.length);
						wvs_ng.offset = data.offset;
					});
				}
			},
			prefix: qlist_prefix,
			callbacks: {
				load: function(){
					si_current_page_num = $j('.page_current').val();
					$j('#qlist_wvs_qlist_yui_menubar').toggle(false);
				}
			}
		};
		
		if (getParams({fortiview: 0}).fortiview) {
			delete qlist_settings.menu_items;
			qlist_settings.options.hide_menu = true;
		}

		// delegate the format function to the appropriate formatter function
		for (var x in formatter) {
			qlist_settings.format_fn[x] = FOSGUI.WVSFormatter.format_fn_to;
		}

		var result = $contentHead
			.removeData()
			.qlist(qlist_settings);

		$j.internationalizeLanguageEntries();
		
		$j("tr", "#contentHead").live("click", DetailsWindow.click);
		$j(document).keydown(DetailsWindow.keypress);
		
		new_content_cb(content);
		$j('#loading').hide();

		var raw_path = decodeURI(json_path);
		var filter_start = raw_path.indexOf('logic"%3A{"is');
		var filter_end = raw_path.indexOf('id"%3A"');
		var is_filter = (raw_path.substring(filter_start,filter_end).indexOf('rel_time') != -1 )?true:false;
		if(is_filter) changePageText(content.source.length);

		wvs_ng.offset = content.offset;
		
		$j("td", "#contentHead").live("mouseover", function() {
			var text = $j(this).text();
			if (text != "") {
				$j(this).attr("title", $j(this).text());
			}
		});

		filter_string = content.filter_string;

		setInactiveCountDown(timeout_in_sec);
		return $j.when(content.source, result);
	});

	wvs_ng.onload = wvs_integration_onload;
}

wvs_ng.showLoading = function() {
	'use strict';
	$j('#loading').css('display', '');
	$j('#contentHead').children().hide();
};

wvs_ng.hideLoading = function() {
	'use strict';
	$j('#loading').hide();
	$j('#contentHead').children().show();
};

wvs_ng.columns = $j.getJSON(qlist_columns_url).then(function(column) {
	'use strict';
	column.columns.forEach(function(col) {
		var returntrue = function() { return true; };
		// manually override the field type of some columns
		if (col.novalidate) {
			if (col.filter == null) { col.filter = {}; }
			col.filter.validate = returntrue;
		}

		if (col.selector === 'rel_time') {
			col.fld_type = FIELD_TYPE.DATE_TIME;
		}
		if ('fld_type' in col) {
			col.type = FIELD_TYPE_STRINGS[col.fld_type];
		}
	});
	return column;
});

wvs_ng.get_filter_disable_columns = get_filter_disable_columns;

var page_ready = $j.Deferred(),
    search_ready = 
    fweb.util.functional.castToJQueryPromise(wvs_ng.search_ready);
    $j(document).ready(page_ready.resolve.bind(page_ready));

//wrap onload function because otherwise the filter gets set incorrectly
$j.when(search_ready, page_ready)
	.then(function(filter) {
		'use strict';
		wvs_integration_onload(Array.isArray(filter) ? filter : undefined);
	});

function changePageText(num)
{
	$j(".total_lines").text(num);
	$j(".page_last").removeClass('list_action');
	$j(".page_last").addClass('tool_last0');
	$j(".page_current").attr('disabled','true');
	$j(".page_current").next().html ('');
	$j(".page_current").next().next().attr('style','display:none');
	$j(".total_lines").parent().parent().attr('style','display:none');
}

function update_aggregate_value()
{
	filter_string = JSON.parse(filter_string);
	$j.when(search_ready, page_ready)
		.then(function(filter) {
			'use strict';
			wvs_integration_onload(Array.isArray(filter_string) ? filter_string : undefined);
		});
}



