/******************************
 Navbar support code
 Init by A. Krywaniuk, Jan 2008
 GUI widgetization project
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

/* Symbols referenced by navbar_tpl.html: */
//EXPORT_SYMBOL reload_default_menu
//EXPORT_SYMBOL ev_l1_create_new
//EXPORT_SYMBOL ajax_save_menu_state
//EXPORT_SYMBOL vdom_button_change


/* Symbols referenced by wij_navbar.c: */
//EXPORT_SYMBOL nb_str_tbl
//EXPORT_SYMBOL default_l3_menu_id
//EXPORT_SYMBOL nb_vdom_list

/* Symbols referenced locally: */
//EXPORT_SYMBOL subnav
//EXPORT_SYMBOL attr
//EXPORT_SYMBOL offset

/* Symbols used in various C/JS modules: */
// EXPORT_SYMBOL navigate_to_tab
// EXPORT_SYMBOL nb_refresh_menu
// EXPORT_SYMBOL nb_set_selected_menu_id

// EXPORT_SYMBOL select_default_element

// Logging object
// TODO: for testing only
var mlogger_obj = new ygLogger("*");


// nb_str_tbl (obsolete) - string table for the navbar frame.
// (Will be updated at runtime by the C module.)
var nb_str_tbl = {
};

var nb_vdom_list = [];

// admin_profname - the adminstrator currently being edited.
var admin_profname = "";

// custom_menu_file - the name of the custom menu file we are using.
// (This is derived directly from the admin profname, although it could also be extracted
// from the URL in the menudef_diff iframe.)
// TODO: the default value is just a placeholder - it shouldn't be used for anything.
var custom_menu_file = "menu_cust.conf";

// Global options:
var enable_logger_window = false;


// nb_free_memory_after_menu_load - whether to free some memory after loading by deleting
// the menu source definition (probably not that significant).
var nb_free_memory_after_menu_load = true;

// nb_allow_customize_std_menus - whether we allow the standard menus to be customized
// (e.g. by adding custom submenus below an L1 menu).
var nb_allow_customize_std_menus = false;

// nb_allow_hide_std_menus - whether or not standard menus can
// be hidden from the layout.
var nb_allow_hide_std_menus = false;

// user_defined_menu_id - this string identifies custom menu items that are not read-only
// by the user, and which should be displayed in blue.
var user_defined_menu_id = "user_defined";

// navbar_js_vars_ready - initialization variable to indicate whether it is safe to
// use the menu_ref attributes attached to each menu item.
var navbar_js_vars_ready = false;

var cur_selected_l1_elem = null;

// default_l3_menu_id - The menu id to be selected on navbar load/refresh.
var default_l3_menu_id = null;

var last_clicked_l3_node = null;

/* Notes:

Only one L1 item can be open at a time. Opening another folder automatically causes
a list iteration to collapse the others.

*/


/******************************
   Advanced Operations
 ******************************/

function get_menu_id_from_l3_node(node)
{
    if (node && node.data && node.data.menu_ref)
    {
        return node.data.menu_ref.menu_id;
    }

    return "";
}

// save_l3_menu_position - Stores the current node name in the menu
// ref of it's parent node. This is used in conjunction with
// restore_l3_menu_position() to keep a short history of which l3 nodes
// have been referenced.
function save_l3_menu_position(node, menu_id)
{
    var o = node.getLabelEl();
    if (!o) return;

    var l1_obj = find_containing_L1_menu(o);
    if (l1_obj)
    {
        var l1_menu = l1_obj.menu_ref;
        l1_menu.last_clicked_l3_id = menu_id;
    }
}

// restore_l3_menu_position - Restore the 3rd level menu selection for an
// L1 menu. If no saved position is available, the first L3 node will be
// selected.
function restore_l3_menu_position(l1_elem)
{
    var l3_menu_id = l1_elem.menu_ref.last_clicked_l3_id;
    if (!l3_menu_id) l3_menu_id = locate_first_l3_menu_id(l1_elem.menu_ref);

    if (l3_menu_id)
    {
        display_tab_by_menu_id(l3_menu_id);
    }
}

function locate_first_l3_menu_id(l1_menu)
{
    var list = l1_menu.child_nodes;
    var len = list.length;

    if (l1_menu.child_nodes.length)
    {
        var l2_menu = l1_menu.child_nodes[0];
        if (l2_menu.child_nodes.length)
        {
            return l2_menu.child_nodes[0].menu_id;
        }
    }

    return null;
}

// locate_l3_menu_by_id - returns a stack of [L1, L2, L3] menus
// comprising a path to the desired tab id.
// NOTE: this only locates L3 tabs - it wouldn't locate a tab containing the
// target menu_id as an L4 widget.
function locate_l3_menu_by_id(tab_name)
{
    var len = l1elems.length;

    for (var i=0; i < len; i++)
    {
        var list2 = l1elems[i].child_nodes;
        var len2 = list2.length;

        for (var j=0; j<len2; j++)
        {
            var list3 = list2[j].child_nodes;
            var len3 = list3.length;

            for (var k=0; k<len3; k++)
            {
                var l3_menu = list3[k];
                if (l3_menu.menu_id == tab_name)
                {
                    // We need to return the whole context so as to
                    // apply the action via a series of clicks.
                    return [l1elems[i], list2[j], l3_menu, i, j, k];
                }
            }
        }
    }

    return null;
}


// navigate_to_tab - navigate the window to a specific tab.
// url_extra (optional) - additional parameters to pass to the page.
// NOTE: If the source of the event is a widget then only update that one frame. But if it's
// a full page then try to resync the navbar+subnav frames as well. Also, try to make
// sure the browser's "back" button still works afterwards.
function navigate_to_tab(menu_id, url_extra)
{
    // Check that we are in direct_load mode or at least viewing the
    // current page in full screen mode. We probably don't want to
    // navigate the whole window if the user is doing this from within
    // a widget.
    var resync_navbar = true;

    // Check for the new widgetized GUI frameset.
    var main_frm = parent.main;
    var icontainer_loaded = (main_frm.location.href.indexOf("/wij_icontainer") >= 0);
    if (icontainer_loaded)
    {
        // If we are in widget mode then don't resync the navbar.
        if (main_frm.wij_cur_layout != main_frm.wij_layout_single)
            resync_navbar = false;
    }

    // Store previous l1 menu item.
    var prev_selected_l1_elem = cur_selected_l1_elem;

    // It is possible that the administrator has hiddden the page we are looking
    // for, so it is certainly not a bug for locate_l3_menu_by_id to return null.
    var menu_ctxt = expand_l2_menu_from_l3_menu(menu_id);
    if (!menu_ctxt)
    {
        // TODO: is this an appropriate signal to the user here?
        alert(wij_string("err_no_access"));
        return;
    }

    if (cur_selected_l1_elem != prev_selected_l1_elem)
    {
        // Hide previous l1 menu if the context has switched.
        collapse_l1_menu(prev_selected_l1_elem, false);
    }

    // TODO: there still seems to be a problem with getting the browser's back
    // button to behave as desired.
    var l3_menu = menu_ctxt[2];
    var l3_elem = l3_menu.treeview;
    on_l3_menu_click(l3_elem, url_extra);
}


// display_tab_by_menu_id - navigate the main window to a new location.
// (replacement for refreshmenu)
function display_tab_by_menu_id(tab_name)
{
    navigate_to_tab(tab_name);
}


/******************************
     Obsolete & unsupported APIs
 ******************************/


// refreshmenu - navigate the main window to a new location.
// TODO: this function has a bad name & the parameters may
// not be applicable in the future.
function refreshmenu(main, sub, tab)
{
    // Shunt to the newer API.
    display_tab_by_menu_id(tab);
}



/******************************
     Menu Operations
 ******************************/

// expand_l2_menu_from_l3_menu - Given a 3rd level menu_id, this function
// will expand its parent l1 & l2 menus (if they exist). Closing previously
// expanded l1/l2 menus is not handled by this function.
function expand_l2_menu_from_l3_menu(menu_id)
{
    var menu_ctxt = locate_l3_menu_by_id(menu_id);
    if (!menu_ctxt)
    {
        // TODO: is this an appropriate signal to the user here?
        alert(wij_string("err_no_access"));
        return null;
    }

    var l1_menu = menu_ctxt[0];
    if (!l1_menu)
        return null;

    var l1_elem = $(l1_menu.id);
    // Use expand_l1_menu_i instead of on_level1_menu_click in order to avoid
    // the jerky menu animation while the page is still loading.
    quick_expand_l1_menu(l1_elem);

    var l2_menu = menu_ctxt[1];
    if (!l2_menu)
        return null;

    // Second level menu must be expanded for 3rd level to be found.
    l2_menu.treeview.expand();

    return menu_ctxt;
}

// select_default_element - open & select the default element.
function select_default_element()
{
mlogger.debug("begin select_default_element");

    var menu_id = default_l3_menu_id;
    if (!menu_id)
    {
        // If no default is specified, use the first L1/L2/L3 menu.
        menu_id = get_menu_id_from_l3_node(last_clicked_l3_node);
    }

    var menu_ctxt = expand_l2_menu_from_l3_menu(menu_id);
    if (!menu_ctxt)
        return;

    var l3_menu = menu_ctxt[2];
    if (!l3_menu)
        return;

    // Select default 3rd level menu, and navigate to that page.
    on_l3_menu_click(l3_menu.treeview);

mlogger.debug("end select_default_element");
}

// nb_set_selected_menu_id - Update the navigation to indicate that
// a given l3 menu_id is selected. This will only update the navigation,
// and will not change the main content frame to view that tabs location.
function nb_set_selected_menu_id(menu_id)
{
    var prev_selected_l1_elem = cur_selected_l1_elem;

    var menu_ctxt = expand_l2_menu_from_l3_menu(menu_id);
    if (!menu_ctxt)
        return;

    // Collapse the previously open L1 menu if it is different
    // than the new one.
    if (cur_selected_l1_elem != prev_selected_l1_elem)
    {
        collapse_l1_menu(prev_selected_l1_elem, false);
    }

    var l3_menu = menu_ctxt[2];
    if (!l3_menu)
        return;

    // Highlight 3rd level menu w/o changing navigation.
    highlight_l3_menu(l3_menu.treeview);
}

// quick_collapse_l1_menu - collapse a specific menu item.
function collapse_l1_menu(l1_elem, should_animate)
{
    if (!l1_elem)
        return;

    var l1_menu = l1_elem.menu_ref;
    var fold_tr = $(l1_menu.fold_id);

    if (!fold_tr)
        return; // invalid element.

    l1_elem.collapsed = true;

    // Change the state of the twistie on the l1 menu item.
    $j("div.menu_level1_selected", l1_elem).removeClass("menu_level1_selected");

    // Collapse the folder.
    enable_display(fold_tr, false, should_animate);
}


// quick_collapse_l1_menu - collapse a specific menu item with no animation.
function quick_collapse_l1_menu(l1_elem)
{
    collapse_l1_menu(l1_elem, false);
}

// get_elem_css_sum - returns the sum of an array of css attributes for a
// particular jQuery object reference.
function get_elem_css_sum(elem, attrs)
{
    var sum = 0;
    for (var i=0; i<attrs.length; i++)
    {
        sum += parseInt(elem.css(attrs[i]).replace("px", ""));
    }
    return sum;
}

function get_elem_v_padding(elem)
{
    return get_elem_css_sum(elem, ["padding-top","padding-bottom"]);
}

function get_elem_h_padding(elem)
{
    return get_elem_css_sum(elem, ["padding-left","padding-right"]);
}

function get_elem_v_margin(elem)
{
    return get_elem_css_sum(elem, ["margin-top","margin-bottom"]);
}

function get_elem_h_margin(elem)
{
    return get_elem_css_sum(elem, ["margin-left","margin-right"]);
}

// navbar_adjust_l1_menus - Adjust the height of l1 menu lists so that the
// expanded one takes up the majority of the screen space, and the others
// are pushed to the bottom.
function navbar_adjust_l1_menus(l1_elem)
{
    if (!l1_elem) return;

    var l1_menu = l1_elem.menu_ref;
    var fold_tr = $j("#" + l1_menu.fold_id);

    // All visible menus.
    var l1_menus = $j("div.menu_level1:visible");

    // .height() is for the first matched element, so multiply it for each.
    var l1_height = l1_menus.height() * l1_menus.length;
    var l1_v_padding = get_elem_v_padding(fold_tr);
    var l1_h_padding = get_elem_h_padding(fold_tr);

    // Get document width & height.
    var wnd_height = $j(window).height();
    var wnd_width = $j(window).width();
    var doc_v_margin = get_elem_v_margin($j(document.body));
    var doc_h_margin = get_elem_h_margin($j(document.body));

    var fold_height = (wnd_height - doc_v_margin - l1_height - l1_v_padding);
    var fold_width = (wnd_width - doc_h_margin - l1_h_padding);

    // Fix the height of each folding list (knocking other l1 menus to the bottom).
    fold_tr.css("height", fold_height);

    fold_tr.css("width", fold_width);
}

// cache_element_positions - Store the current absolute position for
// all selected elements in the object's "data" object. These calculations
// can be used to set the absolute position in a subsequent call, without
// affecting the current positions.
function cache_element_positions(elements)
{
    elements.each( function() {
        var j_elem = $j(this);
        j_elem.data("abs_position", j_elem.offset());
    });
}

// set_element_position_absolute - Uses the stored absolute position from
// cache_element_positions to fix an object in place.
function set_element_position_absolute(obj)
{
    var j_elem = $j(obj);

    // Fail if abs_position attribute is not available.
    var offset = j_elem.data("abs_position");
    if (!offset) return;

    var width = j_elem.width();

    j_elem.css(offset).css({"position": "absolute", "width": width});
}

// set_element_position_static - Remove absolute position values from
// the selected element. Reverts back to static positioning.
function set_element_position_static(obj)
{
    var j_elem = $j(obj);

    j_elem.css({"position": "static", "width": "100%"});
}

// lock_bottom_l1_elems - Fix all "bottom" l1 elements (ie: those below both
// the current and selected element) in position. This prevents an
// undesirable bounce effect seen on the navbar when animations happen
// quickly. 
function lock_bottom_l1_elems(l1_elem)
{
    // Select all visible menus (including VDOM button).
    var l1_menus = $j("div.menu_level1_container:visible, #nb_vdom_btn");

    cache_element_positions(l1_menus);

    // All elements after BOTH the current & new selected elements
    // must be fixed. The menu serial number can be used to easily
    // calculate which ones need to be fixed.
    var min_serialno = l1_elem.menu_ref.serialno;
    if (cur_selected_l1_elem)
    {
        min_serialno = Math.max(l1_elem.menu_ref.serialno, cur_selected_l1_elem.menu_ref.serialno);
    }

    l1_menus.each( function() {
        if (this.menu_ref && this.menu_ref.serialno <= min_serialno) return;
        set_element_position_absolute(this);
    });
}

// unlock_bottom_l1_elems - Return all l1 menus to "static" positioning in preparation
// for a resize, navbar click, etc.
function unlock_bottom_l1_elems()
{
    // Select all visible menus (including VDOM button).
    var l1_menus = $j("div.menu_level1_container:visible, #nb_vdom_btn");

    l1_menus.each( function() {
        set_element_position_static(this);
    });
}

// expand_l1_menu_i - implementation of menu expansion.
function expand_l1_menu_i(l1_elem, should_animate)
{
    var l1_menu = l1_elem.menu_ref;
    var fold_tr = $(l1_menu.fold_id);

    // Store reference to current selected element.
    cur_selected_l1_elem = l1_elem;

    l1_elem.collapsed = false;

    // Set the highlight.
    $j("div.menu_level1", l1_elem).addClass("menu_level1_selected");

    navbar_adjust_l1_menus(l1_elem);

    enable_display(fold_tr, true, should_animate);
}


// expand_l1_menu - cause an animated expansion of an L1 menu.
function expand_l1_menu(l1_elem)
{
    expand_l1_menu_i(l1_elem, true);
}


// quick_expand_l1_menu - expand a specific menu item with no animation.
function quick_expand_l1_menu(l1_elem)
{
    expand_l1_menu_i(l1_elem, false);
}


/******************************
 "<< Global" button (VDOM mode)
 ******************************/

// vdom_button_change - VDOM selection changed.
function vdom_button_change(obj)
{
    // We could refresh the entire frameset to switch out of vdom mode.
    // A more advanced (lower latency) method is to just update the navbar
    // frame.
    var url = window.location.href;
    url = update_url_component(url, "vdom", obj.value);

    // Ensure that the highlighting option is removed when
    // returning to Global mode.
    url = update_url_component(url, "hilite", "0");

    // Unset the "default_tab" value when returning to Global mode.
    url = update_url_component(url, "default_tab", "");

    window.location.href = url;

    // The following is the old method which refreshes the entire frameset.
    //top.location='/index?vdom_list=1';
}


/******************************
     Menu Animation
 ******************************/

var navbar_slide_down = false;
var navbar_slide_up = false;
var navbar_complete_cb = null;

function is_navbar_animating()
{
    return navbar_slide_down || navbar_slide_up;
}

function on_navbar_animation_complete()
{
    if (is_navbar_animating()) return;

    unlock_bottom_l1_elems();

    if (navbar_complete_cb)
    {
        navbar_complete_cb();
        navbar_complete_cb = null;
    }
}

// enable_display - begin the (optionally animated) open/collapse operation.
// TODO: this function has a bad name.
function enable_display(l1_folder, enable, should_animate)
{
    // If disabling, make sure to set the tr visibility in the end. Otherwise, it is
    // safe to set it at the beginning.
    var display_val = enable ? "" : "none";

    if (should_animate)
    {
        if (enable)
        {
            navbar_slide_down = true;
            $j(l1_folder).slideDown("normal", function() {
                navbar_slide_down = false;

                on_navbar_animation_complete();
            });
        }
        else
        {
            navbar_slide_up = true;
            $j(l1_folder).slideUp("normal", function() {
                navbar_slide_up = false;

                on_navbar_animation_complete();
            });
        }
    }
    else
    {
        $j(l1_folder).toggle(enable);
    }
}


/******************************
     Event Handlers
 ******************************/

// find_containing_L1_menu - find the L1 menu root node containing this element.
function find_containing_L1_menu(obj)
{
    while (obj)
    {
        if (obj.id && obj.id.match("l1mi_dv_"))
            return obj;

        obj = obj.parentNode;
    }

    return null;
}

// on_level1_menu_click - respond to a click on an L1 menu by expanding it.
function on_level1_menu_click(obj)
{
    // Ignore menu click's during animations.
    if (is_navbar_animating()) return;

    var l1_elem = find_containing_L1_menu(obj);

    if (l1_elem.collapsed)
    {
        // Set a callback to navigate to the new tab only after the animation is
        // complete. If we attempt to navigate to a new tab before the animation
        // is completed, it is jerky or not displayed at all.
        navbar_complete_cb = function() {
            // Restore previously selected L3 menu, or first available one.
            restore_l3_menu_position(l1_elem);
        };

        // Lock the bottom l1 menus in position for the animation. The position
        // will be restored when the animation is complete.
        lock_bottom_l1_elems(l1_elem);

        // In standard nav mode, collapse the previously opened L1 menu
        collapse_l1_menu(cur_selected_l1_elem, true);

        // Expand this menu.
        expand_l1_menu(l1_elem);
    }
}

// find_containing_L2_menu - find the L2 menu root node containing this element.
function find_containing_L2_menu(obj)
{
    do
    {
        if (obj.id && obj.id.match("l2mi_dv_"))
            return obj;

        obj = obj.parentNode;
    }
    while (obj);

    return null;
}

/******************************
   Rendering Menu items
 ******************************/

/* Notes on menu rendering:

The initial rendering of the main menu HTML code is optimized via
the StringBuffer technique. The L1 HTML is generated in two parts since
we may wish to insert L2 submenus within the folder div. The closing
section of the L1 HTML is always the same, so we just create a static
string for that part.

Despite these optimizations, the overall generation time for the menus
is not really optimized all that menu because we still have to go back
and fixup some JS variables later. However, the visual effect for the
user is greatly improved because the HTML rendering can be done first
and then the JS fixups can be done in the background later.

*/


/* Alternate template w/ colourful borders around all the divs: (useful for testing)

// ar_l1_elem_templ_part1 - template for creating the L1 menu opening HTML code.
var ar_l1_elem_templ_part1 = [
    '<div id="l1mi_dv_',
    "", // [1] = serialno
    '" class="menu_level1_container" style="border:1px solid blue">',
    // Header row
    '<div class="menu_level1" NOWRAP onclick="on_level1_menu_click(this)" onmouseover="level1_mover(this)" onmouseout="level1_mout(this)" style="border:1px solid red">',
    "", // [4] = name
    '</div>',
    // Folder row
    '<div id="l1mi_fdr_',
    "", // [7] = serialno
    '" class="foldinglist" style="display:none; border:1px solid yellow">'
];
*/

// ar_l1_elem_templ_part1 - template for creating the L1 menu opening HTML code.
var ar_l1_elem_templ_part1 = [
    '<div id="l1mi_dv_',
    "", // [1] = serialno
    '" class="menu_level1_container">',
    // Header row
    '<div class="menu_level1" NOWRAP title="',
    "", // [4] = title
    '" onclick="on_level1_menu_click(this)">',
    "", // [6] = name
    '</div>',
    // Folder row
    '<div id="l1mi_fdr_',
    "", // [9] = serialno
    '" class="foldinglist" style="display:none;">'
];

// gen_l1_elem_opening_html - 
function gen_l1_elem_opening_html(l1_menu)
{
    var arr = ar_l1_elem_templ_part1;
    arr[1] = l1_menu.serialno;
    arr[4] = l1_menu.menu_name;
    arr[6] = l1_menu.menu_name;
    arr[9] = l1_menu.serialno;

    return arr.join("");
}


// ar_l1_elem_templ_part2 - template for creating the L1 menu closing HTML code.
var ar_l1_elem_templ_part2 = [
    // End the folder row and create the footer div.
    '</div><div style="display:none">',
    // Rows 1-3 should be disabled if we are not in edit mode.
    '<div class="menu_level2_crnew" onclick="ev_l2_create_new(this)" title="',
    '', // [2] = wij_string("create_new")
    '">+</div>',
    '</div></div>'
];

// TODO: test of using an image instead of the + sign
//ar_l1_elem_templ_part2[1] = '<div class="menu_level2_crnew" style="width:30px; background-color:"><img src="/images/db_add.gif" title=">';

// l1_closing_html - cached version of the string, since it is always the same.
var l1_closing_html = null;
var l1_closing_html_with_crnew = null;


// gen_l1_elem_closing_html - Generate the closing HTML for the L1 menu (or return
// a cached string if available).
function gen_l1_elem_closing_html(menu_ref)
{
    if (l1_closing_html)
        return l1_closing_html;

    // Use the same template as above, but skip rows 1 & 2.
    var arr = ar_l1_elem_templ_part2;
    l1_closing_html = arr[0] + arr[4];
    return l1_closing_html;
}

// gen_l1_elem_tree_view - Generate the 2nd and 3rd level tree-view for
// a level 1 menu.
function gen_l1_elem_tree_view(l1_menu)
{
    var list = l1_menu.child_nodes;
    var len = list.length;
    var tree = new YAHOO.widget.TreeView("l1mi_fdr_" + l1_menu.serialno);
    tree.singleNodeHighlight = true;

    tree.subscribe("clickEvent",
        function(node){
            if (node.node.data.menu_ref.menu_url == undefined) {
                node.node.toggle();
                blur_yui_tree_node(node.node);
            }
            else {
                on_l3_menu_click(node.node);
            }

            return false;
        });

    //get a reusable reference to the root node:
    var root = tree.getRoot();

    for (var i=0; i<len; i++)
    {
        add_l2_elem_tree_node(root, list[i]);
    }

    return tree;
}

function add_l2_elem_tree_node(node, l2_menu)
{
    var l2_list = l2_menu.child_nodes;
    var l2_len = l2_list.length;

    var l2_node = new YAHOO.widget.TextNode( {
            style: "ygtvlabel l2_menu_" + l2_menu.menu_id,
            label: "<span>" + l2_menu.menu_name + "</span>",
            menu_ref: l2_menu
        },
        node,
        false);

    for (var j=0; j<l2_len; j++)
    {
        add_l3_elem_tree_node(l2_node, l2_list[j]);
    }

    l2_menu.treeview = l2_node;
}

function add_l3_elem_tree_node(node, l3_menu)
{
    var l3_node = new YAHOO.widget.TextNode({
            style: "ygtvlabel l3_menu_node",
            label: "<span>" + l3_menu.menu_name + "</span>",
            menu_ref: l3_menu
        },
        node,
        false);

    // Store a reference to the first available l3 menu (as it will be selected by default).
    if (last_clicked_l3_node == null)
    {
        last_clicked_l3_node = l3_node;
    }

    l3_menu.treeview = l3_node;
}

function add_l3_menu_highlight(node)
{
    // Add highlight class to parent <td>.
    var o = node.getLabelEl();
    if (!o) return;

    o.parentNode.className = "selected";
}

function remove_l3_menu_highlight(node)
{
    var o = node.getLabelEl();
    if (!o) return;

    o.parentNode.className = "";
}

function blur_yui_tree_node(node)
{
    var o = node.getLabelEl();
    if (!o) return;

    o.blur();
}

// highlight_l3_menu - Remove highlight from previously
// selected l3 menu, add highlighting to the new node.
function highlight_l3_menu(node)
{
    blur_yui_tree_node(node);

    // Remove the highlight from last clicked node.
    if (last_clicked_l3_node != null)
    {
        remove_l3_menu_highlight(last_clicked_l3_node);
    }

    add_l3_menu_highlight(node);

    last_clicked_l3_node = node;
}

// on_l3_menu_click_report_section - Handle click of "report section"
// L3 menus when report layout is already loaded in content frame.
function on_l3_menu_click_report_section(node, menu_ref)
{
    top.main.ReportLayout.set_active_section( menu_ref.menu_report_section );

    save_l3_menu_position(node, menu_ref.menu_id);
}

// on_l3_menu_click - Load selected l3 menu.
function on_l3_menu_click(node, url_extra)
{
    highlight_l3_menu(node);

    // load new menu url
    var menu_ref = node.data.menu_ref;
    var url = menu_ref.menu_url;

    if (typeof menu_ref.menu_report_section != "undefined" && top.main.ReportLayout) {
        return on_l3_menu_click_report_section(node, menu_ref);
    }

    if (typeof url_extra != "undefined")
        url += (url.indexOf("?") < 0 ? "?" : "&") + url_extra;
    top.main.location = url;

    save_l3_menu_position(node, menu_ref.menu_id);
}


// render_global_menu_tree - called to display the full menu tree as
// stored in the JS tree.
function render_global_menu_tree()
{
mlogger.debug("render_global_menu_tree");
    var oList1 = l1elems;
    var len1 = l1elems.length;

    var aHtml = [];

    for (var i=0; i<len1; i++)
    {
        var l1_menu = oList1[i];
        var str = gen_l1_elem_opening_html(l1_menu);
        aHtml.push(str);

        var oList2 = l1_menu.child_nodes;
        var len2 = oList2.length;

        l1_menu.treeview = gen_l1_elem_tree_view(l1_menu);

        var end_str = gen_l1_elem_closing_html(l1_menu);
        aHtml.push(end_str);
    }

    var menu_div = $("nb_dv_main");
    var str = aHtml.join("");
    menu_div.innerHTML = str;
mlogger.debug("end render_global_menu_tree");
}

// fixup_menuelem_js_vars - fixup the JS variables for all menu items after the
// HTML has been rendered.
function fixup_menuelem_js_vars()
{
mlogger.debug("begin fixup_menuelem_js_vars");
    var oList1 = l1elems;
    var len1 = l1elems.length;

    for (var i=0; i<len1; i++)
    {
        // TODO: is it better to make these HTML attributes instead of JS vars?
        var l1_menu = oList1[i];
        var l1_elem = $(l1_menu.id);
        l1_elem.collapsed = true;
        l1_elem.hovered = false;
        l1_elem.menu_ref = l1_menu;

        if (l1_menu.treeview) l1_menu.treeview.draw();
    }
mlogger.debug("end fixup_menuelem_js_vars");

    navbar_js_vars_ready = true;
}

// render_new_l1_menu - render a newly created L1 menu item.
// (and automatically fixup the JS vars)
function render_new_l1_menu(l1_menu)
{
    // Since this is a newly created menu item, we don't look for existing elements
    // in the DOM. We try to reuse as much of the optimized menu loading framework
    // as possible, although speed is not as critical while creating new menu
    // items on the fly.
    var str = gen_l1_elem_opening_html(l1_menu) + gen_l1_elem_closing_html(l1_menu);
    var dv_navbar = $("nb_dv_main");
    new Insertion.Bottom(dv_navbar, str);

    var l1_elem = $(l1_menu.id);
    l1_elem.collapsed = true;
    l1_elem.hovered = false;
    l1_elem.menu_ref = l1_menu;

    Element.extend(l1_elem);
}


/******************************
    Debug logger
******************************/

// create_fancy_logger - this is taken from the topology viewer
// It creates a fancy logger window with a title bar & clear button.
function create_fancy_logger(div)
{
    var logframe_title = "logger";

    div.style.fontSize = "10px";

    // Create the title bar.
    var div_tb = document.createElement("DIV");
    div_tb.id = "dc_logframe_tb";
    div_tb.style.backgroundColor = "darkblue";
    div_tb.style.position = "relative";
    div_tb.style.cursor = "default"; // arrow
    var logframe_title = "Debug Logger";
    div_tb.innerHTML = '<span style="color:white; padding-left:3px">' + logframe_title + '</span><input type=image id="dc_logframe_btn_clear" style="position:absolute; visibility:hidden;" src="/images/db_refresh.png" onclick="reset_logger_div()">';

    // Create the client window.
    var div_cli = document.createElement("DIV");
    div_cli.id = "dd_logger";

    with (div_cli.style)
    {
        backgroundColor = "#EECCCC";
        position = "relative";
        height = "99%";
//        width = "" + logger_width + "px";
        overflow = "scroll";
//      div_cli.style.margin = "2px";
    }

    div.appendChild(div_tb);
    div.appendChild(div_cli);

    // Adjust the placement of the clear button after the icon has finished loading.
    setTimeout(mlog_reposition_clear_btn, 500);
}


// mlog_reposition_clear_btn - position the clear button at the right edge
// of the header bar.
function mlog_reposition_clear_btn()
{
    var btn = $("dc_logframe_btn_clear");
    var div = $("dc_logframe_tb");

    var x = parseInt(div.offsetWidth) - 2;
    x -= btn.offsetWidth;
    btn.style.left = "" + x + "px";
    btn.style.visibility = "visible";
}


// reset_logger_div - clear the contents of the logger window.
function reset_logger_div()
{
    logger_cli = $("dd_logger");
    logger_cli.innerHTML = "";
}

// stretch_navbar_frame - debug function
// Try to stretch the navbar frame a bit to make room for the logger window
function stretch_navbar_frame()
{
    // Try to stretch the navbar frame a bit so the window isn't so cramped.
    try
    {
        var bd = top.document.body;

        if (bd.childNodes[1].tagName == "FRAME")
        {
            // Firefox case
            bd.childNodes[3].childNodes[1].cols = "240, *";
        }
        else
        {
            // IE case
            bd.childNodes[1].cols = "240, *";
        }
    }
    catch (e)
    {
        mlogger.debug("Failed to stretch navbar frame.");
    }
}


// setup_logger_div - initialize the yyLogger & enable the logger div.
function setup_logger_div()
{
    // Make some room for the logger div.
    stretch_navbar_frame();

    var dv_logger = $("nv_logger");
    dv_logger.style.display = "";

    // Add the title bar & clear button.
    create_fancy_logger(dv_logger);

    logger_cli = $("dd_logger");
    ygLogger.init(logger_cli);
    mlogger_obj.DEBUG_ENABLED = true;
}


/******************************
    Event Handlers
******************************/

// ie_on_select_start - callback when the user is about to start a selection on IE.
// This usually results in ridiculous shaded areas on the screen. So generally we
// want to prevent it.
function ie_on_select_start(ev)
{
    return false;
}

document.onselectstart = ie_on_select_start;


/******************************
    Initialization
******************************/


// do_test - respond to a click on the test button
// TODO: for testing only
function do_test()
{
setup_logger_div();

    // Add whatever code you like here...
    mlogger.debug("logger test");
}


// unload_menu_source_files - Free up some unneeded memory (probably not very much).
// But this also makes it difficult for (unskilled) users to see our raw menu
// definition file.
function unload_menu_source_files()
{
    try
    {
        frames.menudef_base.document.write("");
        var frm = $("menudef_base");
        Element.remove(frm);

        // This may throw an exception on IE if the custom menu file
        // did not exist.
        frames.menudef_diff.document.write("");
        frm = $("menudef_diff");
        Element.remove(frm);
    }
    catch (e) {}
}


// load_navbar_from_frame - main routine for initializing the navbar
function load_navbar_from_frame()
{
    if (enable_logger_window)
    {
        // Initialize the logger window
        // TODO: for testing only
        setup_logger_div();
    }

    // Load the menu definition from the file in the iframe.
    {
        // Parse the standard menu definition file.
        load_menu_from_file_compact(false, null);
        // Parse the custom menu diff file.
        load_menu_from_file_compact(true, null);

        // Free up some unneeded memory (probably not very much).
        if (nb_free_memory_after_menu_load)
            unload_menu_source_files();
    }

    render_global_menu_tree();

    // Set a timeout to fixup the JS variables to the HTML can
    // render immediately. This reduces the apparent latency in
    // menu building for the user.
    setTimeout("fixup_menuelem_js_vars()", 1);
}


// update_profname_in_logo - update the displayed profile name in the menu
// edit bar in the logo frame.
function update_profname_in_logo(profname)
{
    var logo_frm = top;
    var spn = logo_frm.document.getElementById("layout_eb_profname");
    spn.innerHTML = profname;
}


// check_vdom_mode - enable the "return to global" button and the vdom footer if we are
// starting off inside a vdom (this applies to super admins only).
function check_vdom_mode()
{
    if (!nb_runtime_state.in_vdom_mode)
        return;

    // Search the navbar url for a "vdom=" statement. If the vdom is empty then we
    // are in global mode, otherwise we are in vdom mode.
    var vdname = extract_url_parameter(window.location.href, "vdom");
    // If the vdom string is missing from the navbar URL then fallback to the
    // old implementation where we check the URL of the parent frameset.
    if (vdname == null)
        vdname = extract_url_parameter(window.top.location.href, "vdom");

    // enable the vdom footer
    $j("#nb_vdom_btn").show();

    // select the current vdom / global option in the list.
    $j("#nb_vdom_list option").filter( function() {
        return ((this.value == vdname) || (vdname == null && this.value == ""));
    }).attr("selected", "selected");

    // If we didn't find a vdom specification then this is global mode (or we are not
    // a super admin, but that shouldn't happen because in_vdom_mode would not be set).
    if (!vdname || !vdname.length)
        return;


    // set the in_vdom_menu flag (this affects how we parse the menu definition file)
    nb_runtime_state.in_vdom_menu = true;
}

// nb_refresh_menu - Reload the menu tree (pulling in any updates). This function
// will retain the current menu selection unless "menu_id" is specified.
function nb_refresh_menu(menu_id)
{
    if (!menu_id)
    {
        menu_id = get_menu_id_from_l3_node(last_clicked_l3_node);
    }
    
    var url = location.href;

    url = update_url_component(url, "default_tab", menu_id);

    window.location.href = url;
}

// init_navbar - initialize the navbar frame
function init_navbar()
{
mlogger.enable();
    // Check whether we should start in vdom mode (do this before loading the menu file).
    check_vdom_mode();

    nb_translate_static_html();

    YAHOO.util.Event.onDOMReady(load_navbar_from_frame);

    // Open the first element.
    // (Since we are delaying the call to fixup_menuelem_js_vars,
    // we also need to do this for select_default_element.)
    // TODO: Do we also want to do this in edit mode?
    setTimeout("select_default_element()", 1);
}

var navbar_resize_timer = null;

$j(document).ready( function() {
    $j(window)
        .bind("resize", function() {
            if (navbar_resize_timer) clearTimeout(navbar_resize_timer);

            navbar_resize_timer = setTimeout(function() {
                    navbar_adjust_l1_menus(cur_selected_l1_elem);
                },
                200);
        })
        .bind("load", function() {
            init_navbar();
        })
    ;

    var j_nb_vdom_list = $j("#nb_vdom_list");

    j_nb_vdom_list.change(function() {
        vdom_button_change(this);
    });

    j_nb_vdom_list.append($j("<option></option>").attr("value", "").text(wij_string("global")));
    $j.each(nb_vdom_list, function(key, value) {
        j_nb_vdom_list.append($j("<option></option>").attr("value",value).text(value));
    });
});



