/******************************
 navbar_drag.js - Navbar support code
 Init by A. Krywaniuk, Jan 2008 (duplicated from navbar.js)
 GUI widgetization project
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/


// nb_allow_drag_std_items - whether we allow readonly (standard) menu items to be dragged.
var nb_allow_drag_std_items = false;

// nb_force_custom_items_at_bottom - whether to prevent the user from interleaving custom
// & standard menu items by forcing all custom items at the bottom of the column.
var nb_force_custom_items_at_bottom = true;


// drag_y_only - set drag & drop to use Y-axis only in the navbar frame.
drag_y_only = true;


/******************************
    Code from navbar.js
******************************/

var navbar = new Object();

// getModuleArr - Get an ordered array of the draggable objects in the
// container, including the ghost div, but not including the detached
// object (or any non-draggable/unknown objects).
navbar.getModuleArr = function(col)
{
    var arr = [];
    var len = col.childNodes.length;
    var last_std_elem = null;

    // Build an array of the elements in the container (that the dragged
    // item can be placed adjacent to).
    for (var z=0; z<len; z++)
    {
        var elem = col.childNodes[z];

        if (elem.menu_ref)
        {
            // If we are forcing custom items at the bottom then don't allow
            // the custom element to be dragged above any standard elements.
            // (We do this by just excluding them from the list.)
            if (nb_force_custom_items_at_bottom && elem.menu_ref.menu_readonly)
            {
                last_std_elem = elem;
                continue;
            }
        }
        else
        {
            // Exclude any non-menu elements (this shouldn't happen w/ the current
            // code), but make an exception for the ghost module.
            if (elem != moduleGhost)
                continue;
        }

        // Exclude the element currently being dragged.
        if (elem.isDragging)
            continue;

        arr.push(elem);
    }

    // Cache the number of fixed items to skip, in case we need to move the ghost
    // div to the beginning of the dragable section of the list.
    if (nb_force_custom_items_at_bottom)
    {
        col.last_fixed_elem = last_std_elem;
    }

    return arr;
}



// l1m_bottom_margin - Cached layout offsets.
var l1m_bottom_margin = null;
var l1m_left_margin = null;
var l2m_left_margin = null;
var l2m_left_padding = null;


// nb_dragstart - drag start handler for navbar menuitems
function nb_dragstart(x,y,mousex,mousey)
{
    // Hide the drop menu button while dragging.
    hide_dropmenu_btn();

    var dv_elem = this;
    var dv_ghost = moduleGhost;
    var menu_level = dv_elem.menu_ref.menu_level;
    var div_hdr = (menu_level == 1) ? dv_elem.firstDescendant() : dv_elem;

    // Retrieve & cache the margin attributes from the L1 menu style.
    if (!l1m_bottom_margin)
    {
        var l1_elem = find_containing_L1_menu(dv_elem);
        l1m_bottom_margin = parseInt(Element.getStyle(dv_elem, 'marginBottom')); // ?px
        l1m_left_margin = parseInt(Element.getStyle(div_hdr, 'marginLeft')); // 5px
    }

    // Retrieve & cache the margin attributes from the L2 menu style.
    if (menu_level == 2 && !l2m_left_margin)
    {
        l2m_left_margin = parseInt(Element.getStyle(div_hdr, 'marginLeft')); // 13px
        l2m_left_padding = parseInt(Element.getStyle(div_hdr, 'paddingLeft')); // 8px
    }

    // It looks a bit silly to drag an L1 item with the sub-elements expanded, so
    // collapse it.
    if (menu_level == 1)
    {
        quick_collapse_l1_menu(this);
    }

    // Initialize the ghost style so its border will exactly surround the target div,
    // without causing any other elements to move. Since the ghost div has a border, that
    // means we have to adjust for the differences in box-border model between FF & IE.
    // NOTE: we setup the ghost *before* changing any attributes of the target element -
    // otherwise we would need to cache the measurements.
    var fudge1 = FF ? -2 : -2;
    var fudge2 = FF ? 0 : -1;
    var ghost_style = dv_ghost.style;

    // Use the -1 pixel margin to prevent the border from altering the layout of the
    // other elements on the page.
    ghost_style.height = (dv_elem.offsetHeight + fudge1) + "px";
    ghost_style.marginRight = "-1px";
    ghost_style.marginTop = "-1px";

    // The left & bottom margins cause special problems for L1 & L2 menus.
    if (menu_level == 1)
    {
        ghost_style.width = (dv_elem.offsetWidth + fudge2 - l1m_left_margin) + "px";
        ghost_style.marginBottom = (l1m_bottom_margin + 1) + "px";
        ghost_style.marginLeft = (l1m_left_margin - 1) + "px";
    }
    else
    {
        ghost_style.width = (dv_elem.offsetWidth + fudge2) + "px";
        ghost_style.marginBottom = "1px";
        ghost_style.marginLeft = (l2m_left_margin - 1) + "px";
    }


    // NOTE: It also doesn't look great to have non-transparent parts of the background
    // being dragged along. That's why the source images have now been clipped to their
    // borders and given a transparent mask. Unfortunately, this also adds a lot of
    // complexity in calculating the margins & offsets when dragging.

    // Now change the element's positioning from inline to absolute.
    // (We have to account for the padding-left here.)
    var left = dv_elem.offsetLeft;
    Position.absolutize(dv_elem);
    var new_left = parseInt(dv_elem.style.left);
    dv_elem.style.left = (new_left - left) + "px";

    // For L2 items we are going to re-parent the menu, so account for
    // the different coordinate system.
    if (menu_level == 2)
    {
        var new_width = dv_elem.offsetWidth;
        dv_elem.style.width = (new_width - 2*l2m_left_padding) + "px";
//        clogger.debug("After width adjustment: dv_elem.offsetWidth = " + dv_elem.offsetWidth);
    }

    // On IE, we also need to account for the margin on the document body.
    // (TODO: I'm not sure why this correction is specific to IE.)
    if (!FF)
    {
        var ie_body_padding = 15;
        var new_top = dv_elem.offsetTop;
        dv_elem.style.top = (new_top + ie_body_padding) + "px";
    }


    // For L2 items, the col variable gets set to the L1 folder div, even
    // though we detach the elements later.
    var col = dv_elem.parentNode;
    col.insertBefore(moduleGhost, dv_elem);
    moduleGhost.col = col;

    this.isDragging = true;
    navbar.draggingItem = true;

    // For L2 items we even re-parent them under the root div to allow
    // seamless dragging between L1 menus.
    if (menu_level == 2)
    {
        Element.remove(dv_elem);
        var main_dv = $("nb_dv_main");
        main_dv.appendChild(this);
    }
}


// find_L1_elem_containing_pos - find a level 1 element containing the specified
// mouse position.
function find_L1_elem_containing_pos(x,y)
{
    for (var i=0; i< l1elems.length; i++)
    {
        var l1_menu = l1elems[i];
        var l1_elem = $(l1_menu.id);
        if (Position.within(l1_elem, x, y))
        {
//clogger.debug("find_L1_elem_containing_pos - result is " + l1_elem.menu_name);

            return l1_elem;
        }
    }

//clogger.debug("find_L1_elem_containing_pos - result is (null)");
    return null;
}


// nb_drag - drag handler for navbar menuitems
// AFAICT, the difference between x & mousex is that mousex is
// the position of the mouse on the screen, whereas x is the
// position of the drag object relative to the start position.
function nb_drag(x,y,mousex,mousey)
{
    // All we have to do in the ondrag handler is to relocate the ghost div to match
    // the position of the dragged element. In some cases this may also involve
    // expanding/collapsing the L1 menus.

//clogger.debug("nb_drag: x=" + x + ", y=" + y + ", mousex=" + mousex + ", mousey=" + mousey);
    var dv_elem = this;
    var dv_ghost = moduleGhost;
    var menu_level = dv_elem.menu_ref.menu_level;
    var col;

    // For the purposes of find_L1_elem_containing_pos, we need to convert the screen
    // coordinates (of the mouse position) to document coordinates.
//    var bd = IE6 ? document.documentElement : document.body;
    var bd = document.documentElement;
//clogger.debug("bd.scrollLeft=" + bd.scrollLeft + ", bd.scrollTop=" + bd.scrollTop);
    mousex += bd.scrollLeft;
    mousey += bd.scrollTop;

    if (menu_level == 1)
    {
        col = $("nb_dv_main");
    }
    else if (menu_level == 2)
    {
        // update_container_column - update the parent L1 menu element based on the 
        // new mouse position.
        function update_container_column()
        {
            // First check if we are still within the same L1 menu.
            if (Position.within(col.parentNode, mousex, mousey))
                return;

            // If we have moved over a new L1 menu then update the current column
            // and trigger the animated menu expansion.
            var new_elem = find_L1_elem_containing_pos(mousex, mousey);
            if (!new_elem)
                return;

            // Prevent the drag target from being a standard menu if we don't allow that.
            if (!nb_allow_customize_std_menus && new_elem.menu_ref.menu_readonly)
                return;

            // NOTE: After forcing an an animated L1 menu expansion, this may
            // cause us to initially locate the ghost div at the bottom of the
            // list. This little glitch will be fixed as soon as the user jiggles
            // the mouse. (Alternately, we could consider setting a timer to
            // create a spurious drag event after the animation is complete.)
            if (new_elem.collapsed)
            {
                collapse_all();
                expand_l1_menu(new_elem);
            }

            // We do the search based on the full L1 div dimensions, but col actually
            // gets set just to the container section.
            var l1_menu = menu_elem_map[new_elem.id];
            col = $(l1_menu.fold_id);
        }


        // Initialize col to the last-known column, then call the function to update
        // the result.
        col = dv_ghost.col;
        update_container_column();
    }


    // Move the ghost to the new column if necessary.
    if (dv_ghost.col != col)
    {
        // Temporarily append the ghost at the end of the list.
        // we may move it up later.
        if (dv_ghost.parentNode)
            Element.remove(dv_ghost);

        dv_ghost.col = col;
        col.appendChild(dv_ghost);
    }


    var elems = navbar.getModuleArr(col);

    // Remember the previous sibling rather than the index in the array.
    // This avoids the complicated logic involved in sometimes skipping
    // the ghost entry and sometimes not.
    var old_prev_sibling = dv_ghost.previousSibling;
    var new_prev_sibling = null;

    var len = elems.length;
    for (var i=len-1; i >= 0; i--)
    {
        var elem = elems[i];
        if (y > findPosY(elem) + (elem.offsetHeight * 1/3))
        {
            new_prev_sibling = elem;
            break;
        }
    }

    // Don't do anything if the ghost position hasn't changed.
    if (new_prev_sibling != old_prev_sibling && new_prev_sibling != dv_ghost)
    {
        if (dv_ghost.parentNode)
            Element.remove(dv_ghost);

        if (new_prev_sibling)
        {
            // Move the ghost element after another draggable element.
            insertAfter(col, dv_ghost, new_prev_sibling);
        }
        else if (nb_force_custom_items_at_bottom && col.last_fixed_elem)
        {
            // Move the ghost element to the beginning of the draggable section
            // of the list, but after a number of fixed elements.
            insertAfter(col, dv_ghost, col.last_fixed_elem);
        }
        else
        {
            // Move the ghost element to the beginning of the list.
            col.insertBefore(dv_ghost, col.firstChild);
        }
    }
}


// nb_dragend - drag end handler for navbar menuitems
function nb_dragend(x,y,el)
{
    var dv_elem = this;
    var dv_ghost = moduleGhost;
    var col = dv_ghost.col;

    // Turn off the isDragging flag after processing any onclick events.
    delayed_clear_dragging_flag(dv_elem);

    // Make sure the ghost div is actually in the DOM (more of a sanity
    // check than anything).
    if (!dv_ghost.parentNode)
        col.appendChild(dv_ghost);

    col.insertBefore(dv_elem, dv_ghost);
    Element.remove(dv_ghost);

    navbar.draggingItem = false;

    dv_elem.style.position = "static";
    dv_elem.style.height = "";
//    this.style.width = "auto";
    dv_elem.style.width = "";
}


function setupdrag(divModuleHeader, divModule)
{
    // Setup the drag event callbacks.
    Drag.init(divModuleHeader, divModule);
    divModule.onDragStart = nb_dragstart;
    divModule.onDrag = nb_drag;
    divModule.onDragEnd = nb_dragend;
}


/******************************
    Custom code
******************************/

// create_l1_dd_elem - create a drag & drop element
function create_l1_dd_elem(obj)
{
    var div_hdr = obj.firstDescendant();
    setupdrag(div_hdr, obj);
}

// create_l2_dd_elem - create a drag & drop element
function create_l2_dd_elem(obj)
{
    var div_hdr = obj;
    setupdrag(div_hdr, obj);
}

// init_navbar_dragdrop - setup drag & drop for the navbar in edit mode.
function init_navbar_dragdrop()
{
    navbar.columnsObj = new Object();
    navbar.columnsObj.col1 = $("nb_dv_main")

    // Setup drag & drop.
    for (var i=0; i < l1elems.length; i++)
    {
        var l1_menu = l1elems[i];
        var l1_elem = $(l1_menu.id);

        // Setup drag & drop for L1 element.
        if (nb_allow_drag_std_items || !l1_menu.menu_readonly)
            create_l1_dd_elem(l1_elem);

        var aL2_menus = l1_menu.child_nodes;

        for (var j=0; j < aL2_menus.length; j++)
        {
            var l2_menu = aL2_menus[j];
            var l2_elem = $(l2_menu.id);
if (!l2_elem) clogger.debug("l2_elem is null for l2_menu = " + l2_menu.id);

            if (nb_allow_drag_std_items || !l2_menu.menu_readonly)
                create_l2_dd_elem(l2_elem);
        }
    }
}

