/******************************
 navbar_edit.js - Navbar support code
 Init by A. Krywaniuk, Jan 2008
 GUI widgetization project
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/


// max_l12_menuname_len - constrain menu name length to avoid wrapping problems.
var max_l12_menuname_len = 36;


/******************************
    Custom event handlers
******************************/

// ev_nbm_rename_inplace - request to begin renaming a menu item.
function ev_nbm_rename_inplace(elem)
{
    hide_dropmenu_btn();

    /* Create a fake tab on top of the modal div for the user to edit. */
    var dv_target = elem;
    var menu_ref = elem.menu_ref;
    var level = menu_ref.menu_level;

    // We need to use a fake menu_ref in order to avoid duplicating element
    // ids when we generate the tab HTML.
    // TODO: we could consider just adding an alternate version of
    // gen_tab_html() for this.
    var fake_menu_ref = new Object();
    fake_menu_ref.serialno = menu_ref.serialno + "A";
    fake_menu_ref.menu_name = menu_ref.menu_name;
    fake_menu_ref.menu_readonly = false;

    // Generate the tab HTML inside a temp div.
    var tmp_div = document.createElement("DIV");

    // The L1/L2 elements still require some extra fixups, so we need to emulate
    // most of what render_new_lX_menu would do (except for inserting the element
    // into the list).
    if (level == 1)
    {
        var str = gen_l1_elem_opening_html(fake_menu_ref) + gen_l1_elem_closing_html(fake_menu_ref);
        tmp_div.innerHTML = str;
    }
    else
    {
        tmp_div.innerHTML = gen_l2_menu_html(fake_menu_ref);
    }

    var dv_elem = tmp_div.childNodes[0];
    Element.extend(dv_elem);
    dv_elem.menu_ref = menu_ref;
    var div_hdr = (level == 1) ? dv_elem.firstDescendant() : dv_elem;


    var padding = 0;
    var offset = 0;

    if (level == 1)
    {
        dv_elem.collapsed = elem.collapsed;
        update_l1_elem_bgimg(dv_elem);
    }
    else
    {
        // This is a bit ugly... to fake the "selected" property, we
        // actually need to temporarily modify the global variable.
        var saved_id = highlighted_L2_elem_id;
        if (highlighted_L2_elem_id == dv_target.id)
            highlighted_L2_elem_id = dv_elem.id;

        dv_elem.selected = elem.selected;
        update_l2_elem_bgimg(dv_elem);
        dv_elem.style.display = "";

        highlighted_L2_elem_id = saved_id;

        var p1 = parseInt(Element.getStyle(dv_target, "padding-left"));
        var p2 = parseInt(Element.getStyle(dv_target, "margin-left"));
        padding = p1;
        offset = p1 + p2;
    }

    // Remove all the default event handlers.
    div_hdr.onclick = null;
    div_hdr.onmouseover = null;
    div_hdr.onmouseout = null;

    // Match the menu item width to the target element.
    dv_elem.style.width = (dv_target.offsetWidth - padding) + "px";
    dv_elem.style.height = dv_target.offsetHeight + "px";

    // Position the new tab directly above the target element.
    var pos = Position.cumulativeOffset(dv_target);
    dv_elem.style.position = "absolute";
    dv_elem.style.visibility = "visible";
    dv_elem.style.left = pos[0] + "px";
    dv_elem.style.top = pos[1] + "px";
    Element.remove(dv_elem);

    // The L2 menu item offset is all done w/ margins & padding which give it an
    // effective left offset of 0. It is easier to just set it directly to 0 rather
    // than calculating all the padding & margins to subtract.
    if (level == 2)
    {
        dv_elem.style.left = "0px";
    }

    // Restore the ability to select text within the element.
    dv_elem.style.MozUserSelect = "text";

    // Replace the menu description with an edit box.
    // Restore the user-select property that we disabled somewhere up the dom.
    div_hdr.innerHTML = "<input type='text' style='background-color:transparent; border:none;' value='"
            + menu_ref.menu_name + "'>";


    // Match the edit box width to the target element.
    // (Use the original target element width, since the new one hasn't rendered yet.)
    var eb = div_hdr.childNodes[0];
    var orig_elem_hdr = (level == 1) ? elem.firstDescendant() : elem;
    eb.style.width = (orig_elem_hdr.offsetWidth - padding) + "px";

    // Make sure the font inside the edit box matches the tab style.
    eb.style.fontSize = Element.getStyle(orig_elem_hdr, "fontSize");
    eb.style.fontFamily = Element.getStyle(orig_elem_hdr, "fontFamily");
    eb.style.fontWeight = Element.getStyle(orig_elem_hdr, "fontWeight");
    eb.style.color = Element.getStyle(orig_elem_hdr, "color"); // may be red or white

    eb.maxLength = max_l12_menuname_len;

    // Extra hacks on IE to account for the margin in the navbar frame (I think).
    if (IE)
    {
        var outer_margin = 5;
        eb.style.marginLeft = (-outer_margin) + "px";

        if (IE6)
            eb.style.width = (orig_elem_hdr.offsetWidth - offset) + "px";
    }

    // Display an inline modal dialog including our dedicated edit control.
    dv_elem.target_elem = elem;
    wij_display_rename_dlg(dv_elem, eb, nbm_end_rename);
}


// nbm_get_rename_target - get the HTML element displaying the menu name.
function nbm_get_rename_target(elem)
{
    // Use the header div as the target for L1 rename ops.
    if (elem.menu_ref.menu_level == 1)
        return elem.firstDescendant();
    else
        return elem;
}

// nbm_end_rename - called when the rename operation is finished.
function nbm_end_rename(dv_elem, should_save)
{
    if (!should_save)
        return;

    var aElems = dv_elem.getElementsByTagName("INPUT");
    var eb = aElems[0];

    var elem = dv_elem.target_elem;
    var dv_hdr = nbm_get_rename_target(elem);
    var new_name = eb.value;

    // Check for invalid name
    // TODO: XSS characters?
    if (new_name.empty())
        return;

    elem.menu_ref.menu_name = new_name;
    dv_hdr.innerHTML = new_name;
}


// ev_nbm_hide_elem - request to show/hide a menu item.
function ev_nbm_hide_elem(elem, bHide)
{
    set_elem_hidden(elem, bHide);
}


// ev_nbm_hideall_elems - request to show/hide all menu items.
function ev_nbm_hideall_elems(bHide)
{
    // show_child_nodes - enable all child nodes of an L1 menu.
    function show_child_nodes(l1_menu)
    {
        var list2 = l1_menu.child_nodes;
        var len2 = list2.length;

        for (var j=0; j<len2; j++)
        {
            var l2_menu = list2[j];
            if (l2_menu.menu_hidden)
            {
                set_elem_hidden($(l2_menu.id), false);
            }
        }
    }

    var len = l1elems.length;

    // If we are showing all then we need to recursively iterate
    // all L1 & L2 menus to enable them. If we are hiding all,
    // then it should be enough to just hide all the L1 menus.
    for (var i=0; i<len; i++)
    {
        var l1_menu = l1elems[i];
        if (l1_menu.menu_hidden != bHide)
        {
            set_elem_hidden($(l1_menu.id), bHide);
        }

        if (!bHide)
        {
            show_child_nodes(l1_menu);
        }
    }
}


// ev_nbm_delete - request to delete a menu item.
function ev_nbm_delete(elem)
{
    var elem_id = elem.id;
    var menu_ref = elem.menu_ref;
clogger.debug("ev_snm_delete - looking for elem_id = " + elem_id);

    if (menu_ref.menu_level == 1)
    {
        var dv_fold = $(menu_ref.fold_id);
        var aL2_menus = document.getElementsByClassName("menu_level2", dv_fold);
        var len2 = aL2_menus.length;

        for (var i=0; i<len2; i++)
        {
            if (aL2_menus[i].menu_ref.menu_readonly)
            {
                // NOTE: not internationalized because this code is unreachable unless we
                // allow reordering of standard elements.
                var err_str = "#Cannot delete a top level menu that has readonly sub-menus";
                alert(err_str);
                return;
            }
        }

        // Remove the L1 menu from the DOM and from the global array.
        // This may orphan some L2 menus in memory, but they won't be saved later.
        var len1 = l1elems.length;
        for (var j=0; j<len1; j++)
        {
            if (l1elems[j].serialno == menu_ref.serialno)
            {
                l1elems.splice(j,1);
                break;
            }
        }

        Element.remove(elem);
    }
    else
    {
        // It is too much work to find the L2 element in the global tree, so we will
        // orphan it (for now).
        Element.remove(elem);
    }

    // TODO: maybe we need to automatically navigate to another page.
}


// ev_nbm_reset_elem - request to reset a menu item.
// TODO: not implemented
function ev_nbm_reset_elem(elem)
{
    alert("in ev_nbm_reset_elem");
}


//var nb_pending_save_rqst = null;

// ajax_save_menu_state_compact - save the menu state as a diff from the standard menu.
function ajax_save_menu_state_compact()
{
clogger.debug("ajax_save_menu_state_compact");
    // Encode the entire menu in a string.
    // Use the StringBuffer technique to improve performance.
    var aResp = [];

    function add_menu_item_header(obj)
    {
clogger.debug("add_menu_item_header - obj.menu_id=" + obj.menu_id);
        aResp.push(obj.menu_level + ". " + obj.menu_id + "\n");
    }

    function set_menu_item_hidden(obj)
    {
clogger.debug("set_menu_item_hidden - obj.menu_id=" + obj.menu_id);
        aResp.push(obj.menu_level + ". " + obj.menu_id + "\n");
        if (obj.menu_hidden) aResp.push("hidden\n");
    }

    // add_one_menu_item - append the string representation of one menu
    // item to the StringBuffer.
    function add_one_menu_item(obj, pos)
    {
clogger.debug("add_one_menu_item - obj.menu_id=" + obj.menu_id);
        aResp.push(obj.menu_level + ". " + obj.menu_id + "\n");
        // Don't send the menu_name for the standard menu items. We will do
        // the lookup in the language file each time they are used.
        if (!obj.menu_readonly) aResp.push("name=" + obj.menu_name + "\n");

        if (obj.menu_hidden)
        {
            if (obj.menu_level == 4)
            {
clogger.debug("unsupported: L4 entry has attribute hidden");
            }
            else
            {
                aResp.push("hidden\n");
            }
        }

        if (obj.menu_level >= 3)
        {
            if (obj.menu_level == 3 && obj.menu_id == user_defined_menu_id)
            {
                // Avoid adding a bogus URL entry for custom L3 items.
            }
            else
            {
                // I believe it is correct to not encode the URLs here.
                aResp.push("URL=" + obj.menu_url + "\n");
//            aResp.push("URL=" + encodeURIComponent(obj.menu_url) + "\n");
            }
        }

        if (obj.menu_level == 3 && obj.menu_layout > 0)
        {
            aResp.push("layout=" + obj.menu_layout + "\n");
        }

        if (obj.menu_level == 4 && obj.menu_col == 2)
        {
            aResp.push("COL=" + obj.menu_col + "\n");
        }

        if (obj.menu_level == 4 && obj.cust_hdr_color)
        {
            aResp.push("hdr_color=" + obj.cust_hdr_color + "\n");
        }

        if (obj.menu_level == 4 && obj.cust_url_ext)
        {
            aResp.push("URL_ext=" + obj.cust_url_ext + "\n");
//            aResp.push("URL_ext=" + encodeURIComponent(obj.cust_url_ext) + "\n");
        }

        if (obj.menu_level == 4 && obj.cust_hdr_comment)
        {
            aResp.push("hdr_comment=" + obj.cust_hdr_comment + "\n");
        }

        if (obj.menu_level == 4 && obj.cust_height)
        {
            aResp.push("height=" + obj.cust_height + "\n");
        }

        // Save the position in the array. This is not as resistant to reorderings due
        // to upgrades, etc. But it is easier than the alternatives (e.g. using a
        // reference to the previous item in the list).
        if (obj.menu_level < 4)
        {
            aResp.push("POS=" + pos + "\n");
        }
    }


    // Create a floating message to display to the user during the save operation.
    var dv_saving_msg = $("nb_saving_msg");
    if (!dv_saving_msg)
        dv_saving_msg = nb_create_saving_message();
    dv_saving_msg.style.visibility = "";


clogger.debug("Begin encoding menu...");
    // Get the list of elements from the DOM, so as to ensure that any
    // reorderings or deletions are reflected in the saved version.
    var main_dv = $("nb_dv_main");
    var aL1_menus = document.getElementsByClassName("menu_level1_container", main_dv);
    var len1 = aL1_menus.length;

    for (var i=0; i < len1; i++)
    {
        var l1_menu = aL1_menus[i].menu_ref;

        if (!l1_menu.menu_readonly)
        {
            add_one_menu_item(l1_menu, i);
        }
        else if (l1_menu.menu_hidden)
        {
            set_menu_item_hidden(l1_menu);
        }

        var dv_fold = $(l1_menu.fold_id);
        var aL2_menus = document.getElementsByClassName("menu_level2", dv_fold);
        var len2 = aL2_menus.length;

        for (var j=0; j < len2; j++)
        {
            var l2_menu = aL2_menus[j].menu_ref;

            if (!l2_menu.menu_readonly)
            {
                // Add the path to the menu item (unless it's already there).
                if (l1_menu.menu_id != user_defined_menu_id)
                {
                    add_menu_item_header(l1_menu);
                }

                add_one_menu_item(l2_menu, j);
            }
            else if (l2_menu.menu_hidden)
            {
                add_menu_item_header(l1_menu);
                set_menu_item_hidden(l2_menu);
            }


            var l3elems = l2_menu.child_nodes;
            var len3 = l3elems.length;

            for (var k=0; k < len3; k++)
            {
                var l3_menu = l3elems[k];

                if (!l3_menu.menu_readonly)
                {
                    // Add the path to the menu item (unless it's already there).
                    if (l2_menu.menu_id != user_defined_menu_id)
                    {
                        add_menu_item_header(l1_menu);
                        add_menu_item_header(l2_menu);
                    }

                    add_one_menu_item(l3_menu, k);
                }
                else if (l3_menu.menu_hidden)
                {
                    add_menu_item_header(l1_menu);
                    add_menu_item_header(l2_menu);
                    set_menu_item_hidden(l3_menu);
                }


                var l4elems = l3_menu.child_nodes
                var len4 = l4elems.length;

                for (var l=0; l < len4; l++)
                {
                    var l4_menu = l4elems[l];

                    if (l3_menu.menu_id != user_defined_menu_id)
                    {
                        add_menu_item_header(l1_menu);
                        add_menu_item_header(l2_menu);
                        add_menu_item_header(l3_menu);
                    }

                    add_one_menu_item(l4_menu, l);
                }
            }
        }
    }

//    display_alt_loading_message(topol_strs.saving);

clogger.debug("Sending save request...");

    // on_failure - Ajax callback for transport failure.
    function on_failure()
    {
        nb_suppress_saving_message();
        alert(wij_string("err_save_menu_failed"));
    }

    // on_success - Ajax callback for successful delivery.
    function on_success(rqst)
    {
        if (parseInt(rqst.responseText) == 1)
        {
            // Suppress the "saving" message. Sometimes the operation happens very quickly, so it
            // is better to display the message for a minimum of half a second or so.
            setTimeout(nb_suppress_saving_message, 500);
        }
        else
        {
            on_failure()
        }
    }

    // NOTE: Don't add any parameters to the end of the URL or else the post_data parameters will stop working.
    var url = "/navbar_save";
    var menu_filename = custom_menu_file;
    var post_data = "filename=" + menu_filename + "&encoding=compact&dat=" + encodeURIComponent(aResp.join());

    var ajax_opts = {
            method: 'POST',
            parameters: post_data,
            onSuccess: on_success,
            onFailure: on_failure
        };

//    nb_pending_save_rqst = 
    var rqst = new Ajax.Request(url, ajax_opts);
}

// nb_create_saving_message - Create an overlay message to display to the user while the
// data is being saved.
// TODO: this function is very similar to wcd_create_updating_message. Is it worth combining?
function nb_create_saving_message()
{
    var str = wij_string("save_in_progress");
    return top.lg_create_saving_message(str);
}


// nb_suppress_saving_message - hide the "Saving" message after the operation is complete.
function nb_suppress_saving_message()
{
    return top.lg_suppress_saving_message();
}


// ajax_save_menu_state - Send the current menu state back to the server.
// NOTE: this function would be more logically located in navbar_schema.js.
// However, it is also specific to edit mode, so that's why it's here.
function ajax_save_menu_state()
{
    // In the new schema, we only save the diffs from the original file rather
    // than saving the entire menu structure.
    ajax_save_menu_state_compact();
}


// reload_menu_from_string - reload the navbar menus.
// NOTE: menu_str is optional - otherwise the original file from the iframe will be used.
function reload_menu_from_string(menu_str)
{
    clogger.debug("Reload file data received.");

    navbar_reset_global_data();

    // Mirror the behaviour of the page onload handler.
    load_menu_from_file_compact(false, menu_str);
    render_global_menu_tree();
    fixup_menuelem_js_vars();
    select_default_element();
    setup_navbar_editing();
    g_ctxt_menu.render();
}

// NOTE: in the future, we will probably want to be able to load a different
// custom menu file via Ajax. However, this is currently disabled due to a
// character set problem on IE. (It will throw an exception if the charset
// of an Ajax response is set to something other than UTF-8.)

// reload_default_menu - reload the page with a using the default menu file.
function reload_default_menu()
{
    reload_menu_from_string();
}


/*
// reload_default_menu - reload the page with a different menu file.
// TODO: This is theoretically redundant. If we decide not to clear the data
// from the iframe after loading, then we would still have the default
// datafile source available.
function reload_default_menu()
{
clogger.debug("reload_default_menu");
    var url = "/menu-xlat";

    var ajax_opts = {
            method: 'GET',
            onComplete: on_ajax_reload_menu_done
        };

    var rqst = new Ajax.Request(url, ajax_opts);
}


// on_ajax_reload_menu_done - callback notification for reload_default_menu.
function on_ajax_reload_menu_done(response)
{
    clogger.debug("Reload file data received.");

    navbar_reset_global_data();

    // Mirror the behaviour of the page onload handler.
    // TODO: response.responseText will currently crash in IE because the charset
    // is not set to UTF-8.
    reload_menu_from_string(response.responseText);
}
*/


// navbar_reset_global_data - delete all the global data.
function navbar_reset_global_data()
{
    var dv_navbar = $("nb_dv_main");
    dv_navbar.innerHTML = "";

    var btn_crnew = $("wij_btn_l1_crnew");
    if (btn_crnew) btn_crnew.style.display = "none";

    var btn_rm = $("btn_reset_menus");
    if (btn_rm) btn_rm.style.display = "none";

    l1elems = new Array();
    menu_elem_map = new Object();
}


// ev_l1_create_new - request to create a new L1 item.
function ev_l1_create_new(btn)
{
    // Create a new item with the default name.
    var l1_menu = append_new_L1_menu_JS(wij_string("def_menu_name"), user_defined_menu_id);
    render_new_l1_menu(l1_menu);
    var l1_elem = $(l1_menu.id);

    // Put the new item in edit mode.
    create_l1_dd_elem(l1_elem);

    // Let the user rename the menu
    ev_nbm_rename_inplace(l1_elem);
}


// ev_l2_create_new - request to create a new L2 item.
function ev_l2_create_new(btn)
{
    // Create a new item with the default name.
    var l1_elem = find_containing_L1_menu(btn);

    if (l1_elem.collapsed)
    {
        collapse_all();
        quick_expand_l1_menu(l1_elem);
    }

    var l1_menu = l1_elem.menu_ref;
    var l2_menu = append_new_L2_menu_JS(wij_string("def_menu_name"), l1_menu, user_defined_menu_id);
    render_new_l2_menu(l2_menu, l1_menu);

    var l2_elem = $(l2_menu.id);

    // Most L2 elements are created initially hidden. In this case, the parent
    // folder ought to be open, so show it right away.
    l2_elem.style.display = "";

    // Put the new item in edit mode.
    create_l2_dd_elem(l2_elem);

    // Let the user rename the menu
    ev_nbm_rename_inplace(l2_elem);
}


/******************************
    Initialization
******************************/

// lastDescendant (unused?) - for some reason, prototype.js provides a firstDescendant()
// function, but no equivalent lastDescendant().
function lastDescendant(element)
{
    element = $(element).lastChild;
    while (element && element.nodeType != 1) element = element.prevSibling;
    return $(element);
}


// setup_navbar_editing - initialize the JS objects to facilitate
// drag & drop, renaming, etc.
function setup_navbar_editing()
{
//clogger.debug("begin setup_navbar_editing");
    init_navbar_dragdrop();

    $("btn_reset_menus").style.display = "";
    $("wij_btn_l1_crnew").style.display = "";

    // Setup the right-click menus.
    init_navbar_context_menu();
    create_navbar_dropmenu_div();
//clogger.debug("end setup_navbar_editing");
}



