/******************************
 navbar_menu.js - menu for the navbar & subnav
 Init by A. Krywaniuk, Feb 2008
 (duplicated from systopology_menu.js)
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/


// enable_navbar_bg_menu - whether to enable the context menu for clicks on the background
// in the navbar frame. (This can be disabled during debugging if you need to access
// the browsers default menus for that frame.)
var enable_navbar_bg_menu = true;


// TODO: if we do decide to use this menu in the final design, we had better refactor
// the code to use a common library for the topology viewer & navbar.

// g_ctxt_menu - global instance of the menu object.
var g_ctxt_menu = null;


var zz_ctxtmenu = 80; // zorder of popup context menus

/******************************
      Navbar menus
 ******************************/
var aNavbarMenuItems = [];

var mi_hide = 0;
var mi_show = 1;
var mi_rename = 2;
var mi_delete = 3;
var mi_reset = 4;
var mi_newchild = 5;
// Extensions for the background menu.
var mi_showall = 6;
var mi_hideall = 7;

/*
// nbm_strs (obsolete) - default (English) strings for the menu items.
var nbm_strs = {
    hide_menu : "#hide",
    rename_menu : "#rename",
    del_menu : "#delete",
    reset_menu : "#reset to default",
    newchild_menu : "#create new",
    showall_menu : "#show all",
    hideall_menu : "#hide all"
}
*/


// init_menu_desc - setup the menu strings (do this at runtime because the
// default strings may be overwritten by the C module).
function init_menu_desc()
{
    aNavbarMenuItems = [
        wij_string("hide_menu"), // checkmark off (not hidden)
        wij_string("hide_menu"), // checkmark on (hidden)
        wij_string("rename_menu"),
        wij_string("del_menu"),
        wij_string("reset_menu"),
        wij_string("newchild_menu"),
        wij_string("showall_menu"),
        wij_string("hideall_menu")
        // Careful... don't add a trailing comma here or IE will barf!
    ];
}


// nbm_enable_menu_elems - enable navbar menu items
function nbm_enable_menu_elems(oMenu)
{
    // Find the element containing this item
    var elem = oMenu.resolved_target;
    var menu_ref = elem.menu_ref;

    // Display the "hide" element w/ a check mark to indicate state.
    var show_hide = menu_ref.menu_hidden ? mi_show : mi_hide;

    var aItems = new Array(mi_rename, mi_delete);

    if (menu_ref.menu_level == 1)
    {
        aItems.push(mi_newchild);
    }

    // Show/hide is not available when customizing dashboard tabs.
    if (!menu_ref.menu_tab_id)
    {
        aItems.push(show_hide);
    }

    oMenu.unsuppress_items(aItems);

    // The user can't rename/delete the built-in menus, only hide them.
    var readonly = menu_ref.menu_readonly;
    oMenu.enable_item(mi_rename, !readonly);
    oMenu.enable_item(mi_delete, !readonly);

    // Disable the "hide" button for some profile types.
    oMenu.enable_item(show_hide, nb_allow_hide_std_menus || !menu_ref.menu_readonly);

    // Ditto for the create new button (unless you enable an experimental
    // configuration option).
    if (menu_ref.menu_level == 1)
    {
        oMenu.enable_item(mi_newchild, !readonly || nb_allow_customize_std_menus);
    }

    // Must have at least one dashboard tab.
    if (menu_ref.menu_tab_id && cur_displayed_l2_menu.child_nodes.length <= 1)
    {
        oMenu.enable_item(mi_delete, false);
    }

    // The user can't enable a menu without any child nodes.
    if (menu_ref.menu_hidden)
    {
        var can_show = true;

        if (  (menu_ref.menu_level == 1 && menu_ref.child_nodes.length == 0)
           || (menu_ref.menu_level == 2 && menu_ref.child_nodes.length == 0) )
        {
            can_show = false;
        }

        oMenu.enable_item(show_hide, can_show);
    }
}



// nbm_onMenuItemClick - respond to a menu item click in the navbar frame
function nbm_onMenuItemClick(menu_id, elem)
{
    switch (menu_id)
    {
        case mi_hide:
            ev_nbm_hide_elem(elem, true);
            break;

        case mi_show:
            ev_nbm_hide_elem(elem, false);
            break;

        case mi_rename:
            ev_nbm_rename_inplace(elem);
            break;

        case mi_delete:
            ev_nbm_delete(elem);
            break;

        case mi_reset:
            ev_nbm_reset_elem(elem);
            break;

        case mi_newchild:
            ev_l2_create_new(elem);
            break;
    }
}


// snm_onMenuItemClick - respond to a menu item click for the subnav frame
function snm_onMenuItemClick(menu_id, elem)
{
    // Since the menu for the subnav is actually implemented in the icontainer,
    // we need to re-route the messages.
    var sn_win = top.frames.subnav;

    switch (menu_id)
    {
        case mi_hide:
            sn_win.ev_snm_hide_elem(elem, true);
            break;

        case mi_show:
            sn_win.ev_snm_hide_elem(elem, false);
            break;

        case mi_rename:
            sn_win.ev_snm_rename_inplace(elem);
            break;

        case mi_delete:
            sn_win.ev_snm_delete(elem);
            break;

// TODO: not implemented
/*
        case mi_reset:
            ev_nbm_reset_elem(elem);
            break;

        case mi_newchild:
            ev_l2_create_new(elem);
            break;
*/
    }
}


// nbm_enable_bg_menu_elems - enable navbar menu items (for background click)
function nbm_enable_bg_menu_elems(oMenu)
{
    var aItems = new Array(mi_hideall, mi_showall, mi_reset);

    oMenu.unsuppress_items(aItems);

    oMenu.enable_item(mi_hideall, nb_allow_hide_std_menus);
    oMenu.enable_item(mi_showall, nb_allow_hide_std_menus);
}


// nbm_onBackgroundClick - respond to a background click in the navbar frame
function nbm_onBackgroundClick(menu_id)
{
    switch (menu_id)
    {
        case mi_hideall:
            ev_nbm_hideall_elems(true);
            break;

        case mi_showall:
            ev_nbm_hideall_elems(false);
            break;

        case mi_reset:
            reload_default_menu();
            break;
    }
}


 /******************************
      Menu helper functions
 ******************************/

// Menu id constants:
var show_navbar_l1_menu = 1;
var show_navbar_l2_menu = 2;
var show_navbar_l3_menu = 3;
var show_navbar_bg_menu = 4;

// bgclick_menu - which menu to show on a background click (varies per-frame).
var bgclick_menu = 0;


// nbm_show_which_menu - decide which menu to show for the given (navbar) context.
function nbm_show_which_menu(obj, elem)
{
    // This function should never even be called if not in edit mode.
    if (!in_edit_mode)
        return 0;

    // !elem means that the click was outside the navbar div.
    if (!elem)
    {
        // Return the navbar/subnav background menu id (if available).
        return bgclick_menu;
    }


    switch (elem.menu_ref.menu_level)
    {
        case 1:
            return show_navbar_l1_menu;
        case 2:
            return show_navbar_l2_menu;
        case 3:
            return show_navbar_l3_menu;
    }

    return 0;
}


// nbm_resolve_contextmenu_target - determine the contextual target of this context menu.
function nbm_resolve_contextmenu_target(target)
{
    // Find the menu element containing this item
    var elem = target;
    while (elem)
    {
        if (elem.id == "nb_dv_main" || elem.tagName == "BODY")
        {
            elem = null;
            break;
        }

        if (elem.menu_ref)
            break;

        elem = elem.parentNode;
    }

    return elem;
}


// cancel_context_menu - cancel the context menu if it is currently displayed.
// TODO: obsolete?
function cancel_context_menu()
{
    // The context event module sets a handler to detect mouse clicks on the body
    // and close the menu in that case. The D&D module somehow interferes with
    // this process. The result is that mousedown events that result in an object
    // being dragged will not trigger the menu to be cancelled (probably a bug in
    // the YUI library). Anyway, you can call this function to do it manually.
    if (g_ctxt_menu)
        g_ctxt_menu.hide();
}


// recalc_menu_width - adjust the menu width based on the calculated width of the
// currently visible subitems.
// TODO: obsolete?
function recalc_menu_width(oMenu)
{
    // The rendered width was originally calculated based on all the menu items being
    // visible. Since we have suppressed some of them, we need to tweak the width a bit.
    var sWidth = oMenu._getOffsetWidth();
    oMenu.element.style.width = "" + sWidth + "px";
}


// onMoveMenu_generic - callback for the YUI onMenuMove pseudo-event - adapt the 
// contents & display of the context menu to the new target.
// TODO: for some unknown reason, this function is called twice for every right
// button click. I'm not sure if that is normal.
function onMoveMenu_generic()
{
    var oMenu = this;

    if (oMenu.right_click_triggered)
        hide_dropmenu_btn();

    var elem = nbm_resolve_contextmenu_target(oMenu.contextEventTarget);
    var menu_type = nbm_show_which_menu(oMenu, elem);

    // Save the target element for use by the callback function.
    this.resolved_target = elem;
    this.saved_menu_type = menu_type;

    // First suppress all the menu items. Then conditionally enable/hide/grey the ones that are
    // relevant to this particular target element.
    oMenu.reset_all_items();

    switch (menu_type)
    {
        case show_navbar_l1_menu:
        case show_navbar_l2_menu:
        case show_navbar_l3_menu:
            nbm_enable_menu_elems(oMenu);
            break;

        case show_navbar_bg_menu:
            nbm_enable_bg_menu_elems(oMenu);
            break;

        default:
            // TODO: need a way to cancel the menu?
//            this.hide();
            return false;
    }

//    reset_idle_timeout();
}


// onMenuItemClick_generic - callback for the menu item click event
// This is where we handle the event and execute the user command.
//function onMenuItemClick_generic(p_sType, p_aArguments) 
function onMenuItemClick_generic(menu_id) 
{
    var oMenu = this;

    var menu_type = oMenu.saved_menu_type;
    var target_elem = oMenu.resolved_target;

    // Dispatch to the relevant context handler.
    switch (menu_type)
    {
        case show_navbar_l1_menu:
        case show_navbar_l2_menu:
            nbm_onMenuItemClick(menu_id, target_elem);
            break;

        case show_navbar_l3_menu:
            snm_onMenuItemClick(menu_id, target_elem);
            break;

        case show_navbar_bg_menu:
            nbm_onBackgroundClick(menu_id);
            break;
    }
}


/******************************
      Menu initialization
 ******************************/

 // init_navbar_context_menu - called at page load time to initialize the context menu module.
function init_navbar_context_menu()
{
    init_menu_desc();

    // Initialize the generic context menu. (We could support multiple menus, but 
    // currently we just use one menu and alter the contents based on the context.)
    if (enable_navbar_bg_menu)
    {
        g_ctxt_menu = init_menu_generic("mainnav_html", window);
        bgclick_menu = show_navbar_bg_menu;
    }
    else
    {
        g_ctxt_menu = init_menu_generic("nb_dv_main", window);
    }

    // set mi_show as a toggle field.
    wij_menu_append_checkmark(g_ctxt_menu, mi_show);
    g_ctxt_menu.render();
}

// init_subnav_context_menu - same as init_context_menus, but for subnav frame.
function init_subnav_context_menu()
{
    init_menu_desc();

    // We are displaying the menu in a different frame, so set the alternate
    // document and also ignore the y coordinate of the clicks so the menu
    // always appears right at the frame border.
    var mainfrm_wnd = top.frames.main;

    g_ctxt_menu = init_menu_generic("tabs_area", mainfrm_wnd);
    g_ctxt_menu.ignore_y_coord = true;

    // set mi_show as a toggle field.
    wij_menu_append_checkmark(g_ctxt_menu, mi_show);
    g_ctxt_menu.render();
}

// init_menu_generic - common code for menu initialization.
function init_menu_generic(bgdiv_id, output_wnd_P)
{
    // Create the bg menu
    var menu_div_id = "ctxtmenu";

    // TODO: is this the best way to structure the initialization?
    var menu_params = {
        trigger: bgdiv_id,
        output_window: output_wnd_P,
        click_fn: onMenuItemClick_generic,
        move_fn: onMoveMenu_generic
        };

    var oMenu = new WIJ_ContextMenu(menu_div_id, menu_params);

    // Add the full list of possible menu items. The set of items that are actually
    // displayed will be pruned at run-time based on the context.
    add_new_menu_items(oMenu, aNavbarMenuItems, onMenuItemClick_generic);

    return oMenu;
}

// add_new_menu_items - populate the context menu object with the designated menu defn.
function add_new_menu_items(oMenu, aItems, click_fn)
{
    var nItems = aItems.length;
    var i;

    // Add items to the main menu
    for (i=0; i<nItems; i++) 
    {
        var oItem = new WIJ_ContextMenuItem(aItems[i], i);
        oMenu.addItem(oItem);
    }
}



/******************************
      Drop menu button
 ******************************/

// The drop menu is used on both the navbar & subnav frames, so we have to be
// careful to make it portable.
// TODO: Since the code below is also used for the subnav frame, it appears
// that many of the functions & element ids are poorly named.

// create_navbar_dropmenu_div - create the movable dropdown menu toggle, which
// is an alternative to using right-click as a context menu trigger.
function create_navbar_dropmenu_div()
{
    // Set the initial parent to the main client div of the navbar/subnav frame.
    // This will be updated at runtime once we create some menu items.
    var dv = $("nb_dv_main")
    if (!dv) dv = $("tabs_area");
    if (!dv) return;

    var elem = document.createElement("DIV");
    elem.id = "navbar_dropmenu";
    elem.style.position = "absolute";
    elem.style.visibility = "hidden";

    elem.innerHTML = '<img id="navbar_dropmenu_img" src="/theme/images/menu_drop.gif">';
    elem.onmousedown = on_click_dropmenu_btn;
    elem.onclick = dropmenu_btn_ignore_event;

    dv.appendChild(elem);

    // At least one of the following statements is fixing the image height on IE.
    // As usual it's difficult to tell.
    var img = $("navbar_dropmenu_img");
    img.style.lineHeight = "14px";
    img.style.height = "14px";
    img.height = 14;

    return elem;
}

// get_navbar_dropmenu_btn - return the existing drop menu button or create
// a new one. This is a safety mechanism, since the div will be reparented
// inside other menu elements, which could be deleted at run-time.
function get_navbar_dropmenu_btn()
{
    var elem = $("navbar_dropmenu");
    if (elem) return elem;

    return create_navbar_dropmenu_div();
}

// on_click_dropmenu_btn - trigger an event when the drop menu button is clicked.
function on_click_dropmenu_btn(ev)
{
    var oMenu = g_ctxt_menu;
    var btn = $("navbar_dropmenu");
    wij_menu_on_btn_trigger(oMenu, btn, ev);

    return false;
}

// dropmenu_btn_ignore_event - in order to resolve conflicts between the drop menu
// button and the parent menu item, we need to process mousedown events on the
// button and prevent click events from propagating.
function dropmenu_btn_ignore_event(ev)
{
    if (!ev) ev = window.event;
    if (ev) Event.stop(ev);
}


// relocate_dropmenu_btn - move the button at the right side
// of the hovered menu that triggers the drop down menu.
function relocate_dropmenu_btn(elem)
{
    // Choose the appropriate target
    var hdr = elem;
    var menu_level = elem.menu_ref.menu_level;

    if (menu_level == 1)
    {
        hdr = elem.firstDescendant();
    }

    // TODO: a lot of this positioning stuff could be cached in
    // global variables. (It doesn't always work well while the
    // element is still rendering anyway.)
    var btn = get_navbar_dropmenu_btn();

    var w = hdr.offsetWidth;
    var w_btn = btn.offsetWidth;

    var h = hdr.offsetHeight;
    var h_btn = btn.offsetHeight;
    var y_fudge = Prototype.Browser.IE ? 1 : -1;

    if (menu_level == 3)
    {
        var x = w - w_btn - 8;
        var y = (h - h_btn) - 2;
    }
    else
    {
        // We need to add in the cumulative offset because the drop menu
        // positioning style is "absolute".
        var pos = Position.cumulativeOffset(hdr);
        var x = pos[0] + w - w_btn - 4;
        var y = pos[1] + (h - h_btn) / 2 + y_fudge;
    }

    // Re-parent the button.
    if (btn.parentNode) btn.parentNode.removeChild(btn);
    hdr.appendChild(btn);

    btn.style.left = x + "px";
    btn.style.top = y + "px";
    btn.style.visibility = "visible";
}

// hide_dropmenu_btn - hide the drop down menu trigger button
// when a menu item is no longer being hovered.
function hide_dropmenu_btn()
{
    var btn = get_navbar_dropmenu_btn();
    btn.style.visibility = "hidden";
    // Move the button out of the way so it can't affect the page width.
    btn.style.left = "0px";
    btn.style.top = "0px";
}

