/******************************
 Navbar menu definition schema
 Init by A. Krywaniuk, Mar 2008
 GUI widgetization project
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

/* Referenced by wij_navbar.c: */
// EXPORT_SYMBOL wij_suppress_pages
// EXPORT_SYMBOL nb_runtime_state
// TODO: it is not clear why in_edit_mode would need to be stripped here.
// Perhaps it is because navbar.js is included in both lists in strip.sh?
// EXPORT_SYMBOL in_edit_mode

/******************************
   Menu item data structures
 ******************************/

// L1 menu items are the expandable folders in the navbar pane.
// L2 menu items are the clickable elements in the navbar pane.
// L3 menu items are the tabs in the subnav frame.
// L4 menu items are the widgets inside the icontainer page.

// next_menuitem_serial_no - unique serial numbers for each menu item.
// The serial number is guaranteed to be unique across all 3 levels of menus.
var next_menuitem_serial_no = 1;

// l1elems - global array of all L1 menu items.
var l1elems = new Array();

// menu_elem_map (obsolete) - global hash table of all L1 & L2 menu items
// (accessible by the HTML element ids).
var menu_elem_map = new Object();


// wij_direct_load_pages - list (associative map) of pages that should not be
// viewed within the icontainer frame.
// TODO: currently, this list is arbitrary.
var wij_direct_load_pages = {
//    "topology" : 1,
    "dummy" : 1 // fake last item (no trailing comma)
};

// wij_customizable_pages - list (associative map) of pages that can accept
// configurable parameters.
var wij_customizable_pages = {
    "firewallpolicy" : 1,
    "log_access_memory" : 1,
    "route_monitor" : 1,
    "topology" : 1,
    "DB_jsconsole" : 1,
    "dummy" : 1 // fake last item (no trailing comma)
};

// is_page_customizable - API to check if a widget should display the customize button.
function is_page_customizable(menu_id)
{
    return (!!wij_customizable_pages[menu_id]);
}


// wij_fixed_sized_pages - list (associative map) of pages that should not be
// auto-sized to fit the contents. (We probably want to put all of these in the
// "customizable pages" list as well, since the height can be configured by the user.)
// TODO: looking this up based on the English menu names is not a good long-term solution.
var wij_fixed_sized_pages = {
    "topology" : 1,
    "DB_jsconsole" : 1,
    "log_access_memory" : 1,
    "dummy" : 1 // fake last item (no trailing comma)
};

// is_page_fixed_size - API to check if a widget should not be auto-sized.
function is_page_fixed_size(name)
{
    return (!!wij_fixed_sized_pages[name]);
}


// nat_mode_only_pages - pages to be suppressed in use mode in TP mode.
// TODO: there is some inconsistency in the design here. This whole list is duplicated in
// the main menu definition file, but we really need to have it here in order to add
// runtime pruning for user-added widgets. So the NAT_ONLY keyword could probably be
// safely removed at this point. Also, there are a couple of TP-mode only pages, but that
// filtering is done in the C module. In this case the list is much bigger, so it makes
// sense to include it as part of a static JS file rather than regenerating it all the time.
var nat_mode_only_pages = {
    "sysdhcpservice" : 1,
    "sysdhcpdynamic" : 1,
    "route_static" : 1,
    "routerpolicy" : 1,
    "route_rip" : 1,
    "route_ospf" : 1,
    "route_bgp" : 1,
    "route_multicast" : 1,
    "route_monitor" : 1,
    "vip" : 1,
    "vip_group" : 1,
    "ldb_monitor" : 1,
    "ipool" : 1,
    "concentrator" : 1,
    "pptp_range" : 1,
    "ssl_config" : 1,
    "ssl_monitor" : 1,
    "ssl_bookmark" : 1,
    "ssl_bookmark_group" : 1,
    "usb_modem" : 1,
    "dummy" : 1 // fake last item (no trailing comma)
};

// wij_suppress_pages - pages that we want to directly suppress at runtime (e.g. the
// disk-log viewer if no HD is detected). Set to 2 to suppress in both use & edit mode.
// (1 for use mode only.)
var wij_suppress_pages = {
    "dummy" : 2 // fake last item (no trailing comma)
};


// nb_runtime_state - to be overwritten at runtime
// This includes variables which control the enabling of menu items, as well as
// cached preference values.
var nb_runtime_state = {
    tp_mode : false,
    dummy : 0
};

/*
// TODO: consider using a menu-iterator class. It's an efficiency & complexity
// vs. code size tradeoff.
var MenuIterator = Class.create();

MenuIterator.prototype = {

    initialize: function()
    {
        this.i = 0;
        this.len = l1elems.length;

        this.j = 0;
        this.list2 = l1elems[i].child_nodes;
        this.len2 = list2.length;

        this.k = 0;
        this.list3 = list2[j].child_nodes;
        this.len3 = list3.length;

        this.l3_menu = list3[k];
    },

    next_l3_menu: function()
    {
        ...
    }
}
*/


function iterate_l3_menus(cb_fn)
{
    var len = l1elems.length;

    for (var i=0; i < len; i++)
    {
        var list2 = l1elems[i].child_nodes;
        var len2 = list2.length;

        for (var j=0; j<len2; j++)
        {
            var list3 = list2[j].child_nodes;
            var len3 = list3.length;

            for (var k=0; k<len3; k++)
            {
                var l3_menu = list3[k];
                cb_fn(l3_menu);
            }
        }
    }

    return null;
}

/******************************
    Append functions
******************************/

// append_new_L1_menu_JS - append a new L1 menu to the JS
// data structures.
function append_new_L1_menu_JS(name, menu_id)
{
    var serialno = next_menuitem_serial_no++;

    var l1_menu = new Object();
    l1_menu.serialno = serialno;
    l1_menu.menu_level = 1;
    l1_menu.id = "l1mi_dv_" + serialno;
    l1_menu.fold_id = "l1mi_fdr_" + serialno;
    l1_menu.menu_name = name;
    l1_menu.menu_id = menu_id;
    l1_menu.menu_hidden = false;
    l1_menu.menu_readonly = (menu_id != user_defined_menu_id);

    // Create the container for child elements.
    l1_menu.child_nodes = new Array();

    // Push into the global data structures.
    l1elems.push(l1_menu);
    menu_elem_map[l1_menu.id] = l1_menu;

    return l1_menu;
}


// append_new_L2_menu_JS - append a new L2 menu to the JS
// data structures.
function append_new_L2_menu_JS(name, l1_menu, menu_id)
{
    var serialno = next_menuitem_serial_no++;

    var l2_menu = new Object();
    l2_menu.serialno = serialno;
    l2_menu.menu_level = 2;
    l2_menu.id = "l2mi_dv_" + serialno;
    l2_menu.menu_name = name;
    l2_menu.menu_id = menu_id;
    l2_menu.menu_hidden = false;
    l2_menu.menu_readonly = (menu_id != user_defined_menu_id);

    // Create the JS container for L3 menu items.
    l2_menu.child_nodes = new Array();

    // Push into the global data structures.
    l1_menu.child_nodes.push(l2_menu);
    menu_elem_map[l2_menu.id] = l2_menu;

    return l2_menu;
}


// append_new_L3_menu - create a new Level 3 menu item.
function append_new_L3_menu(name, l2_menu, url, menu_id)
{
    var serialno = next_menuitem_serial_no++;
    var is_custom = (menu_id == user_defined_menu_id)

    var menu = new Object();
    menu.serialno = serialno;
    menu.menu_level = 3;
    menu.id = "sn_tab_" + serialno;
    menu.menu_name = name;
    menu.menu_id = menu_id;
    menu.menu_url = url;
    menu.menu_hidden = false;
    menu.menu_readonly = (!is_custom && !l2_menu.customizable);

    // menu_layout - single-column for custom, full-page for standard.
    menu.menu_layout = is_custom ? 1 : 0;
    // direct_load - whether to load the page directly, bypassing the icontainer frame.
    menu.direct_load = false;

    // Create the JS container for L4 menu items.
    // TODO: maybe only do this if this is a custom menu?
    menu.child_nodes = new Array();

    l2_menu.child_nodes.push(menu);
    return menu;
}

// get_next_tab_id - Finds the next available "tab" index based on the current
// tab configuration of a L2 menu.
function get_next_tab_id(l2_menu)
{
    var id = 0;

    for (var i = 0; i < l2_menu.child_nodes.length; i++)
    {
        var l3_menu = l2_menu.child_nodes[i];
        if (l3_menu.menu_tab_id && l3_menu.menu_tab_id > id)
        {
            id = l3_menu.menu_tab_id;
        }
    }

    return (id + 1);
}


// create_new_l3_menu - create a new Level3 menu item w/ default values.
function create_new_l3_menu(l2_menu)
{
    var def_name = wij_string("def_menu_name");
    var fake_url = "error"; // TODO: what to put here?

    var new_tab = append_new_L3_menu(def_name, l2_menu, fake_url, user_defined_menu_id);

    if (l2_menu.customizable && !in_edit_mode)
    {
        // Force full-page layout.
        new_tab.menu_layout = 0;
        new_tab.direct_load = true;
        new_tab.menu_tab_id = get_next_tab_id(l2_menu);
        new_tab.menu_url = "/system/status/status?tab_id=" + new_tab.menu_tab_id;

        Request.sendPOST("/system/status/tabs", "action=create&tab_id=" + new_tab.menu_tab_id);
    }


    return new_tab;
}


// append_new_L4_menu - create a new Level 4 menu item.
function append_new_L4_menu(name, l3_menu, url, menu_id)
{
    var menu = new Object();
    menu.serialno = next_menuitem_serial_no++;
    menu.menu_level = 4;
    menu.menu_name = name;
    menu.menu_id = menu_id;
    menu.menu_url = url;
    menu.menu_hidden = false;
    // Currently there are no L4 menus in the standard menu file, thus every L4
    // menu is user-configured. (If we changed this then we would have to go
    // back to the old technique of setting a global variable while loading
    // standard vs. diff files.)
    menu.menu_readonly = false;
//    menu.menu_readonly = (menu_id != user_defined_menu_id);

    // These properties are cached inside the menu item. (To avoid wasting memory,
    // the properties will be left undefined unless we explicitly set them.
    if (is_page_customizable(menu_id)) menu.menu_customizable = true;
    if (is_page_fixed_size(menu_id)) menu.menu_fixedsize = true;

    l3_menu.child_nodes.push(menu);
    return menu;
}



/******************************
    Initialization
******************************/

// Add left trim, right trim, and trim functions
// TODO: duplicated from subnav.js
if (!String.prototype.lTrim) {
    String.prototype.lTrim = function() { return this.replace(/^\s*/, ''); }
}
if (!String.prototype.rTrim) {
    String.prototype.rTrim = function() { return this.replace(/\s*$/, ''); }
}
if (!String.prototype.trim) {
    String.prototype.trim = function() { return this.lTrim().rTrim(); }
}


// load_menu_from_file_compact - read the menu definition from a hidden iframe
// diff_mode - whether to add changes to an existing menu definition file.
function load_menu_from_file_compact(diff_mode, menu_src)
{
//clogger.debug("load_menu_from_file_compact");
    if (!menu_src)
    {
        // Extract the menu source from inside the iframe document's <pre> block.
        // (Used at page load time)
        var menu_doc = null;

        try
        {
            menu_doc = diff_mode ? frames.menudef_diff.document : frames.menudef_base.document;
            if (!menu_doc || !menu_doc.documentElement)
            {
                throw("missing document");
            }
        }
        catch (e)
        {
            // IE will throw an exception if the document in the iframe fails to load and we
            // attempt to access its contents. To counteract this problem, the navbar-xlat module
            // will return an empty file rather than giving an error. Still, for safety's sake it
            // is good to catch the potential exception here.
            return;
        }

        // If we use body.innerHTML, the special characters will be mangled (e.g. "&"
        // will be converted to "&amp;"). So it is better to use textContent or innerText
        // (depending on browser support).
        menu_src = menu_doc.documentElement.textContent; // FF case
        if (!menu_src) menu_src = menu_doc.documentElement.innerText; // IE case
        if (!menu_src && menu_doc.body) menu_src = menu_doc.body.firstChild.innerHTML; // Just in case
    }

    // l0_menu - fake menu item for the root of the tree.
    var l0_menu = {
        menu_level: 0,
        child_nodes: l1elems
    };

    // Menu parsing scope:
    var menu_context = [ l0_menu, null, null, null, null ];
    var cur_elem = null;

    var new_elem; // actually, only used within finish_cur_elem

    // start_new_elem - begin a new active element context.
    function start_new_elem(level, name)
    {
        // TODO: There's no good reason why we don't use the same variable names for
        // cur_elem properties as we do for the final menu item.
        cur_elem = new Object();
        cur_elem.menu_level = level;
        cur_elem.id = name;
        cur_elem.name = name;
        cur_elem.menu_url = "error"; // needed for L3 only - will be set later.
    }

    // finish_cur_elem - finish adding the element in the active context.
    function finish_cur_elem()
    {
        if (!cur_elem) return;

        var menu_level = cur_elem.menu_level;

        var skip_adding_elem = false;
        var force_elem_readwrite = false;

        // In diff mode, try to find an existing menu item that corresponds to this
        // one. In that case we will ignore the changes and only use it for context
        // (and possibly apply some customizations).
        // (Don't do this for L4 widgets because these don't have the user_defined
        // id and we want to support duplicate widgets on the same page.)
        if (diff_mode && cur_elem.id != user_defined_menu_id && menu_level != 4)
        {
            // Search for the menu id in the child_nodes array of the parent menu.
            var arr = menu_context[menu_level-1].child_nodes;
            var len = arr.length;

            for (var i=0; i<len; i++)
            {
                var test_elem = arr[i];
                if (test_elem.menu_id == cur_elem.id)
                {
                    // If we find an existing element then add it into the current
                    // menu context (but skip the part where we add a new one).
                    new_elem = test_elem;
                    menu_context[menu_level] = test_elem;
                    skip_adding_elem = true;

                }
            }

            // We didn't find a standard menu item (possibly due to a menu being
            // moved or deleted during upgrading), so add a new one but without the
            // readonly flag.
            if (!skip_adding_elem)
            {
                force_elem_readwrite = true;
            }
        }


        // In base mode (or in diff mode if we didn't find the menu reference), create
        // a new element.
        if (!skip_adding_elem)
        {
            switch (menu_level)
            {
            case 1:
                new_elem = append_new_L1_menu_JS(cur_elem.name, cur_elem.id);
                break;

            case 2:
                var l1_menu = menu_context[1];
                new_elem = append_new_L2_menu_JS(cur_elem.name, l1_menu, cur_elem.id);
                if (cur_elem.customizable) new_elem.customizable = true;
                break;

            case 3:
                var l2_menu = menu_context[2];
                new_elem = append_new_L3_menu(cur_elem.name, l2_menu, cur_elem.menu_url, cur_elem.id);
                if (typeof cur_elem.menu_layout != "undefined") new_elem.menu_layout = cur_elem.menu_layout;
                if (typeof cur_elem.menu_tab_id != "undefined") new_elem.menu_tab_id = cur_elem.menu_tab_id;
                if (typeof cur_elem.menu_report_section != "undefined") new_elem.menu_report_section = cur_elem.menu_report_section;
                break;

            case 4:
                var l3_menu = menu_context[3];
                new_elem = append_new_L4_menu(cur_elem.name, l3_menu, cur_elem.menu_url, cur_elem.id);
                if (cur_elem.menu_col) new_elem.menu_col = cur_elem.menu_col;
                break;
            }

            menu_context[menu_level] = new_elem;
        }

//clogger.debug("Added an L" + cur_elem.menu_level + " element w/ name = " + cur_elem.name);


        // Now that we have either found the existing element or created a new one, we
        // can set some of the customization flags.

        // Set the element hidden in retrospect. If we are in use mode, this will
        // actually result in the menu item being stripped from the global data tree.
        if (cur_elem.hidden)
        {
            new_elem.menu_hidden = true;
        }

        // Also check for any temporarily suppressed menus. These can be re-enabled at
        // run-time, but currently we are just going to hide/suppress them. If the runtime state
        // changes then the menu tree would just need to be refreshed.
        // TODO: is this a good idea?
        if (new_elem.menu_url)
        {
            var sv = wij_suppress_pages[new_elem.menu_id];

            // As a possible optimization, suppression for TP-mode only pages is done via
            // a separate static array.
            if (!sv && nb_runtime_state.tp_mode)
            {
                sv = nat_mode_only_pages[new_elem.menu_id];
            }

            if (sv && !in_edit_mode)
                new_elem.menu_hidden = true;
            else if (sv == 2 && in_edit_mode)
                new_elem.menu_hidden = true;

            // TODO: there is currently nothing here to prevent the user from re-enabling a
            // suppressed menu item in edit mode (although the change would not have any effect).
        }


        // Add some extended attributes that aren't available as parameters to the
        // append_new_Lx_menu() functions.
        if (menu_level == 4)
        {
            if (cur_elem.hdr_color) new_elem.cust_hdr_color = cur_elem.hdr_color;
            if (cur_elem.url_ext) new_elem.cust_url_ext = cur_elem.url_ext;
//if (cur_elem.url_ext) clogger.debug("load_menu_from_file_compact - l4 menu has url_ext: " + cur_elem.url_ext);
            if (cur_elem.hdr_comment) new_elem.cust_hdr_comment = cur_elem.hdr_comment;
            if (cur_elem.height) new_elem.cust_height = cur_elem.height;
        }

        // Force a "standard" element to be editable if we didn't find it in the base
        // menu definition file.
        if (force_elem_readwrite)
        {
            new_elem.menu_readonly = false;
        }

        // Set a few troublesome pages as "direct load only", meaning that they can't be
        // widgetized.
        // TODO: this is proof of concept only.
        if (menu_level == 3 && wij_direct_load_pages[new_elem.menu_id])
        {
//clogger.debug("Setting the direct_load attribute on item '" + new_elem.menu_id + "'");
            new_elem.direct_load = true;
        }

        // Re-order the menu item in the list.
        if (diff_mode && cur_elem.pos != undefined)
        {
            var pos = cur_elem.pos;
            var arr = menu_context[menu_level-1].child_nodes;
            var len = arr.length;

            if (pos >= 0 &&  pos < len-1)
            {
                var elem = arr.pop(); // should be cur_elem.
                arr.splice(pos, 0, elem);
            }
        }

        cur_elem = null;
    }


    /* Create a lookup table for parsing specific menu attributes. */

    // parse_url - parse the "url" attribute for L3/L4 menus
    function parse_url(val)
    {
        if (cur_elem.menu_level < 3)
        {
            clogger.debug("Attempt to define URL w/ no l3/l4 menu in scope:" + ln);
            return -1;
        }
        cur_elem.menu_url = val;
        return 1;
    }

    // parse_layout - parse the "layout" attribute for L3 menus
    function parse_layout(val)
    {
        if (cur_elem.menu_level != 3)
        {
            clogger.debug("Attempt to define layout w/ no l3 menu in scope:" + ln);
            return -1;
        }

        cur_elem.menu_layout = parseInt(val);
        return 1;
    }

    // parse_COL - parse the "COL" attribute for L4 menus
    function parse_COL(val)
    {
        if (cur_elem.menu_level != 4)
        {
            clogger.debug("Attempt to define column w/ no l4 menu in scope:" + ln);
            return -1;
        }

        cur_elem.menu_col = parseInt(val);
        return 1;
    }

    // parse_name - parse the "name" attribute for all menus
    function parse_name(val)
    {
        cur_elem.name = val;
        return 1;
    }

    // parse_hdr_color - parse the "hdr_color" attribute for all menus
    function parse_hdr_color(val)
    {
        if (cur_elem.menu_level != 4)
        {
            clogger.debug("Attempt to define header color w/ no l4 menu in scope:" + ln);
            return -1;
        }

        cur_elem.hdr_color = val;
        return 1;
    }

    function parse_hdr_comment(val)
    {
        if (cur_elem.menu_level != 4)
        {
            clogger.debug("Attempt to define header comment w/ no l4 menu in scope:" + ln);
            return -1;
        }

        cur_elem.hdr_comment = val;
        return 1;
    }

    function parse_URL_ext(val)
    {
        if (cur_elem.menu_level != 4)
        {
            clogger.debug("Attempt to define URL extension w/ no l4 menu in scope:" + ln);
            return -1;
        }

        cur_elem.url_ext = val;
        return 1;
    }

    function parse_POS(val)
    {
        if (cur_elem.menu_level > 3)
        {
            return -1;
        }

        cur_elem.pos = parseInt(val);
        return 1;
    }

    function parse_height(val)
    {
        if (cur_elem.menu_level != 4)
        {
            clogger.debug("Attempt to define iframe height w/ no l4 menu in scope:" + ln);
            return -1;
        }

        cur_elem.height = parseInt(val);
        return 1;
    }

    // parse_tab - parse the "TAB" attribute for L3 dashboard tabs
    function parse_TAB(val)
    {
        if (cur_elem.menu_level < 3)
        {
            clogger.debug("Attempt to define TAB w/ no l3/l4 menu in scope:" + ln);
            return -1;
        }

        cur_elem.menu_tab_id = Number(val);
        return 1;
    }

    // parse_report_section - parse the "REPORT_SECTION" attribute for L3 report sections
    function parse_REPORT_SECTION(val)
    {
        if (cur_elem.menu_level < 3)
        {
            clogger.debug("Attempt to define REPORT_SECTION w/ no l3/l4 menu in scope:" + ln);
            return -1;
        }

        cur_elem.menu_report_section = Number(val);
        return 1;
    }

    // TODO: we could replace this with a generic function to read in all the attributes from
    // the file and set them in an object, then only parse the ones we are expecting (and provide
    // a debug mode in which we check for anything unexpected).

    // av_parser_fns - associative map of callback functions for known attributes
    // Attributes w/o values such as "hidden" are parsed separately below.
    var av_parser_fns = {
        "URL" : parse_url,
        "layout" : parse_layout,
        "COL" : parse_COL,
        "name" : parse_name,
        "hdr_color" : parse_hdr_color,
        "hdr_comment" : parse_hdr_comment,
        "URL_ext" : parse_URL_ext,
        "POS" : parse_POS,
        "height" : parse_height,
        "TAB" : parse_TAB,
        "REPORT_SECTION" : parse_REPORT_SECTION
    };


    function set_hidden() { cur_elem.hidden = true; return 1; }
    // TODO: need to differentiate between hidden & no access at some point.
    function set_NO_ACCESS() { cur_elem.hidden = true; return 1; }

    function set_NAT_ONLY()
    {
        if (!in_edit_mode && nb_runtime_state.tp_mode)
        {
clogger.debug("Set elem hidden due to NAT_ONLY keyword: " + cur_elem.name);
            cur_elem.hidden = true;
        }

        return 1;
    }

    function set_VDOM_EACH()
    {
        if (!in_edit_mode && nb_runtime_state.in_vdom_mode && !nb_runtime_state.in_vdom_menu)
        {
//clogger.debug("Set elem hidden due to VDOM_EACH keyword: " + cur_elem.name);
            cur_elem.hidden = true;
        }

        return 1;
    }

    function set_VDOM_GLOBAL()
    {
        if (!in_edit_mode && nb_runtime_state.in_vdom_mode && nb_runtime_state.in_vdom_menu)
        {
//clogger.debug("Set elem hidden due to VDOM_GLOBAL keyword: " + cur_elem.name);
            cur_elem.hidden = true;
        }

        return 1;
    }

    function set_CUSTOMIZABLE()
    {
//clogger.debug("Set elem customizable due to CUSTOMIZABLE keyword: " + cur_elem.name);

        cur_elem.customizable = true;

        return 1;
    }

    // av_parser_fns - associative map of callback functions for known keywords
    // (standalone keywords, as opposed to A/V pairs).
    var kwd_parser_fns = {
        "hidden" : set_hidden,
        "NO_ACCESS" : set_NO_ACCESS,
        "NAT_ONLY" : set_NAT_ONLY,
        "VDOM_EACH" : set_VDOM_EACH,
        "VDOM_GLOBAL" : set_VDOM_GLOBAL,
        "CUSTOMIZABLE" : set_CUSTOMIZABLE
    };



    // parse_attribute - check for any known attribute/values on the current line.
    function parse_attribute(ln)
    {
        // Parse known attribute-value pairs.
        var sep = ln.indexOf("=");
        if (sep > 0)
        {
            var attr = ln.substring(0, sep);
            var cb_fn = av_parser_fns[attr];
            if (cb_fn)
            {
                if (!cur_elem)
                {
                    clogger.debug("Attempt to set attribute w/ no menu in scope: " + ln);
                    return -1;
                }

                var val = ln.substring(sep+1);
                return cb_fn(val);
            }
        }

        // Parse standalone keywords.
        var cb_fn = kwd_parser_fns[ln];
        if (cb_fn)
        {
            if (!cur_elem)
            {
                clogger.debug("Attempt to set property w/ no menu item in scope: " + ln);
                return -1;
            }

            return cb_fn(ln);
        }

        return 0;
    }


    // Parse the menu file line by line.
    var aMenuLines = menu_src.split("\n");
    for (i=0; i<aMenuLines.length; i++)
    {
        var ln = aMenuLines[i];

        // Trimming the string is needed on IE for some reason, probably to do
        // with the CRLF format.
        ln = ln.trim();

        // TODO: don't we need to trim the line before parsing the attribute?
        if (parse_attribute(ln) != 0)
            continue;


        // Otherwise look for menu item definitions
        var sep = ln.indexOf("=");
        if (sep < 0)
        {
//            mlogger.debug("lmff - ignore line w/ no '=' sign.");
            continue;
        }

        var menu_num = ln.substring(0, sep-1);

        // NOTE: For some reason that I don't understand, using menu_num.match instead of
        // ln.match below will always fail (at least on FF2).
        if (!ln.match(/^[1-9]+/))
        {
            clogger.debug("lmff - unknown attribute doesn't look like a menu definition: " + ln);
            continue;
        }

        var name = ln.substring(sep+1);

        // Count the number of dots to the left of the equals sign.
        // This is just an elaborate way to determine the menu level.
        var dot_count = 0;
        var p = menu_num.indexOf(".", p+1);

        while (p > 0)
        {
            dot_count++;
            p = menu_num.indexOf(".", p+1);
        }

        if (dot_count > 3)
        {
            clogger.debug("lmff - ignore line w/ " + dot_count + " '.' separators");
            continue;
        }

        // Start a new menu item at the specified level.
        var menu_level = (dot_count + 1);

        // Close the previous menu context.
        finish_cur_elem();

        // Close any cached contexts that fell out of scope (using
        // Duff's device to optimize).
        switch (menu_level)
        {
            case 1: menu_context[2] = null;
            case 2: menu_context[3] = null;
            case 3: menu_context[4] = null;
        }


        if (!menu_context[menu_level-1])
        {
            clogger.debug("Attempt to define L" + menu_level + " menu w/ no parent scope: " + ln);
            continue;
        }

        start_new_elem(menu_level, name);
    }

    finish_cur_elem();


    // prune_i - helper function for prune_hidden_menus.
    // (We use identical attribute names in the L1-L4 menu item definitions
    // in order to facilitate recursive iteration.)
    function prune_i(aMenus, level, check_prune)
    {
        // Iterate backwards to avoid bugs while removing elements by index.
        var len = aMenus.length;
        for (var i=len-1; i >= 0; i--)
        {
            var menu_ref = aMenus[i];
            if (check_prune(menu_ref))
            {
                aMenus.splice(i,1);
                continue;
            }

            if (menu_ref.child_nodes && level < 4)
            {
                prune_i(menu_ref.child_nodes, level+1, check_prune);

                // Also prune out any empty menus in use mode.
                if (menu_ref.child_nodes.length == 0)
                {
                    if ((level == 3) && (menu_ref.menu_id != user_defined_menu_id) )
                    {
                        // Standard L3 menu items have an implied L4 menu item,
                        // so they are not really empty.
                    }
                    else
                    {
                        aMenus.splice(i,1);
                        continue;
                    }
                }
            }
        }
    }

    // prune_hidden_menus - iterate the global menu tree and remove any
    // hidden menu items in use mode.
    // TODO: we are probably better off doing this in the Apache modules
    // (which would also prevent any information leakage).
    function prune_hidden_menus()
    {
        prune_i(l1elems, 1, function (m) {
            return m.menu_hidden; }
        );
    }

    // prune_customizable_menus - iterate the global menu tree and remove any
    // customizable menu items in edit mode.
    function prune_customizable_menus()
    {
        prune_i(l1elems, 1, function(m) {
            return m.customizable; }
        );
    }


    if (!in_edit_mode)
    {
        prune_hidden_menus();
    }
    else
    {
        // Hide customizable menus (ie: dashboard) in edit mode.
        prune_customizable_menus();

        // As a special case, suppress the vdom page in edit mode.
        // Normally we don't suppress pages just because they are incompatible with
        // the current configuration. However this is a special case because only
        // the super admin can access this page and we (currently) don't support
        // reconfiguration of the super admin's menu layout.
        var ctxt = locate_l3_menu_by_id('vdom');
        if (ctxt)
        {
            var l1_menu = ctxt[0];
            var l2_menu = ctxt[1];
            var l3_menu = ctxt[2];
            var j = ctxt[4];
            var k = ctxt[5];

            // Remove the vdom tab.
            l2_menu.child_nodes.splice(k,1);

            // If the vdom tab is removed, the L2 menu should now be empty, so remove
            // it as well.
            if (l2_menu.child_nodes.length == 0)
            {
                l1_menu.child_nodes.splice(j,1);
            }
        }
    }
}

