define("services/cmdb", ["angular", "fweb", "jquery", "services/loader"], function(angular, fweb, $) {
    "use strict";
    function factory($http, $q, $injector, $rootScope, $log, $cacheFactory, loader, ftntCopy) {
        function thisError(object) {
            return new loader.FOSError("Use new keyword to create " + object)
        }
        function CMDBError(response, message, config) {
            var CFG_ERR = {
                cmdb_no_permissions: CMDBError.NO_PERMISSIONS
            };
            if (!(this instanceof CMDBError))
                throw thisError("CMDBError");
            if (this.message = "",
            "string" == typeof response)
                message = response,
                response = void 0;
            else if ("number" == typeof response.error)
                loader.FOSError.call(this, response.error);
            else if ("number" == typeof response.status)
                loader.FOSError.call(this, response.status);
            else {
                var err_no = CFG_ERR[response.error];
                void 0 !== err_no ? loader.FOSError.call(this, err_no) : (this.err_no = null ,
                this.message = response.error || this.message)
            }
            this.name = "CMDBError",
            this.response = response,
            message && (this.message && (this.message += "\n"),
            this.message += message),
            response && response.message && (this.message && (this.message += "\n"),
            this.message += "(" + response.message + ")"),
            this.config = config
        }
        function response_filter(response) {
            "number" == typeof response.status && loader.login_redirect(response.status);
            var cmdb_response = response.data;
            return response.data ? "object" != typeof cmdb_response || "error" in cmdb_response ? (cmdb_response.indexOf && cmdb_response.indexOf('<form id="login_panel"') > -1 && loader.login_redirect(),
            $q.reject(new CMDB.Error(cmdb_response))) : cmdb_response && "success" === cmdb_response.status ? "GET" === response.config.method ? cmdb_response.results : cmdb_response : $q.reject(new CMDB.Error(response,"Unknown error")) : $q.reject(new CMDB.Error(response,"Response data is " + response.data))
        }
        function login_filter(response) {
            return loader.login_redirect(response.status),
            $q.reject(new CMDB.Error(response))
        }
        function mkey_valid(mkey) {
            return "string" == typeof mkey ? !!mkey : "number" == typeof mkey ? !0 && 4294967295 >= mkey && mkey >= 0 : !1
        }
        function CMDB(path, name, preferences) {
            if (!(this instanceof CMDB))
                throw thisError("CMDB instance.");
            1 === arguments.length && (preferences = path,
            path = void 0,
            preferences instanceof CMDB && (preferences = angular.copy(preferences.parameters)));
            var parameters = {
                cache: !1,
                path: path,
                name: name
            }
              , instance = this;
            this.parameters = angular.extend(parameters, preferences);
            var bound = ["fetch", "defaults", "schema", "_cached_schema"];
            bound.forEach(function(fn) {
                instance[fn] = instance[fn].bind(instance)
            }),
            this._shortcuts = this._get_shortcuts(),
            this._models = angular.extend({}, CMDB._models)
        }
        function CMDBUnion() {
            if (!this)
                throw thisError("CMDBUnion");
            var args;
            args = 1 === arguments.length ? arguments[0] : $.makeArray(arguments),
            this.tables = args
        }
        function CMDB_batch() {
            function resolve(result) {
                if (arguments.length > 0) {
                    collect.push(result);
                    var progress = collect.length / (collect.length + operations.length);
                    deferred.notify({
                        successful: collect,
                        last: result,
                        progress: progress
                    })
                }
                if (operations.length) {
                    var operation = operations.shift();
                    if (!angular.isFunction(operation))
                        return $q.reject(new CMDBError("Batch operation is not a function " + operation));
                    operation().$promise.then(resolve, reject)
                } else
                    deferred.resolve(collect);
                return result
            }
            function reject(error) {
                return deferred.reject(error)
            }
            var operations = $.isArray(arguments[0]) ? arguments[0] : $.makeArray(arguments)
              , collect = []
              , deferred = $q.defer();
            return resolve(),
            deferred.promise
        }
        function CMDBModel(path, name, prototype, enhance, enhance_schema) {
            if (!(this instanceof CMDBModel))
                throw thisError("CMDBError");
            this.path = path,
            this.name = name,
            this.prototype = prototype,
            this.enhance = enhance,
            this.enhance_schema = enhance_schema
        }
        function CMDB_model() {
            for (var i = 0, len = arguments.length; len > i; ++i) {
                var models = $injector.invoke(arguments[i]);
                angular.isArray(models) || (models = [models]);
                for (var m = 0, len2 = models.length; len2 > m; ++m) {
                    var model = models[m];
                    CMDB._models[model.path + "." + model.name] = model
                }
            }
        }
        function CMDB_get_cache() {
            var LRU_CACHE_COUNT = 5;
            return CMDB._cache || (CMDB._cache = $cacheFactory("CMDB", {
                number: LRU_CACHE_COUNT
            }))
        }
        CMDBError.NO_PERMISSIONS = loader.FOSError.NO_PERMISSIONS;
        var API_URL = "/api/cmdb"
          , COMPLEX_OBJECTS = ["log.disk.setting", "log.gui-display", "log.threat-weight", "system.global", "vpn.l2tp", "report.setting", "log.eventfilter"];
        return CMDB.INVALID_MKEY = null ,
        CMDB.prototype = {
            _get_shortcuts: function() {
                var cmdb = this
                  , _shortcuts = {
                    $delete: function(preferences) {
                        function error_fn() {
                            throw error
                        }
                        var result, entry = this, error = new CMDBError(CMDBError.NO_PERMISSIONS,"Entry has been deleted ");
                        if (!mkey_valid(entry.$mkey)) {
                            var msg = cmdb._is_complex_object() ? "Unable to delete Complex Objects" : "Entry cannot be deleted. mkey is invalid: " + String(entry.$mkey);
                            throw new CMDBError(CMDBError.NO_PERMISSIONS,msg)
                        }
                        return result = cmdb.del(entry.$mkey, preferences),
                        result.$promise = result.$promise.then(function(result) {
                            return angular.copy({
                                $promise: $q.reject(error),
                                $resolved: !0,
                                $delete: error_fn,
                                $get: error_fn
                            }, entry),
                            entry.$mkey = CMDB.INVALID_MKEY,
                            result
                        }),
                        result
                    },
                    $save: function(preferences) {
                        var result, entry = this, mkey = entry.$mkey;
                        return mkey_valid(mkey) || (mkey = CMDB.INVALID_MKEY),
                        result = cmdb.edit(mkey, entry, preferences)
                    },
                    $save_defaults: function(preferences) {
                        var result, entry = this, mkey = this.$new ? -1 : entry.$mkey;
                        if (this.$new || mkey_valid(mkey))
                            return result = entry.$new ? cmdb.append(entry, preferences) : cmdb.edit(mkey, entry, preferences),
                            this.$delete || (this.$delete = _shortcuts.$delete.bind(this)),
                            result;
                        throw new CMDBError(CMDBError.NO_PERMISSIONS,"Cannot save defaults without valid mkey or id")
                    }
                };
                return _shortcuts
            },
            _get_mkey: function(entry) {
                var schema = entry.$schema || this._cached_schema();
                return schema.$promise.then(function(schema) {
                    var result = entry[schema.mkey];
                    return mkey_valid(result) || (result = CMDB.INVALID_MKEY),
                    result
                })
            },
            _set_mkey: function(entry, value) {
                function resolve(schema) {
                    if (!mkey_valid(value))
                        throw $log.error("Mkey supplied to _set_mkey is invalid", entry, value, schema),
                        new CMDBError("mkey is invalid: " + value);
                    return entry.$mkey = entry[schema.mkey] = value,
                    value
                }
                var schema = entry.$schema || this._cached_schema();
                return schema.$resolved ? (resolve(schema),
                null ) : schema.$promise.then(resolve)
            },
            fetch: function(preferences) {
                return this._fetch(preferences)
            },
            _fetch: function(preferences, returnSingle) {
                function shortcuts(entry, resource) {
                    entry.$save = cmdb._shortcuts.$save.bind(entry),
                    entry.$delete = cmdb._shortcuts.$delete.bind(entry),
                    entry.$defaults = cmdb.defaults,
                    entry.$schema = cmdb._cached_schema(),
                    cmdb._get_mkey(entry).then(function(mkey) {
                        entry.$mkey = mkey
                    }),
                    resource && (resource.$defaults = entry.$defaults,
                    resource.$schema = entry.$schema)
                }
                var parameters = {
                    action: "select",
                    with_meta: !0
                }
                  , isArray = !this._is_complex_object()
                  , cmdb = this;
                return parameters = this._params(parameters, preferences),
                this._request(parameters, "GET", isArray, returnSingle, shortcuts, this._get_model(parameters))
            },
            _is_complex_object: function() {
                var path_name = this.parameters.path + "." + this.parameters.name;
                return COMPLEX_OBJECTS.indexOf(path_name) > -1
            },
            edit: function(mkey, value, preferences) {
                var result, parameters = {
                    action: "edit",
                    mkey: mkey === CMDB.INVALID_MKEY && this._is_complex_object() ? -1 : mkey,
                    json: value,
                    shortcuts: !1
                };
                if (parameters = this._params(parameters, preferences),
                mkey === CMDB.INVALID_MKEY && !this._is_complex_object())
                    throw new CMDBError(CMDBError.NO_PERMISSIONS,"Entry cannot be saved with no mkey because it is not a complex object.");
                return result = this._request(parameters, "POST")
            },
            append: function(value, preferences) {
                var result, parameters = {
                    action: "append",
                    mkey: angular.isArray(value) ? value.map(function() {
                        return -1
                    }) : -1,
                    json: value,
                    shortcuts: !1
                }, cmdb = this;
                return parameters = this._params(parameters, preferences),
                result = this._request(parameters, "POST"),
                result.$promise = result.$promise.then(function(result) {
                    function _set_mkey(value, i) {
                        value.$new && (value.$new = !1),
                        cmdb._set_mkey(value, isArray ? result.mkey[i] : result.mkey)
                    }
                    var isArray = angular.isArray(value);
                    return isArray ? value.forEach(_set_mkey) : _set_mkey(value),
                    result
                }),
                result
            },
            get: function(mkey, preferences) {
                var parameters = {
                    key: "number" == typeof mkey ? "id" : "name",
                    pattern: mkey,
                    with_meta: !0
                };
                return preferences = angular.extend(parameters, preferences),
                this._fetch(preferences, !0)
            },
            del: function(mkey, preferences) {
                var parameters = {
                    action: "delete",
                    mkey: mkey,
                    shortcuts: !1
                };
                return parameters = this._params(parameters, preferences),
                this._request(parameters, "POST")
            },
            move: function(mkey, index_to, insert_before, preferences) {
                var parameters = {
                    action: "move",
                    mkey: mkey,
                    before: insert_before ? index_to : void 0,
                    after: insert_before ? void 0 : index_to,
                    shortcuts: !1
                };
                return parameters = this._params(parameters, preferences),
                this._request(parameters, "POST")
            },
            defaults: function(preferences) {
                function shortcuts(entry, resource) {
                    entry.$save = cmdb._shortcuts.$save_defaults.bind(entry),
                    entry.$defaults = cmdb.defaults,
                    entry.$new = !0,
                    (resource || entry).$schema = cmdb._cached_schema()
                }
                var parameters = {
                    action: "fetch_default",
                    cache: !0
                }
                  , cmdb = this;
                return parameters = this._params(parameters, preferences),
                this._request(parameters, "GET", null , null , shortcuts, this._get_model(parameters))
            },
            schema: function(preferences) {
                var parameters = {
                    action: "schema",
                    cache: !0
                }
                  , cmdb = this;
                parameters = this._params(parameters, preferences);
                var model = this._get_model(parameters)
                  , result = this._request(parameters, "GET", !1);
                return model && model.enhance_schema && (result.$promise = result.$promise.then(function() {
                    return model.enhance_schema(result, cmdb),
                    result
                })),
                result
            },
            _cached_schema_resource: null ,
            _cached_schema: function() {
                var result = this._cached_schema_resource;
                return result || (result = this._cached_schema_resource = this.schema()),
                result
            },
            _get_model: function(parameters) {
                return parameters = parameters || this.parameters,
                void 0 !== parameters.model ? parameters.model : this._models[parameters.path + "." + parameters.name]
            },
            _request: function(parameters, method, isArray, returnSingle, shortcuts, model) {
                function Resource(data, parameters, model, promise) {
                    this.$cmdb = parameters,
                    Resource.init(this, data, model, promise)
                }
                function addShortcuts(shortcuts, resource) {
                    function finish(resource) {
                        for (var i = 0, len = entries.length; len > i; ++i)
                            shortcuts(entries[i]);
                        return resource
                    }
                    function onError(error) {
                        function make_error_fn(shortcut) {
                            entries[i][shortcut] = function() {
                                throw new CMDBError(error,"Can't " + shortcut + " entry is invalid.")
                            }
                        }
                        for (var i = 0, len = entries.length; len > i; ++i)
                            keys.forEach(make_error_fn);
                        return error
                    }
                    var keys, dummy = {}, isArray = angular.isArray(resource), entries = isArray ? resource : [resource];
                    shortcuts(dummy, resource),
                    keys = Object.keys(dummy),
                    resource.$promise.then(finish, onError),
                    keys.forEach(function(shortcut) {
                        function not_resolved() {
                            throw new CMDBError("Unable to call shortcut, " + shortcut + ": resource is not resolved",null ,this)
                        }
                        if (angular.isFunction(dummy[shortcut]))
                            for (var i = 0, len = entries.length; len > i; ++i)
                                entries[i][shortcut] = not_resolved
                    })
                }
                function resolve(data) {
                    if (angular.isArray(data) !== isArray) {
                        var error = new CMDBError({
                            data: data,
                            parameters: parameters
                        },"CMDB Configuration Error. Expected result to be an " + (isArray ? "Array" : "Object") + " but got an " + (isArray ? "Object" : "Array"));
                        return $q.reject(error)
                    }
                    if (isArray && !returnSingle) {
                        result.length = 0;
                        for (var i = 0, len = data.length; len > i; ++i)
                            model && model.prototype && model.put_prototype(Resource, data[i]),
                            result.push(new Resource(data[i],cmdb.parameters,model,result.$promise))
                    } else {
                        var promise = result.$promise;
                        if (isArray && returnSingle) {
                            if (0 === data.length)
                                return reject(new CMDBError({
                                    data: data,
                                    parameters: parameters
                                },"Entry not found"));
                            data = data[0]
                        }
                        model && model.prototype && model.put_prototype(Resource, data, !0),
                        Resource.init(result, data, model, promise),
                        result.$promise = promise
                    }
                    return result.$resolved = !0,
                    "POST" === method && new_original && json && (json.$original = new_original),
                    result
                }
                function reject(response) {
                    return response instanceof CMDBError && (response.config = parameters),
                    result.$resolved = !0,
                    "POST" === method && (result.status = response),
                    $q.reject(response)
                }
                function prune(entry) {
                    if (angular.isArray(entry))
                        return entry.map(prune);
                    var result = {}
                      , original = entry.$original;
                    return angular.forEach(entry, function(value, key) {
                        "$" === key.substr(0, 1) || angular.equals(original[key], value) || (result[key] = value)
                    }),
                    result
                }
                Resource.init = function(resource, data, model, promise) {
                    var $cmdb = resource.$cmdb;
                    angular.copy(data || {}, resource),
                    resource.$cmdb = $cmdb,
                    resource.$$original = data,
                    resource.$original = data,
                    model && model.enhance && (promise = promise.then(function() {
                        return resource
                    }),
                    model.enhance(resource, promise)),
                    data && "schema" !== action && "GET" === method && cmdb._get_mkey(resource).then(function(mkey) {
                        resource.$mkey = mkey
                    })
                }
                ,
                model && model.prototype && model.put_prototype(Resource);
                var cmdb = this
                  , do_prune = parameters.prune
                  , new_original = null 
                  , action = parameters.action
                  , orig_parameters = parameters;
                if (isArray = !!isArray,
                parameters.shortcuts === !1 && (shortcuts = null ),
                parameters.model && (model = parameters.model,
                model.enhance_schema))
                    throw new CMDBError("enhance_schema not implemented for model overrides! (FIXME)");
                delete parameters.model,
                delete parameters.shortcuts,
                delete parameters.prune;
                var result_promise, cache_id, cache, req_params = {
                    request: parameters
                }, http_params = {
                    method: method,
                    url: API_URL,
                    cache: parameters.cache || !1,
                    responseType: "json"
                }, result = isArray && !returnSingle ? [] : new Resource(null ,cmdb.parameters);
                if (http_params.cache = req_params.cache || !1,
                "GET" === method)
                    req_params.request = JSON.stringify(req_params.request),
                    http_params.params = req_params;
                else if ("POST" === method) {
                    var json = req_params.request.json
                      , storage = {};
                    new_original = angular.copy(ftntCopy.clean(json, storage)),
                    ftntCopy.unclean(new_original, storage),
                    do_prune && json && (req_params.request.json = prune(json)),
                    http_params.data = req_params
                }
                return result.$resolved = !1,
                orig_parameters.ng_cache && "GET" === method && (cache_id = angular.toJson(orig_parameters),
                cache = CMDB._get_cache(),
                result_promise = cache.get(cache_id)),
                result_promise || (result_promise = $http(http_params),
                cache && cache.put(cache_id, result_promise)),
                result.$promise = result_promise.then(response_filter, login_filter).then(resolve, reject),
                shortcuts && !result.$resolved && addShortcuts(shortcuts, result),
                result
            },
            _params: function(parameters, preferences) {
                var result = angular.extend({}, this.parameters);
                return angular.extend(result, parameters),
                angular.extend(result, preferences)
            }
        },
        CMDBUnion.prototype = {
            fetch: function() {
                function resolve(datas) {
                    result.length = 0;
                    for (var i = 0, len = datas.length; len > i; ++i)
                        result.splice.apply(result, [result.length, 0].concat(datas[i]));
                    return result.$resolved = !0,
                    result
                }
                function reject(error) {
                    return result.$resolved = !0,
                    $q.reject(error)
                }
                var result = []
                  , promises = this.tables.map(function(table) {
                    return table.fetch().$promise
                });
                return result.$promise = $q.all(promises).then(resolve, reject),
                result.$resolved = !1,
                result
            }
        },
        CMDBModel.prototype = {
            put_prototype: function(ctor, entry, copy) {
                if (this.prototype) {
                    var is_fn = angular.isFunction(this.prototype);
                    if (is_fn || entry) {
                        if (is_fn && entry) {
                            var new_proto = this.prototype(entry);
                            copy ? angular.copy(new_proto, ctor.prototype) : ctor.prototype = new_proto
                        }
                    } else
                        ctor.prototype = this.prototype
                }
            }
        },
        $rootScope.$on("$routeChangeStart", function() {
            CMDB._models = {}
        }),
        angular.extend(CMDB, {
            _models: {},
            Union: CMDBUnion,
            Error: CMDBError,
            Model: CMDBModel,
            batch: CMDB_batch,
            model: CMDB_model,
            _get_cache: CMDB_get_cache
        }),
        CMDB
    }
    return angular.module("ftnt").factory("CMDB", factory)
}),
define("services/admin", ["angular", "services/cmdb"], function(angular) {
    "use strict";
    function Admin($resource, CMDB, $q) {
        var admin_resource = $resource("/p/system/admins/current/json/")
          , instance = this
          , model = admin_resource.get()
          , deferred = $q.defer();
        if (!this)
            throw new Error("Use new keyword to create Admin");
        angular.extend(this, model),
        this.$promise = deferred.promise,
        model.$promise.then(function(model) {
            angular.extend(instance, model),
            instance.$promise = deferred.promise,
            deferred.resolve(instance)
        })
    }
    Admin.prototype.has_permissions = function(required_permissions) {
        var profile = this.profile
          , perm_types = Object.keys(required_permissions);
        return perm_types.every(function(type) {
            var req_perm_type = required_permissions[type];
            return required_permissions[type].test(profile[type]) && (req_perm_type !== Admin.PERM_RW || this.rw_admin)
        }
        .bind(this))
    }
    ,
    Admin.prototype.has_write_permissions = function(required_permissions) {
        var profile = this.profile
          , perm_types = Object.keys(required_permissions);
        return perm_types.every(function(type) {
            return this.rw_admin && Admin.PERM_RW.test(profile[type])
        }
        .bind(this))
    }
    ,
    Admin.prototype.in_global_vdom = function() {
        return "" === this.current_vdom
    }
    ,
    angular.extend(Admin, {
        PERM_RO: /^read/,
        PERM_RW: /^read-write$/,
        PERM_ANY: /.+/,
        PERM_NONE: /^none$/
    });
    var module = angular.module("ftnt");
    return module.service("admin", Admin),
    module.constant("Admin", Admin),
    Admin
}),
define("lang", ["angular", "fweb", "jquery", "app"], function(angular, fweb, $) {
    "use strict";
    function lang_factory($resource, $rootScope, $q, $sce) {
        function Translated(value, trusted) {
            if (!(this instanceof Translated))
                throw new Error("Please use the new keyword ","to create a new lang.Translated object");
            this.trusted = trusted,
            this.value = value
        }
        function lang(id, interpolate) {
            function is_trusted(value) {
                return value instanceof Translated && value.trusted || "number" == typeof value
            }
            var result, trusted = !0;
            return id instanceof Translated ? result = id : (result = "fgt_lang" in window ? $.getInfo(id, !0) : "",
            null  == result && (trusted = !1,
            result = id)),
            interpolate && (result = lang.format(result, interpolate),
            trusted = trusted && interpolate.every(is_trusted)),
            result = result instanceof Translated ? result : translated[result] || new Translated(result,trusted),
            translated[result.value] = result,
            result
        }
        function reset_translated() {
            translated = {}
        }
        var translated = {}
          , sceGetTrustedHtml = $sce.getTrustedHtml
          , sceValueOf = $sce.valueOf
          , decoder = document.createElement("textarea");
        $sce.valueOf = function(maybeTrusted) {
            return maybeTrusted instanceof Translated && (maybeTrusted = String(maybeTrusted),
            decoder.innerHTML = maybeTrusted,
            maybeTrusted = decoder.value),
            sceValueOf.call(this, maybeTrusted)
        }
        ,
        $sce.getTrustedHtml = function(value) {
            if (value instanceof Translated) {
                var trusted = value.trusted;
                value = String(value),
                trusted && (value = $sce.trustAsHtml(value))
            }
            return sceGetTrustedHtml.call(this, value)
        }
        ,
        Translated.prototype.toString = function() {
            return String(this.value)
        }
        ,
        Translated.prototype.valueOf = function() {
            return this.value
        }
        ;
        var getOwnPropertyNames = Object.getOwnPropertyNames || Object.keys;
        getOwnPropertyNames(String.prototype).forEach(function(fn_name) {
            var fn = String.prototype[fn_name];
            !angular.isFunction(fn) || fn_name in Translated.prototype || (Translated.prototype[fn_name] = function() {
                return fn.apply(this.value || "", arguments)
            }
            )
        }),
        $rootScope.$on("lang_updated", reset_translated),
        $rootScope.$on("$routeChangeSuccess", reset_translated),
        lang.format = function(format, params) {
            return String(format).replace(/\{(\d+)\}/g, function(m, i) {
                return String(params[i])
            })
        }
        ,
        lang.Translated = Translated;
        var langReady = $q.defer();
        if ("undefined" != typeof fgt_lang)
            langReady.resolve();
        else
            var stopListening = $rootScope.$on("lang_updated", function() {
                langReady.resolve(),
                stopListening()
            });
        return lang.resolved = function() {
            return langReady.promise
        }
        ,
        lang
    }
    var module = angular.module("ftnt");
    module.factory("lang", lang_factory),
    module.directive("fLang", function(lang, $sce) {
        return function(scope, element, attr) {
            function getStringValue() {
                return lang(attr.fLang) || ""
            }
            scope.$watch(getStringValue, function(value) {
                element.html($sce.getTrustedHtml(value))
            })
        }
    }),
    module.filter("lang", function(lang) {
        return function(input, interpolate) {
            return input = input || "",
            lang(input, interpolate)
        }
    })
}),
define("services/interceptor", ["angular", "jquery", "app"], function(angular, $) {
    "use strict";
    function factory($injector, $cookies) {
        var CCSRF = {
            HEADER_NAME: "X-CSRFTOKEN",
            COOKIE_NAME: "ccsrftoken"
        }
          , DCSRF = {
            HEADER_NAME: "X-CSRFTOKEN",
            COOKIE_NAME: "csrftoken",
            FORM_TOKEN_NAME: "csrfmiddlewaretoken"
        };
        return {
            request: function(config) {
                if (/^\/p\//.test(config.url)) {
                    var parts = config.url.split("?");
                    if (parts.length > 1 && (config.url = parts.shift(),
                    config.params = parts.join("?").split("&").reduce(function(result, param) {
                        return param = param.split("="),
                        result[param[0]] = decodeURIComponent(param[1]) || "",
                        result
                    }, config.params || {})),
                    "/" !== config.url.slice(-1) && (config.url = config.url + "/"),
                    "POST" === config.method) {
                        var django_csrf = $cookies[DCSRF.COOKIE_NAME];
                        if (angular.isDefined(django_csrf)) {
                            config.headers[DCSRF.HEADER_NAME] = django_csrf;
                            var data = config.data;
                            angular.isString(data) && -1 === data.indexOf(DCSRF.FORM_TOKEN_NAME) ? data += "&" + DCSRF.FORM_TOKEN_NAME + "=" + django_csrf : angular.isObject(data) && !data[DCSRF.FORM_TOKEN_NAME] && (data[DCSRF.FORM_TOKEN_NAME] = django_csrf,
                            data = $.param(data)),
                            config.data = data
                        }
                    }
                } else {
                    config.headers["X-Requested-With"] = "XMLHttpRequest";
                    var c_csrf = $cookies[CCSRF.COOKIE_NAME];
                    c_csrf && (c_csrf = c_csrf.replace(/(^"|"$)/g, ""),
                    config.headers[CCSRF.HEADER_NAME] = c_csrf),
                    "POST" === config.method && config.data && (null  != config.data.request && (config.data.request = angular.toJson(config.data.request)),
                    config.data = $.param(config.data))
                }
                return "POST" === config.method && (config.headers["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8"),
                config
            },
            response: function(response) {
                return "createStyleSheet" in document && /\.html$/.test(response.config.url) && $injector.invoke(fix_ie_links, null , {
                    response: response
                }),
                response
            }
        }
    }
    function fix_ie_links($compile, $rootScope, $route, response) {
        var links = response.data.match(/(<link[^>]*>)/g);
        if (links) {
            var head = document.getElementsByTagName("head")[0]
              , route_path = $route.current.$$route.originalPath;
            $("head link[data-route]").each(function(i, link) {
                link.getAttribute("data-route") !== route_path && link.parentNode.removeChild(link)
            }),
            links = links.map(function(link) {
                return link = angular.element(link)[0],
                link.className = "compile_me",
                link
            }),
            angular.element(head).append(links),
            $("head link.compile_me").each(function(i, link) {
                link.className = "",
                link.setAttribute("data-route", route_path),
                $compile(link)($rootScope)
            })
        }
    }
    angular.module("ftnt").factory("ftntInterceptor", factory)
}),
define("services/ftnt", ["angular", "fweb.util/objects", "fweb", "app"], function(angular, f_obj) {
    "use strict";
    function FtntRoute($route) {
        this.$route = $route
    }
    function FtntCopy() {}
    var module = angular.module("ftnt");
    FtntRoute.interp_expr = /([\/^]):([^\/$]+)/g,
    FtntRoute.prototype = {
        interpolate: function(path, routeParams) {
            function rp_sub(match, g1, g2) {
                return g1 + encodeURIComponent(routeParams[g2])
            }
            return path.replace(FtntRoute.interp_expr, rp_sub)
        },
        findBySegment: function(segment, withParams) {
            function pluckName(key) {
                return key.name
            }
            return withParams = withParams && f_obj.makeSet(withParams),
            Object.keys(this.$route.routes).filter(function(r) {
                var route = this.$route.routes[r];
                return route.segment === segment && (!withParams || withParams.equalToSet(route.keys.map(pluckName)))
            }
            .bind(this))[0]
        }
    },
    FtntCopy.prototype = {
        cleanCopy: function(src) {
            var storage = {}
              , dst = this.clean(src, storage);
            return this.unclean(dst, storage),
            dst
        },
        clean: function(subject, storage, recurse) {
            var i, len, result = {};
            if (Array.isArray(subject)) {
                result = subject.slice();
                for (i in subject)
                    "$" === i[0] && (storage[i] = subject[i]);
                for (i = 0,
                len = result.length; len > i; ++i)
                    recurse !== !1 && (storage[i] = {},
                    result[i] = this.clean(result[i], storage[i], !1))
            } else
                for (i in subject)
                    "$" === i[0] ? storage[i] = subject[i] : result[i] = subject[i];
            return result
        },
        unclean: function(subject, storage) {
            var i, len;
            if (Array.isArray(subject)) {
                for (i = 0,
                len = subject.length; len > i; ++i)
                    angular.extend(subject[i], storage[i]);
                for (i in storage)
                    "$" === i[0] && (subject[i] = storage[i])
            } else
                angular.extend(subject, storage)
        }
    },
    module.service({
        ftntRoute: FtntRoute,
        ftntCopy: FtntCopy
    })
}),
define("directives/head", ["angular", "services/loader"], function(angular) {
    "use strict";
    var module = angular.module("ftnt");
    module.provider("cssRouteSegment", function($injector) {
        try {
            var $routeSegmentProvider = $injector.get("$routeSegmentProvider");
            this.$get = function() {
                return {
                    $routeSegmentProvider: $routeSegmentProvider
                }
            }
        } catch (ex) {
            this.$get = function() {
                return {}
            }
        }
    }),
    module.directive("head", function($rootScope, $compile, loader, cssRouteSegment) {
        var getUrls = function(route) {
            var segments, routeSegments, segmentCSS, urls = [], result = [], set = {};
            return route && route.$$route.css ? urls = route.$$route.css : route && route.$$route.segment && (routeSegments = route.$$route.segment.split("."),
            segments = cssRouteSegment.$routeSegmentProvider.segments,
            segmentCSS = routeSegments.reduce(function(css, s) {
                var segment = segments[s]
                  , scss = segment && segment.params.css;
                return segments = segment && segment.children || {},
                css.concat(scss || [])
            }, []),
            segmentCSS.length > 0 && (urls = segmentCSS)),
            urls.forEach(function(url) {
                set[url] || (result.push(loader.cache_path(url, null , route)),
                set[url] = !0)
            }),
            result
        }
        ;
        return {
            restrict: "E",
            scope: !0,
            link: function(scope, element) {
                var html = '<link rel="stylesheet" type="text/css" ng-repeat="url in urls" ng-href="{{ url }}" />';
                element.append($compile(html)(scope)),
                $rootScope.$on("$routeChangeStart", function(event, next) {
                    scope.urls = getUrls(next)
                })
            }
        }
    })
}),
define("directives/ftnt", ["angular", "jquery", "fweb", "lang", "services/cmdb"], function(angular, $, fweb) {
    "use strict";
    function ml_create_new_callback(input, ngModel, params, scope) {
        function toString() {
            return this.name
        }
        function callback() {
            $(window).on(ns_msg, update_ml),
            fweb.dialog(fweb.iframe(params.url))
        }
        function update_ml(e) {
            var event = e.originalEvent
              , loc = window.location
              , origin = loc.origin || loc.protocol + "//" + loc.host
              , val = event.data.name
              , getter = params.getter
              , is_name_arr = params.mlist.name_array;
            if (event.origin === origin && val) {
                var mlist_cfg = field.prop("config") || {}
                  , sep = mlist_cfg.separator || ","
                  , cur_val = ngModel.$viewValue
                  , is_arr = isArray(cur_val) || is_name_arr
                  , vals = cur_val ? is_arr ? cur_val : cur_val.split(sep) : [];
                Array.isArray(vals) || (vals = [vals]),
                is_name_arr && (val = {
                    name: val,
                    toString: toString
                }),
                vals.push(val),
                field.is("input") ? field.val(vals.join(sep)) : field.val(vals),
                scope.$apply(function() {
                    ngModel.$setViewValue(vals)
                });
                var obj = angular.isFunction(getter) ? getter() : void 0;
                obj ? (obj.list.push(val),
                obj.mapping[val] = {
                    text: val
                },
                field.multiList($.extend(mlist_cfg, {
                    source: obj.list
                }))) : field.is("select") ? (field.prepend($("<option>", {
                    value: val,
                    text: val,
                    selected: !0
                })),
                field.multiList()) : isArray(mlist_cfg.source) && (mlist_cfg.source.unshift(val),
                field.multiList())
            }
            $(window).off(ns_msg)
        }
        var field = $(input)
          , ns_msg = "message." + field.attr("id");
        return callback
    }
    var isArray = angular.isArray
      , DIRECTIVE_MESSAGES = {
        required: "err_required",
        f_is_unique: -15,
        f_password_policy: -49,
        f_ipv4_address: "err_ip4",
        f_ipmask: "err_netmask",
        f_subnet_list: "err_subnet_list",
        f_combined_field: "err_ip_range",
        f_min_length: "err_min_str_length",
        f_max_length: "err_max_str_length",
        max: "err_max_value",
        min: "err_min_value",
        email: "Invalid Email",
        f_value_confirm: "Doesn't Match"
    }
      , ng_parse_params = function(validation_type, attr, scope) {
        var supported = {
            f_min_length: "fMinLength",
            f_max_length: "fMaxLength",
            max: "max",
            min: "min"
        }
          , directive = supported[validation_type];
        if (angular.isUndefined(directive))
            return [];
        var directive_val = scope.$eval(attr[directive]);
        if (angular.isUndefined(directive_val))
            return [];
        var num = parseInt(directive_val, 10);
        return angular.isNumber(num) ? [num] : []
    }
      , is_subnet0 = function(ip) {
        return 0 === ip.indexOf("0")
    }
      , module = angular.module("ftnt");
    module.directive("fValidationMessage", function(lang, $timeout) {
        var DEBOUNCE_INTERVAL = 250;
        return {
            restrict: "A",
            require: ["?ngModel", "?fValidationLink"],
            compile: function() {
                function find_elem(elem, outside) {
                    var result;
                    return outside ? (elem = elem.parent(),
                    elem.length && (result = find_elem(elem),
                    result.length || (result = find_elem(elem, !0)))) : (result = $(elem).next(".validation-msg"),
                    result.length || (result = $(elem).siblings(".validation-msg"))),
                    result
                }
                return function(scope, elem, attr, ctrls) {
                    function debounceRefresh(value) {
                        function showLast(a, b) {
                            var u = "validation-msg_show";
                            return (a === u ? 1 : 0) + (b === u ? -1 : 0)
                        }
                        value && !refreshing[value.name] && (refreshing[value.name] = value,
                        timeout = timeout || $timeout(function() {
                            Object.keys(refreshing).sort(showLast).forEach(function(k) {
                                refreshMsg(refreshing[k])
                            }),
                            timeout = null ,
                            refreshing = {}
                        }, DEBOUNCE_INTERVAL))
                    }
                    function refreshMsg(value) {
                        var force = !elem.is("input,select,textarea");
                        if (value && "validation-msg_show" === value.name) {
                            if (void 0 !== ngModel.$viewValue)
                                try {
                                    ngModel.$setViewValue(ngModel.$viewValue)
                                } catch (ex) {}
                            force = !0
                        }
                        var link = fValidationLink && fValidationLink.other()
                          , linkShow = link && link.$dirty && link.$invalid
                          , show = ngModel.$dirty && ngModel.$invalid && (blurred || force);
                        if (show && ngModel.$error) {
                            var msgs = [];
                            angular.forEach(ngModel.$error, function(val, key) {
                                if (val) {
                                    var priority = "required" === key
                                      , lang_err = scope.$eval(attr.fValidationMessage);
                                    if (angular.isObject(lang_err) && (lang_err = lang_err[key]),
                                    lang_err || (lang_err = DIRECTIVE_MESSAGES[key]),
                                    lang_err) {
                                        var fmt_params = ng_parse_params(key, attr, scope);
                                        lang_err = lang(lang_err),
                                        lang_err = fmt_params.length ? lang.format(lang_err, fmt_params) : lang_err,
                                        msgs[priority ? "unshift" : "push"](lang_err)
                                    }
                                }
                            }),
                            msg.text(msgs.length > 0 ? msgs[0] : ""),
                            msg.css("display", msgs.length > 0 ? "" : "none")
                        } else
                            linkShow || msg.css("display", "none")
                    }
                    var ngModel = ctrls.shift()
                      , fValidationLink = ctrls.shift()
                      , blurred = !1
                      , outside = "fValidationOutside" in attr
                      , msg = find_elem(elem, outside);
                    if (outside || msg && msg.length || (msg = angular.element("<label>").addClass("validation-msg error").css("display", "none"),
                    elem.after(msg)),
                    !msg || !msg.length)
                        throw new Error("Unable to find validation-msgoutside: " + outside);
                    var timeout, refreshing = {};
                    ngModel && (elem.on("blur", function() {
                        blurred = !0,
                        refreshMsg()
                    }),
                    scope.$watch(function() {
                        return scope.$eval(attr.fValidationMessage)
                    }, refreshMsg, !0),
                    scope.$watch(function() {
                        return ngModel.$error
                    }, refreshMsg, !0),
                    scope.$on("validation-msg_show", debounceRefresh),
                    scope.$on("validation-msg_update", debounceRefresh))
                }
            }
        }
    }).directive("fValidationLink", function() {
        var recursing = !1;
        return {
            require: ["ngModel", "^form", "fValidationLink"],
            priority: -1e3,
            controller: function() {},
            link: function(scope, elem, attr, ctrls) {
                function parse(value) {
                    var other = ctrl.other();
                    if (!recursing) {
                        recursing = !0;
                        try {
                            var vv = other.$viewValue;
                            other.$setViewValue(null ),
                            other.$setViewValue(vv)
                        } catch (ie8) {} finally {
                            recursing = !1
                        }
                    }
                    return value
                }
                var ngModel = ctrls.shift()
                  , ngForm = ctrls.shift()
                  , ctrl = ctrls.shift();
                ngModel.$parsers.push(parse),
                ctrl.other = function() {
                    return ngForm[attr.fValidationLink]
                }
            }
        }
    }).directive("fValidationWatch", function() {
        return {
            require: "ngModel",
            link: function(scope, elem, attr, ngModel) {
                var remove_if = angular.noop
                  , remove_watch = angular.noop;
                attr.$observe("fValidationWatch", function(value) {
                    function watch(enabled) {
                        remove_watch(),
                        enabled && (remove_watch = scope.$watch(watch_expr, do_watch))
                    }
                    function do_watch(v, oldV) {
                        if (v !== oldV) {
                            var vv = ngModel.$viewValue;
                            ngModel.$setViewValue(null ),
                            ngModel.$setViewValue(vv)
                        }
                    }
                    remove_if();
                    var expressions = value.split(/\s+if\s+/)
                      , watch_expr = expressions.shift()
                      , if_expr = expressions.shift();
                    if_expr ? remove_if = scope.$watch(if_expr, watch) : (watch(!0),
                    remove_if = angular.noop)
                })
            }
        }
    }),
    module.directive("fMultiList", function(FOSError) {
        function pluck_name(value) {
            return value && value.name
        }
        function name_obj(name) {
            return {
                name: name
            }
        }
        return {
            priority: -10,
            restrict: "A",
            template: "<div><input></div>",
            replace: !0,
            require: ["ngModel", "?input", "?select"],
            link: function(scope, elem, attr, ctrls) {
                function init_multilist(params) {
                    var mlist_cfg = params.mlist || {}
                      , create_new_cfg = mlist_cfg.create || {}
                      , create_new_enabled = create_new_cfg.enable
                      , url = params.url
                      , sep = mlist_cfg.separator || ","
                      , vals = ngModel.$viewValue
                      , is_name_arr = mlist_cfg.name_array || !1;
                    if (Array.isArray(vals) || (vals = [vals]),
                    create_new_enabled && !create_new_cfg.callback && url) {
                        var cb = ml_create_new_callback(input, ngModel, params, scope);
                        create_new_cfg.callback = cb
                    }
                    is_name_arr && (vals = vals.map(pluck_name)),
                    input.value = vals.join(sep),
                    $(input).multiList(mlist_cfg).on("change", function() {
                        var model_val, field = $(this), val = field.val(), is_arr = isArray(val), vals = val ? is_arr ? val : val.split(sep) : [];
                        model_val = is_name_arr ? vals.map(name_obj) : vals,
                        scope.$apply(function() {
                            ngModel.$setViewValue(model_val)
                        })
                    })
                }
                function update_multilist(params) {
                    var resource = params.resource;
                    if (resource) {
                        var src = [];
                        angular.forEach(resource, function(res) {
                            src.push(res.name)
                        }),
                        params.mlist.source = src,
                        init_multilist(params)
                    } else
                        init_multilist(params)
                }
                function parser(value) {
                    var mlist_cfg = $(input).prop("config") || {}
                      , single = "single" === mlist_cfg.selector_type;
                    return single && (value = value[value.length - 1]),
                    value
                }
                var ngModel = ctrls.shift();
                if (ctrls.some(function(ctrl) {
                    return ctrl
                }))
                    throw new FOSError("f-multi-list directive cannotbe added to <input> or <select> elements");
                var input = elem[0].firstChild;
                elem.addClass("f-multi-list"),
                ngModel.$render = function(params) {
                    params = params || scope.$eval(attr.fMultiList),
                    input.value = ngModel.$viewValue,
                    params && update_multilist(params)
                }
                ,
                scope.$watch(attr.fMultiList, ngModel.$render, !0),
                ngModel.$isEmpty = function(value) {
                    return !value || Array.isArray(value) && !value.length;
                }
                ,
                scope.$on("refresh_multilist", function() {
                    var params = scope.$eval(attr.fMultiList)
                      , qelem = $(input)
                      , old_val = qelem.val();
                    isArray(old_val) ? qelem.val([]) : qelem.val(""),
                    update_multilist(params)
                }),
                ngModel.$parsers.push(parser)
            }
        }
    }).directive("fIsUnique", function($q, CMDB) {
        return {
            restrict: "A",
            require: "ngModel",
            scope: "=ngModel",
            link: function(scope, elem, attr, ngModel) {
                var names = {};
                scope.$watch(attr.fIsUnique, function(newVal, oldVal, cScope) {
                    if (newVal) {
                        var paths = newVal
                          , cmdbs = []
                          , expressions = [];
                        isArray(paths) || (paths = [paths]),
                        angular.forEach(paths, function(config) {
                            if ("string" == typeof config)
                                expressions.push(config);
                            else {
                                if (!config.path || !config.name)
                                    return;
                                var defaults = {
                                    format: {
                                        name: "%name"
                                    },
                                    model: !1
                                };
                                config = angular.extend(defaults, config),
                                cmdbs.push(new CMDB(config))
                            }
                        });
                        var union = new CMDB.Union(cmdbs).fetch();
                        union.$promise.then(function(res) {
                            angular.forEach(res, function(obj) {
                                names[obj.name] = 1
                            });
                            var check_unique = function(value) {
                                function check_expr(expr) {
                                    return cScope.$eval(expr, {
                                        $value: value
                                    })
                                }
                                var valid = !names[value] || expressions.some(check_expr);
                                return ngModel.$setValidity("f_is_unique", valid),
                                valid ? value : void 0
                            }
                            ;
                            ngModel.$parsers.push(check_unique),
                            ngModel.$formatters.push(check_unique)
                        })
                    }
                }, !0)
            }
        }
    }).directive("fPasswordPolicy", function($resource, $http, $timeout) {
        return {
            restrict: "A",
            require: "ngModel",
            scope: "=ngModel",
            link: function(scope, elem, attr, ngModel) {
                function setup_validator(apply_to) {
                    function passwordPolicyValidator(password) {
                        function check() {
                            var data = {
                                apply_to: apply_to,
                                password: password
                            };
                            $http({
                                method: "POST",
                                url: url,
                                data: data
                            }).then(function(res) {
                                res && res.data && "invalid" === res.data.status && (valid = !1),
                                ngModel.$setValidity("f_password_policy", valid)
                            })
                        }
                        var valid = !0
                          , skip_check = Object.keys(ngModel.$error).some(function(name) {
                            return "f_password_policy" !== name && ngModel.$error[name]
                        })
                          , wait = 0;
                        return last_timeout && (wait = DEBOUNCE,
                        $timeout.cancel(last_timeout),
                        last_timeout = null ),
                        skip_check || (last_timeout = $timeout(check, wait)),
                        password
                    }
                    ngModel.$parsers.push(passwordPolicyValidator),
                    ngModel.$formatters.push(passwordPolicyValidator)
                }
                var last_timeout, accepted = ["ipsec", "admin"], url = "/p/system/password_policy_conform/", DEBOUNCE = 1e3;
                scope.$watch(attr.fPasswordPolicy, function(newVal) {
                    if (ngModel) {
                        if (newVal === !1)
                            return void ngModel.$setValidity("f_password_policy", !0);
                        var apply_to;
                        apply_to = angular.isUndefined(newVal) || -1 === accepted.indexOf(newVal) ? "admin" : newVal,
                        setup_validator(apply_to)
                    }
                }, !0)
            }
        }
    }).directive("fMinLength", function() {
        return {
            restrict: "A",
            require: "ngModel",
            scope: "=ngModel",
            link: function(scope, elem, attr, ngModel) {
                function minValidator(value) {
                    var min = parseInt(scope.$eval(attr.fMinLength), 10)
                      , valid = !(angular.isNumber(min) && !ngModel.$isEmpty(value) && value.length < min)
                      , changed = valid !== ngModel.$valid;
                    return ngModel.$setValidity("f_min_length", valid),
                    (changed || !valid) && scope.$broadcast("validation-msg_update"),
                    value
                }
                if (ngModel) {
                    ngModel.$parsers.push(minValidator),
                    ngModel.$formatters.push(minValidator);
                    var remove = angular.noop;
                    attr.$observe("fMinLength", function(value) {
                        remove(),
                        remove = scope.$watch(value, function(newValue, oldValue) {
                            newValue !== oldValue && minValidator(ngModel.$viewValue)
                        })
                    })
                }
            }
        }
    }).directive("fMaxLength", function() {
        return {
            restrict: "A",
            require: "ngModel",
            scope: "=ngModel",
            link: function(scope, elem, attr, ngModel) {
                function maxValidator(value) {
                    var max = parseInt(scope.$eval(attr.fMaxLength), 10)
                      , valid = !(angular.isNumber(max) && !ngModel.$isEmpty(value) && value.length > max)
                      , changed = valid !== ngModel.$valid;
                    return ngModel.$setValidity("f_max_length", valid),
                    (changed || !valid) && scope.$broadcast("validation-msg_update"),
                    value
                }
                if (ngModel) {
                    ngModel.$parsers.push(maxValidator),
                    ngModel.$formatters.push(maxValidator);
                    var remove = angular.noop;
                    attr.$observe("fMaxLength", function(value) {
                        remove(),
                        remove = scope.$watch(value, function(newValue, oldValue) {
                            newValue !== oldValue && maxValidator(ngModel.$viewValue)
                        })
                    })
                }
            }
        }
    }).directive("fArrayRequired", function() {
        return {
            restrict: "A",
            require: "ngModel",
            scope: "=ngModel",
            link: function(scope, elem, attr, ngModel) {
                return ngModel ? scope.$watch(function() {
                    var cond = attr.fArrayRequired || "true";
                    return scope.$eval(cond) ? ngModel.$modelValue : void 0
                }, function(value) {
                    if (angular.isUndefined(value))
                        ngModel.$setValidity("required", !0);
                    else {
                        var invalid = !value || !value.length;
                        ngModel.$setValidity("required", !invalid)
                    }
                }) : void 0
            }
        }
    }).directive("fIpmask", function() {
        return {
            restrict: "A",
            require: "ngModel",
            scope: "=ngModel",
            link: function(scope, elem, attr, ngModel) {
                return scope.$watch(function() {
                    var cond = attr.fIpmask || "true";
                    return scope.$eval(cond) ? ngModel.$modelValue : void 0
                }, function(value) {
                    if (angular.isUndefined(value))
                        ngModel.$setValidity("f_ipmask", !0);
                    else {
                        var valid = fweb.util.commonRegExp.IP_MASK.test(value);
                        ngModel.$setValidity("f_ipmask", valid)
                    }
                })
            }
        }
    }).directive("fIpv4Address", function() {
        return {
            restrict: "A",
            require: "ngModel",
            scope: "=ngModel",
            link: function(scope, elem, attr, ngModel) {
                return scope.$watch(function() {
                    var cond = attr.fIpv4Address || "true";
                    return scope.$eval(cond) ? ngModel.$modelValue : void 0
                }, function(value) {
                    if (angular.isUndefined(value))
                        ngModel.$setValidity("f_ipv4_address", !0);
                    else {
                        var valid = fweb.util.commonRegExp.IP_HOST.test(value);
                        valid = valid && !is_subnet0(value),
                        ngModel.$setValidity("f_ipv4_address", valid)
                    }
                })
            }
        }
    }).directive("fCombinedField", function($parse, FOSError) {
        return {
            restrict: "A",
            require: "ngModel",
            scope: "=ngModel",
            link: function(scope, elem, attr, ngModel) {
                function get_params(value) {
                    var result = value || scope.$eval(attr.fCombinedField);
                    return result && {
                        fields: result[0],
                        parsed: result[0].map(function(field) {
                            return $parse(field)
                        }),
                        type: result[1] || "",
                        separator: result[2] || "-"
                    }
                }
                function part_test(type) {
                    return function(part) {
                        if (type instanceof RegExp)
                            return type.test(part);
                        if (angular.isFunction(type))
                            return type(part);
                        if ("address_range" === type)
                            return fweb.util.commonRegExp.IP_HOST.test(part) && !is_subnet0(part);
                        if (type)
                            throw new FOSError("Unable to test f-combined-field type " + type);
                        return !0
                    }
                }
                function parse(text) {
                    var params = get_params();
                    if (!params)
                        return text;
                    var parts = (text || "").split(params.separator)
                      , valid = !params.type;
                    if (parts.length === params.fields.length) {
                        var pt = part_test(params.type);
                        valid = parts.every(pt),
                        valid && parts.forEach(function(part, i) {
                            params.parsed[i].assign(scope, part)
                        })
                    }
                    return ngModel.$setValidity("f_combined_field", valid),
                    valid ? text : void 0
                }
                function format(text) {
                    var params = get_params();
                    if (!params)
                        return text;
                    var fields = params.parsed.map(function(parsed) {
                        return parsed(scope)
                    });
                    params.type && (fields = fields.map(function(field) {
                        return field || "0.0.0.0"
                    }));
                    var valid = !params.type;
                    if (2 === fields.length && params.fields.length) {
                        var ft = part_test(params.type);
                        valid = fields.every(ft)
                    }
                    return ngModel.$setValidity("f_combined_field", valid),
                    fields.join(params.separator)
                }
                var remove = angular.noop;
                scope.$watch(attr.fCombinedField, function(newVal, oldVal) {
                    if (newVal === oldVal && (ngModel.$parsers.push(parse),
                    ngModel.$formatters.push(format)),
                    !newVal)
                        return void ngModel.$setValidity("f_combined_field", !0);
                    oldVal || format(ngModel.$modelValue),
                    remove();
                    var params = get_params(newVal);
                    params && (remove = scope.$watch("[" + params.fields.join(",") + "]", function(values) {
                        var value = values.join(params.separator)
                          , ngModel = $parse(attr.ngModel);
                        angular.toJson(value) !== angular.toJson(ngModel(scope)) && ngModel.assign(scope, value)
                    }, !0))
                }, !0)
            }
        }
    }).directive("fWith", function() {
        return {
            scope: !0,
            link: function(scope, elem, attr) {
                var exprs = attr.fWith.split(/\s*;\s*/).map(function(expr) {
                    return expr.split(/\s+as\s+/)
                });
                if (exprs.some(function(expr) {
                    return 2 !== expr.length
                }))
                    throw new Error('f-with directive requires an expression like "_expression_ as _alias_[;_expression_ as _alias_;...]"');
                exprs.forEach(function(expr) {
                    scope.$watch(expr[0], function(value) {
                        scope[expr[1]] = value
                    }, !0)
                })
            }
        }
    }).directive("fTextarea", function() {
        return {
            scope: !1,
            link: function(scope, elem) {
                elem.addClass("f-textarea"),
                $(elem).textarea(),
                scope.$on("textarea_reset", function() {
                    scope.$$postDigest(function() {
                        var $elem = $(elem);
                        $elem.height(0),
                        $elem.textarea()
                    })
                })
            }
        }
    }).directive("fSubnetList", function(lang, CMDB) {
        return {
            require: "ngModel",
            compile: function(elem) {
                elem.addClass("with_help_icon");
                var help_icon = angular.element("<span>").addClass("a_sprite").addClass("tool_help").addClass("within_input").attr("title", lang("help_subnet_list"));
                return elem.after(help_icon),
                function(scope, element, attr, ctrl) {
                    var cfg = scope.$eval(attr.fSubnetList) || {}
                      , cfg_sep = cfg.sep
                      , match = /\/(.*)\//.exec(cfg_sep)
                      , separator = match && new RegExp(match[1]) || cfg_sep || ","
                      , detect_conflict = cfg.detect_conflict
                      , parse = function(viewValue) {
                        var SUBNET = fweb.util.commonRegExp.SUBNET;
                        if (!angular.isUndefined(viewValue)) {
                            var list = []
                              , valid = !0
                              , subnets = []
                              , conflict = "f_subnet_list_conflict";
                            if (viewValue && (subnets = viewValue.split(separator),
                            angular.forEach(subnets, function(value) {
                                if (value) {
                                    var trimmed = $.trim(value);
                                    list.push(trimmed),
                                    SUBNET.test(trimmed) || (valid = !1)
                                }
                            })),
                            ctrl.$setValidity(conflict, !0),
                            valid && subnets.length > 0 && detect_conflict) {
                                var prefs = {
                                    format: {
                                        name: "%name",
                                        ip: "%ip",
                                        secip: "%secondaryip"
                                    }
                                }
                                  , intf_schema = new CMDB("system","interface",prefs).schema();
                                intf_schema.$promise.then(function(s) {
                                    s.$is_subnet_conflicting(subnets).then(function() {
                                        ctrl.$setValidity(conflict, !1)
                                    })
                                })
                            }
                            return ctrl.$setValidity("f_subnet_list", valid),
                            list
                        }
                    }
                    ;
                    return ctrl.$parsers.push(parse),
                    ctrl.$formatters.push(function(value) {
                        return angular.isArray(value) ? value.join(", ") : void 0
                    }),
                    scope.$watch(attr.ngRequired, function(newVal) {
                        newVal ? parse(ctrl.$viewValue) : ctrl.$setValidity("f_subnet_list", !0)
                    })
                }
            }
        }
    }).directive("fScrolling", function($window, $document, $rootScope, $timeout) {
        function scrolling() {
            var doc = $document[0];
            return $window.innerHeight ? doc.body.offsetHeight > $window.innerHeight : doc.documentElement.scrollHeight > doc.documentElement.offsetHeight || doc.body.scrollHeight > doc.body.offsetHeight
        }
        return {
            scope: !1,
            link: function(scope, elem) {
                function update() {
                    return $timeout.cancel(timeout),
                    timeout = $timeout(function() {
                        elem.toggleClass("f-scrolling", scrolling())
                    }, DEBOUNCE_INTERVAL, !1),
                    !0
                }
                var timeout, DEBOUNCE_INTERVAL = 100;
                angular.element($window).bind("resize", update),
                $rootScope.$watch(update)
            }
        }
    }).directive("fPattern", function() {
        return {
            scope: !1,
            require: "ngModel",
            link: function(scope, elem, attr, ngModel) {
                function fPatternValidator(value) {
                    var pattern = scope.$eval(attr.fPattern);
                    return !pattern || ngModel.$isEmpty(value) || pattern.test(value) ? ngModel.$setValidity("f_pattern", !0) : (ngModel.$setValidity("f_pattern", !1),
                    value = void 0),
                    value
                }
                scope.$watch(attr.fPattern, function() {
                    fPatternValidator(ngModel.$viewValue)
                }),
                ngModel.$formatters.push(fPatternValidator),
                ngModel.$parsers.push(fPatternValidator)
            }
        }
    }).directive("fValueConfirm", function() {
        return {
            scope: {
                value: "=fValueConfirm"
            },
            require: "ngModel",
            link: function(scope, elem, attr, ngModel) {
                var validator = function(value) {
                    return value === scope.value ? ngModel.$setValidity("f_value_confirm", !0) : (ngModel.$setValidity("f_value_confirm", !1),
                    value = void 0),
                    value
                }
                ;
                scope.$watch("value", function() {
                    validator(ngModel.$viewValue)
                }),
                ngModel.$formatters.push(validator),
                ngModel.$parsers.push(validator)
            }
        }
    }).directive("fLabelHighlight", function() {
        return function(scope, elem, attrs) {
            var label = elem.closest("div.field").find('label[for="' + attrs.id + '"]');
            elem.on("focus", function() {
                label.css("font-weight", "bold")
            }).on("blur", function() {
                label.css("font-weight", "")
            })
        }
    }).directive("fUiRefresh", function($timeout, uiJqConfig) {
        return {
            scope: !1,
            compile: function(tElem, tAttrs) {
                var options = uiJqConfig && uiJqConfig[tAttrs.uiJq];
                return function(scope, elem, attr) {
                    scope.$watch(attr.fUiRefresh, function() {
                        $timeout(function() {
                            elem.is(":ui-" + attr.uiJq) && elem[attr.uiJq]("destroy");
                            var linkOptions = scope.$eval(attr.uiOptions);
                            linkOptions = angular.extend({}, options, linkOptions),
                            elem[attr.uiJq](linkOptions)
                        })
                    })
                }
            }
        }
    }).directive("fTip", function($window) {
        return {
            template: '<div class="f-tip" ng-transclude></div>',
            transclude: !0,
            scope: {
                show: "&fTip",
                options: "&",
                position: "&",
                reposition: "&",
                promise: "&"
            },
            require: "?^fTipTarget",
            link: function($scope, $element, $attrs, fTipTarget, $transclude) {
                function init_tip(show) {
                    return show && (show = angular.extend(options.show || {}, {
                        ready: !0
                    })),
                    $element.qtip(angular.extend({
                        content: {
                            text: ""
                        }
                    }, options, show || {})),
                    $element.qtip("api")
                }
                var options = angular.copy($scope.options() || {})
                  , position = $scope.position();
                position ? options.position = position : options.position || (options.position = {
                    my: "bottom left",
                    at: "top right",
                    target: "mouse",
                    viewport: $($window),
                    adjust: {
                        x: 10
                    }
                }),
                fTipTarget && (options.positions = angular.extend({
                    target: fTipTarget.elem
                }, options.positions),
                options.show = angular.extend({
                    target: fTipTarget.elem
                }, options.show),
                options.hide = angular.extend({
                    target: fTipTarget.elem
                }, options.hide)),
                options.hide && "string" == typeof options.hide.target && (options.hide.target = $(options.hide.target)),
                options.position && "window" === options.position.viewport && (options.position.viewport = $($window)),
                options.position && angular.isFunction(options.position.container) && (options.position.container = options.position.container());
                var tip = init_tip();
                $element.children().addClass("f-tip-hide"),
                $transclude(function(clone) {
                    function get_text() {
                        var promise = $scope.promise();
                        if (promise) {
                            var deferred = $.Deferred();
                            return promise.then(function() {
                                $scope.$evalAsync(function() {
                                    deferred.resolve(clone),
                                    tip.reposition(null , !1)
                                })
                            }),
                            deferred.promise()
                        }
                        return clone
                    }
                    clone.is("*") && (tip.set("content.text", $scope.promise() ? get_text : clone),
                    options.content = {
                        text: get_text
                    },
                    $scope.$watch("show()", function(show) {
                        $scope.$evalAsync(function() {
                            tip.toggle(show)
                        })
                    }),
                    $scope.$watch("reposition()", $scope.$evalAsync.bind($scope, function() {
                        tip.reposition()
                    })),
                    $scope.$watch("promise()", function(p, oldp) {
                        (p !== oldp || oldp) && tip.set("content.text", p ? get_text : clone)
                    }))
                }),
                $scope.$on("$destroy", function() {
                    tip.destroy()
                }),
                $scope.$on("qtip_hide", function() {
                    tip.hide()
                })
            }
        }
    }).directive("fTipTarget", function() {
        return {
            controller: function($scope, $element) {
                this.elem = $element,
                $scope.$on("$destroy", function() {
                    this.elem = null 
                }
                .bind(this))
            }
        }
    }).directive("fIncludeCloak", function() {
        return {
            link: function(scope, element) {
                function cloak() {
                    element.toggleClass("f-include-cloak", loadingCount > 0)
                }
                var loadingCount = 0;
                scope.$on("$includeContentRequested", function() {
                    ++loadingCount,
                    cloak()
                }),
                scope.$on("$includeContentLoaded", function() {
                    loadingCount > 0 && (--loadingCount,
                    cloak())
                })
            }
        }
    })
}),
define("filters/ftnt", ["angular", "fweb_extra", "app"], function(angular, fweb_extra) {
    "use strict";
    function password() {
        return function(value) {
            return (value || "").replace(/./g, "•")
        }
    }
    function bytes($filter) {
        var units = ["bytes", "KB", "MB", "GB", "TB", "PB"]
          , units_max = units.length - 1
          , numberFilter = $filter("number");
        return function(text, fractionSize) {
            fractionSize = void 0 === fractionSize ? 2 : fractionSize;
            var number = +text;
            isNaN(number) && (number = 0);
            for (var i = 0; units_max > i; i++) {
                if (1024 > number)
                    return numberFilter(number, fractionSize) + " " + units[i];
                number /= 1024
            }
            return numberFilter(number, fractionSize) + " " + units[units_max]
        }
    }
    function toCase($filter) {
        function titleCase(value) {
            return String(value).toLowerCase().replace(/(?:^|\s)(\w)/g, doCase.upper)
        }
        function sentenceCase(value) {
            return String(value).toLowerCase().replace(/(?:^|\.\s+)(\w)/g, doCase.upper)
        }
        var doCase = {
            upper: $filter("uppercase"),
            lower: $filter("lowercase"),
            title: titleCase,
            sentence: sentenceCase
        };
        return function(value, fmt) {
            if (fmt in doCase)
                return doCase[fmt](value);
            throw new Error("Unable to format using " + fmt + "-case")
        }
    }
    function deviceSprite() {
        return function(type) {
            return fweb_extra.byod_common.gen_fw_device_class(type)
        }
    }
    function elapsedTime(lang) {
        var SECOND = 1e3
          , MINUTE = 60 * SECOND
          , HOUR = 60 * MINUTE
          , DAY = 24 * HOUR
          , PERIODS = [DAY, HOUR, MINUTE, SECOND]
          , PERIOD_MAX_INDICES = ["day", "hour", "minute", "second"]
          , LANG_KEY_MAP = {};
        return LANG_KEY_MAP[DAY] = "fmt_elapsed_time_days",
        LANG_KEY_MAP[HOUR] = "fmt_elapsed_time_hours",
        LANG_KEY_MAP[MINUTE] = "fmt_elapsed_time_minutes",
        LANG_KEY_MAP[SECOND] = "fmt_elapsed_time_seconds",
        function(milliseconds, format, max) {
            var result, lang_key, list = [], is_short = "short" === format, value_added = !1, add_period = function(period) {
                var count = Math.floor(milliseconds / period)
                  , value = count;
                is_short && (value = "",
                10 > count && (value += "0"),
                value += count),
                (count || value_added) && (list.push(value),
                milliseconds -= period * count,
                lang_key = lang_key || LANG_KEY_MAP[period],
                value_added = !0)
            }
            ;
            return "number" == typeof milliseconds && isFinite(milliseconds) && (PERIODS.slice(PERIOD_MAX_INDICES.indexOf(max || "day")).forEach(add_period),
            result = is_short ? list.join(":") : lang(lang_key, list)),
            result
        }
    }
    function keys() {
        return function(obj) {
            return Object.keys(obj || {})
        }
    }
    angular.module("ftnt").filter({
        password: password,
        bytes: bytes,
        "case": toCase,
        devicesprite: deviceSprite,
        elapsedTime: elapsedTime,
        keys: keys
    })
}),
define("services/persistent_storage", ["angular", "services/cmdb"], function(angular) {
    "use strict";
    var ftnt = angular.module("ftnt");
    ftnt.factory("persistentStorage", function($cookies, $window) {
        var have_localStorage = "localStorage" in $window && null  !== $window.localStorage;
        return {
            get: function(key) {
                var value;
                return have_localStorage ? value = localStorage.getItem(key) : (value = $cookies[key],
                value && (value = JSON.parse(value))),
                value ? angular.fromJson(value) : value
            },
            put: function(key, value) {
                if (value = angular.toJson(value),
                have_localStorage)
                    try {
                        return void localStorage.setItem(key, value)
                    } catch (ex) {
                        have_localStorage = !1
                    }
                $cookies[key] = JSON.stringify(value)
            },
            remove: function(key) {
                have_localStorage ? localStorage.removeItem(key) : delete $cookies[key]
            }
        }
    })
}),
define("app", ["angular", "jquery", "fweb", "services/admin", "lang", "services/loader", "services/cmdb", "services/interceptor", "services/injector", "services/ftnt", "directives/head", "directives/ftnt", "filters/ftnt", "services/persistent_storage"], function(angular, $, fweb) {
    "use strict";
    var BASE_TEMPLATE = "base.html"
      , BASE_DIALOG_TEMPLATE = "base_dialog.html"
      , BASE_CSS = ["/style.css", "/css/notify.css", "/ng/ngstyle.css"]
      , BASE_DIALOG_CSS = BASE_CSS.concat(["/css/dlg.css"])
      , app = angular.module("app", ["ngRoute", "ngSanitize", "ngCookies", "ui.jq", "ui.event", "ui.mask", "route-segment", "view-segment", "ftnt", "ui.validate"]);
    return app.config(function($routeProvider, $httpProvider, loaderProvider, Admin) {
        $httpProvider.interceptors.push("ftntInterceptor"),
        $routeProvider.when("/vpn/wizard", {
            templateUrl: loaderProvider.base_path(BASE_DIALOG_TEMPLATE),
            css: BASE_DIALOG_CSS.concat(["/css/qed_list_all.css", "/css/firewall.css", "main.css"]),
            controller: "Wizard",
            resolve: loaderProvider.resolve(["/directives/wizard", "/directives/subform", "/controllers/wizard", "services", "controllers"], {
                vpngrp: Admin.PERM_RW
            })
        }).when("/vpn/edit/?:mkey*?", {
            path: "/vpn/edit",
            templateUrl: loaderProvider.base_path(BASE_DIALOG_TEMPLATE),
            css: BASE_DIALOG_CSS.concat(["/css/qed_list_all.css", "/css/firewall.css", "/css/jquery.multilist.css", "main.css"]),
            controller: "VPNEdit",
            resolve: loaderProvider.resolve(["/directives/subform", "/directives/list_edit", "/directives/virtual_scroll", "/vpn/wizard/services", "controllers"], {
                vpngrp: Admin.PERM_RO
            })
        }).when("/vpn/template/:mkey*/?", {
            path: "/vpn/template",
            templateUrl: loaderProvider.base_path(BASE_DIALOG_TEMPLATE),
            css: BASE_DIALOG_CSS.concat(["/css/qed_list_all.css", "/css/firewall.css"]),
            controller: "VPNTemplate",
            resolve: loaderProvider.resolve(["controllers"], {
                vpngrp: Admin.PERM_RO
            })
        }).when("/vpn/wizard/instruction/:type", {
            templateUrl: loaderProvider.base_path(BASE_TEMPLATE),
            css: BASE_DIALOG_CSS.concat(["/css/qed_list_all.css", "/css/firewall.css", "main.css"]),
            controller: "VPNWizardInstruction",
            resolve: loaderProvider.resolve(["controllers"], {
                vpngrp: Admin.PERM_RO
            })
        }).when("/widget/sysres", {
            templateUrl: loaderProvider.base_path(BASE_TEMPLATE),
            css: BASE_CSS.concat(["/css/widget_sprite.css", "/module_css/system/system_resource.css", "main.css"]),
            controller: "SystemResourceController",
            resolve: loaderProvider.resolve(["/services/monitor", "/services/dashboard_module", "/widget/sysres/directives", "/widget/sysres/controllers", "/widget/directives"], {
                system: Admin.PERM_RO
            })
        }).when("/widget/license_info", {
            templateUrl: loaderProvider.base_path(BASE_TEMPLATE),
            controller: "LicenseInfoController",
            css: BASE_CSS.concat(["/css/widget_sprite.css", "/css/jquery.ui.css", "main.css"]),
            resolve: loaderProvider.resolve(["/directives/jquery_plugins", "/services/dialog", "/widget/directives", "controllers", "directives", "services"], {
                system: Admin.PERM_RO
            })
        }).when("/widget/registration", {
            template: "",
            controller: "LegacyRegistrationController",
            resolve: loaderProvider.resolve(["/services/dialog", "/widget/license_info/controllers", "/widget/license_info/services"], {
                system: Admin.PERM_RO
            })
        }).when("/system/firmware", {
            templateUrl: loaderProvider.base_path(BASE_DIALOG_TEMPLATE),
            controller: "FirmwareController",
            css: BASE_DIALOG_CSS.concat(["/css/firewall.css", "/css/widget_sprite.css", "/css/jquery.ui.css", "main.css"]),
            resolve: loaderProvider.resolve(["/directives/jquery_plugins", "/services/reboot", "controllers", "directives", "services"], {
                system: Admin.PERM_RO
            })
        })
    }).run(function($rootScope, $location, loader, FOSError, CMDB, $window, $timeout) {
        function select_first() {
            $timeout(function() {
                return $("input, select").filter(":visible").not(".ui-helper-hidden-accessible").first().focus().length > 0
            })
        }
        app.model = CMDB.model.bind(CMDB);
        var remove_include_loaded = angular.noop;
        $rootScope.$on("$routeChangeSuccess", function(event, next) {
            null  != next && next.locals.authorized === !1 && loader.error_redirect(FOSError.NO_PERMISSIONS),
            $window.top.postMessage("route_changed", $window.location.origin),
            remove_include_loaded = $rootScope.$on("$includeContentLoaded", function() {
                select_first() && remove_include_loaded()
            })
        }),
        $rootScope.$on("f_focus_first_input", select_first),
        $rootScope.GUI_NO = fweb.CONFIG_GUI_NO,
        $rootScope.cancel = function() {
            var hWnd = fweb.opener();
            hWnd && hWnd.dlg_close ? hWnd.dlg_close() : history.back()
        }
        ,
        $rootScope.dialogFooterTemplate = "ok_cancel.html",
        $rootScope.is_in_fweb_dlg = function() {
            var hWnd = fweb.opener()
              , isMainFrame = "main" === window.name || window === window.top;
            return !isMainFrame && hWnd && hWnd.dlg_close
        }
    }),
    app.run(function($rootScope, $routeSegment) {
        $rootScope.$routeIsSegment = !1,
        $rootScope.$on("$routeChangeSuccess", function(event, current, previous) {
            var segmentsOn = !1
              , segmentsOff = !1
              , inPrev = !1
              , inCurrent = !1;
            null  != previous && (inPrev = "segment" in (previous.$route || previous.$$route)),
            null  != current && (inCurrent = "segment" in (current.$route || current.$$route)),
            $rootScope.$routeIsSegment = inCurrent,
            segmentsOff = inPrev && !inCurrent,
            segmentsOn = inCurrent && !inPrev,
            null  != previous && (segmentsOff || segmentsOn) && $rootScope.$broadcast("routeSegmentChange", {
                index: 0,
                segment: segmentsOff ? null  : $routeSegment.chain[0]
            })
        })
    }),
    app
}),
define("services/injector", ["angular", "app"], function(angular) {
    "use strict";
    function Injector($injector) {
        function invoked() {
            return Array.prototype.slice.call(arguments)
        }
        this.bind = function(fn, context, locals) {
            $injector.annotate(fn),
            invoked.$inject = fn.$inject;
            var args = $injector.invoke(invoked, context, locals);
            return fn.bind.apply(fn, [context].concat(args))
        }
        ,
        this.partial = function(fn, context, positional, locals) {
            function remove_positional(arg) {
                return -1 === positional.indexOf(arg)
            }
            $injector.annotate(fn),
            invoked.$inject = fn.$inject.filter(remove_positional);
            var args = $injector.invoke(invoked, context, locals);
            return fn.bind.apply(fn, [context].concat(args))
        }
        ,
        this.injectMarked = function(context, locals) {
            var key, property;
            for (key in context)
                if (property = context[key],
                angular.isFunction(property) && property.$injectMark) {
                    var result = $injector.invoke(property, context, locals);
                    context[key] = "function" == typeof result ? result.bind(context) : result
                }
        }
    }
    return angular.module("ftnt").service("injector", Injector),
    {
        mark: function(fn) {
            return fn.$injectMark = !0,
            fn
        }
    }
}),
define("services/loader", ["fweb", "angular", "jquery", "./injector"], function(fweb, angular, $) {
    "use strict";
    function FOSError_factory(lang) {
        function FOSError(err_no) {
            if (!this)
                throw new Error("Use new keyword to create FOSError");
            this.name = "FOSError",
            isNaN(Number(err_no)) ? (this.message = err_no,
            this.err_no = null ) : (this.message = err_no + ": " + lang(String(err_no)),
            this.err_no = err_no);
            try {
                try {
                    throw new Error
                } catch (ex) {
                    this._stack = ex.stack.split("\n").slice(2, 99999)
                }
            } catch (ex) {}
        }
        return angular.extend(FOSError, {
            NO_PERMISSIONS: -37
        }),
        FOSError
    }
    function normalize_path(path, pre_slash, post_slash) {
        return path.replace(/^\/?(.+?)\/?$/, (pre_slash ? "/" : "") + "$1" + (post_slash ? "/" : ""))
    }
    function login_redirect(statusCode) {
        if (void 0 === statusCode || statusCode >= 400 && 500 > statusCode) {
            var url = window.location.pathname + window.location.hash;
            window.location.href = "/login?redir=" + encodeURIComponent(url)
        }
    }
    function Loader() {}
    function LoaderProvider($compileProvider, $controllerProvider, $provide) {
        var called_modules;
        this._called_modules = called_modules = [],
        this.$get = function($injector) {
            var service = $injector.instantiate(LoaderService);
            return this.providers = service.providers = fweb.loader.providers = {
                $compile: $compileProvider,
                $controller: $controllerProvider,
                $provide: $provide,
                $injector: $injector
            },
            service._called_modules = called_modules,
            service
        }
        ,
        this.base_path = fweb.loader.base_path.bind(fweb.loader),
        this.resolve = resolve_modules,
        this.initModules = init_modules,
        this.providers = {
            $compile: $compileProvider,
            $controller: $controllerProvider,
            $provide: $provide
        }
    }
    function init_modules(modules, $q, $log) {
        var promises = []
          , result = $q ? $q.defer() : {
            resolve: angular.noop,
            reject: angular.noop
        }
          , called = this._called_modules || [];
        try {
            modules.forEach(function(module) {
                function matchModule(memo) {
                    return memo.module === module
                }
                if (angular.isFunction(module)) {
                    var memo = called.filter(matchModule)[0];
                    void 0 === memo && (memo = {
                        module: module,
                        result: module(this.providers, this)
                    },
                    called.push(memo)),
                    promises.push(memo.result)
                }
            }, this),
            $q && $q.all(promises).then(function() {
                result.resolve()
            }, function(reason) {
                throw new Error("A RequireJS module returned a rejected promise. Reason: " + reason)
            })
        } catch (ex) {
            if (!$q)
                throw ex;
            $log && $log.error(ex),
            result.reject(ex)
        }
        return result.promise
    }
    function resolve_modules(modules, required_permissions, baseModule) {
        return {
            required_dependencies: function($q, $rootScope, loader, $route, $injector, $log) {
                loader._use_current_route(!1);
                var path = baseModule ? baseModule.id.split("/").slice(0, -1).join("/") + "/" : loader.route_path()
                  , module_names = modules.slice().map(function(module) {
                    return "/" === module[0] ? module.substr(1) : path + module
                })
                  , deferred = $q.defer();
                return require(module_names, function() {
                    var modules = $.makeArray(arguments);
                    loader._use_current_route(),
                    loader.initModules(modules, $q, $log).then(deferred.resolve.bind(deferred)),
                    $rootScope.$broadcast("loader.modulesLoaded", $route.$current, modules),
                    requirejs.onError = loader.login_redirect.bind(loader)
                }, function(ex) {
                    $log.error(ex),
                    deferred.reject(ex)
                }),
                deferred.promise
            },
            authorized: function(admin, loader, $rootScope) {
                return admin.$promise.then(function(admin) {
                    return $rootScope.ADMIN_RO = !admin.has_write_permissions(required_permissions),
                    admin.has_permissions(required_permissions)
                }, function(error) {
                    loader.login_redirect(error.status)
                })
            }
        }
    }
    function LoaderService($route, lang, $rootScope, $timeout, injector) {
        this._use_current_route = injector.partial(this._use_current_route, this, ["use_current"]),
        this.$route = $route,
        this.$route_history = $route.current ? [$route.current] : [],
        this.FOSError = FOSError_factory(lang);
        var loader = this;
        $rootScope.$on("$routeChangeStart", function() {
            loader._use_current_route()
        }),
        $rootScope.$on("$routeChangeSuccess", function() {
            0 === loader.$route_history.length && loader._use_current_route()
        })
    }
    function cache_path_filter(loader) {
        return function(input) {
            return input = input || "",
            loader.cache_path(input, !0)
        }
    }
    Loader.prototype = {
        _config: {
            root: "/",
            path: "ng/"
        },
        error_redirect: function(error) {
            var url, err_no = error.err_no;
            "number" == typeof error && (err_no = error),
            url = "number" == typeof err_no ? "/p/error/" + encodeURIComponent(err_no) + "/" : "/p/error/-1/",
            window.location.href.replace(url)
        },
        login_redirect: login_redirect,
        base_path: function(path) {
            return "/" === path.substr(0, 1) ? this._config.root + path.substr(1) : this._config.root + this._config.path + path
        },
        config: function(newConfig) {
            this._config = angular.extend(this._config, newConfig)
        }
    },
    fweb.loader = new Loader,
    LoaderService.prototype = fweb.loader,
    LoaderService.prototype.initModules = init_modules,
    LoaderService.prototype._use_current_route = function($route, use_current) {
        use_current === !1 ? this.$route_history.shift() : $route.current && (this.$route_history.unshift($route.current),
        this.$route_history.length > 2 && (this.$route_history.length = 2))
    }
    ,
    LoaderService.prototype.route_path = function(use_last, route) {
        var route_path;
        return route = route || use_last && this.$route_history[0] || this.$route.current,
        route_path = route.$$route.path,
        route_path || (route_path = route.$$route.originalPath.replace(/:.*$/, "")),
        normalize_path(route_path, !1, !0)
    }
    ,
    LoaderService.prototype.cache_path = function(path, use_last, route) {
        return "/" !== path[0] && (path = this.route_path(use_last, route) + path),
        this.base_path(path)
    }
    ;
    var module = angular.module("ftnt");
    return module.provider("loader", LoaderProvider),
    module.factory("FOSError", FOSError_factory),
    module.filter("cache_path", cache_path_filter),
    fweb.loader
});
