/* globals define */
/* device_manage.js *//* globals dm_ng, FOSGUI */
define(['angular', 'directives/faceted_search', 'device_manage/facets', 'directives/context_menu',
	'fweb.util/persist',
	'services/facets_log', 'services/persistent_storage'
],
function(angular, faceted_search, dm_facets, context_menu, f_persist) {
	'use strict';
	var module = angular.module('ftnt');

	module.config(function(loaderProvider) {
		loaderProvider.initModules([faceted_search, dm_facets, context_menu]);
	});
	module.controller('DMViewerSearch', DMViewerSearch);

	function DMViewerSearch($scope, dmFacets, $q, persistentStorage, facets, facetedSearchUtil, $window, $http, $document) {
		var PERSIST_KEY = 'DMViewerSearch', qlistConfig = null;
		$scope.refresh = function() {
			dm_ng.showLoading();
			dm_ng.onload(facets.makeQlistFilters($scope.facetedSearch.model));
		};
		//add by shuyusun for delete button
		$scope.is_rw_admin = is_rw_admin;
		$scope.popUpMenu = false;
		$scope.popUpMenuToggle = function() {
			$j("#popMenu").show();
			$scope.popUpMenu = !$scope.popUpMenu;
			event.stopPropagation();
		};
		$document.click(function(event){
			event.stopPropagation();
			if(event.target.title != $j.getInfo("delete_data"))
			{
				$scope.popUpMenu = false;
				$j("#popMenu").hide();
				$j("#delete_button").removeClass("pop-up-toggled");
			}
		});
		$scope.deleteDevice = function(val) {
			var config={
				params: {
					'lastdates': val
				}
			};
			var data={};
			$scope.popUpMenu = false;
			var postSuccess = function(){
				hide_wait();
				$window.location.reload();
			};
			var postError = function() {
				$window.alert("Delete request failed.");
			};
			if(confirm($j.getInfo("delete_msg")) == true)
			{
				show_wait();
				$http.post('/waf/device_manage/delete', data, config).then(postSuccess, postError);
			}
		};

		// use $evalAsync because jquery promises can sometimes execute syncronously,
		//and we'd have a double apply
		dm_ng.columns.then(function(columns) {
			$scope.$evalAsync(function() {
				var disabled_columns = dm_ng
				.get_filter_disable_columns(columns.columns),
				model;
				var urlFilter = $window.location.search.replace(/^\?/, '')
				.split('&').filter(startsWithFilter).map(doReplaceFilter)[0];
				try {
					model = persistentStorage.get(PERSIST_KEY);
				} catch (ex) {}

				columns = columns.columns.filter(columnFilterNotDisabled);

				$scope.facetedSearch = {
					facets: dmFacets.forLogType(columns, highlight),
					model: model || {},
					options: {
						entries: entriesGetter,
						source: 'history',
						complex: true,
						filterMerge: {max: 1}
					}
				};

				if (urlFilter) {
					urlFilter = JSON.parse(decodeURIComponent(urlFilter));
					var urlModel = facets.fromQlistFilters(urlFilter, 'history');
					angular.extend(model, urlModel);
				}
				$scope.facetsBySource = $scope.facetedSearch.facets.reduce(bySourceHistory, {});

				$scope.facetedSearch.model = facetedSearchUtil
					.jsonForModel($scope.facetedSearch.model);

				function columnFilterNotDisabled(column) {
					return disabled_columns.indexOf(column.selector) === -1;
				}
				function bySourceHistory(index, facet) {
					index[facet.selectors.history] = facet;
					return index;
				}

				function startsWithFilter(str) { return /^filter=/.test(str) }
				function doReplaceFilter(str) { return str.replace(/^filter=/, '') }
			});
		});

		$scope.addContextFilter = function(valueOption) {
			var model = $scope.facetedSearch.model[$scope.context.facet.id];
			if (model === undefined) {
				model = $scope.facetedSearch.model[$scope.context.facet.id] = [];
			}
			model.push(valueOption.key);
			$scope.context = {};
		};

		function refreshQlist(model) {
			dm_ng.showLoading();
			dm_ng.ready.then(function() {
				dm_ng.onload(facets.makeQlistFilters(model || $scope.facetedSearch.model));
			});
		}

		$scope.$watch('facetedSearch.model', function(value, oldValue) {
			//columns may not be loaded yet
			if(value === undefined)
				return;
			if (oldValue && oldValue !== value) {
				persistentStorage.put(PERSIST_KEY, value);
				refreshQlist(value);
			} else {
				dm_ng.search_ready.resolve(facets.makeQlistFilters(value));
			}
			//search_ready resolve should create dm_ng.ready promise
			if (dm_ng.ready) {
				dm_ng.ready.then(function(entries, $qlist) {
					$scope.facetedSearch.facets.forEach(function(facet) {
						facet.getValues(entries, 'history');
					});
				//rebind everything because dm nukes the qlist data.
				var filterEvt = 'filter_applied.DMViewerSearch remove_filters.DMViewerSearch';
				var contextEvt = 'contextmenu.DMViewerSearch';
				qlistConfig = $qlist.qlist('config');
				$qlist.off(filterEvt).on(filterEvt, function(evt, filters) {
					$scope.$apply(function() {
						//if the remove_filters event is triggered
						//the filters argument is undefined;
						$scope.facetedSearch.model =
						facets.fromQlistFilters(filters || [], 'history');
					});
				});

				$qlist.off(contextEvt).on(contextEvt, function(evt) {
					var $elem = angular.element(evt.target).closest('td');
					var mkey = $elem.closest('[mkey]').attr('mkey');
					var selector = $elem.length && $elem[0].className;

					$scope.$apply(dm_ng.ready.then.bind(dm_ng.ready, function(source) {
						$scope.context = {
							origin: {x: evt.pageX, y: evt.pageY},
							row: source.filter(findRow)[0],
							selector: selector,
							facet: $scope.facetsBySource[selector]
						};
						var value = $scope.context.row && $scope.context.row[selector];
						$scope.context.filters = $scope.context.facet &&
						$scope.context.facet.contextFilters(value);

					}));
					evt.preventDefault();
					function findRow(row) {
						return row['#'] === Number(mkey);
					}
				});
			});
		}}, true);

		function entriesGetter() {
			return $q.when(dm_ng.ready);
		}

		function highlight() {
			/* jshint validthis: true *//* this is a SearchFacet */
			var chosen = false,
			    scm = FOSGUI.LogFormatter.smartColumnMap,
			    selector = this.selectors.history;
			if (qlistConfig && qlistConfig.chosen_columns) {
				chosen = qlistConfig.chosen_columns.indexOf(selector) > -1;
				if (!chosen && scm && (selector in scm)) {
					selector = scm[selector];
					chosen = qlistConfig.chosen_columns.indexOf(selector) > -1;
				}
			}
			return chosen;
		}
	}
});
