/* global define */

define(['fweb.util/dom'], function(fweb_dom) {
    'use strict';

    var compareBar = function(loader) {
        return {
            restrict: 'A',
            templateUrl: loader.base_path('/ng/directives/compare_bar.html'),
            scope: {
                values: '=',
                max: '=',
                caption: '=',
                colors: '='
            },
            link: function(scope, element) {
                element.addClass('compare-bar-container');

                scope.$watchGroup(['values', 'max', 'colors'], function(watched) {
                    var summed;
                    var values = watched[0];
                    var max = watched[1];
                    var colors = watched[2];

                    if (!Array.isArray(values)) {
                        values = [values];
                    }
                    summed = values.reduce(function(previous, current) {
                        return previous + current;
                    });
                    if (max == null) {
                        max = summed;
                    }
                    colors = colors || (values.length > 1 ? ['red', 'green'] : ['blue']);

                    scope.width = ((summed / max) * 100).toFixed(1) + '%';
                    scope.calculated = values.map(function(value, index) {
                        var width;
                        if (index < values.length - 1) {
                            width = ((value / summed) * 100).toFixed(1) + '%';
                        }
                        return {
                            color: fweb_dom.COMPARE_BAR.COLORS[colors[index].toUpperCase()],
                            width: width
                        };
                    });
                });
            }
        };
    };

    return function(providers) {
        providers.$compile.directive('fCompareBar', compareBar);
    };
});
