/* globals define */
define(['angular'], function(angular) {
    'use strict';

    //simple context menu directive. To be superceded by a proper one later?
    function fContextMenu($window, $document) {
        return {
            scope: {
                /* should be {x: pageX, y: pageY} or null */
                position: '=fContextMenu'
            },
            link: function(scope, elem) {
                elem.addClass('f-context-menu f-context-menu-hide');
                var $overlay =
                    angular.element('<div class="f-context-menu-overlay f-context-menu-hide">')
                        .appendTo($document.find('body'));
                scope.$watch('position', function(value) {
                    if (value) {
                        var pos = {
                            top: 'auto',
                            left: 'auto',
                            right: 'auto',
                            bottom: 'auto'
                        };
                        if (value.x < $window.innerWidth * 0.6) {
                            pos.left = value.x;
                        } else {
                            pos.right = $window.innerWidth - value.x;
                        }
                        if (value.y < $window.innerHeight * 0.6) {
                            pos.top = value.y;
                        } else {
                            pos.bottom = $window.innerHeight - value.y;
                        }
                        elem.css(pos);
                    }
                    [elem, $overlay].forEach(function(e) {
                        e.toggleClass('f-context-menu-hide', !value);
                    });
                });
                $overlay.on('click contextmenu', function(event) {
                    scope.$apply(function() {
                        scope.position = null;
                    });
                    event.preventDefault();
                });
                scope.$on('$destroy', function() {
                    $overlay.remove();
                });
            }
        };
    }

    return function(providers) {
        providers.$compile.directive('fContextMenu', fContextMenu);
    };
});
