define("ng/directives/faceted_search/templates", function() {
    "use strict";
    return function(providers) {
        if (providers.$injector) {
            var $templateCache = providers.$injector.get("$templateCache");
            $templateCache.put("/61520b2265589a021a701424b92c634a/ng/directives/faceted_search/active_facet.html", '<div class="f-active-facet" title="{{ $model.viewValue.name }}" ng-click="$event.stopPropagation()" ng-class="{ \'f-active-facet-invalid\': !$model.$valid }"><button class="f-faceted-search-remove bare" ng-click="$remove(null, $event)" f-facet-input="remove" title="{{ \'filter_remove\' | lang }}"><f-icon class="fa-times"></f-icon></button> <input type="text" class="facet-input" ng-show="$editing === \'facet\'" ng-model="$model.name" f-facet-input="facet" tabindex="1"> <button class="facet-name" f-facet-input="selectFacet" ng-show="$editing !== \'facet\'" ng-click="$edit(\'facet\')">{{ $model.facet.name | lang }}:</button> <span f-facet-modifiers ng-show="$editing === \'value\'"><span class="facet-options-container"><input type="text" class="value-input" ng-model="$model.value" placeholder="{{ $model.facet.valuePlaceholder }}" ng-class="{ \'f-facet-value-invalid\': $model.$valid === false }" f-facet-input="value" f-facet-modified f-facet-format="$model.facet"><div class="facet-options" f-scroll-parent f-with="$possibleValues($selValue()) as possibleValues" ng-show="\n                    (possibleValues.length || $model.facet.hint) && $editing === \'value\'"><span class="facet-value-hint" ng-show="$model.facet.hint" ng-bind-html="$model.facet.hint | lang"></span> <span class="facet-options-flexbox"><span class="facet-date-pickers" ng-if="datePickerOptions"><span ui-jq="datepicker" ui-options="datePickerOptions" f-datepicker-set-date="datePickerDate" f-facet-pseudo-input="dateSelected"></span></span><ul><li ng-repeat="v in possibleValues" ng-class="{selected: $preSelected.value == v, highlight: v.highlight()}" f-scroll-into-view="$preSelected.value == v"><label><button ng-click="$event.stopPropagation(); $select.value(v)" edit-group="value" f-facet-input="value_{{v.key}}">{{ v.value }}</button> <span ng-bind-html="v.description"></span></label></li></ul></span></div></span><div class="modifier-group"><input f-facet-modifier="&lt;="><input f-facet-modifier="&gt;="><input f-facet-modifier="A-B"><input f-facet-modifier="OR"><input f-facet-modifier="NOT"></div></span> <button class="facet-value" f-facet-input="selectValue" ng-click="$edit(\'value\')" ng-show="!$editing">{{ $fmtValue() }}</button> <button class="facet-value" f-facet-input="addValue" ng-click="$edit(\'value\')" ng-show="$editing !== \'value\' && !$model.value && $model.facet">&hellip;</button><div class="facet-options" f-scroll-parent f-with="$possibleFacets($model.name) as possibleFacets" ng-show="possibleFacets.length && $editing == \'facet\'"><ul><li ng-repeat="f in possibleFacets" ng-class="{selected: $preSelected.facet == f, highlight: f.highlight()}" f-scroll-into-view="$preSelected.facet == f"><button ng-click="$select.facet(f)" f-facet-input="facet_{{f.name}}" edit-group="facet">{{ f.name | lang }}</button></li></ul></div></div>'),
            $templateCache.put("/61520b2265589a021a701424b92c634a/ng/directives/faceted_search/main.html", '<div class="f-faceted-search" ng-class="{ \'f-fs-focused\': $focused() }"><div class="f-faceted-search-inner" ng-click="$newFacet($event)"><div ng-repeat="sf in $activeFacets" f-active-facet="sf" index="$index"></div><button class="f-faceted-search-edit button search-action inner" autofocus type="button" ng-show="!$editing()" ng-click="$newFacet($event)" f-facet-input="addFilter"><f-icon class="fa-plus-circle"></f-icon><span f-lang="Add Filter"></span></button></div><button class="f-faceted-search-cancel bare" ng-click="$cancel($event)" type="button" ng-show="$activeFacets.length" f-facet-input="cancelAll" title="{{ \'clearFilter\' | lang }}"><f-icon class="fa-times"></f-icon></button><div f-faceted-search-overlay></div></div>')
        }
    }
}),
define("ng/directives/faceted_search/faceted_search", ["module", "angular"], function(module, angular) {
    "use strict";
    function FacetedSearch(injector, $scope, $element, $timeout, $document, KEYS) {
        this.activeFacets = [],
        this.inputs = [],
        this.editQueue = null,
        this.scope = $scope,
        this.getValues = injector.partial(this.getValues, this, ["facet"]),
        ["addFacet", "syncFromModel", "syncToModel", "mergeComplexValues", "focusedElement"].forEach(function(fn) {
            this[fn] = injector.bind(this[fn], this)
        }
        .bind(this)),
        ["focus", "focused", "focusedElement", "editing"].forEach(function(fn) {
            this[fn] = this[fn].bind(this)
        }
        .bind(this)),
        this.blockBackspace($scope, KEYS),
        this.monitorFocus($timeout, $document, $element),
        $scope.$watch(function() {
            var fe = this.focusedElement();
            return fe && fe.$activeFacet && !!fe.$activeFacet.focused
        }
        .bind(this), function(value) {
            this.$overlay.toggleClass("ng-hide", !value)
        }
        .bind(this)),
        $scope.$watch("[facets, options, model]", this.update.bind(this), !0)
    }
    function fFacetedSearch(loader) {
        return {
            scope: {
                facets: "=",
                options: "=",
                model: "="
            },
            templateUrl: loader.base_path("ng/directives/faceted_search/main.html"),
            controller: FacetedSearch,
            require: "fFacetedSearch",
            link: function(scope, elem, attr, controller) {
                function newFacet($event) {
                    controller.addFacet(),
                    $event && $event.stopPropagation()
                }
                function cancel() {
                    scope.$activeFacets.length = 0,
                    controller.syncToModel()
                }
                elem.addClass("f-faceted-search-container"),
                controller.fallback = function() {
                    elem.addClass("f-fi-fallback")
                }
                ,
                scope.$activeFacets = controller.activeFacets,
                scope.$editing = controller.editing,
                scope.$focused = controller.focused,
                scope.$newFacet = newFacet,
                scope.$cancel = cancel
            }
        }
    }
    function fFacetedSearchOverlay() {
        return {
            scope: !1,
            require: "^fFacetedSearch",
            link: function(scope, elem, attr, facetedSearch) {
                facetedSearch.$overlay = elem,
                elem.addClass("f-faceted-search-overlay"),
                elem.on("mousedown mouseup mouseout", function(event) {
                    facetedSearch.overlayState = event.type
                }),
                elem.on("mousedown click contextmenu", function(event) {
                    return facetedSearch.editFacet(null),
                    event.preventDefault(),
                    !1
                })
            }
        }
    }
    function FacetedSearchUtil(injector) {
        this.jsonForModel = injector.partial(this.jsonForModel, this, ["model", "inplace"])
    }
    return FacetedSearch.prototype = {
        editQueue: null,
        update: function() {
            this.facetsById = null,
            this.syncFromModel()
        },
        facets: function() {
            return this.scope.facets
        },
        isComplex: function() {
            return this.scope.options && this.scope.options.complex
        },
        getValues: function(ActiveFacet, facet) {
            var options = this.scope.options;
            if (facet && options && angular.isFunction(options.entries)) {
                var entries = options.entries();
                return entries ? facet.populate(entries, options.source) : []
            }
            return ActiveFacet.emptyArray
        },
        addFacet: function(ActiveFacetModel) {
            for (var af = this.activeFacets, i = af.length - 1; i >= 0; --i)
                af[i].name && (af[i].value || af[i].editing) || af.splice(i, 1);
            var afm = new ActiveFacetModel;
            af.push(afm),
            this.editFacet(afm, "facet")
        },
        syncFromModel: function(ActiveFacetModel, $q, ComplexValue, $log) {
            function notIn(aSet) {
                return function(key) {
                    return -1 === aSet.indexOf(key)
                }
            }
            function addMissing(id) {
                return function(key) {
                    var facet = facetsById[id];
                    if (facet) {
                        if (!afs.some(afMatches(id, key))) {
                            var value = key;
                            value instanceof ComplexValue || (value = facet.normalizeOption(key));
                            var afm = new ActiveFacetModel(facet,value);
                            afs.push(afm)
                        }
                    } else
                        $log.warn("Can't add missing facet from model: " + id + " Available facets: " + Object.keys(facetsById))
                }
            }
            function afMatches(id, key) {
                return function(af) {
                    var facet = af.facet;
                    return facet && facet.id === id && af.value && af.value.intersection([key])
                }
            }
            var scope = this.scope;
            if (scope.facets && scope.facets.length && scope.model) {
                this.facetsById || (this.facetsById = scope.facets.reduce(FacetedSearch.indexById, {}));
                for (var keys, found, afs = this.activeFacets, model = scope.model, facetsById = this.facetsById, clearModel = angular.copy(model), i = afs.length - 1; i >= 0; --i) {
                    var af = afs[i];
                    af.facet && af.value && (keys = clearModel[af.facet.id],
                    found = keys && af.value && af.value.intersection(keys, !0),
                    null != found && af.facet.id in this.facetsById || afs.splice(i, 1),
                    found && (clearModel[af.facet.id] = keys.filter(notIn(found))))
                }
                for (var id in model)
                    model[id].forEach(addMissing(id));
                this.mergeComplexValues()
            }
        },
        syncToModel: function(ComplexValue, facetedSearchUtil) {
            function toModel(model, af) {
                if (af.facet && af.value) {
                    var id = af.facet.id
                      , values = model[id];
                    values || (values = model[id] = []),
                    af.value instanceof ComplexValue ? values.push(af.value) : values.push(af.value.key)
                }
                return model
            }
            this.mergeComplexValues();
            var scope = this.scope;
            this.facetsById || (this.facetsById = scope.facets.reduce(FacetedSearch.indexById, {}));
            var newModel = this.activeFacets.reduce(toModel, {})
              , facetsById = this.facetsById;
            for (var id in scope.model)
                id in facetsById || (newModel[id] = scope.model[id]);
            angular.copy(newModel, scope.model),
            this.isComplex() && facetedSearchUtil.jsonForModel(scope.model, !0)
        },
        mergeComplexValues: function(ComplexValue, SearchFacet) {
            function mergeValues(activeFacets, group, options) {
                function merge(result, afm) {
                    var valid = result.merge(makeCV(afm), ",");
                    return valid ? remove.push(afm) : ++filterCount,
                    afm.$valid = null == options.max || filterCount <= options.max,
                    result
                }
                var remove = []
                  , filterCount = 1
                  , value = makeCV(group[0])
                  , origValue = group[0].value;
                if (group.slice(1).reduce(merge, value),
                remove.length) {
                    if (origValue instanceof SearchFacet.ValueOption && (origValue = origValue.key),
                    origValue instanceof ComplexValue && origValue.values === value.values)
                        throw new Error("shared array fail");
                    group[0].value = value.getSimple(),
                    remove.forEach(function(afm) {
                        var i = activeFacets.indexOf(afm);
                        i > -1 && activeFacets.splice(i, 1)
                    })
                }
            }
            function makeCV(afm) {
                var value = afm.value
                  , facet = afm.facet;
                value instanceof SearchFacet.ValueOption && (value = value.key);
                var ovalue = value;
                if (value = facet.complexValue(value, !0),
                value === ovalue && (value = new ComplexValue(value)),
                value.values === ovalue.values)
                    throw new Error("shared array fail!");
                return value
            }
            function groupByFacet(result, afm) {
                return afm.$valid = !0,
                afm.facet && void 0 !== afm.value && (afm.facet.id in result || (result[afm.facet.id] = []),
                result[afm.facet.id].push(afm)),
                result
            }
            if (this.isComplex()) {
                var afmGroups = this.activeFacets.reduce(groupByFacet, {})
                  , options = this.scope.options.filterMerge || {};
                Object.keys(afmGroups).forEach(function(k) {
                    var group = afmGroups[k];
                    group.length > 1 && (options.useLast && group.reverse(),
                    mergeValues(this.activeFacets, group, options))
                }
                .bind(this))
            }
        },
        addInput: function(input) {
            this.inputs.push(input)
        },
        removeInput: function(input) {
            var index = this.inputs.indexOf(input);
            index > -1 && this.inputs.splice(index, 1)
        },
        editing: function() {
            function isEditing(af) {
                return af.$editing()
            }
            return this.activeFacets.some(isEditing)
        },
        focusedElement: function() {
            var elements = this.inputs.filter(this._isFocused);
            return elements[0]
        },
        focused: function() {
            return this.inputs.some(this._isFocused)
        },
        _isFocused: function(input) {
            return input.focused
        },
        focus: function(value) {
            function isVisible(input) {
                return input.$elem.is(":visible")
            }
            function isAddFilter(input) {
                return "addFilter" === input.name
            }
            function priority(a, b) {
                var order = ["addFilter", "value", "facet", "selectValue", "selectFacet", "remove", "cancelAll"];
                return a = order.indexOf(a.name),
                b = order.indexOf(b.name),
                (a >= 0 ? a : order.length) - (b >= 0 ? b : order.length)
            }
            if (this.focused() || value === !1 || -1 !== [this.overlayState, this.mouseState].indexOf("mousedown"))
                value === !1 && this.scope.$broadcast("editFacet", -1, "facet");
            else {
                var inputs = this.inputs.slice();
                inputs.sort(priority);
                var input = inputs.filter(isVisible)[0] || this.inputs.filter(isAddFilter)[0];
                input && input.focus()
            }
        },
        editPrev: function(model, remove) {
            var af = this.activeFacets
              , index = af.indexOf(model);
            if (index > -1 && remove && af.splice(index, 1),
            index > 0) {
                var result = this.scope.$broadcast("editFacet", index - 1);
                result.defaultPrevented || (this._editQueued = [result, index, index])
            }
        },
        editNext: function(model, addFacet) {
            var index = this.activeFacets.indexOf(model);
            if (index < this.activeFacets.length - 1) {
                var result = this.scope.$broadcast("editFacet", index + 1, "facet");
                result.defaultPrevented || (this._editQueued = [result, index, "facet"])
            } else if (addFacet)
                return void this.addFacet()
        },
        editFacet: function(model, input) {
            var index = this.activeFacets.indexOf(model);
            if (index < this.activeFacets.length) {
                var result = this.scope.$broadcast("editFacet", index, input);
                result.defaultPrevented || (this._editQueued = [result, index, input])
            }
        },
        popEditQueue: function() {
            var r = this._editQueued;
            return this._editQueued = null,
            r
        },
        blockBackspace: function(scope, KEYS) {
            var eventName = "keydown.facetedSearchBlockBackspace_" + scope.$id;
            angular.element(document).on(eventName, function(e) {
                var elem = this.focusedElement();
                e.keyCode === KEYS.BACKSPACE && elem && "button" === elem.type && e.preventDefault()
            }
            .bind(this)),
            scope.$on("$destroy", function() {
                angular.element(document).off(eventName)
            })
        },
        monitorFocus: function($timeout, $document, element) {
            function ns(eventName) {
                return eventName + ".facetedSearchFocusMonitor_" + scope.$id
            }
            var scope = this.scope
              , focusEvents = ["focusout", "focusin"].map(ns).join(" ")
              , mouseEvents = ["mousedown", "mouseup", "mouseout"].map(ns).join(" ")
              , clickEvent = ns("click");
            element.on(focusEvents, function() {
                $timeout(function() {
                    var nothingFocused = !$document[0].activeElement || "body" === String($document[0].activeElement.tagName).toLowerCase();
                    nothingFocused && !this.focused() && this.focus()
                }
                .bind(this), 0, !0)
            }
            .bind(this)),
            element.on(mouseEvents, function(event) {
                this.mouseState = event.type
            }
            .bind(this)),
            angular.element(document).on(clickEvent, function(e) {
                0 === element.find(e.target).length && this.focus(!1)
            }
            .bind(this)),
            scope.$on("$destroy", function() {
                element.off(focusEvents + " " + clickEvent + " " + mouseEvents)
            })
        }
    },
    FacetedSearch.indexById = function(index, facet) {
        return index[facet.id] = facet,
        index
    }
    ,
    FacetedSearchUtil.prototype = {
        jsonForModel: function(ComplexValue, model, inplace) {
            var result = inplace ? model : angular.copy(model);
            return Object.keys(result).forEach(function(k) {
                var searchFacet = this.facets[k];
                result[k] = result[k].map(function(v) {
                    return ComplexValue.probablyComplex(v) ? searchFacet.complexValue(v, !0) : v
                })
            }
            .bind(this)),
            result
        },
        facets: null
    },
    function(providers, loader) {
        var result = loader.initModules(["search_facet", "active_facet", "facet_input", "facet_modifier", "templates"], module);
        return providers.$provide.service("facetedSearchUtil", FacetedSearchUtil),
        providers.$compile.directive({
            fFacetedSearchOverlay: fFacetedSearchOverlay,
            fFacetedSearch: fFacetedSearch
        }),
        result
    }
}),
define("ng/directives/faceted_search/search_facet", ["angular", "fweb.util/patterns", "ng/services/lang"], function(angular, f_patterns) {
    "use strict";
    function SearchFacetFactory($injector, $q, ComplexValue, lang) {
        function SearchFacet(config) {
            if (!(this instanceof SearchFacet))
                throw new Error("Please use the new keyword to create a SearchFacet");
            var genRelevanceFns = {
                ip: SearchFacet.ipGenRelevanceFn
            };
            this.genRelevanceFn = genRelevanceFns[config.type] || this.genRelevanceFn,
            Object.keys(SearchFacet.prototype).forEach(function(prop) {
                prop in config && (this[prop] = config[prop])
            }
            .bind(this)),
            Object.keys(SearchFacet.prototype.tweakFilter).forEach(function(protoTF, prop) {
                prop in this.tweakFilter || (this.tweakFilter[prop] = protoTF[prop])
            }
            .bind(this, SearchFacet.prototype.tweakFilter))
        }
        return SearchFacet.uniqCompact = function(values, pluckKey) {
            function getValues(key) {
                return result[key]
            }
            function makeObj(result, item) {
                var key = pluckKey ? pluckKey(item) : item;
                return null !== key && "" !== key && (result[key] = item),
                result
            }
            var result = values.reduce(makeObj, {});
            return Object.keys(result).map(getValues)
        }
        ,
        SearchFacet.regexGenRelevanceFn = function(searchValue, regExParts, wildCards, wildCardExprs) {
            function suggestionRelevance(value, item) {
                var i, len;
                if (Array.isArray(value)) {
                    var result;
                    for (i = 0,
                    len = value.length; len > i; ++i)
                        if (result = suggestionRelevance(value[i], item),
                        null !== result)
                            return result += (len - i) / len * ARRAY_MATCH_RELEVANCE;
                    return null
                }
                var highlightBonus = 0;
                if (item && "highlight"in item && "function" == typeof item.highlight && item.highlight() && (highlightBonus = .5),
                void 0 === searchValue)
                    return 0 + highlightBonus;
                var match = suggestRegex.exec(value);
                if (match)
                    for (match.shift(),
                    i = 0; i < match.length; ++i)
                        if (void 0 !== match[i])
                            return match.length - i + highlightBonus;
                return null
            }
            var escapedSearch = f_patterns.re_escape((searchValue || "").toString());
            wildCards && wildCards.forEach(function(wc, i) {
                wc instanceof RegExp || (wc = new RegExp(f_patterns.re_escape(f_patterns.re_escape(wc)),"g")),
                escapedSearch = escapedSearch.replace(wc, wildCardExprs[i])
            });
            var expr = "(?:" + regExParts.join(escapedSearch) + ")"
              , suggestRegex = new RegExp(expr,"i")
              , ARRAY_MATCH_RELEVANCE = .001;
            return suggestionRelevance
        }
        ,
        SearchFacet.defaultGenRelevanceFn = function(searchValue, wildCards, wildCardExprs) {
            var ex = ["(^", "$)|(^", ")|(\\b", ")|(", ")"];
            return SearchFacet.regexGenRelevanceFn(searchValue, ex, wildCards, wildCardExprs)
        }
        ,
        SearchFacet.ipGenRelevanceFn = function(searchValue) {
            function maxRel(result, field) {
                var frel = rel(field);
                return null === result && null === frel ? null : Math.max(result, frel)
            }
            var rel = SearchFacet.defaultGenRelevanceFn(searchValue, [/^\\\*|\\\*$/g], ["[\\da-fA-F.:]*"]);
            return function(value) {
                var ip = Array.isArray(value) ? value[0] : value
                  , fields = ip.replace(/(^[|]$)/g, "").split(/[.:]/)
                  , result = rel(value);
                return fields.length && (result = fields.reduce(maxRel, result)),
                result
            }
        }
        ,
        SearchFacet.NO_SORT = function() {
            return 0
        }
        ,
        SearchFacet.DEFAULT_SORT = null,
        SearchFacet.ValueOption = function(key, value, description) {
            this.value = value,
            this.key = key,
            this.description = description
        }
        ,
        SearchFacet.ValueOption.prototype = {
            highlight: function() {
                return !1
            },
            $promise: void 0,
            formatted: function() {
                return this.value
            },
            equals: function(value) {
                return value instanceof SearchFacet.ValueOption ? value.key === this.key : value === this.key
            },
            localeCompare: function(value) {
                return value instanceof SearchFacet.ValueOption ? String(this.formatted()).localeCompare(value.formatted()) : String(this.formatted()).localeCompare(value)
            },
            intersection: function(values) {
                function intersect(result, value) {
                    return ComplexValue.probablyComplex(value) ? (value instanceof ComplexValue || (value = new ComplexValue(value)),
                    result.concat(value.intersection([this.key]) || [])) : result.concat(this.key === value ? [value] : [])
                }
                if (this.key instanceof ComplexValue)
                    return this.key.intersection(values);
                var result = values.reduce(intersect.bind(this), []);
                return result.length ? result : null
            }
        },
        SearchFacet.prototype = {
            id: null,
            name: null,
            nameHtml: null,
            langName: function() {
                return lang(this.name)
            },
            selectors: {},
            alias: null,
            unique: !1,
            sort: null,
            modifiers: null,
            valuePlaceholder: "",
            allowUserInput: !0,
            suggestionLimit: 1e3,
            type: null,
            meta: null,
            hint: "",
            highlight: function() {
                return !1
            },
            localeCompare: function(other) {
                return lang(this.name).localeCompare(lang(other.name))
            },
            tweakFilter: {
                api_monitor: function(filter, reportBy, source) {
                    return filter
                },
                history: function(filter) {}
            },
            allowsModifier: function(modifier) {
                return null === this.modifiers || this.modifiers.indexOf(ComplexValue.resolveModifier(modifier)) > -1
            },
            contextFilters: function(key, complex) {
                function notNull(v) {
                    return null != v
                }
                function makeModifierFilter(modifier) {
                    if (this.allowsModifier(modifier)) {
                        var value = ComplexValue.build([key], [modifier]);
                        return new SearchFacet.ValueOption(value,value.formatted(this))
                    }
                    return null
                }
                if (complex = complex !== !1,
                !key)
                    return this.allowsModifier("!") && complex ? [[new ComplexValue("!*")]] : null;
                var modifiers = (complex ? ["<=", ">=", "!"] : []).map(makeModifierFilter.bind(this)).filter(notNull);
                return [[this.normalizeOption(key)].concat(modifiers)]
            },
            getValues: function(entries, source) {
                function pluckKey(item) {
                    var result = facet.getKey(item, source);

                    /* remove parameters in URL */
                    if(facet.id === "http_url" && result) {
                        var pos = result.indexOf('?');
                        if(pos != -1)
                            result = result.substring(0, pos);
                    }

                    return void 0 === result && (result = null),
                    result
                }
                function pluckUnique(value) {
                    return value && null != value.value ? value.value : value
                }
                var facet = this
                  , MAX_OLD_ENTRIES = 200
                  , oldEntries = this._entries ? this._entries.slice(0, MAX_OLD_ENTRIES) : [];
                return SearchFacet.uniqCompact((entries || []).map(pluckKey).concat(oldEntries), pluckUnique)
            },
            populate: function(entries, source) {
                var facet = this;
                return $q.when(entries).then(function(result) {
                    return facet._entries = facet.getValues(result, source),
                    facet._entries
                })
            },
            getKey: function(entry, source) {
                return entry[this.selectors[source]]
            },
            lookup: function(key, reverse) {
                function match(entry) {
                    return entry instanceof SearchFacet.ValueOption ? reverse ? void 0 !== entry.value && entry.value.valueOf() === key : void 0 !== entry.key && entry.key.valueOf() === key : entry === key
                }
                var facet = this
                  , entries = this._entries || this.getValues();
                return entries ? $q.when(entries).then(function(entries) {
                    facet._entries_cache = facet._entries_cache || {},
                    facet._rentries_cache = facet._rentries_cache || {};
                    var entry = reverse ? facet._rentries_cache[key] : facet._entries_cache[key];
                    if (void 0 !== entry)
                        return entry;
                    var ret;
                    return entry = entries.filter(match)[0],
                    ret = entry instanceof SearchFacet.ValueOption ? reverse ? entry.key : entry.value : entry ? entry : key,
                    facet._entries_cache[key] = ret,
                    ret
                }) : key
            },
            reverseLookup: function(value) {
                var args = Array.prototype.slice.call(arguments, 1);
                return this.lookup.apply(this, [value, !0].concat(args))
            },
            clearValues: function() {
                this._values = null
            },
            normalizeOption: function(key, value) {
                if (key instanceof SearchFacet.ValueOption)
                    return key;
                var result = new SearchFacet.ValueOption(key,value);
                if (key && key.description && (result.description = key.description),
                void 0 === value) {
                    var promise = this.lookup(key);
                    result.$promise = $q.when(promise, function(v) {
                        return delete result.$promise,
                        result.value = v,
                        v
                    })
                }
                return result
            },
            genRelevanceFn: SearchFacet.defaultGenRelevanceFn,
            adjustRelevance: function(searchValue, relevance) {
                return relevance
            },
            format: function(value) {
                return value
            },
            parse: function(value) {
                return value
            },
            complexValue: function(value, convert) {
                var isComplex = value instanceof ComplexValue;
                return null != value && (isComplex || convert) && (value = new ComplexValue(value)),
                value
            }
        },
        $injector.annotate(SearchFacet),
        SearchFacet
    }
    return function(providers) {
        providers.$provide.factory("SearchFacet", SearchFacetFactory)
    }
}),
define("ng/directives/faceted_search/active_facet", ["angular", "fweb.util/datetime", "fweb", "ng/services/fortigateInfo"], function(angular, f_datetime, fweb) {
    "use strict";
    function activeFacetModelFactory(SearchFacet, ComplexValue, lang) {
        function ActiveFacetModel(facet, value) {
            if (facet instanceof ActiveFacetModel && (facet = facet.facet,
            facet && (value = facet.normalizeOption(value))),
            this.$new = !facet,
            this.facet = facet,
            this.name = facet && lang(facet.name),
            this.value = value,
            this.$valid = !0,
            value && !(value instanceof SearchFacet.ValueOption || value instanceof ComplexValue))
                throw Error("Please supply a Searchfacet.ValueOption or ComplexValue object as value");
            this.$editing = function() {
                return !1
            }
        }
        return ActiveFacetModel.prototype.assign = function(other) {
            ActiveFacetModel.call(this, other)
        }
        ,
        ActiveFacetModel
    }
    function ActiveFacet(injector, $scope) {
        function genToString(name) {
            return function() {
                return "function " + name + "()"
            }
        }
        this.scope = $scope,
        this.inputs = {},
        this._undo = [],
        $scope.$editing = !1,
        $scope.$preSelected = {};
        var fn, locals, inject = {
            updateOptions: ["facetName"],
            possibleFacets: ["searchName"],
            possibleValues: ["searchName"],
            preSelect: ["name", "delta", "accept"],
            suggest: ["list", "searchValue", "pluckValue", "genRelevanceFn", "sort", "limit"],
            valueUpdated: ["value"],
            datePickerUpdate: !1,
            datePickerGetDate: !1,
            datePickerSetDate: ["value"],
            keyPress: ["which", "input"],
            tab: ["shiftKey", "input"],
            pushUndo: !1,
            updateFocus: ["input", "value"]
        };
        for (fn in inject)
            locals = inject[fn],
            this[fn] = locals ? injector.partial(this[fn], this, locals) : injector.bind(this[fn], this),
            this[fn].toString = genToString(fn);
        var select = this.select;
        this.select = {};
        for (fn in select)
            locals = [fn].concat("facet" === fn ? ["dontEdit"] : []),
            this.select[fn] = injector.partial(select[fn], this, locals);
        this.possibleValues = this.possibleValues.bind(this),
        this.remove = this.remove.bind(this),
        $scope.$watch("$model.name", this.updateOptions),
        $scope.$watch("$model.value", this.valueUpdated),
        $scope.$watch("$editing", function(value) {
            this.updateFocus(value ? this.inputs[value] : null, !!value)
        }
        .bind(this)),
        $scope.$watch(function() {
            var d = this.datePickerGetDate();
            return d && d.getTime()
        }
        .bind(this), function() {
            var value = this.datePickerGetDate();
            this.datePickerSetDate(value)
        }
        .bind(this)),
        this.datePickerUpdate()
    }
    function fActiveFacet(lang, $q, SearchFacet, $window, loader, ComplexValue) {
        return {
            templateUrl: loader.base_path("ng/directives/faceted_search/active_facet.html"),
            require: ["^fFacetedSearch", "fActiveFacet"],
            controller: ActiveFacet,
            replace: !0,
            scope: {
                $model: "=fActiveFacet",
                $index: "=index"
            },
            link: function(scope, elem, attr, ctrls) {
                function editFacet(evt, index, inputName) {
                    scope.$index === index ? (evt.preventDefault(),
                    inputName !== activeFacet.editing() && scope.$edit(inputName || "value")) : (-1 === index && (activeFacet.remove(!0) || activeFacet.select.current()),
                    activeFacet.updateFocus(null, !1))
                }
                var facetedSearch = ctrls.shift()
                  , activeFacet = ctrls.shift();
                activeFacet.init(facetedSearch),
                scope.$fmtValue = function() {
                    var v = scope.$model.value;
                    return v instanceof ComplexValue || v instanceof SearchFacet.ValueOption ? v.formatted(scope.$model.facet) : v
                }
                ,
                scope.$selValue = function() {
                    var v = scope.$model.value;
                    return v instanceof ComplexValue ? v.selectedValue() : v instanceof SearchFacet.ValueOption ? v.formatted() : v
                }
                ,
                scope.$edit = activeFacet.edit.bind(activeFacet),
                scope.$on("editFacet", editFacet);
                var editQueue = facetedSearch.popEditQueue();
                editQueue && editFacet.apply(null, editQueue),
                scope.$remove = activeFacet.remove,
                scope.$select = activeFacet.select,
                scope.$preSelect = activeFacet.preSelect,
                scope.$possibleFacets = activeFacet.possibleFacets,
                scope.$possibleValues = activeFacet.possibleValues
            }
        }
    }
    function fDatepickerSetDate($timeout) {
        return function(scope, element, attrs) {
            function update() {
                $timeout(function() {
                    element.is(".hasDatepicker") && element.datepicker("setDate", last)
                })
            }
            var last = null;
            scope.$watch(attrs.fDatepickerSetDate, function(value) {
                last = value,
                update(value)
            }),
            scope.$watch(attrs.jqUi, scope.$evalAsync.bind(scope, update))
        }
    }
    return ActiveFacet.FOCUS_DELAY = 10,
    ActiveFacet.emptyArray = [],
    ActiveFacet.value = function(value) {
        return function(kv) {
            return kv.value === value
        }
    }
    ,
    ActiveFacet.prototype = {
        init: function(facetedSearch) {
            this.facetedSearch = facetedSearch,
            this.focused = null;
            var scope = this.scope;
            scope.$model && scope.$model.$new && (scope.$model.$new = !1),
            scope.$model.$editing = this.editing.bind(this)
        },
        addInput: function(input) {
            if (input.name in this.inputs)
                throw new Error("FacetInput names inside an activeFacet must be unique!Tried to add duplicate input for " + input.name);
            this.inputs[input.name] = input
        },
        removeInput: function(input) {
            delete this.inputs[input.name]
        },
        isEmpty: function() {
            return !this.scope.$model.facet
        },
        edit: function(name) {
            if (!(name in this.inputs))
                throw new Error("Unable to edit " + name + ": FacetInput does not exist");
            this.scope.$editing = name
        },
        editing: function() {
            return this.scope.$editing
        },
        suggest: function(SearchFacet, list, searchValue, pluckValue, genRelevanceFn, sort, limit) {
            function notNull(details) {
                return null !== details.relevance
            }
            function pluckItem(details) {
                return details.item
            }
            function exec(item) {
                var value = pluckValue(item);
                return {
                    value: value,
                    item: item,
                    relevance: getRelevance(value, item)
                }
            }
            function relevance(a, b) {
                var a_value = Array.isArray(a.value) ? a_value = a.value[0] : a.value
                  , b_value = Array.isArray(b.value) ? b_value = b.value[0] : b.value;
                return b.relevance - a.relevance || sort && sort(a.item, b.item) || "string" == typeof a_value && "string" == typeof b_value && a_value.localeCompare(b_value) || "localeCompare"in a.item && "localeCompare"in b.item && a.item.localeCompare(b.item) || "number" == typeof a_value && "number" == typeof b_value && b_value - a_value || (a_value && !b_value ? 1 : b_value && !a_value ? -1 : 0)
            }
            pluckValue = pluckValue || function(v) {
                return v
            }
            ;
            var getRelevance = (genRelevanceFn || SearchFacet.defaultGenRelevanceFn)(searchValue)
              , preSliced = list.map(exec).filter(notNull);
            return preSliced.length > limit && (preSliced = preSliced.slice(0, limit)),
            preSliced.sort(relevance).map(pluckItem)
        },
        possibleFacets: function(SearchFacet, lang, $location, $routeParams, $route, searchName) {
            function uniqueCheck(facet) {
                function matches(otherFacet) {
                    return otherFacet.facet === facet
                }
                return this.scope.$model.facet === facet || !facet.unique || !this.facetedSearch.activeFacets.some(matches)
            }
            function pluckValue(facet) {
                function pluckSelector(s) {
                    return facet.selectors[s]
                }
                var facetName = langTable[facet.name] || lang(facet.name).toString()
                  , selectors = Object.keys(facet.selectors).map(pluckSelector);
                return langTable[facet.name] = facetName,
                [facetName, facet.name].concat(selectors)
            }
            var langTable = {}
              , facets = this.facetedSearch.facets();

            // Sessions need special possible facets, modified by Nan Mou
            // var i, 
            //     j = -1, 
            var path = "";
            if ($route && $route.current) {
                path = $route.current.$$route.originalPath;
            }
            if (facets && facets.length) {
                var filteredFacets = this.suggest(facets.filter(uniqueCheck.bind(this)), searchName, pluckValue);
                // if (!searchName && (path === "/fortiview/sources" || path === "/fortiview/policies")) {
                //     // level 1, hide filter destination
                //     for (i = 0; i < filteredFacets.length; i++) {
                //         if (filteredFacets[i].id == "destinations")
                //             j = i;
                //     }
                //     if (j > -1) {
                //         filteredFacets.splice(j, 1);
                //         return filteredFacets;
                //     }
                // } else if (!searchName && path === "/fortiview/:segment/:drilldownValue/sessions/:tab/:drilldownTabValue") {
                //     // level 3, hide all filters
                //     return ActiveFacet.emptyArray;
                // }

                if (!searchName && path === "/fortiview/:segment/:drilldownValue/sessions/:tab/:drilldownTabValue") {
                    // level 3, hide all filters
                    return ActiveFacet.emptyArray;
                }
            }
            return facets && facets.length ? filteredFacets : ActiveFacet.emptyArray
        },
        possibleValues: function(fortigateInfo, SearchFacet, ComplexValue, searchName) {
            function pluckValue(kv) {
                return [kv.value].concat(kv.value !== kv.key ? [kv.key] : []).concat(kv.description ? [kv.description] : [])
            }
            function notMatchKeys(keys) {
                return function(vo) {
                    var hasIntersection = vo instanceof SearchFacet.ValueOption || vo instanceof ComplexValue;
                    return hasIntersection ? !vo.intersection(keys) : -1 === keys.indexOf(vo)
                }
            }
            if (!this.scope.$valueOptions || !this.scope.$model.facet)
                return ActiveFacet.emptyArray;
            var facet = this.scope.$model.facet
              , value = this.scope.$model.value
              , key = value && (value instanceof SearchFacet.ValueOption ? value.key : value)
              , keys = key && key instanceof ComplexValue ? key.values : [key]
              , modelValues = this.facetedSearch.scope.model[facet.id]
              , otherKeys = ComplexValue.flattenValues(modelValues || []).filter(notMatchKeys(keys))
              , options = this.scope.$valueOptions.filter(notMatchKeys(otherKeys));

            //  Sessions policies need special possible values, modified by Nan Mou
            if (facet.id === "policies" && fortigateInfo.info.policies) {
                var arr = [];
                for (var i = 0; i < fortigateInfo.info.policies.length; i++) {
                    arr.push(new SearchFacet.ValueOption(fortigateInfo.info.policies[i], fortigateInfo.info.policies[i]));
                }
                return arr;
            }
	    // added by lk, for mantis bug 481745, add attack_type suggest value for fortiview
	    else if(facet.id === 'attack_type')
	    {
		    var arr = [];

		    arr.push(new SearchFacet.ValueOption('Account', 'Account'));
		    arr.push(new SearchFacet.ValueOption('Lockout', 'Lockout'));
		    arr.push(new SearchFacet.ValueOption('Allow Method', 'Allow Method'));
		    arr.push(new SearchFacet.ValueOption('Antivirus Detection', 'Antivirus Detection'));
		    arr.push(new SearchFacet.ValueOption('Bad Robot', 'Bad Robot'));
		    arr.push(new SearchFacet.ValueOption('Black IP List', 'Black IP List'));
		    arr.push(new SearchFacet.ValueOption('Bot Detection', 'Bot Detection'));
		    arr.push(new SearchFacet.ValueOption('Brute Force Login', 'Brute Force Login'));
		    arr.push(new SearchFacet.ValueOption('Cookie Security', 'Cookie Security'));
		    arr.push(new SearchFacet.ValueOption('Credential Stuffing Defense', 'Credential Stuffing Defense'));
		    arr.push(new SearchFacet.ValueOption('Cross Site Scripting', 'Cross Site Scripting'));
		    arr.push(new SearchFacet.ValueOption('Cross Site Scripting (Extended)', 'Cross Site Scripting (Extended)'));
		    arr.push(new SearchFacet.ValueOption('CSRF Protection', 'CSRF Protection'));
		    arr.push(new SearchFacet.ValueOption('Custom Access', 'Custom Access'));
		    arr.push(new SearchFacet.ValueOption('Custom Signature Detection', 'Custom Signature Detection'));
		    arr.push(new SearchFacet.ValueOption('FortiSandbox Detection', 'FortiSandbox Detection'));
		    arr.push(new SearchFacet.ValueOption('Generic Attacks', 'Generic Attacks'));
		    arr.push(new SearchFacet.ValueOption('Generic Attacks(Extended)', 'Generic Attacks(Extended)'));
		    arr.push(new SearchFacet.ValueOption('GEO IP', 'GEO IP'));
		    arr.push(new SearchFacet.ValueOption('Hidden Fields', 'Hidden Fields'));
		    arr.push(new SearchFacet.ValueOption('HTTP Access Limit', 'HTTP Access Limit'));
		    arr.push(new SearchFacet.ValueOption('HTTP Flood Prevention', 'HTTP Flood Prevention'));
		    arr.push(new SearchFacet.ValueOption('HTTP Parsing Error', 'HTTP Parsing Error'));
		    arr.push(new SearchFacet.ValueOption('HTTP Protocol Constraints', 'HTTP Protocol Constraints'));
		    arr.push(new SearchFacet.ValueOption('HTTPS Connection Failure', 'HTTPS Connection Failure'));
		    arr.push(new SearchFacet.ValueOption('Illegal File Type', 'Illegal File Type'));
		    arr.push(new SearchFacet.ValueOption('Illegal File Size', 'Illegal File Size'));
		    arr.push(new SearchFacet.ValueOption('Illegal JSON Format', 'Illegal JSON Format'));
		    arr.push(new SearchFacet.ValueOption('Illegal XML Format', 'Illegal XML Format'));
		    arr.push(new SearchFacet.ValueOption('Information Disclosure', 'Information Disclosure'));
		    arr.push(new SearchFacet.ValueOption('IP Reputation', 'IP Reputation'));
		    arr.push(new SearchFacet.ValueOption('Known Exploits', 'Known Exploits'));
		    arr.push(new SearchFacet.ValueOption('Machine Learning', 'Machine Learning'));
		    arr.push(new SearchFacet.ValueOption('Malicious IPs', 'Malicious IPs'));
		    arr.push(new SearchFacet.ValueOption('Mobile API Protection', 'Mobile API Protection'));
		    arr.push(new SearchFacet.ValueOption('Other Attacks', 'Other Attacks'));
		    arr.push(new SearchFacet.ValueOption('Padding Oracle', 'Padding Oracle'));
		    arr.push(new SearchFacet.ValueOption('Page Access', 'Page Access'));
		    arr.push(new SearchFacet.ValueOption('Parameter Validation', 'Parameter Validation'));
		    arr.push(new SearchFacet.ValueOption('Personally Identifiable Information', 'Personally Identifiable Information'));
		    arr.push(new SearchFacet.ValueOption('Protected Hostnames', 'Protected Hostnames'));
		    arr.push(new SearchFacet.ValueOption('Quarantined IPs', 'Quarantined IPs'));
		    arr.push(new SearchFacet.ValueOption('SQL Injection', 'SQL Injection'));
		    arr.push(new SearchFacet.ValueOption('SQL Injection (Extended)', 'SQL Injection (Extended)'));
		    arr.push(new SearchFacet.ValueOption('SQL Injection (Syntax Based Detection)', 'SQL Injection (Syntax Based Detection)'));
		    arr.push(new SearchFacet.ValueOption('Start Pages', 'Start Pages'));
		    arr.push(new SearchFacet.ValueOption('SYN Flood Protection', 'SYN Flood Protection'));
		    arr.push(new SearchFacet.ValueOption('TCP Flood Prevention', 'TCP Flood Prevention'));
		    arr.push(new SearchFacet.ValueOption('Timeout Session', 'Timeout Session'));
		    arr.push(new SearchFacet.ValueOption('Trojans', 'Trojans'));
		    arr.push(new SearchFacet.ValueOption('Trojan Detection', 'Trojan Detection'));
		    arr.push(new SearchFacet.ValueOption('URL Access ', 'URL Access'));
		    arr.push(new SearchFacet.ValueOption('User Tracking', 'User Tracking'));
		    arr.push(new SearchFacet.ValueOption('XML Validation Violation', 'XML Validation Violation'));
		    return arr;
	    }
	   

            return this.suggest(options, searchName, pluckValue, facet.genRelevanceFn, facet.sort, facet.suggestionLimit)
        },
        cancel: function(ifEmpty, $event) {
            $event && $event.stopPropagation(),
            (!ifEmpty || this.isEmpty()) && (this.focused && this.undo(),
            this.scope.$editing = null)
        },
        remove: function(ifEmpty, $event) {
            var scope = this.scope;
            if ($event && $event.stopPropagation(),
            ifEmpty && !this.isEmpty())
                return !1;
            var af = this.facetedSearch.activeFacets
              , index = af.indexOf(scope.$model);
            return index > -1 && af.splice(index, 1),
            this.facetedSearch.syncToModel(),
            this.facetedSearch.focus(!0),
            !0
        },
        pushUndo: function(ActiveFacetModel) {
            this._undo.push(new ActiveFacetModel(this.scope.$model))
        },
        undo: function() {
            this._undo.length && this.scope.$model.assign(this._undo.pop())
        },
        tab: function($q, shiftKey, input) {
            var scope = this.scope;
            return shiftKey || this.select[input.editGroup](!0, !0),
            shiftKey ? "value" === input.editGroup ? this.scope.$edit("facet") : (this.facetedSearch.editPrev(scope.$model),
            this.remove(!0)) : "facet" === input.editGroup ? this.scope.$edit("value") : this.facetedSearch.editNext(scope.$model),
            !0
        },
        select: {
            current: function() {
                this.scope.$editing && this.select[this.scope.$editing](!0)
            },
            facet: function(lang, SearchFacet, facet, dontEdit) {
                if (facet === !0 && (facet = null),
                facet || (facet = this.scope.$model.name),
                facet instanceof SearchFacet || (facet = this.preSelect("facet", 0) || this.possibleFacets(facet)[0]),
                !facet)
                    return !1;
                var scope = this.scope
                  , name = lang(facet.name).toString();
                return scope.$model.name = name,
                scope.$model.facet = facet,
                dontEdit || scope.$edit("value"),
                !0
            },
            value: function(SearchFacet, ComplexValue, $q, value) {
                var allowedType, scope = this.scope, useSuggestion = value === !0, preSelected = scope.$preSelected, forceSuggestion = !(scope.$model.facet.allowUserInput || value instanceof SearchFacet.ValueOption);
                if ((null == value || useSuggestion) && (value = scope.$preSelected.value,
                null == value && (value = scope.$model.value)),
                scope.$model.facet.allowUserInput || (useSuggestion = !(value instanceof SearchFacet.ValueOption)),
                useSuggestion || forceSuggestion) {
                    var suggestion = this.preSelect("value", 0);
                    if (null == suggestion && (suggestion = this.preSelect("value", 1)),
                    null != suggestion && (value = suggestion),
                    null == value)
                        return void (scope.$preSelected = preSelected)
                }
                allowedType = value instanceof SearchFacet.ValueOption || value instanceof ComplexValue;
                var done = !0;
                if (allowedType)
                    scope.$model.value = value;
                else if (scope.$model.facet) {
                    var facet = scope.$model.facet
                      , key = facet.reverseLookup(value);
                    done = $q.when(key).then(function(key) {
                        key ? scope.$model.value = facet.normalizeOption(key, value) : value ? scope.$model.value = new ComplexValue(value) : scope.$model.value = void 0
                    })
                }
                return $q.when(done).then(function() {
                    scope.$preSelected.value = null,
                    this.facetedSearch.syncToModel(),
                    this.scope.$editing = !1
                }
                .bind(this)),
                done
            }
        },
        keyPress: function(ComplexValue, which, input) {
            if ("facet" === input.name && ["=", "<", ">", "!"].indexOf(which) > -1) {
                var valueInput = this.inputs.value;
                return "=" !== which && valueInput.modify && valueInput.modify(which),
                this.select.facet(),
                !0
            }
            return !1
        },
        preSelect: function(lang, name, delta) {
            var list = null
              , scope = this.scope;
            if ("facet" === name ? list = this.possibleFacets(scope.$model.name) : "value" === name && (list = this.possibleValues(scope.$fmtValue())),
            list && list.length) {
                var index = list.indexOf(scope.$preSelected[name]);
                delta && (0 > delta && -1 === index && (index = 0),
                index = (index + delta + list.length) % list.length);
                var value = list[index];
                if (void 0 !== value)
                    return delta && (scope.$preSelected[name] = value),
                    value
            }
            return null
        },
        focusPending: null,
        delayedFocus: function($timeout, input, value) {
            var fp = this.focusPending = this.focusPending || {};
            fp[input.editGroup] && $timeout.cancel(fp[input.editGroup]),
            fp[input.editGroup] = $timeout(function() {
                fp[input.editGroup] = null,
                input.doFocus(value)
            }, ActiveFacet.FOCUS_DELAY, !0)
        },
        updateFocus: function($timeout, input, value) {
            function doFocus() {
                $timeout(function() {
                    if (!input.focus(value)) {
                        if (retries >= 10)
                            throw fweb.log.error("ActiveFacet: Unable to focus " + input.name),
                            new Error("ActiveFacet: Unable to focus " + input.name);
                        value && (++retries,
                        doFocus())
                    }
                })
            }
            var editing;
            if ((null !== input || (input = this.focused,
            editing = this.editing(),
            input && !value)) && !this.scope.$pseudoFocus) {
                value ? (this.focused && this.focused !== input && this.focused.focus(!1),
                this.focused = input) : this.focused === input && (this.focused = null);
                var retries = 0;
                doFocus();
                var focused = !!this.focused;
                focused === value && (editing = this.editing() === input.editGroup,
                editing !== value && this.pushUndo(),
                this.scope.$editing = value && input.editGroup)
            }
        },
        pseudoFocus: function(name, value) {
            this._pseudoFocus = this._pseudoFocus || {},
            this._pseudoFocus[name] = value,
            value || delete this._pseudoFocus[name],
            this.scope.$pseudoFocus = Object.keys(this._pseudoFocus).length > 0
        },
        datePickerGetDate: function(SearchFacet, ComplexValue) {
            var value = null
              , scope = this.scope;
            return scope.$model.facet && "date_time" === scope.$model.facet.type && (value = scope.$model.value,
            value instanceof ComplexValue ? value = value.selectedValue() ? new Date(value.selectedValue() * f_datetime.S_TO_MS) : void 0 : value instanceof SearchFacet.ValueOption && (value = new Date(value.key * f_datetime.S_TO_MS))),
            value
        },
        datePickerSetDate: function(value) {
            this.scope.datePickerOptions && (value = value || this.datePickerGetDate(),
            this.scope.datePickerDate = value)
        },
        datePickerUpdate: function(ComplexValue) {
            var scope = this.scope
              , oneDay = new Date(0,0,0,23,59,59).getTime() - new Date(0,0,0,0,0,0).getTime()
              , oneDaySeconds = oneDay * f_datetime.MS_TO_S;
            scope.datePickerOptions = null,
            scope.$model.facet && "date_time" === scope.$model.facet.type && (scope.datePickerOptions = {
                onSelect: function(dateStr, inst) {
                    function startEnd(date, wantStart) {
                        var start = new Date(date.getTime());
                        return ["setHours", "setMinutes", "setSeconds", "setMilliseconds"].forEach(function(fn) {
                            start[fn](0)
                        }),
                        start = f_datetime.dateToLocalSeconds(start),
                        void 0 === wantStart ? [start, start + oneDaySeconds] : start + (wantStart ? 0 : oneDaySeconds)
                    }
                    var value = inst.input.datepicker("getDate");
                    scope.$apply(function() {
                        if (scope.$model.value instanceof ComplexValue && 1 === scope.$model.value.selectedCount) {
                            value = startEnd(value, 0 === scope.$model.value.selected);
                            var cv = new ComplexValue(scope.$model.value,scope.$model.value);
                            cv.setSelectedValue(value),
                            value = scope.$model.value = cv
                        } else
                            value ? (value = startEnd(value).join("-"),
                            value = new ComplexValue(value),
                            value.selected = 0,
                            value.selectedCount = 1) : value = new Date;
                        this.pseudoFocus("dateSelected", !1);
                        var valid = !0;
                        "-" === value.splitter && value instanceof ComplexValue && (valid = Number(value.values[0]) <= Number(value.values[1]),
                        value.setSelected((value.selected + 1) % value.values.length),
                        this.datePickerSetDate()),
                        scope.$model.value = value,
                        scope.$model.$valid = valid
                    }
                    .bind(this))
                }
                .bind(this)
            })
        },
        updateOptions: function($q, lang, facetName) {
            function facetNamed(facet) {
                return lang(facet.name).toString().toLowerCase() === facetName
            }
            function assignValueOptions(values) {
                var scope = this.scope;
                if (this.scope.$model.facet === facet && (scope.$valueOptions = values.map(normalizeOption),
                facet && scope.$model.value && scope.$model.value.key)) {
                    var key = scope.$model.value.key
                      , option = scope.$valueOptions.filter(matchKey(key))[0];
                    option && (scope.$model.value = option,
                    $q.when(option.$promise).then(function(value) {
                        scope.$model.inputValue = value
                    }))
                }
            }
            function normalizeOption(value) {
                return facet.normalizeOption(value)
            }
            function matchKey(key) {
                return function(option) {
                    return option.key === key
                }
            }
            var facets = this.facetedSearch.facets();
            if (facets && facets.length) {
                facetName = facetName && facetName.toLowerCase();
                var facet = facets.filter(facetNamed)[0];
                if (this.preSelect("facet", 0),
                this.scope.$valueOptions = ActiveFacet.emptyArray,
                facet) {
                    var p = $q.when(this.facetedSearch.getValues(facet)).then(assignValueOptions.bind(this));
                    this.scope.$valueOptions.$promise = p,
                    this.datePickerUpdate()
                }
            }
        },
        valueUpdated: function($q, value) {
            function valueNamed(option) {
                return option.value === value
            }
            function pluckPromise(option) {
                return option.$promise
            }
            if (void 0 !== value) {
                var option = this.scope.$valueOptions.filter(valueNamed)[0];
                if (!option) {
                    var promises = this.scope.$valueOptions.filter(pluckPromise).map(pluckPromise);
                    if (promises.length)
                        return void $q.all.apply($q, promises).then(this.valueUpdated.bind(this, value))
                }
                option && (this.scope.$model.value = option,
                this.facetedSearch.syncToModel())
            }
        }
    },
    function(providers, loader) {
        providers.$provide.factory("ActiveFacetModel", activeFacetModelFactory),
        providers.$provide.constant("ActiveFacet", ActiveFacet),
        providers.$compile.directive("fActiveFacet", fActiveFacet),
        providers.$compile.directive("fDatepickerSetDate", fDatepickerSetDate)
    }
}),
define("ng/directives/faceted_search/facet_input", ["../scroll_into_view"], function(registerScrollIntoView) {
    "use strict";
    function FacetInput($scope, $element, $attrs, $parse, $timeout) {
        this.type = $element[0].type,
        this.$attr = $attrs,
        this.$scope = $scope,
        this.$elem = $element,
        this.$timeout = $timeout,
        $element.on("focus blur", function(event) {
            var focused = "focus" === event.type;
            $element.toggleClass("focused", focused),
            this.focused = focused
        }
        .bind(this))
    }
    function fFacetInput($timeout, $parse, KEYS) {
        return {
            scope: !1,
            controller: FacetInput,
            require: ["^fFacetedSearch", "^?fActiveFacet", "fFacetInput", "?fFacetModified"],
            link: function(scope, elem, attr, ctrls) {
                function fakeKeypress(event, nextDelay) {
                    $timeout.cancel(ctrl.$pendingKeypress),
                    preventKeypress || (activeFacet && event.which in preSelectKeys && scope.$apply(function() {
                        activeFacet.preSelect(name, preSelectKeys[event.which]),
                        event.preventDefault()
                    }),
                    $timeout.cancel(ctrl.$pendingKeypress),
                    ctrl.$pendingKeypress = $timeout(fakeKeypress.bind(null, event), nextDelay || KEY_PRESS_REPEAT_INTERVAL))
                }
                var facetedSearch = ctrls.shift()
                  , activeFacet = ctrls.shift()
                  , ctrl = ctrls.shift()
                  , facetModified = ctrls.shift()
                  , name = attr.fFacetInput;
                ctrl.init(name, activeFacet, attr.editGroup),
                facetModified && (ctrl.modify = facetModified.modify),
                "BUTTON" === elem[0].tagName.toUpperCase() && (elem.attr("type") || elem.prop("type", "button"),
                ctrl.type = "button"),
                activeFacet && activeFacet.addInput(ctrl),
                facetedSearch.addInput(ctrl),
                scope.$on("$destroy", function() {
                    facetedSearch.removeInput(ctrl),
                    activeFacet && activeFacet.removeInput(ctrl)
                });
                var preventKeypress = !1
                  , inputStopsEdit = !0
                  , keyDownVal = null
                  , KEY_PRESS_REPEAT_INTERVAL = 30
                  , KEY_PRESS_REPEAT_DELAY = 500;
                elem.on("keypress", function(event) {
                    preventKeypress && event.preventDefault(),
                    activeFacet && scope.$apply(function() {
                        activeFacet.keyPress(String.fromCharCode(event.which), ctrl) && event.preventDefault()
                    })
                });
                var preSelectKeys = {};
                preSelectKeys[KEYS.UPARROW] = -1,
                preSelectKeys[KEYS.DOWNARROW] = 1;
                var keydown = {};
                elem.on("focus", function() {
                    keydown = {}
                }),
                elem.on("keydown", function(event) {
                    "button" !== ctrl.type && (preventKeypress = !1,
                    keyDownVal = elem.val(),
                    activeFacet && scope.$apply(function() {
                        event.which === KEYS.TAB && (activeFacet.tab(event.shiftKey, ctrl),
                        event.preventDefault(),
                        preventKeypress = !0)
                    }),
                    preventKeypress || event.isDefaultPrevented() || event.which === KEYS.TAB || (inputStopsEdit = !1,
                    event.which in preSelectKeys && fakeKeypress(event, KEY_PRESS_REPEAT_DELAY)),
                    keydown[event.which] = !0)
                }),
                elem.on("keyup", function(event) {
                    $timeout.cancel(ctrl.$pendingKeypress),
                    inputStopsEdit = !0,
                    preventKeypress || (scope.$apply(function() {
                        event.which === KEYS.ESC ? activeFacet && (activeFacet.cancel(),
                        activeFacet.isEmpty() && activeFacet.remove()) : event.which === KEYS.ENTER && keydown[event.which] && activeFacet && name in activeFacet.select && activeFacet.select[name]()
                    }),
                    keydown[event.which] = !1)
                })
            }
        }
    }
    function fFacetPseudoInput() {
        var fevents = {
            mousedown: !0,
            mouseup: !1
        };
        return {
            scope: {
                name: "@fFacetHoverInput"
            },
            controller: "FacetInput",
            require: "^fActiveFacet",
            link: function(scope, element, attr, activeFacet) {
                var events = Object.keys(fevents).join(" ");
                element.on(events, "a, input, button", function(event) {
                    scope.$apply(function() {
                        element.is(":visible") && 3 !== event.isTrigger && activeFacet.pseudoFocus(scope.name, fevents[event.type])
                    })
                }),
                element.on("focus", "*", function(event) {
                    event.preventDefault()
                })
            }
        }
    }
    function fFacetFormat(ComplexValue, SearchFacet) {
        return {
            scope: {
                facet: "=fFacetFormat"
            },
            require: "ngModel",
            link: function(scope, element, attr, ngModel) {
                function parse(value) {
                    if (lastValueOption && value === lastValueOption.value && (value = lastValueOption),
                    scope.facet) {
                        errReset();
                        try {
                            value = scope.facet.complexValue(value, !1),
                            value = cvmap(value, scope.facet.parse.bind(scope.facet))
                        } catch (ex) {
                            doCatch(ex),
                            value = void 0
                        }
                    }
                    return value
                }
                function format(value) {
                    return lastValueOption = null,
                    value instanceof SearchFacet.ValueOption && (lastValueOption = value,
                    value = value.key instanceof ComplexValue ? value.key : value.value),
                    scope.facet && (value = cvmap(value, scope.facet.format.bind(scope.facet))),
                    value
                }
                function cvmap(value, fn) {
                    errReset();
                    try {
                        value = value instanceof ComplexValue ? value.formatted(fn, !0) : fn(value)
                    } catch (ex) {
                        doCatch(ex),
                        value = void 0
                    }
                    return value
                }
                function errReset() {
                    errors.forEach(function(error) {
                        ngModel.$setValidity(error, !0)
                    })
                }
                function doCatch(ex) {
                    var err = ex.constructor.name;
                    "Error" === err && (err = ex.message.split(/ /).slice(0, 2).join("-")),
                    errors.push(err),
                    ngModel.$setValidity(err, !1)
                }
                ngModel.$parsers.push(parse),
                ngModel.$formatters.push(format);
                var lastValueOption, errors = []
            }
        }
    }
    var KEYS = {
        ESC: 27,
        ENTER: 13,
        BACKSPACE: 8,
        TAB: 9,
        UPARROW: 38,
        DOWNARROW: 40
    };
    return FacetInput.prototype = {
        $activeFacet: null,
        $pendingKeypress: null,
        init: function(name, activeFacet, editGroup) {
            this.name = name,
            this.editGroup = editGroup || name,
            this.$activeFacet = activeFacet
        },
        focus: function(focus) {
            return this.$elem.is(":hidden") ? !1 : (focus = focus !== !1,
            this.focused = focus,
            this.$elem.focus(),
            !0)
        }
    },
    function(providers, loader) {
        return providers.$controller.register("FacetInput", FacetInput),
        providers.$compile.directive({
            fFacetInput: fFacetInput,
            fFacetFormat: fFacetFormat,
            fFacetPseudoInput: fFacetPseudoInput
        }),
        providers.$provide.constant("KEYS", KEYS),
        loader.initModules([registerScrollIntoView])
    }
}),
define("ng/directives/faceted_search/facet_modifier", [], function() {
    "use strict";
    function fFacetModifier(lang) {
        return {
            scope: {
                modifier: "@fFacetModifier"
            },
            controller: "FacetInput",
            require: ["^fFacetModifiers", "fFacetModifier", "^?fActiveFacet", "^fFacetedSearch"],
            link: function(scope, elem, attr, ctrls) {
                var facetModifiers = ctrls.shift()
                  , facetInput = ctrls.shift()
                  , activeFacet = ctrls.shift()
                  , facetedSearch = ctrls.shift();
                facetedSearch.isComplex() || elem.css("display", "none"),
                facetInput.init("FacetModifier:" + attr.fFacetModifier, activeFacet, "value");
                var fmBound = facetModifiers.modify.bind(facetModifiers, scope.modifier);
                elem.prop("type", "button"),
                elem.val(lang(scope.modifier));
                var modifier = FacetModified.resolveModifier(scope.modifier);
                elem.attr("title", lang(FacetModified.modifierDefs[modifier].tip)),
                elem.addClass("f-facet-modifier"),
                elem.on("click", scope.$apply.bind(scope, fmBound)),
                scope.$watch(function() {
                    var model = activeFacet && activeFacet.scope.$model
                      , facet = model && model.facet;
                    return facet && facet.modifiers
                }, function(facetModifiers) {
                    var show = !facetModifiers || -1 !== facetModifiers.indexOf(modifier);
                    elem.toggleClass("ng-hide", !show)
                })
            }
        }
    }
    function FacetModifiers() {}
    function fFacetModifiers() {
        return {
            controller: FacetModifiers,
            scope: !1,
            require: "fFacetModifiers",
            link: function(scope, elem) {
                elem.addClass("f-facet-modifiers")
            }
        }
    }
    function FacetModified(injector) {
        this.restoreCursor = injector.partial(this.restoreCursor, this, ["$elem"])
    }
    function fFacetModified($timeout) {
        return {
            controller: FacetModified,
            scope: !1,
            require: ["ngModel", "^fFacetModifiers", "fFacetModified", "fFacetInput", "?^fFacetedSearch"],
            link: function(scope, elem, attr, ctrls) {
                function selectedWatch() {
                    return current instanceof ComplexValue && [current.selected, current.selectedCount]
                }
                function updateCaretCurrent(value) {
                    current = value,
                    caret = value.getCaret()
                }
                function updateCaret() {
                    if (current) {
                        var ss = elem[0].selectionStart
                          , sl = elem[0].selectionEnd - ss;
                        current.setCaret(ss, sl);
                        var mv = ngModel.$modelValue;
                        mv !== current && mv instanceof ComplexValue && mv.setCaret(ss, sl),
                        skipUpdate = !doubleClicked,
                        doubleClicked = !1
                    }
                }
                function parse(value) {
                    var complex = facetedSearch && facetedSearch.isComplex();
                    return complex && (value = new ComplexValue(value),
                    updateCaretCurrent(value)),
                    value
                }
                function formatter(value) {
                    return value instanceof ComplexValue && (updateCaretCurrent(value),
                    value = value.formatted()),
                    value
                }
                var ngModel = ctrls.shift()
                  , facetModifiers = ctrls.shift()
                  , facetModified = ctrls.shift()
                  , facetInput = ctrls.shift()
                  , facetedSearch = ctrls.shift();
                elem.addClass("f-facet-modified"),
                facetModifiers.register(facetModified),
                facetModified.modify = facetModified.modify.bind(facetModified, ngModel, facetInput, elem);
                var caret, $render = ngModel.$render;
                ngModel.$render = function() {
                    $render.call(this, arguments),
                    caret ? (elem[0].setSelectionRange && elem[0].setSelectionRange(caret.start, caret.start + caret.length),
                    caret = null,
                    $timeout.cancel(updateCaretPending)) : updateCaret(),
                    elem.attr("size", elem.val().length)
                }
                ;
                var current, updateCaretPending, skipUpdate, doubleClicked;
                scope.$watch(selectedWatch, function(value) {
                    value && !skipUpdate ? (caret = current.getCaret(),
                    caret.length === elem[0].selectionEnd - elem[0].selectionStart && caret.start === elem[0].selectionStart || 0 === caret.length ? caret = null : ngModel.$render()) : skipUpdate = !value
                }, !0),
                ngModel.$parsers.push(parse),
                ngModel.$formatters.push(formatter),
                elem.on("dblclick", function() {
                    doubleClicked = !0
                }),
                elem.on("input keydown keyup keypress mouseup", function() {
                    caret = null,
                    updateCaretPending = $timeout(updateCaret, 0, !0)
                }
                .bind(this))
            }
        }
    }
    function ComplexValue(value, linkSelected) {
        function foundModifier(m) {
            for (var spaceExpr = /^\s+$/; !spaceExpr.test(m) && MODIFIER_EXPR.test(m); )
                for (var i = 0, len = ComplexValue.modifiers.length; len > i; ++i) {
                    var mod = ComplexValue.modifiers[i];
                    mod === m.substr(0, mod.length) && (m = m.substr(mod.length),
                    this.modifiers.push(mod))
                }
            return ""
        }
        value.__ComplexValue && (this._restrictModifiers = value._restrictModifiers,
        value = this.formatted.call(value)),
        this.__ComplexValue = !0;
        var splitMatch, splitter, olen = value.length, splitters = {
            "-": /\s*-\s*/g,
            ",": /\s*,\s*/g
        }, splitExpr = /$ ^/g;
        this.modifiers = [],
        this.value = value,
        value = String(value).replace(MODIFIER_EXPR, foundModifier.bind(this)),
        this._mpad = olen - value.length,
        this.splitter = null;
        for (splitter in splitters)
            if (-1 !== value.indexOf(splitter)) {
                splitExpr = splitters[splitter],
                this.splitter = splitter;
                break
            }
        for (this.selected = 0,
        this.selectedCount = 0,
        this._spad = [],
        linkSelected && linkSelected.__ComplexValue && (this._linkSelected = linkSelected,
        this.selected = this._linkSelected.selected,
        this.selectedCount = this._linkSelected.selectedCount); null !== (splitMatch = splitExpr.exec(value)); )
            this._spad.push(splitMatch[0].length);
        if (this.values = value.split(splitExpr),
        this._restrictModifiers) {
            var wm = this.withModifiers(this._restrictModifiers);
            ["values", "modifiers", "splitter", "_spad", "_mpad"].forEach(function(prop) {
                this[prop] = wm[prop]
            }
            .bind(this))
        }
    }
    var MODIFIER_EXPR = /^(:?<=|>=|<|>|!)+\s*/
      , END_SPLIT_EXPR = /\s*[-,]\s*$/
      , SPLIT_EXPR = function() {
        return /\s*[-,]\s*/g
    }
      , RS = "";
    return FacetModifiers.prototype = {
        modified: null,
        register: function(modified) {
            this.modified = modified
        },
        modify: function(modifier) {
            this.modified.modify(modifier)
        }
    },
    FacetModified.initModifiers = function() {
        var modifierDefs = FacetModified.modifierDefs
          , modifiers = FacetModified.prototype.modifiers
          , lookup = FacetModified.prototype.modifierLookup;
        for (var m in modifierDefs) {
            var value = modifierDefs[m];
            "string" == typeof value && (lookup[m] = value,
            value = modifiers[m] = modifierDefs[value]),
            Array.isArray(value) && (lookup[m] = m,
            modifierDefs[m] = {
                tip: value.shift(),
                isModifier: value.shift(),
                coexist: value.shift(),
                splitReplace: value.shift(),
                endSplitReplace: value.shift()
            },
            modifiers[m] = this.genModifier(m, modifierDefs[m]))
        }
    }
    ,
    FacetModified.resolveModifier = function(modifier) {
        return FacetModified.prototype.modifierLookup[modifier]
    }
    ,
    FacetModified.genModifier = function(modifier, rules) {
        function canCoexist(m) {
            return Array.isArray(rules.coexist) ? rules.coexist.indexOf(m) > -1 : rules.coexist && m !== modifier
        }
        var args = [rules.endSplitReplace, rules.splitReplace];
        return "string" == typeof coexist && (rules.coexist = [rules.coexist]),
        function(value) {
            for (var expr = [END_SPLIT_EXPR, SPLIT_EXPR()], i = 0, len = args.length; len > i; ++i)
                void 0 !== args[i] && (value = value.replace(expr[i], args[i]));
            var complex = new ComplexValue(value)
              , exists = complex.modifiers.indexOf(modifier) > -1;
            return complex.modifiers = complex.modifiers.filter(canCoexist),
            rules.isModifier && !exists && complex.addModifier(modifier),
            value = value.replace(MODIFIER_EXPR, ""),
            complex.modifiers.length > 0 && (value = complex.modifiers.join("") + " " + value),
            rules.isModifier || (value += rules.splitReplace,
            this.cursor.end = this.cursor.start = value.length),
            value
        }
    }
    ,
    FacetModified.modifierDefs = {
        "!": ["Negate the filter value", !0, !0],
        "<=": ["Less than or equal to this value", !0, "!", " "],
        ">=": ["Greater than or equal to this value", !0, "!", " "],
        ">": ["Greater than this value", !0, "!", " "],
        "<": ["Less than this value", !0, "!", " "],
        ",": ["Match any of these values", !1, "!", ", ", ""],
        "-": ["Between these two values (inclusive)", !1, "!", " - ", ""],
        "…": "-",
        "A-B": "-",
        NOT: "!",
        OR: ",",
        RANGE: "-"
    },
    FacetModified.prototype = {
        modifiers: {},
        modifierLookup: {},
        modify: function(ngModel, facetInput, elem, modifier) {
            var modifiers = this.modifiers;
            modifier = FacetModified.resolveModifier(modifier),
            this.saveCursor(elem);
            var value = modifiers[modifier].call(this, ngModel.$viewValue || "");
            elem.val(value),
            elem.focus(),
            ngModel.$setViewValue(value),
            this.restoreCursor(elem)
        },
        saveCursor: function(elem) {
            elem = elem[0],
            this.cursor = {
                start: elem.selectionStart,
                end: elem.selectionEnd,
                word: elem.value
            }
        },
        restoreCursor: function($timeout, $elem) {
            var value = $elem.val()
              , elem = $elem[0];
            if (this.cursor) {
                if (this.cursor.start < value.length) {
                    var pad = value.length - this.cursor.word.length;
                    this.cursor.start += pad,
                    this.cursor.end += pad
                }
                elem.setSelectionRange && elem.setSelectionRange(this.cursor.start, this.cursor.end)
            }
            $timeout(function() {
                $elem.focus()
            })
        },
        cursor: null
    },
    FacetModified.initModifiers(),
    ComplexValue.build = function(values, modifiers, splitter) {
        return new ComplexValue({
            values: values,
            modifiers: modifiers,
            splitter: splitter,
            __ComplexValue: !0
        })
    }
    ,
    ComplexValue.probablyComplex = function(value) {
        return value && (value.__ComplexValue || MODIFIER_EXPR.test(value) || SPLIT_EXPR().test(value))
    }
    ,
    ComplexValue.flattenValues = function(cvs) {
        function flatten(result, cv) {
            return result.concat(ComplexValue.probablyComplex(cv) && cv.values ? cv.values : [cv])
        }
        return cvs.reduce(flatten, [])
    }
    ,
    ComplexValue.modifiers = Object.keys(FacetModified.prototype.modifiers),
    ComplexValue.resolveModifier = FacetModified.resolveModifier,
    ComplexValue.prototype = {
        selected: 0,
        splitter: null,
        values: null,
        modifiers: null,
        value: null,
        addModifier: function(modifier) {
            function modifierSort(a, b) {
                return modifierOrder.indexOf(a) - modifierOrder.indexOf(b)
            }
            var modifierOrder = ComplexValue.modifiers;
            this.modifiers.push(modifier),
            this.modifiers.sort(modifierSort)
        },
        setCaret: function(selectionStart, selectionLength) {
            function valueIndexOf(cv, index) {
                for (var len = 0, sel = 0, vlen = cv.values.length; vlen > sel && (len += String(cv.values[sel]).length,
                !(len >= index)); ++sel)
                    len += cv._spad[sel] || 0;
                return sel
            }
            selectionStart -= this._mpad,
            selectionLength = selectionLength || 0;
            var sel = valueIndexOf(this, selectionStart)
              , selCount = selectionLength && valueIndexOf(this, selectionStart + selectionLength) + 1 - sel;
            sel >= this.values.length && (sel = this.values.length - 1),
            sel + selCount > this.values.length && (selCount = this.values.length - sel),
            this.selected = sel,
            this.selectedCount = selCount,
            this._linkSelected instanceof ComplexValue && (this._linkSelected.selected = sel,
            this._linkSelected.selectedCount = selCount)
        },
        getCaret: function() {
            function len(result, value) {
                return result + String(value).length
            }
            function sum(result, value) {
                return result + value
            }
            var startLength = 0
              , startPad = 0
              , lvalues = this.selectedValues()
              , selPad = 0;
            return this.selected > 0 && (startLength = this.values.slice(0, this.selected).reduce(len, 0),
            startPad = this._spad.slice(0, this.selected).reduce(sum, 0)),
            this.selectedCount > 1 && (selPad = this._spad.slice(this.selected, this.selected + this.selectedCount - 1).reduce(sum)),
            {
                start: this._mpad + startLength + startPad,
                length: this.selectedCount && lvalues.reduce(len, 0) + selPad
            }
        },
        toString: function() {
            return String(this.selectedValue())
        },
        selectedValue: function() {
            return this.values[this.selected]
        },
        selectedValues: function() {
            var end = this.selected + Math.max(this.selectedCount, 1);
            return this.values.slice(this.selected, end)
        },
        setSelectedValue: function(value) {
            this.values[this.selected] = value
        },
        setSelectedValues: function(values) {
            this.values.splice.apply(this.values, [this.selected, Math.max(this.selectedCount, 1)].concat(values)),
            this.selectedCount = values.length
        },
        setSelected: function(index, count) {
            this.selected = index,
            void 0 !== count && (this.selectedCount = count),
            this._linkSelected && (this._linkSelected.selected = index,
            void 0 !== count && (this._linkSelected.selectedCount = count))
        },
        replace: function() {
            var value = this.toString();
            return value.replace.apply(value, arguments)
        },
        withoutSplitter: function(splitter, noClone) {
            function otherSplitter(match) {
                match = match.trim();
                var current = match === result.splitter
                  , noSplitter = null === result.splitter
                  , oldSplitter = match === splitter;
                return oldSplitter || !current && !noSplitter ? match : (result.splitter = match.trim(),
                RS)
            }
            var result = this;
            return this.splitter === splitter && (result = noClone ? this : new ComplexValue(this.value,this),
            result.splitter = null,
            result.values = result.value.replace(MODIFIER_EXPR, "").replace(SPLIT_EXPR(), otherSplitter).split(RS),
            result._restrictModifiers = [splitter]),
            result
        },
        merge: function(other, splitter) {
            var joinedModifiers = this.modifiers.join(RS);
            return other.modifiers.join(RS) !== joinedModifiers || -1 === ["!", ""].indexOf(joinedModifiers) || null != this.splitter && this.splitter !== splitter ? !1 : (this.values.splice.apply(this.values, [0, 0].concat(other.values)),
            this.splitter = splitter,
            !0)
        },
        getSimple: function() {
            return this.splitter || 0 !== this.modifiers.length || 1 !== this.values.length || this._restrictModifiers ? this : this.values[0]
        },
        withModifiers: function(modifiers) {
            function notWanted(modifier) {
                return -1 === modifiers.indexOf(modifier)
            }
            function defined(modifier) {
                return modifier
            }
            function remove(modifier) {
                if (SPLIT_EXPR().test(modifier))
                    result = result.withoutSplitter(modifier, result !== this);
                else {
                    var index = result.modifiers.indexOf(modifier);
                    index > -1 && (removed[index] = modifier,
                    result === this && (result = new ComplexValue(this.value,this)),
                    result.modifiers.splice(index, 1))
                }
            }
            modifiers = modifiers.map(FacetModified.resolveModifier);
            var result = this
              , currentModifiers = this.modifiers.concat(this.splitter ? [this.splitter] : [])
              , removed = [];
            return currentModifiers.filter(notWanted).forEach(remove.bind(this)),
            removed.length && (result.values[0] = removed.filter(defined).join("") + " " + result.values[0]),
            result._restrictModifiers = modifiers,
            result
        },
        formatted: function(fmt, complex) {
            if ("function" != typeof fmt && (fmt = fmt && fmt.format && fmt.format.bind(fmt) || function(v) {
                return v
            }
            ),
            complex) {
                var result = new ComplexValue(this,this);
                return result.values = result.values.map(fmt),
                result
            }
            var modifierDef = FacetModified.modifierDefs[this.splitter]
              , splitReplace = modifierDef && modifierDef.splitReplace;
            return (this.modifiers.length ? this.modifiers.join("") + " " : "") + this.values.map(fmt).join(splitReplace)
        },
        equals: function(value) {
            return value instanceof ComplexValue && value.formatted() === this.formatted()
        },
        localeCompare: function() {
            return this.value.localeCompare.apply(this, arguments)
        },
        intersection: function(other, cull) {
            function intersects(value) {
                return other.indexOf(value) > -1
            }
            function normalizeSplitter(s) {
                return "," === s || null === s ? "" : s
            }
            if (other instanceof ComplexValue) {
                if (other.modifiers.join("") !== this.modifiers.join("") || normalizeSplitter(other.splitter) !== normalizeSplitter(this.splitter))
                    return null
            } else if (this.modifiers.length || "" !== normalizeSplitter(this.splitter))
                return null;
            other = ComplexValue.flattenValues(other);
            var values = this.values.filter(intersects);
            return values.length > 0 ? (cull && values.length !== this.values.length && this.values.splice.apply([0, this.values.length].concat(values)),
            values) : null
        }
    },
    function(providers) {
        providers.$provide.value("ComplexValue", ComplexValue),
        providers.$compile.directive("fFacetModifiers", fFacetModifiers),
        providers.$compile.directive("fFacetModifier", fFacetModifier),
        providers.$compile.directive("fFacetModified", fFacetModified)
    }
});
