/* global define */

define(['ng/ftnt'], function(module) {
    'use strict';

    module.controller('QlistContextMenuConfig', function($scope, lang) {
        var movingChosen = false;
        var chosen_map = {};

        var updateChosen = function() {
            $scope.menu.toggleMeta.chosen = $scope.chosen.map(function(entry) {
                return entry.selector;
            });
        };

        var removeChosen = function(entry) {
            $scope.chosen.splice($scope.chosen.indexOf(entry), 1);
            $scope.available.push(entry);
            updateChosen();
        };

        $scope.menu.toggleMeta = {
            chosen: [],
            action: null
        };
        $scope.chosen = [];
        $scope.available = [];

        $scope.options.chosen_columns.forEach(function(selector) {
            chosen_map[selector] = true;
        });
        $scope.options.columns.forEach(function(column) {
            var selector = column.selector;
            var entry = {
                selector: selector,
                value: column.lang_key === null ? '' : lang(column.lang_key || selector),
                fixed: !!column.fixed,
                icon: column.icon
            };
            if (chosen_map[selector]) {
                $scope.chosen.push(entry);
            } else if (!column.hidden) {
                $scope.available.push(entry);
            }
        });

        $scope.setAction = function(action) {
            $scope.menu.toggleMeta.action = action;
        };

        $scope.addAvailable = function(entry) {
            $scope.available.splice($scope.available.indexOf(entry), 1);
            $scope.chosen.push(entry);
            updateChosen();
        };


        $scope.removeMouseUp = function(event, entry) {
            if (!movingChosen && !entry.fixed) {
                removeChosen(entry);
            }
        };

        $scope.sortableOptions = {
            start: function(event, ui) {
                movingChosen = true;
                var $menuItem = ui.item.find('.menu-item');
                var $contextMenu = $scope.menu.$element;
                // The context menu should maintain its dimensions during drag and drop
                $contextMenu.css({
                    'width': Math.max($contextMenu.width(), $menuItem.outerWidth()) + 'px',
                    'overflow-x': 'hidden'
                });
                $menuItem.css('cursor', 'move');
            },
            stop: function(event, ui) {
                movingChosen = false;
                var $contextMenu = $scope.menu.$element;
                $contextMenu.css({
                    'width': '',
                    'overflow-x': ''
                });
                ui.item.find('.menu-item').css('cursor', '');
            },
            items: 'li:not(.not-sortable)'
        };

        $scope.$watchCollection('chosen', function() {
            updateChosen();
        });
    });
});
