/* globals define */

define(['ng/ftnt', 'jquery', 'notify', 'ng/services/slide',
    'ng/directives/menu/templates'
], function(module, $, Notify) {
    'use strict';


    function fMenuItemQuarantine(dialog, lang, state, loader) {
        var templatePath = loader.base_path('/ng/directives/menu/partials/');
        return {
            restrict: 'A',
            templateUrl: templatePath + 'quarantine.html',
            scope: {
                srcipColName: '='
            },
            require: ['?^fPopUpMenu', '?^fMenuBar'],
            link: function(scope, element, attrs, controllers) {
                element.addClass('menu-item');
                scope.menu = controllers[0] || controllers[1];

                function getSelectedAddresses(entries) {
                    var selectedEntries = entries || scope.menu.entries || [];
                    var srcipColName = scope.srcipColName || 'address';
                    return selectedEntries.map(pluck(srcipColName));
                }

                scope.state = state;

                scope.$watch('menu.entries', function(entries) {
                    scope.addrs = getSelectedAddresses(entries);
                });

                scope.quarantine = function() {
                    var intervals = [
                        { label_key: 'seconds', value: 1},
                        { label_key: 'minutes', value: 60},
                        { label_key: 'hours', value: 60 * 60},
                        { label_key: 'days', value: 60 * 60 * 24 }
                    ];
                    var params = {
                        title: $.getInfo('Quarantine Duration'),
                        template: templatePath + 'quarantine_dlg.html',
                        model: { interval: 60, duration: 30, permanent: false },
                        scope: { intervals: intervals }
                    };
                    dialog.open('quarantineDlg', params).then(ban);

                    function ban(model) {
                        var quarantine_data = {
                            ip_addresses: getSelectedAddresses()
                        };
                        if (!model.permanent) {
                            quarantine_data.expiry = model.duration * model.interval;
                        }

                        $.ajax({
                            url: '/api/v2/monitor/user/banned/add_users/',
                            type: 'POST',
                            dataType: 'json',
                            data: JSON.stringify(quarantine_data)
                        }).then(success, failure);

                        function success(result, jqxhr) {
                            if (result.status === 'error') {
                                failure(jqxhr, result.error);
                            } else {
                                Notify.post(lang('This {ITEM} has been Quarantined.',
                                            [lang('src_addr')]).toString());
                            }
                        }

                        function failure(jqxhr, status) {
                            Notify.post(status, 'error');
                        }

                    }
                };
            }
        };
    }

    function pluck(key) { return function(obj) { return obj[key] } }

    return function(providers) {
        providers.$compile.directive('fMenuItemQuarantine', fMenuItemQuarantine);
    };

});
