define('ng/directives/navbar', ['angular', 'ng/ftnt', 'ng/services/injector', 'fweb'], 
function(angular, module, inject, fweb) {
	'use strict';

	function Navbar($scope, $element, injector, navbar) {
		injector.injectMarked(this, {$scope: $scope, $element: $element});

		this.navbar = navbar;
		this.state = {
			vdom_mode: vdom_mode,
                        hostname: hostname,
                        vdoms: vdoms,
			current_vdom: current_vdom
		};

		this.loading = true;
		this.loadingVdom = true;
		this.searchModel = null;

		this.cur_menu = '';

		this.init();
	}

	Navbar.prototype.VDOM_SELECTION_CONFIG = {
		sources: 'availableVdoms',
		singleSelect: true,
		meta: {
			includeGlobal: true
		},
		sortFunction: fweb.util.sort.vdomSort
	};

	// doesn't include state, navbarFavorites, vdomState
	Navbar.prototype.init = inject.mark(
	function($scope, $location, structure, navbar, shortcuts, $http, $window) {
		return function(){
			var previousUpdateID;
			var that = this;

			var updateAndSelectActive = function(changeLocation) {
				that.loadingVdom = true;
				navbar.update().then(function() {
					that.loadingVdom = false;
					navbar.selectActiveEntry(navbar.active).then(function() {
						if(changeLocation)
							top.main.location = navbar.activeEntry.uri;
					}, function() {
						if(changeLocation)
						{
							navbar.getFirstValidEntry().then(function(entry) {
								top.main.location = entry.uri;
							});
						}
					});
				});
			};

			var watch_menu = function() {
				var menu = document.getElementById('cur_menu');
				if(menu)
				{
					if(menu.value != that.cur_menu)
					{
						that.cur_menu = menu.value;
						navbar.refresh_menu(that.cur_menu);

						menu.value = '';
					}
				}
				setTimeout(watch_menu, 500);
			}

			setTimeout(watch_menu, 500);
			this.vdom = this.createOmniSelectValidVdom(this.state.current_vdom);

			// watch for the vdom changed
			$scope.$watch('navbarCtrl.vdom', function(vdom, previous) {
				var updatedVdom = vdom.q_origin_key;
				var previousVdom = previous.q_origin_key;

				if(updatedVdom !== previousVdom && updatedVdom != that.state.current_vdom)
				{
					// change vdom first send the request to change the enviroment vdom in apache
					var url = '/system/setvdom?vdom=' + updatedVdom + '&redir=/system/status/status' + '&q=' + Math.random();
					$http.get(url, {cache: false}).then(function(){
						that.navbar.state.current_vdom = updatedVdom;
						that.state.current_vdom = updatedVdom;
						updateAndSelectActive(true);
					});
				}
			});
			var url = '/system/setvdom?vdom=' + this.state.current_vdom + '&redir=/system/status/status' + '&q=' + Math.random();
			$http.get(url, {cache: false}).then(function() {
				navbar.update().then(function() {
					that.loading = false;
					that.loadingVdom = false;

					/*
					navbar.getFirstValidEntry().then(function(entry) {
						top.main.location = entry.uri;
					});
					*/
					if(top.changeLocationVdom){
						top.changeLocationVdom = false;
						navbar.selectActiveEntry(top.refreshMenuId);
					}else{
						navbar.selectActiveEntry();
					}
				});
			});

			/*
			navbar.update().then(function() {
				that.loading = false;
				that.loadingVdom = false;
			});

			navbar.selectActiveEntry();
			*/

			$scope.$watch('navbarCtrl.searchModel', function(value, previous) {
				if(value != previous) {
					navbar.update(value).then(function() {
						if(value)
							navbar.indexSearchResults();
					});
				}
			});
			
			shortcuts.subscribe(shortcuts.SHORTCUTS.SEARCH, function() {
				this.searchInputVisible = true;
			}.bind(this), 'shortcut::nav_search', true);

			$scope.navbar_strtbl = navbar_strtbl;

			// Accept message send by postMessage() function
			$window.addEventListener('message', function(event) {
				var origin = fweb.util.structure.getOrigin();
				var data = event.data;
				if (event.origin === origin) {
					switch (data.messageType) {
						// change current vdom of nav
						case 'enterVDOM':
							// in order to triger watch function which bind to scope, we need to use $scope.$apply()
							$scope.$apply(function() {
								$scope.navbarCtrl.vdom = that.createOmniSelectValidVdom(data.vdom);
							});
						break;
						// refresh menu
						case 'refreshState':			
							top.changeLocationVdom = true;
							top.refreshMenuId = data.refreshMenuId;
							top.mainnav.window.location.reload();
										
						break;
					}
				}
			}, false);
		};
	});

	Navbar.prototype.createOmniSelectValidVdom = inject.mark(function(lang) {
		return function(name) {
			var isGlobal = name === '';
			return {
				name: isGlobal ? navbar_strtbl['global']:name,
				q_origin_key: name,
				datasource: 'system.vdom',
				'css-class': isGlobal ? 'fa-globe' : 'ftnt-vdom-proxy'
			};
		};
	});

	Navbar.prototype.clearSearch = function() {
		this.searchModel = null;
	};

	Navbar.prototype.hideSearch = function() {
		this.searchInputVisible = false;
	};

	Navbar.prototype.entryClicked = inject.mark(function(navbar) {
		return function(entry, doNavigation) {
			if(entry){
				navbar.entryClicked(entry, doNavigation);
				this.clearSearch();
				this.hideSearch();
			}
		};
	});

	Navbar.prototype.onSearchKeyDown = inject.mark(function($window, navbar, shortcuts) {
		var that;

		var webkitFocusFix = function() {
			$window.setTimeout(function() {
				document.activeElement.blur();
			});
		};

		var shortcutChecker = fweb.util.shortcuts.create_shortcut_checker([
			shortcuts.SHORTCUTS.CLEAR,
			shortcuts.SHORTCUTS.PREVIOUS,
			shortcuts.SHORTCUTS.NEXT,
			shortcuts.SHORTCUTS.SELECT
		], function(shortcut, event) {
			switch(shortcut) {
				case shortcuts.SHORTCUTS.CLEAR:
					if(that.searchModel){
						that.searchModel = null;
					} else {
						that.searchInputVisible = false;
						webkitFocusFix();
					}
					break;
				case shortcuts.SHORTCUTS.PREVIOUS:
					navbar.previousSearchResult();
					break;
				case shortcuts.SHORTCUTS.NEXT:
					navbar.nextSearchResult();
					break;
				case shortcuts.SHORTCUTS.SELECT:
					that.entryClicked(that.navbar.indexedSearchResult, true);
					webkitFocusFix();
					break;
			}
			event.preventDefault();
		});

		return function(event) {
			that = this;
			shortcutChecker(event);
		};
	});

	// navbar
	module.directive('fNavbar', function(loader) {
		return {
			restrict: 'A',
			controllerAs: 'navbarCtrl',
			templateUrl: '/ng/navbar/navbar.html',
			controller: Navbar
		};
	});


	// navbar menu
	module.directive('fNavbarMenu', function(loader, recursionHelper) {
		return {
			restrict: 'E',
			replace: true,
			scope: {
				menu: '=',
				level: '='
			},
			templateUrl: '/ng/navbar/navbar_menu.html',
			bindToController: true,
			controllerAs: 'navbarMenuCtrl',
			controller: function(navbar) {
				this.navbar = navbar;
			},
			compile: function(element) {
				return recursionHelper.compile(element);
			}
		};
	});

	// navbar menu item
	module.directive('fNavbarMenuItem', function(loader) {
		var navbarController;

		return {
			scope: {
				entry: '=fNavbarMenuItem',
			},
			templateUrl: '/ng/navbar/navbar_menu_item.html',
			bindToController: true,
			controllerAs: 'menuItemCtrl',
			require: '^fNavbar',
			controller: function($scope, $element, $attrs, $timeout, navbar) {
				var that = this;
				this.navbar = navbar;

				$scope.$watch(function() {
					return that.entry.name === (navbar.indexedSearchResult &&
						navbar.indexedSearchResult.name)
				}, function(isIndexedResult) {
					that.isIndexedResult = isIndexedResult;
				});

				$element.on('click', function() {
					$scope.$apply(function() {
						navbarController.entryClicked(that.entry);
					});
				});
			},
			link: function(scope, element, attrs, controller) {
				element.addClass('menu-item');
				scope.navbarCtrl = navbarController = controller;
			}
		};
	});
});
