/* globals define */
define(['fweb.util/objects', 'angular', 'jquery'],  function(f_obj) {
    'use strict';
    //If the list is longer than this, disable animation during scroll
    var MAX_ANIMATED_LEN = 500,
        ANIMATION_DISABLED_INTERVAL = 100;
    function VirtualScroll($scope, $element, $attrs, $animate, $timeout) {
        this.count = parseFloat($attrs.items);
        this.$element = $element;
        this._animateEnabled = $animate.enabled($element);
        this.makeSlices = this.makeSlices.bind(this, $scope);
        this.updateScroll = this.updateScroll.bind(this, $timeout, $element, $animate);
        this.collectionExpr = this.collectionExpr.bind(this, $attrs);
        this.$elems = {
            //order matters!
            before: [],
            visible: [],
            after: []
        };
        this._elemsSorted = {};
        $scope.$virtualScroll = this;
        this.scrollTop = $element[0].scrollTop;
        var updating = false;
        $element.on('scroll', function() {
            $scope.$apply(function() {
                if (!updating) {
                    $scope.$evalAsync(function() {
                        updating = false;
                        this.updateScroll();
                    }.bind(this));
                    updating = true;
                }
            }.bind(this));
        }.bind(this));
        $scope.$evalAsync(this.updateScroll);
        $scope.$watchCollection($attrs.fVirtualScroll, this.makeSlices);
    }

    VirtualScroll.prototype = {
        /**
         * Current scrolltop from event
         * @type {Number}
         */
        scrollTop: null,
        emptyArray: [],
        collectionExpr: function($attrs) {
            return $attrs.fVirtualScroll;
        },
        makeSlices: function($scope, value) {
            if (value) {
                this._lastValue = value;
            } else {
                value = this._lastValue;
            }
            if (value && Array.isArray(value)) {
                $scope.$VSSliceBefore = this.slice('before', value);
                $scope.$VSSliceVisible = this.slice('visible', value);
                $scope.$VSSliceAfter = this.slice('after', value);
            }
        },
        slice: function(location, items) {
            var sw = this.scrollWindow();
            switch (location) {
                case 'before': return items.slice(0, sw.start);
                case 'visible': return items.slice(sw.start, sw.start + sw.count);
                case 'after': return items.slice(sw.start + sw.count);
            }
        },
        scrollWindow: function() {
            if (this._scrollWindow) {
                return this._scrollWindow;
            }
            var start = this.findStart(),
                sw = {
                    start: start || 0,
                    count: this.count
                };
            if (start !== null) {
                this._scrollWindow = sw;
            }
            return sw;
        },
        updateScroll: function($timeout, $element, $animate, value) {
            //TODO: OPTIONAL debounce on the scroll event. Sacrifice fidelity for smoothness.
            value = value || this.$element[0].scrollTop;
            if (this._scrollTop !== value) {
                // disable animation briefly if the list is long.
                if (this._lastValue && this._animateEnabled) {
                    $animate.enabled($element, this._lastValue.length < MAX_ANIMATED_LEN);
                    $timeout.cancel(this._animateDisableTimeout);
                    this._animateDisableTimeout = $timeout(function() {
                        $animate.enabled($element, true);
                    }, ANIMATION_DISABLED_INTERVAL);
                }
                this._scrollWindow = null;
                this._scrollTop = value;
                this.makeSlices();
            }
        },
        //binary search through virtual elements to find the sweet spot.
        //Make sure this only happens AFTER browser layout has finished so it costs less.
        findStart: function() {
            var locations = Object.keys(this.$elems),
                start = null,
                containerTop = this.$element.offset().top;
            if (this.$element[0].offsetHeight === 0) {
                return null;
            }
            var offset = 0;
            locations.forEach(function(l) {
                if (!this._elemsSorted[l]) {
                    this.$elems[l].sort(this.elemSort);
                }
            }.bind(this));
            var elems = f_obj.values(this.$elems).reduce(flatten, []),
                pos = 0,
                oldPos = null,
                len = elems.length,
                min = 0,
                max = len,
                a = null, b = null,
                guard = len * 100;
            if (!len) {
                //skip
                return false;
            }
            do {
                if (a !== null && b !== null) {
                    oldPos = pos;
                    if (a > 0) {
                        max = pos;
                        pos -= Math.round((pos - min) / 2);
                    } else if (b < 0) {
                        min = pos;
                        pos += Math.round((max - pos) / 2);
                    } else if (b === 0) {
                        min = pos;
                        pos = pos + 1;
                    }
                    if (pos < 0) {
                        console.error({pos: pos, len: len, a: a, b: b, oldPos: oldPos});
                        throw new Error('Calculated invalid search position');
                    }
                }
                a = elems[pos].offset().top - containerTop;
                b = pos + 1 >= len ? a + 1 :
                    elems[pos + 1].offset().top - containerTop;
                if (a > b) {
                    throw new Error('List not sorted');
                }
                if (a <= 0 && b > 0) {
                    start = pos + offset;
                }
                if (--guard <= 0) {
                    throw new Error('Binary Search Failed!');
                }
            } while (pos + 1 < len && pos !== oldPos && start === null);
            offset = offset + len;
            return start;

            function flatten(result, arr) { return result.concat(arr); }
        },
        add: function(elem, location) {
            this.$elems[location].push(elem);
            this._elemsSorted[location] = false;
            this._scrollWindow = null;
        },
        remove: function(elem, location) {
            var locElems = this.$elems[location];
            var index = locElems.indexOf(elem);
            if (index > -1) {
                locElems.splice(index, 1);
            }
        },
        elemSort: function(a, b) {
            var a0 = a[0],
                b0 = b[0];
            if (a0.offsetParent === b0.offsetParent) {
                // hopefully this is faster than jquery
                // http://jsperf.com/offsettop-and-offsetleft-vs-jquery-s-offset/5
                return a0.offsetTop - b0.offsetTop;
            } else {
                // can't compare them directly
                return a.position().top - b.position().top;
            }
        }
    };

    function fVirtualScroll() {
        return {
            controller: VirtualScroll,
            requires: 'fVirtualScroll',
            scope: true,
            link: function(scope, elem) {
                elem.addClass('f-virtual-scroll');
            }
        };
    }


    function vsItem(location) {
        return {
            link: function link(scope, elem) {
                //can't use requires because ng-repeat transclusion breaks it?
                scope.$virtualScroll.add(elem, location);
                scope.$on('$destroy', function() {
                    scope.$virtualScroll.remove(elem, location);
                });
            }
        };
    }

    function fVirtualScrollAfter() {
        return vsItem('after');
    }
    function fVirtualScrollBefore() {
        return vsItem('before');
    }
    function fVirtualScrollVisible() {
        return vsItem('visible');
    }


    return function(providers) {
        providers.$compile.directive({
            fVirtualScroll: fVirtualScroll,
            fVirtualScrollBefore: fVirtualScrollBefore,
            fVirtualScrollAfter: fVirtualScrollAfter,
            fVirtualScrollVisible: fVirtualScrollVisible
        });
    };
});
