define(["angular", "app", "jquery", 'policy_view', 'jquery.smartmarquee'], function(angular, app, $, policy_view)
{
	function ServerPool($scope, $rootScope, $http, $interval)
	{
		var restPath = "/rest_redir";
		var url = "api/v1.0/Fortiview/Fabric/PolicyJson";
		var intervalPromise;
		$scope.BubbleOptions = BUBBLE_OPTIONS;
		$scope.type = $scope.BubbleOptions[0].value;
		$scope.view_type = $j.getInfo("view_type");
		$scope.changeFabricStyle = function(ths){
			var bodyContainer = $("body.fabric");
			if(ths.type == "chart")
			{
				//$scope.$broadcast("chart");
				//$interval.cancel(intervalPromise);
				//intervalPromise = $interval(callBack, 3000);
				bodyContainer.css("background", "#3a3a3a");
			}
			else 
			{
				//$scope.$broadcast("topology");
				bodyContainer.css("background", "#fff");
			}
		};
		$scope.vserver = {};
		$scope.$on("CR:vserverlist", function(events, params){
			$scope.vserver["vserver_"+params.id] = true;
		});
		var getData = function(){
			restPath = setQueryValue(restPath, "uri", url);	

			$http.get(restPath).then(function(response){
				finishList = false;
				$scope.policyData = response.data.results;
				angular.forEach($scope.policyData, function(obj, index){
					var key = "vserver_" + index;
					var vsr_mod = {};
					vsr_mod[key] = false;
					angular.extend($scope.vserver, vsr_mod);
				});
			});
		};
		var callBack = function(){
			if(finishList == true)
				getData();
			
			finishList = false;
			return;
		};
		getData();
		intervalPromise = $interval(callBack, 3000);
		/*
		$scope.$on('topology', function() {
			$interval.cancel(intervalPromise);
		});*/
		$scope.$on('$destory', function(){
			$interval.cancel(intervalPromise);
		});
	}
	function ContentRouting($scope, $rootScope, $http, $timeout, $interval)
	{
		var restPath = "/rest_redir";
		var url = "api/v1.0/Fortiview/Fabric/PolicyJson?mode=1";
		
		$scope.BubbleOptions = BUBBLE_OPTIONS;
		$scope.type = $scope.BubbleOptions[0].value;
		$scope.view_type = $j.getInfo("view_type");
		$scope.changeFabricStyle = function(ths){
			var bodyContainer = $("body.fabric");
			if(ths.type == "chart")
			{
				bodyContainer.css("background", "#3a3a3a");
			}
			else 
			{
				bodyContainer.css("background", "#fff");
			}
			$rootScope.$broadcast("change");
		};
		
		$scope.ruleMode = false;
		$scope.vserver = {};
		$scope.$on("ruleMode", function(){
			$scope.ruleMode = true;
		});
		$scope.$on("back", function(){
			$scope.ruleMode = false;
		});
		$scope.$on("CR:vserverlist", function(events, params){
			$scope.vserver["vserver_"+params.id] = true;
		});
		var getData = function(){
			restPath = setQueryValue(restPath, "uri", url);	
			$http.get(restPath).then(function(response){
				finishList = false;
				$scope.policyData = response.data.results;
				angular.forEach($scope.policyData, function(obj, index){
					var key = "vserver_" + index;
					var vsr_mod = {};
					vsr_mod[key] = false;
					angular.extend($scope.vserver, vsr_mod);
				});
			});
		};
		var callBack = function(){
			if(finishList == true)
				getData();
			finishList = false;
			return;
		};
		getData();
		$interval(callBack, 3000);
	}
	function ContentRule($scope, $rootScope, $http, $routeParams, $interval, $location)
	{
		var restPath = "/rest_redir";
		var url = "api/v1.0/Fortiview/Fabric/PolicyJson?mode=1";
		
		var intervalPromise;
		$scope.back = $j.getInfo("back");
		$scope.rule = true;
		$scope.backToContentRouting = function(){
			$scope.rule = false;
			$rootScope.$broadcast("back");
			$location.url("/");
		};
		$scope.$on("change", function(){
			$scope.rule = !($scope.rule);
		});

		var getData = function(){
			restPath = setQueryValue(restPath, "uri", url);	
			$http.get(restPath).then(function(response){
				finishList = false;
				var datas = response.data.results;
				angular.forEach(datas, function(obj){
					if(angular.equals(obj.name, $routeParams.policy_name))
						$scope.ruleData = obj.routing;
				});
			});
		};
		var callBack = function(){
			if(finishList == true)
			{
				getData();
			}
			finishList = false;
			return;
		};
		getData();
		intervalPromise = $interval(callBack, 3000);
		$scope.$on('$destory', function(){
			$interval.cancel(intervalPromise);
		});
	}
	app.controller('ServerPool', ServerPool);
	app.controller('ContentRouting', ContentRouting);
	app.controller('ContentRule', ContentRule);
});
