define(["angular", "ng/services/injector", "app", "jquery", "d3_fabric", "d3", "base_ftnt_object", "d3_images"], 
	function(angular, inject, app, $, D3Controller, d3, BaseFtntObject, FABRIC_IMAGES){
	'use strict';
	
	var LINK_STROKE_WIDTH = 1;
	var DEFAULT_ICON_COLOR = '#333';
	var TRANSITION_DURATION = {
		BASE: 1000,
		ZOOM: 750,
		QUICK: 100
	};
	var MARGIN = {
		LEFT: 163,
		TOP: 15
	};
	var ROW = {
		ROOT: {
			WIDTH: 202,
			HEIGHT: 42
		},
		SECOND: {
			WIDTH: 186,
			HEIGHT: 42
		},
		THIRD: {
			WIDTH: 174,
			HEIGHT: 42
		},
		FORTH: {
			WIDTH: 241,
			HEIGHT: 42
		} 
	};
	var TOGGLE_WIDTH = 18;
	var COLORS = ["#1e6cad", "#37b3d5", "#06ad72", "#6fbd46"];
	// var STATUS_COLORS = ["#ffcc00", "#86ff4a", "#fff"];
	var STATUS_COLORS = ["#fa8d00", "#d8ff00", "#cccccc"];
	var ICON_BACKGROUND = ["#004580", "#0c76b8", "#059462", "#559e2f"];
	var ICON_BACK_ROW = {
		WIDTH: 48,
		HEIGHT: 42
	};
	var DIVISION = {
		WIDTH: 420,
		HEIGHT: 50
	};
	var TEXT_INDENT = 55;
	var TOOLTIP_X_OFFSET = 35;
	var TOOLTIP_Y_OFFSET = 35;
	var TOOLTIP_BUFFER = 5;
	var MAX_TEXT_LENGTH = 21;
	var serverPool = true;
	var DIVISION_OFFSET_X = 50;
	var DEFAULT_OFFSET_X = 200;
	var CURRENT_LINKLAYER_PERSIST = "linkNumber";
	var INTERVAL = 30;
	var IMAGE_OFFSET = {
		x: 12,
		y: 7
	};
	var TOGGLE_PERSIST = "fabricCollapse";
	
	var persist = fweb.util.persist.get(TOGGLE_PERSIST) || [];
	fweb.util.persist.put(TOGGLE_PERSIST, persist);

	function valueFormatter(d) {
		return this.$scope.shownKeyFormatter(d);
	}

	function iconSize(d) {
		return toPx(d.r * 2 / MAX_AREA);
	}

	function toPx(num) {
		return (Math.floor(num * 1000) / 1000) + 'px';
	}
	function pluckX(d) {
		return d.x;
	}
	function pluckY(d) {
		return d.y;
	}
	function pluckDeviceName(d) {
		return d.alias || d.hostname ||
			(d.device ? $.getInfo('Short::device-type.' + d.device) : '') || d.name;
	}
	function transformD(d) {
		return transformXY(d.x, d.y);
	}
	function transformXY(dx, dy) {
		return 'translate(' + dx + ',' + dy + ')';
	}
	function quickTransition(collection, attrs, styles, textfn) {
		var transition = collection.transition();

		if (attrs) {
			transition.attr(attrs);
		}
		if (styles) {
			transition.style(styles);
		}
		if (textfn) {
			transition.text(textfn);
		}
	}
	function linkId(prefix) {
		return function(d) {
			return (prefix ? prefix + '-' : '') + d.target.id;
		};
	}
	function childrenDivisionMinX(d) {
		var minX = (d.source.divisionHMargin || {}).minX;
		return {
			x: d.source.x,
			y: d.source.y + 149 + TOGGLE_WIDTH
		};
	}
	function parentDivisionMaxX(d) {
		var maxX = (d.target.divisionHMargin || {}).maxX;
		return {
			x: d.target.x,
			y: d.target.y - 25
		};
	}
	function horizontalProjection(d) {
		var offsetX = d.x - 21;
		return [d.y, offsetX];
	}

	var D3FabricController = function($scope, $element, $injector, $q, $http, $interval){
		var tree = d3.layout.tree().size([500, 300]);
		var ftntData = [];
		var mode = $scope.mode;
		var restPath = "/rest_redir";
		var url = "api/v1.0/Fortiview/Fabric/PolicyJson";
		
		if(mode == "content_routing")
			url = "api/v1.0/Fortiview/Fabric/PolicyJson?mode=1";

		restPath = setQueryValue(restPath, "uri", url);
		
		var promise = $http.get(restPath);
		this.reloadData = function(response){
			ftntData = this.processSource(response, mode);
			$scope.data = this.processSource(response, mode);
		}.bind(this);
		/*For toggle collapse*/
		this.updateData = function(data){
			var d = data.data.results;
			var toggle_persist = fweb.util.persist.get(TOGGLE_PERSIST);
			if(data.data.results == undefined || data.data.results == null)
				return;
			d.map(function(obj, index){
				if (obj.server_pool !== undefined)
				{
					if(toggle_persist && (toggle_persist.indexOf(obj.name) >= 0))
					{
						data.data.results[index].server_pool.sp_item = [];
					}
				}
				else if(obj.routing !== undefined)
				{
					obj.routing.map(function(routeObj, j){
						var id = obj.name + "_" + routeObj.name;
						if(toggle_persist && (toggle_persist.indexOf(id) >= 0))
						{
							data.data.results[index].routing[j].server_pool.sp_item = [];
						}
					});
				}
			});
		};
		
		this.dataFetch = promise.then(function(data){
			this.updateData(data);
			this.reloadData(data);
		}.bind(this));

		this.data = [];

		$q.all([this.ready, this.dataFetch]).then(function(){
			
			angular.copy(ftntData, this.data);
			
			var withInterfaces = false;
			$injector.invoke(D3Controller, this, {$scope: $scope, $element: $element});
			this.$element.addClass('d3-bubble-cluster-chart');
			this.init();
			this.color = null;
			this.outerSvg = this.svg;
			this.defs = this.outerSvg.append('defs');
			this.createImages();

			this.zoom = d3.behavior.zoom()
				.translate([0, 0])
				.on('zoom', function() {
					this.svg.attr('transform',
						'translate(' + d3.event.translate + ')' +
						' scale(' + d3.event.scale + ')');
					}.bind(this));

			this.svg = this.outerSvg
				.append('g');

			this.outerSvg.on('mousedown', this.restrictZoomBehavior(), true)
			.call(this.zoom)
			.call(this.zoom.event);

			this.overlayRect = this.svg.append('rect')
			.attr({
				width: this.width,
				height: this.height,
				'pointer-events': 'all',
				'class': 'overlay pannable'
			})
			.style({
				fill: 'none'
			})
			.on('click', this.overlayClicked());
			this.linksLayer = this.svg.append('g').attr('class', 'link-layer');
			
			this.tooltipDiv = d3.select("body").append("div")	
				.attr("class", "pop-up-menu")				
				.style("display", "none")
				.style("color", "#262626")
				.style("padding", 4)
				.style("opacity", 0.8);


		}.bind(this));
		
		var topologyPromise;
		this.sendRequest = function(){
			$http.get(restPath).then(function(data){
				this.updateData(data);
				this.reloadData(data);
			}.bind(this));
		}.bind(this);

		topologyPromise	= $interval(this.sendRequest, INTERVAL*1000);
		$scope.$on('$destory', function(){
			$interval.cancel(topologyPromise);
		});

	};
	D3FabricController.prototype = Object.create(D3Controller.prototype);
	D3FabricController.prototype.constructor = D3FabricController;

	D3FabricController.prototype.restrictZoomBehavior = function() {
		// Preventing applying zooming/panning behavior on right click
		var that = this;
		return function() {
			var stop = d3.event.button || d3.event.ctrlKey;
			if (stop) {
				d3.event.stopImmediatePropagation();
			}
		};
	};
	D3FabricController.prototype.overlayClicked = function() {
		var that = this;
		return function() {
			if (d3.event.defaultPrevented) {
				return;
			}
			if (that.currentZoomInClusterId || that.currentZoomInNodeId) {
				that.zoomReset();
			}
		};
	};
	D3FabricController.prototype.updateCursor = function() {
		var that = this;
		that.clusterContainerLayer.selectAll('circle.cluster-container').each(function() {
			var $this = that.d3.select(this);
			var intf = $this.data()[0];
			that.d3.select(this).style({
				cursor: (that.currentZoomInClusterId === intf.upstreamSrcIntfId ||
					 that.currentZoomInNodeId) ? 'zoom-out' : 'zoom-in'
			});
		});
		that.svg.selectAll('g.node circle').each(function() {
			var $this = that.d3.select(this);
			var node = $this.data()[0];
			var id = node.srcIntfId + node.name;
			$this.style({
				cursor: (that.currentZoomInNodeId === id) ? 'zoom-out' : 'zoom-in'
			});
		});
	};
	D3FabricController.prototype.zoomReset = function() {
		var that = this;
		this.currentZoomInNodeId = null;
		this.currentZoomInClusterId = null;
		this.svg.transition()
			.duration(TRANSITION_DURATION.ZOOM)
			.call(this.zoom
					.translate(that.translate || [0, 0])
					.scale(that.fullViewScale || 1).event);
		//this.updateCursor();
	};
	D3FabricController.prototype.updateSize = function(width, height) {
		[this.svg, this.overlayRect].forEach(function(obj) {
			obj.attr({
				width: width,
				height: height
			});
		}.bind());
	};
	D3FabricController.prototype.update = function(data){
		this.updateSize(this.width, this.height);
		this.renderTopology(data);
	};
	D3FabricController.prototype.processSource = function(result, mode){
		var ftntData = [];
		var spChildrenReconstruct = function(poolArr){
			var children = [];
			if(poolArr.length === 0 || poolArr === undefined)
			{
				return children;
			}
			angular.forEach(poolArr, function(obj){
				var copyNode = {};
				var tmpObj = {
					name: obj.ip_domain + ":" + obj.port,
					hc_status: obj.hc_status,
					type: obj.type,
					ip_domain: obj.ip_domain,
					port: obj.port,
					weight: obj.weight,
					ssl: obj.ssl,
					isForth: true,
				};
				angular.copy(tmpObj, copyNode);
				children.push(copyNode);
			});
			return children;
		};
		$.each(result.data.results, function(index, o){
			var childNode = {};
			if(mode == "server_pool")
			{
				serverPool = true;
				var pObj = {
					name: o.name,
					//ip: o.ip,
					//ip6: o.ip6,
					//http_port: o.http_port,
					//https_port: o.https_port,
					protocol: o.protocol,
					monitor_mode: o.monitor_mode,
					status: o.status,
					children: [{
						name: o.server_pool.name,
						//sp_item: o.server_pool.sp_item,
						sp_mode: o.server_pool.sp_mode,
						algo: o.server_pool.algo,
						parentFtnt: o.name,
						isLeaf: true,
						children: spChildrenReconstruct(o.server_pool.sp_item),
					}],
					parentFtnt: null,
					isRoot: true,
				};
				angular.copy(pObj, childNode);
				ftntData.push(childNode);
			}
			else if(mode == "content_routing")
			{
				serverPool = false;
				var cObj;
				cObj = {
					name: o.name,
					//ip: o.ip,
					//ip6: o.ip6,
					//http_port: o.http_port,
					//https_port: o.https_port,
					protocol: o.protocol,
					monitor_mode: o.monitor_mode,
					status: o.status,
					children: [],
					parentFtnt: null,
					isRoot: true
				};
				if(o.routing !== undefined && o.routing.length)
				{
					$.each(o.routing, function(index, r){
						var routingObj = {};
						var tmpObj = {
							name: r.name,
							is_default: r.is_default,
							children: [{
								name: r.server_pool.name,
								//sp_item: r.server_pool.sp_item,
								isLeaf: true,
								parentFtnt: r.name,
								sp_mode: r.server_pool.sp_mode,
								algo: r.server_pool.algo,
								children: spChildrenReconstruct(r.server_pool.sp_item)
							}],
							isMid: true,
							parentFtnt: o.name
						};
						angular.copy(tmpObj, routingObj);
						cObj.children.push(routingObj);

					});
				}
				angular.copy(cObj, childNode);
				ftntData.push(childNode);
			}
		});
		return ftntData;
	};
	D3FabricController.prototype.renderTopology = function(ftntData){
		var tree = d3.layout.tree().size([500, 300]);
		var startX = MARGIN.TOP;
		var startY = MARGIN.LEFT;
		var levelMid = 0, levelLeaf = 0, levelRoot = 0, levelForth = 0;
		var nodes;


		var withInterfaces = false;

		var policyNodes = [];
		var that = this;
		var linkNodes = [];// = tree.links(nodes);
		var mode = 0;

		var number = 0;
		ftntData.forEach(function(nodeObj){
			policyNodes = [];
			nodes = tree.nodes(nodeObj).reverse();
			//policyNodes = nodes;
			nodes.forEach(function(d) {
				var i;
				d.y = d.depth * DIVISION.WIDTH + MARGIN.LEFT - DIVISION_OFFSET_X;
				if(d.isRoot != undefined && d.isRoot)
				{
					//d.x = startX;	
					levelRoot = levelRoot + 1;
					d.x = startX + DIVISION.HEIGHT * levelRoot;
				}
				else if(d.isMid != undefined && d.isMid)
				{
					levelMid = levelMid + 1;
					d.x = startX + DIVISION.HEIGHT * levelMid;
					mode = 1;
				}
				else if(d.isLeaf != undefined && d.isLeaf)
				{
					levelLeaf = levelLeaf + 1;
					d.x = startX + DIVISION.HEIGHT * levelLeaf;
				}
				else if(d.isForth != undefined && d.isForth)
				{
					var even;
					levelForth = levelForth + 1;
					even = (levelForth%2 == 0)?true:false;
					d.x = startX + DIVISION.HEIGHT * levelForth;
				}
				
				policyNodes.push(d);
			});
			number++;
			var tmpLinkNodes = tree.links(nodes);
			linkNodes.push({links: tmpLinkNodes});
			that.renderPolicy(policyNodes, number);
		});
		number = 0;
		linkNodes.forEach(function(obj){
			number++;
			that.renderLink(obj.links, withInterfaces, number);
		});

		/*When reduce policy nodes the extra link and nodes should be removed*/
		var prevLinksNumber = fweb.util.persist.get(CURRENT_LINKLAYER_PERSIST);
		if(prevLinksNumber != undefined && prevLinksNumber != null)
		{
			for(var l=number+1; l<=prevLinksNumber; l++)
			{
				that.removeExtraLink([], l);
				that.removeExtraNodes([], l);
			}
		}
		fweb.util.persist.put(CURRENT_LINKLAYER_PERSIST, number);

		var dep = (mode == 1)?4:3;
		var bBox = {
			x1: 0,
			y1: 0,
			x2: dep*DIVISION.WIDTH + MARGIN.LEFT + MARGIN.LEFT,
			y2: startX + DIVISION.HEIGHT * levelForth /*-20*/ + MARGIN.TOP + ROW.FORTH.HEIGHT/2
		};
		if (bBox) {
			var dx = bBox.x2 - bBox.x1,
				dy = bBox.y2 - bBox.y1,
			x = (bBox.x1 + bBox.x2) / 2;

			var height = this.height;
			var width = this.width;
			var fullViewScale = 1 / Math.max(dx / width, dy / height);
			var translateX = width/2 - fullViewScale*x;

			translateX = translateX ? translateX : fullViewScale*(MARGIN.LEFT)
			
			var translate = [translateX, MARGIN.TOP];
			// this scale factor is for overall view
			this.fullViewScale = fullViewScale < 1 ? fullViewScale : 1;
			this.translate = fullViewScale < 1 ? translate : [DEFAULT_OFFSET_X, MARGIN.TOP];
			if (fullViewScale < 1) {
				this.updateSize(this.width / fullViewScale, this.height / fullViewScale);
			}
		}
		this.zoomReset();
	};
	D3FabricController.prototype.renderPolicy = function(nodes, number) {
		var rowWidth = ROW.ROOT.WIDTH;
		var rowHeight = ROW.ROOT.HEIGHT;
		var layer = this.svg;
		var devices = layer.selectAll('g.ftnt-device'+number).data([{name:'parentContainer'}], function(d){ return d.id || (d.id = (d.depth + '_' + d.name + '_' + d.x));});
		
		devices.enter().append('g');
		
		var deviceAttrs = {
			transform: function(d) {
				var offset = {
					x: -20,
					y: -ROW.ROOT.HEIGHT
				};
				return transformXY(offset.x, offset.y);
			},
			class: 'ftnt-device'+number
		};
		var textMargin = 10;
		var textFontSize = 15;

		var intfGAttrs = {
			transform: function(d, i) {
				var h = 20;
				return transformXY(d.y, d.x);
			},
			class: function(d){
				return 'intf tr';
			}
		};
		var intfRectAttrs = {
			x: ICON_BACK_ROW.WIDTH,
			y: 0,
			width: function(d){
				var width;
				if(d.isRoot == true)
					width = ROW.ROOT.WIDTH;
			        else if(d.isMid == true)
					width = ROW.SECOND.WIDTH;
				else if(d.isLeaf == true)
					width = ROW.THIRD.WIDTH;
				else if(d.isForth == true)
					width = ROW.FORTH.WIDTH;

				return width - ICON_BACK_ROW.WIDTH;
					
			},
			height: function(d){
				if(d.isRoot == true)
					return ROW.ROOT.HEIGHT;
			        else if(d.isMid == true)
					return ROW.SECOND.HEIGHT;
				else if(d.isLeaf == true)
					return ROW.THIRD.HEIGHT;
				else if(d.isForth == true)
					return ROW.FORTH.HEIGHT;
				else 
					return 0;
			},
			class: function(d) {
				return 'td';
			}
		};
		var intfTextAttrs = {
			x: TEXT_INDENT,
			y: ROW.ROOT.HEIGHT/2,
			dy: toPx(rowHeight / 8),
			'font-size': toPx(textFontSize),
			class: 'intf-text'
		};
		var i = 0;
		var intfs = devices.selectAll('g.intf').data(nodes, function(d) { return d.id || (d.id = (d.depth + '_' + d.name + '_' + d.x)); });
		var intfNameFn = function(d) {
			var showName = d.name;
			if(showName.length > MAX_TEXT_LENGTH){
				if(d.type){
					var port_string = showName.substring(showName.lastIndexOf(":")+1);
					showName = showName.substring(0, 14) + "...:" + port_string;	
				}else{
					showName = showName.substring(0, 16) + "...";
				}

			}
			return showName;
		};

		var intfsEnter = intfs.enter()
			.append('g')
			.attr(intfGAttrs);

		var that = this;
		var hideTooltip = function(){
			var div = $("div.pop-up-menu");
			div.css("display", "none");	
		};

		var setPosition = function(event) {
			var $tooltip = $("div.pop-up-menu");
			var height, width, top, left, left_over;
			var offset = {
				left: that.$element[0].offsetLeft,
				top: that.$element[0].offsetTop
			};
			width = 150;
			top = event.pageY - offset.top - TOOLTIP_Y_OFFSET;
			if (top < TOOLTIP_BUFFER) {
				top = TOOLTIP_BUFFER;
			}
			if (top > that.height - $tooltip.height())
			{
				top = event.pageY - $tooltip.height();
			}
			left = event.pageX - offset.left + TOOLTIP_X_OFFSET;
			left_over = left + width - that.$element[0].offsetWidth;
			if (left_over > -TOOLTIP_BUFFER) {
				left = event.pageX - offset.left - width - TOOLTIP_X_OFFSET -
					TOOLTIP_BUFFER;
			}

			$tooltip.css({
				'left': left,
				'top':top
			});
		};

		var colorFn = function(d){
			var id = "#depth_opacity_" + (d.isRoot == true ? d.depth : (serverPool?d.depth+1:d.depth));
		};

		var imageAttrFn = function(d){
			return "#image_" + (d.isRoot == true ? d.depth : (serverPool?d.depth+1:d.depth));
		};
	
		intfsEnter.append('circle')
			.attr({
				fill: function(d){
					return "#808080";
				},
				cx: -4,
				cy: ICON_BACK_ROW.HEIGHT/2,
				r: 4,
				class: function(d){
					return d.depth == 0 ? "root" : "grey";
				}
			});
		intfsEnter.append('rect')
			.attr({
				width: ICON_BACK_ROW.WIDTH,
				height: ICON_BACK_ROW.HEIGHT,
				x: 0,
				y: 0,
			})
			.style({
				cursor: 'pointer',
				fill: function(d){
					if(serverPool == true && d.isLeaf == true)
						d.depth = 2;
					else if(serverPool == true && d.isForth == true)
						d.depth = 3;
					return ICON_BACKGROUND[d.depth];
				}
			});
		intfsEnter.append('rect')
			.attr(intfRectAttrs)
			.style({
				cursor: 'pointer',
				fill: function(d){
					if(serverPool == true && d.isLeaf == true)
						d.depth = 2;
					else if(serverPool == true && d.isForth == true)
						d.depth = 3;
					/*return 'url("#depth_opacity_' + d.depth + '")';*/
					return COLORS[d.depth];
				} 
			});

		intfsEnter.append("text")
			.attr(intfTextAttrs)
			.style({
				"pointer-events":'none',
				fill: "#fff"
			})
		.text(intfNameFn);

		intfsEnter.append("use")
			.attr({
				x: IMAGE_OFFSET.x,
				y: IMAGE_OFFSET.y,
				'xlink:href': function(d){
					return "#image_" + d.depth;
				},
				fill: "#fff",
					'fill-opacity': 1
			});

		var toggleSelector = intfs.filter(function(d){
			var collapseArray = fweb.util.persist.get(TOGGLE_PERSIST);
			var id;
			var index;
			if(d.isLeaf === true)
			{
				if(d.parent.isMid === true){
					id = d.parent.parentFtnt + "_" + d.parentFtnt;
				}
				else
				{
					id = d.parentFtnt;
				}
				index = collapseArray.indexOf(id);
				return (d.children == null && index < 0) ? false : true;
			}
			return false;
		});

		that.renderToggleIconButtons(toggleSelector);

		devices.selectAll("g.tree-toggle").each(that.toggleIconClickBindFn());

		quickTransition(devices, deviceAttrs);
		quickTransition(intfs, intfGAttrs);
		quickTransition(intfs.selectAll('rect.td'), intfRectAttrs);
		quickTransition(intfs.selectAll('text.intf-text'), intfTextAttrs);
		intfs.selectAll('rect.td').each(function(d){
			var $this = $(this);
			$this.off("mouseover").on("mouseover", function(event){
				that.createPolicyTooltipBindFn(d);
				setPosition(event);
			})
			$this.off("mouseleave").on("mouseleave", function(event){
				hideTooltip();
			})
			$this.off("mousemove").on("mousemove", function(event){
				setPosition(event);
			});
		});
		that.renderStatusImage(intfs);
		intfs.selectAll('circle.root').remove();
		intfs.exit().remove();
		
	};

	D3FabricController.prototype.renderLink = function(linkNodes, withInterfaces, number) {
		var layer = this.linksLayer;
		var srcMinX, srcMaxX;
		var dstMinX, dstMaxX;
		
		if(!linkNodes.length) return;

		srcMinX = srcMaxX = linkNodes[0].source.x;
		dstMinX = dstMaxX = linkNodes[0].target.x;
		linkNodes.forEach(function(link){
			var srcX = link.source.x;
			var dstX = link.target.x;
			if(srcX < srcMinX)
				srcMinX = srcX;
			if(srcX > srcMaxX)
				srcMaxX = srcX;

			if(dstX < dstMinX)
				dstMinX = dstX;
			if(dstX > dstMaxX)
				dstMaxX = dstX;

			angular.extend(link.source, {
				divisionHMargin: {
					minX: srcMinX,
					maxX: srcMaxX
				}
			});
			angular.extend(link.target, {
				divisionHMargin: {
					minX: dstMinX,
					maxX: dstMaxX
				}
			});
		});
		// We need the path to animate from right to left
		var linkPathDiagonal = d3.svg.diagonal()
			.source(childrenDivisionMinX)
			.target(parentDivisionMaxX)
			.projection(horizontalProjection);

		var linkPathCustomDiagonal = function(d, i) {
			var mainCurve = linkPathDiagonal(d, i);
			return  mainCurve;
		};

		var linkPathStyle = {
			fill: 'none',
			stroke: function(d) { return "#ababab"; }.bind(this),
			'stroke-width': LINK_STROKE_WIDTH
		};
		var linkPathAttrs = {
			class: "link"+number,
			d: linkPathCustomDiagonal
		};
		var i = 0;
		var linkPaths = layer.selectAll('path.link'+number)
			.data(linkNodes, function(d) { return d.id || (d.id = ++i); });
		linkPaths.enter()
			.append('path')
			.style(linkPathStyle)
			.attr(linkPathAttrs);
		
		linkPaths
			.style(linkPathStyle)
			.attr(linkPathAttrs)
			.transition()
			.duration(TRANSITION_DURATION.BASE)
			.style(linkPathStyle)
			.attr(linkPathAttrs);

		if (withInterfaces) {
			linkPaths.each(this.linkTooltipBindFn);
		}
		linkPaths.exit().remove();
	};
	D3FabricController.prototype.removeExtraLink = function(linkNodes, number){
		var layer = this.linksLayer;
		var i = 0;
		var linkPaths = layer.selectAll('path.link'+number)
			.data(linkNodes, function(d) { return d.id || (d.id = ++i); });

		linkPaths.exit().remove();
	};
	D3FabricController.prototype.removeExtraNodes = function(nodes, number){
		var layer = this.svg;
		var devices = layer.selectAll('g.ftnt-device'+number).data(nodes, function(d){ 
			return d.id || (d.id = (d.depth + '_' + d.name + '_' + d.x));
		});
		
		devices.exit().remove();
	};
	D3FabricController.prototype.renderStatusImage = function(selection){
		//append status icon for policy and pserver
		var circles = selection.filter(function(d){
			if((d.isRoot !== undefined && d.isRoot == true) || (d.isForth !== undefined && d.isForth == true))
				return true;
			else
				return false;
		});
		
		circles.selectAll("circle.status").remove();
		circles.append("circle")
			.attr({
				fill: function(d){
					return STATUS_COLORS[(d.hc_status !== undefined) ? d.hc_status : d.status];
				},
				cx: function(d)
				{
					if(d.isRoot != undefined && d.isRoot == true)
						return ROW.ROOT.WIDTH - 15;
					else if(d.isForth != undefined && d.isForth == true)
						return ROW.FORTH.WIDTH - 15;
				},
				cy: "22",
				r: "8",
				class: "status"
			});
	};

	D3FabricController.prototype.renderToggleIconButtons = function(toggleSelector){
		
		toggleSelector.selectAll("g.tree-toggle").remove();
		
		var toggle_offset_x = Number(ROW.THIRD.WIDTH);
		var toggle_offset_y = Number(ROW.THIRD.HEIGHT)/2;
		var transform = function(d){
			return "translate("+ toggle_offset_x +", " + toggle_offset_y + ")";
		};
		var i = 0;
		var toggleEnter = toggleSelector.append("g")
		.attr({
			class: "tree-toggle chart-visual-toggle",
		        transform: transform,
		        "pointer-events": "all",
			id: function(d){ return d.id || (d.id = ++i);}
		})
		.style({
			cursor: 'pointer',
		});
		var toggleIconClassFn = function(d){
			var cls = (d.children && d.children.length) ? "fa-minus-square" : "fa-plus-square";
			return "f-icon " + cls;
		};
		var iconUnicodeFn = function(d){
			var ucd = (d.children && d.children.length) ? "\uE125" : "\uE0E4"; 
			return ucd;
		};
		var toggleIconAttrs = {
			y: TOGGLE_WIDTH/2,
			fill: "black",
			"font-family": "fa-icons",
			"font-size": toPx(TOGGLE_WIDTH),
			class: toggleIconClassFn,
			"pointer-events": "all"
		};
		
		toggleEnter.append("rect")
		.attr({
			width: TOGGLE_WIDTH,
			height: TOGGLE_WIDTH,
			fill: "#fff",
			y: -TOGGLE_WIDTH/2
		});
		toggleEnter.append("text")
		.attr(toggleIconAttrs)
		.text(iconUnicodeFn);

	};
	
	D3FabricController.prototype.toggleIconClickBindFn = function(){
		var that = this;
		var data = this.data;
		return function(d){
			var $this = $(this);
			
			var collapseCheckFn = function(){
				var toggle_persist;
				toggle_persist = fweb.util.persist.get(TOGGLE_PERSIST);

				return ((toggle_persist==null) || (toggle_persist.indexOf(d.id)<0)) ? false : true; 
			};

			var toggleClickFn = function(){
				var id;
				id = (d.parent.isMid !== undefined && d.parent.isMid === true) ? (d.parent.parentFtnt + "_" + d.parentFtnt) : d.parentFtnt;
				if(d.children && d.children.length)
				{
					d._chidren = d.children;
					d.children = null;
					persist.push(id);
					
					if(d._children === undefined || d._children === null) that.sendRequest();
				}
				else
				{
					d.children = d._chidren;
					d._chidren = null;
					var start = persist.indexOf(id);
					if(start >= 0)
						persist.splice(start, 1);
					
					if(d.children === undefined || d.children === null) that.sendRequest();
				}
				fweb.util.persist.put(TOGGLE_PERSIST, persist);
				if(d.parent.isMid !== undefined && d.parent.isMid === true) // Content Routing
				{
					//id = d.parent.parentFtnt + "_" + d.parentFtnt;
					data.map(function(nodeObj){
						if(nodeObj.name === d.parent.parentFtnt)
						{
							nodeObj.children.map(function(routeObj, index){
								if(routeObj.name === d.parentFtnt)
									nodeObj.children[index].children[0] = d;
							});
						}
					});
				}
				else if(d.parent.isRoot !== undefined && d.parent.isRoot == true) //Server Pool
				{
					//id = d.parentFtnt;
					data.map(function(nodeObj){
						var chld = nodeObj.children[0];
						nodeObj.children[0] = (nodeObj.name === d.parentFtnt)?d:chld;
					});
				}
				that.update(data);
			};

			$this.off("click").on("click", toggleClickFn);
		}
	};

	D3FabricController.prototype.createPolicyTooltipBindFn = function(d) {
		var $this = $(this);
		var tooltipDiv = $("div.pop-up-menu");
		var getNameFn = function(d){
			if(d.isRoot == true)
				return $j.getInfo("policy_name");
			else if(d.isMid == true)
				return $j.getInfo("hcr_name");
			else if(d.isLeaf == true)
				return $j.getInfo("sp_name");
			else if(d.isForth == true)
				return $j.getInfo("pserver_name");
			else
				return $j.getInfo("name");
		};
		var attrs = [{
			key: 'name',
			lang: getNameFn(d)
		},{
			key: "type",
			lang: $j.getInfo("server_type")
		},{
			key: 'ip_domain',
			lang: $j.getInfo("ip_domain")
		},{
			key: 'ip6',
			lang: $j.getInfo("ip_domain")
		},{
			key: 'port',
			lang: $j.getInfo("port")
		},{
			key: 'https_port',
			lang: $j.getInfo("https_port")
		},{
			key: "protocol",
			lang: $j.getInfo("protocol")
		},{
			key: "monitor_mode",
			lang: $j.getInfo("monitor_mode")
		},{
			key: "is_default",
			lang: $j.getInfo("default_policy")
		},{
			key: "sp_mode",
			lang: $j.getInfo("mode")
		},{
			key: "algo",
			lang: $j.getInfo("load_balance_algo")
		},{
			key: "weight",
			lang: $j.getInfo("weight")
		},{
			key: "ssl",
			lang: $j.getInfo("ssl_status")
		},{
			key: "hc_status",
			lang: $j.getInfo("hc_status")
		}];
		var statusOptions = ["fa-status-down", "fa-status-up", "fa-status-down-disabled"];
		var tiphtml = '<div class="qtip-content"><table class="table slightly-condensed key-value select-tooltip-table"><tbody>';
		attrs.forEach(function(attr) {
			var val = d[attr.key];
			var str = '';
			if (typeof(val) != 'undefined') {
				if(attr.key == 'sp_item')
				{
					val.forEach(function(item){
						tiphtml += ['<tr>', '<td>', $j.getInfo("server_pool"), 
						'</td>', '<td>', '<f-icon class="', statusOptions[item.hc_status], '">', 
						'</f-icon>', item.ip_domain,':', item.port,'</td>', '</tr>'].join('');
					});
				}
				else
				{
					if(attr.key == "hc_status"){
						var status_text = '';
						if(val == 1){
							status_text = 'healthy';
						}else if(val == 0){
							status_text = 'unhealthy';
						}else{
							status_text = 'unknown';
						}
						tiphtml += ['<tr>', '<td>', attr.lang, '</td>',
						'<td>', $j.getInfo(status_text), '</td>', '</tr>'].join('');
					}else{
						tiphtml += ['<tr>', '<td>', attr.lang, '</td>',
						'<td>', $j.getInfo(val), '</td>', '</tr>'].join('');
					}
				}
			}
		});

		tiphtml += '</div></tbody></table>';

		tooltipDiv.html(tiphtml)
			.css("display", "");

		return tooltipDiv;
	};
	D3FabricController.prototype.createImages = function(){
		var that = this;
		var i = 0;
		angular.forEach(FABRIC_IMAGES, function(value, key){
			var Image = that.defs.append("g")
				.attr({
					id: "image_" + (i++)
				});
			Image.append("path").attr({d: value});
		});
	};

	var D3BubbleFabric = function(){
		return {
			restrict: 'A',
			scope: {
				data: '=',
				interfaceClick: '=',
				tooltipFormatter: '=',
				mode: '@'
			},
			controller: D3FabricController
		};
	};
	app.directive("fD3BubbleFabricChart", D3BubbleFabric);
});
