define(["angular", "app", "jquery", "jquery.smartmarquee"], function(angular, app, $){
	'use strict';
	
	var MAX_LENGTH_PER_LINE = 11;

	var animateScroll = function(){
		return {
			restrict: 'A',
			replace: false,
			scope: {
			},
			link: function(scope, element, attributes){
				$(".animate").smartmarquee({
						duration: 1000,   
						loop : false,      
						interval : 1000, 
						axis : "vertical", 

				});
			}
		};
	};
	
	var serverPoolPolicyController = function($scope, $rootScope){
		$scope.displayVserverList = function(){
			$rootScope.$broadcast("CR:vserverlist", $scope.policyItem);
		};
	};
	var fPolicyContainer = function(){
		return {
			restrict: 'E',
			replace: false,
			scope: {
				policyItem: "@policy"	
			},
			template: '<div class="policyBox">' +
				'<div class="contentTitle"><div class="left-head"><span class="policy-name" title="{{policyItem.name}}"><label>{{policyItem.name}}</label></span></div>' +
				'	<div class="right-head" ng-if="policyItem.vserver_name !== undefined"><span class="policy-ip"><a ng-click="displayVserverList()" title="{{\'vserver_tip\' | lang}}">{{policyItem.vserver_name}}&nbsp;</a>:{{policyItem.http_port}}</span></div>' + 
				//'	<span><img ng-src="{{image_src}}"></span>' + 
				'</div>' + 
				'<div class="contentBody">' +
			        '	<table>' +
				'		<tr><td colspan="2"><span class="pool-name" title="{{policyItem.server_pool.name}}">' +
				'			{{policyItem.server_pool.name}}' + 
				'	        </span></td></tr>' + 
				'		<tr>' + 
				'		    <td><ul class="left-container">' +
				'			<li class="border-line" ng-repeat="pool in policyItem.server_pool.sp_item" ng-class="{hide: $index>4}"></li>' +
				'		    </ul></td>' +
				'		    <td class="animate" animate-scroll>' +
				'			<ul class="right-container container">' +
				'			 <li class="text-indent" ng-repeat="pool in policyItem.server_pool.sp_item" ng-class="{status_up:pool.hc_status==1, status_down: pool.hc_status==0, status_maint: pool.hc_status==2, hide:$index>4}">{{pool.ip_domain}}:{{pool.port}}</li>' +
				'			</ul>' +
				'		    </td>' +
				'		</tr>' +
				'	</table>' +	
				'</div>' +
				'<div class="footerBox"><span class="policyStatus"><img ng-src="{{image_src}}"></span></div>' + 
				'</div>',
			link: function(scope, element, attributes){
				attributes.$observe('policy', function(policy) {
					scope.policyItem = JSON.parse(policy);
					console.log(scope.policyItem);
					var ip6_list = (scope.policyItem.ip6_list !== undefined ? scope.policyItem.ip6_list : []);
					var i = 0;
					for(i=0; i<ip6_list.length; i++)
					{
						var ip6 = ip6_list[i];
						if(ip6.length > 13){
							scope.policyItem.ip6 = ip6.substring(0, 13) + "...";
						}
					}
					scope.image_src = "/images/status_" + (scope.policyItem.status?"up":"down") + ".png";

				});
			},
			controller: serverPoolPolicyController
		};
	};
	
	var contentRoutingController = function($scope, $rootScope, $window, $routeParams){
		$scope.ruleMode = false;
		$scope.vserver_name = $scope.policyItem.vserver_name;
		$scope.showContentRule = function(){
			$scope.ruleMode = true;
			$rootScope.$broadcast("ruleMode");
			$window.location.href = "#/contentRule/" + $scope.policyItem.name;
		};
		$scope.displayVserverList = function(){
			$rootScope.$broadcast("CR:vserverlist", $scope.policyItem);
		};
		$(".contentBody").on("mouseenter", function(){
			$(this).parent(".mainInfo").stop().animate({"margin-top": -300}, 400);
		});
		$(".drillDownInfo").on("mouseleave", function($window){
			$(this).prev().stop().animate({"margin-top": 0}, 400);
		});

	}
	var fContentRouting = function(){
		return {
			restrict: 'E',
			replace: false,
			scope: {
				policyItem: "@policy"
			},
			template: '<div class="policyBox routing">' +
				'<div class="mainInfo" style="margin-top: 0px;">' + 
				'<div class="contentTitle"><div class="left-head"><span class="policy-name" title="{{policyItem.name}}"><label>{{policyItem.name}}</label></span></div>' +
				'	<div class="right-head"><span class="policy-ip"><a ng-click="displayVserverList()" title="{{\'vserver_tip\' | lang}}">{{policyItem.vserver_name}}&nbsp;</a>:{{policyItem.http_port}}</span></div>' + 
				//'	<span><img ng-src="{{image_src}}"></span>' + 
				'</div>' + 
				'<div class="contentBody">' +
			        '	<table>' +
				'		<tr><td colspan="2"><span class="pool-name" title="{{content_routing}}">' +
				//'               <a ng-click="showContentRule()" href="#/contentRule/{{policyItem.name}}">' +
				'			{{content_routing}}' + 
				//'		</a>' + 
				'	        </span></td></tr>' + 
				'		<tr>' + 
				'		    <td><ul class="left-container">' +
				'			<li class="border-line" ng-repeat="route in policyItem.routing" ng-class="{hide: $index>4}"></li>' +
				'		    </ul></td>' +
				'		    <td class="animate" animate-scroll>' +
				'			<ul class="right-container container">' +
				'			 <li class="text-no-indent" ng-repeat="route in policyItem.routing" ng-class="{hide:$index>4}" title="{{route.name}}"><nobr>{{route.name}}</nobr></li>' +
				'			</ul>' +
				'		    </td>' +
				'		</tr>' +
				'	</table>' +	
				'</div>' +
				'<div class="footerBox"><span class="policyStatus"><img ng-src="{{image_src}}"></span></div>' + 
				'</div>' + 
				'<div class="drillDownInfo" style="padding-top: 180px;" ng-click="showContentRule()">' +
				'	{{slide_text}}' +
				'</div>' + 
				'</div>',
			link: function(scope, element, attributes){
				attributes.$observe('policy', function(policy) {
					scope.policyItem = JSON.parse(policy);
					var ip6_list = (scope.policyItem.ip6_list !== undefined ? scope.policyItem.ip6_list : []);
					var i = 0;
					for(i=0; i<ip6_list.length; i++)
					{
						var ip6 = ip6_list[i];
						if(ip6.length > 13){
							scope.policyItem.ip6 = ip6.substring(0, 13) + "...";
						}
					}
					scope.image_src = "/images/status_" + (scope.policyItem.status?"up":"down") + ".png";
				});
				scope.content_routing = $j.getInfo("content_routing");
				scope.slide_text = $j.getInfo("slide_text");
			},
			controller: contentRoutingController
		};
	};

	
	var fContentRule = function(){
		return {
			restrict: 'E',
			replace: false,
			scope: {
				ruleItem: "@rule"	
			},
			template: '<div class="policyBox">' +
				'<div class="contentTitle"><span class="rule-name" title="{{ruleItem.name}}">{{ruleItem.name}}</span>' +
				'</div>' + 
				'<div class="contentBody">' +
			        '	<table>' +
				'		<tr><td colspan="2"><span class="pool-name" title="{{ruleItem.server_pool.name}}">' +
				'			{{ruleItem.server_pool.name}}' + 
				'	        </span></td></tr>' + 
				'		<tr>' + 
				'		    <td><ul class="left-container">' +
				'			<li class="border-line" ng-repeat="pool in ruleItem.server_pool.sp_item" ng-class="{hide: $index>4}"></li>' +
				'		    </ul></td>' +
				'		    <td class="animate" animate-scroll>' +
				'			<ul class="right-container container">' +
				'			 <li class="text-indent" ng-repeat="pool in ruleItem.server_pool.sp_item" '+
				'			     ng-class="{status_up:pool.hc_status==1, status_down: pool.hc_status==0, status_maint: pool.hc_status==2, hide:$index>4}">{{pool.ip_domain}}:{{pool.port}}</li>' +
				'			</ul>' +
				'		    </td>' +
				'		</tr>' +
				'	</table>' +	
				'</div>' +
				'</div>',
			link: function(scope, element, attributes){
				attributes.$observe('rule', function(rule) {
					scope.ruleItem = angular.fromJson(rule);
				});
			}
		};
	};

	var VserverListController = function($scope, $rootScope){
		$scope.turnBack = turnBack;
		function turnBack(){
			$scope.vserver = false;
		}
	};
	
	var fVserverList = function(){
		return {
			restrict: 'E',
			replace: false,
			scope: {
				vserver_name: "@vserver",
				vserver: "=ngModel"
			},
			template: '<div class="policyBox">' +
				'<div class="contentTitle"><span class="rule-name" title="{{\'vserver_list\' | lang }}">{{\'vserver_list\' | lang}}</span><span class="link-back"><a ng-click="turnBack()"><&nbsp;{{\'back\' | lang}}</a></span>' +
				'</div>' + 
				'<div class="contentBody">' +
				'		<div><span class="pool-name title-padding" title="{{vserver_name}}">' +
				'			{{vserver_name}}' + 
				'	        </span></div>' + 
				'		<div class="list">' + 
				'			<ul class="right-container container space" ng-class="{rowup: ipList.length > 5}">' +
				'			 <li class="text-indent-bottom" ng-repeat="item in ipList track by $index" '+
				'			     ng-class="">{{item.ip}}</li>' +
				'			 <li ng-if="ipList.length > 5" class="text-indent-bottom" ng-repeat="item in ipList track by $index" '+
				'			     ng-class="">{{item.ip}}</li>' +
				'			</ul>' +
				'		</div>' +
				'</div>' +
				'</div>',
			link: function(scope, element, attributes){
				attributes.$observe('list', function(val) {
					if(val !== "")
						scope.ipList = angular.fromJson(val);
				});
			},
			controller: VserverListController
		};
	};
	app.directive("animateScroll", animateScroll)
	.directive("fPolicyContainer", fPolicyContainer)
	.directive("fContentRouting", fContentRouting)
	.directive("fContentRule", fContentRule)
	.directive("fVserverList", fVserverList);
});
