/*globals define*/
define([
    'angular',
    'module',
    'jquery',
    'fweb',
    'ftnt_shared',
    'select_setup',
    'slide_setup',
    'ng/services/loader',
    'ng/services/interceptor',
    'ng/services/ftnt',
    'ng/services/persistent_storage',
    'ng/services/injector',
    'ng/services/reboot',
    'ng/services/route',
    'ng/services/slide',
    'ng/services/state',
    'ng/services/password',
    'ng/services/ensure_dcsrf',
    'ng/services/vdom_state',
    'ng/directives/qlist',
    'ng/directives/f-list',
    'ng/directives/head',
    'ng/directives/ftnt',
    'ng/directives/menu/menu',
    'ng/filters/ftnt',
    'ng/structure/services/structure',
    'ng/structure/services/shortcuts',
    'ng/prompt/services'
],
function(angular, module) {
    'use strict';

    var CSS = [
        '/ng/log/view/main.css',
        '/module_css/widget.css',
        '/ng/directives/faceted_search/faceted_search.css',
        '/css/logdisplay.css',
        // '/p/sprite/app_logos/sprite_map.css',
        // '/module_css/top_sessions.css',
        '/css/flag_icons.css',
        '/ng/fortiview/styles/main.css'
    ];

    var fortiview = angular.module('fortiview', [
        'ngRoute', 'ngSanitize', 'ngCookies', 'ngResource', 'ngAnimate', 'route-segment',
        'view-segment', 'ftnt', 'ui.jq', 'ui.event', 'ui.mask', 'ui.validate',
        'ui.sortable', 'ftnt-gui'
    ]);

    fortiview.config(function($locationProvider, $httpProvider, $routeSegmentProvider, $routeProvider, $injector, loaderProvider) {
    	var main_template = 'fortiview/views/main.html';
    	var drilldown_template = 'fortiview/views/drilldown.html';
    	$routeSegmentProvider.options.autoLoadTemplates = true;

    	$locationProvider.html5Mode(true);
        //$httpProvider.interceptors.push('ftntInterceptor');


        $routeSegmentProvider
        .when('/fortiview/threatmap', 'threatmap')
        .segment('threatmap', {
            templateUrl: '/ng/threatmap/base.html',
            controller: 'ThreatMapController',
            css: [
                '/ng/threatmap/main.css',
                //'/module_css/flag_icons.css'
            ],
            resolve: loaderProvider.resolve([
                '/ng/directives/d3',
                '/ng/threatmap/controllers'
            ])
        })
        .when('/fortiview/scanner_integration', 'scannerIntegration')
        .segment('scannerIntegration', {
            templateUrl: '/ng/fortiview/views/scanner_integration.html',
            controller: 'ScannerIntegrationController',
            css: CSS,
            resolve: loaderProvider.resolve([
                '/ng/fortiview/scripts/controllers/scannerIntegration', '/ng/services/fortigateInfo'
            ])
        })
        .when('/fortiview/tSource', 'fortiview.tSource')
        .when('/fortiview/tSource/:drilldownValue',
            'fortiview.tSourceDrilldown')
        .when('/fortiview/tCountry', 'fortiview.tCountry')
        .when('/fortiview/tCountry/:drilldownValue',
            'fortiview.tCountryDrilldown')
	.when('/fortiview/aPolicy', 'fortiview.aPolicy')
	.when('/fortiview/aPolicy/:drilldownValue',
	    'fortiview.aPolicyDrilldown')
        .when('/fortiview/threat', 'fortiview.threat')
        .when('/fortiview/threat/:drilldownValue',
              'fortiview.threatDrilldown')
        .when('/fortiview/country', 'fortiview.country')
        .when('/fortiview/country/:drilldownValue',
            'fortiview.countryDrilldown')
        .when('/fortiview/sources', 'fortiview.sources')
        .when('/fortiview/sources/:drilldownValue',
            'fortiview.sourcesDrilldown')
        .when('/fortiview/policies', 'fortiview.policies')
        .when('/fortiview/policies/:drilldownValue',
            'fortiview.policiesDrilldown')
        .when('/fortiview/:segment/:drilldownValue/sessions/:tab/:drilldownTabValue',
            'fortiview.sessionsDrilldown')
        .when('/fortiview/:segment/:type/:drilldownValue/:tab/:drilldownTabValue',
            'fortiview.sessionDrilldown')
        .when('/fortiview/:segment/:drilldownValue/:tab/:drilldownTabValue',
            'fortiview.sessionDrilldown')
        .segment('fortiview', {
            templateUrl: 'fortiview/views/root.html',
            css: CSS,
            controller: 'Fortiview',
            resolve: loaderProvider.resolve([
                '/ng/fortiview/scripts/controllers/root', '/ng/services/fortigateInfo'
            ], module)
        })
        .within()
            .segment('sessionsDrilldown', {
                templateUrl: main_template,
                controller: 'FortiviewSessionsDrilldown',
                resolve: loaderProvider.resolve(['/ng/fortiview/scripts/controllers/sessionsDrilldown'], module)
            })
            .segment('sessionDrilldown', {
                templateUrl: main_template,
                controller: 'FortiviewSessions',
                resolve: loaderProvider.resolve(['/ng/fortiview/scripts/controllers/session'], module)
            })
            .segment('tSource', {
                templateUrl: main_template,
                controller: 'FortiviewSource',
                resolve: loaderProvider.resolve(['/ng/fortiview/scripts/controllers/tSource'], module)
            })
            .segment('tSourceDrilldown', {
                templateUrl: drilldown_template,
                controller: 'FortiviewSourceDrilldown',
                dependencies: ['drilldownValue'],
                resolve: loaderProvider.resolve(['/ng/fortiview/scripts/controllers/tSourceDrilldown'], module),
                untilResolved: { template: '{{ "Loading..." | lang }}' }
            })
            .segment('tCountry', {
                templateUrl: main_template,
                controller: 'FortiviewTCountry',
                resolve: loaderProvider.resolve(['/ng/fortiview/scripts/controllers/tCountry'], module)
            })
            .segment('tCountryDrilldown', {
                templateUrl: drilldown_template,
                controller: 'FortiviewTCountryDrilldown',
                dependencies: ['drilldownValue'],
                resolve: loaderProvider.resolve(['/ng/fortiview/scripts/controllers/tCountryDrilldown'], module),
                untilResolved: { template: 'Loading...' }
            })
	    .segment('aPolicy', {
		templateUrl: main_template,
		controller: 'FortiviewAPolicy',
		resolve: loaderProvider.resolve(['/ng/fortiview/scripts/controllers/aPolicy'], module)
	    })
	    .segment('aPolicyDrilldown', {
		templateUrl: drilldown_template,
		controller: 'FortiviewAPolicyDrilldown',
		dependencies: ['drilldownValue'],
		resolve: loaderProvider.resolve(['/ng/fortiview/scripts/controllers/aPolicyDrilldown'], module),
		untilResolved: {template: 'Loading...'}
	    })
            .segment('threat', {
                templateUrl: main_template,
                controller: 'FortiviewThreat',
                resolve: loaderProvider.resolve(['/ng/fortiview/scripts/controllers/threat'], module)
            })
            .segment('threatDrilldown', {
                templateUrl: drilldown_template,
                controller: 'FortiviewThreatDrilldown',
                dependencies: ['drilldownValue'],
                resolve: loaderProvider.resolve(['/ng/fortiview/scripts/controllers/threatDrilldown'], module)
            })
            .segment('country', {
                templateUrl: main_template,
                controller: 'FortiviewCountry',
                resolve: loaderProvider.resolve(['/ng/fortiview/scripts/controllers/country'], module)
            })
            .segment('countryDrilldown', {
                templateUrl: drilldown_template,
                controller: 'FortiviewCountryDrilldown',
                dependencies: ['drilldownValue'],
                resolve: loaderProvider.resolve(['/ng/fortiview/scripts/controllers/countryDrilldown'], module),
                untilResolved: { template: 'Loading...' }
            })
            .segment('sources', {
                templateUrl: main_template,
                controller: 'FortiviewSources',
                resolve: loaderProvider.resolve(['/ng/fortiview/scripts/controllers/sources'], module)
            })
            .segment('policies', {
                templateUrl: main_template,
                controller: 'FortiviewPolicies',
                resolve: loaderProvider.resolve(['/ng/fortiview/scripts/controllers/policies'], module)
            })
            .segment('sourcesDrilldown', {
                templateUrl: drilldown_template,
                controller: 'FortiviewSourcesDrilldown',
                dependencies: ['drilldownValue'],
                resolve: loaderProvider.resolve(['/ng/fortiview/scripts/controllers/sourcesDrilldown'], module),
                untilResolved: { template: 'Loading...' }
            })
            .segment('policiesDrilldown', {
                templateUrl: drilldown_template,
                controller: 'FortiviewPoliciesDrilldown',
                dependencies: ['drilldownValue'],
                resolve: loaderProvider.resolve(['/ng/fortiview/scripts/controllers/policiesDrilldown'], module),
                untilResolved: { template: 'Loading...' }
            })

    });

    // fortiview.config(function($httpProvider) {
    //     $httpProvider.interceptors.push('templateUrlInterceptor');
    // });

    // // ensure that the template is fetched via the cache url, especially since
    // // the
    // // server will often 400 error if it's not
    // fortiview.factory('templateUrlInterceptor', function() {
    //     /*global fweb*/
    //     var GUI_NO;
    //     if (typeof fweb !== 'undefined') { GUI_NO = fweb.CONFIG_GUI_NO; }
    //     return {
    //         request: function(config) {
    //             if (GUI_NO && /^fortiview\/views\/.*.html$/.test(config.url)) {
    //                 config.url = '/ng/' + config.url;
    //             }
    //             return config;
    //         }
    //     };
    // });

    return fortiview;
});
