(function(require) {
    'use strict';

    require.config({
        WaitSeconds: 0,
        baseUrl: '/',
        paths: {
		'app': 'ng/fortiview/app',
		'jquery': 'js/jquery-1.11.2.min',
		'angular' : 'ng/angular_lib',
		'server_pool': 'ng/fortiview/controllers/server_pool',
		'policy_view': 'ng/fortiview/directives/policy_view',
		'jquery.smartmarquee': 'js/jquery.smartmarquee',
		'd3': 'js/d3',
		'd3_fabric': 'ng/directives/d3_fabric', 
		'd3_bubble_fabric': 'ng/fortiview/directives/d3_bubble_fabric_chart',
		'ng/services/injector': 'ng/fortiview/services/injector',
		'jquery.debounce': 'js/jquery.ba-throttle-debounce.min',
		'fweb_core_all': 'js/fweb_core_all',
		'constants': 'ng/services/chart/constants',
		'base_ftnt_object': 'ng/services/chart/base_ftnt_object',
		'bubble_cluster': 'ng/services/chart/bubble_cluster',
		'device_type': 'ng/services/chart/device_type',
		'topology_tree': 'ng/services/chart/topology_tree',
		'd3_images': 'ng/fortiview/directives/d3_images',
		'lang.wizard': '/fgt_lang.js?type=0&paths=fortiview/fabric/lang/:server_pool',
		'lang': 'ng/lang'
	},
	shim: {
	    'jquery': {
	            exports : 'jQuery'
	    },
            'angular': {exports : 'angular'},
	    'jquery.smartmarquee': {
		    deps: ['jquery'],
		    exports: 'smartmarquee'
	    },
	    'jquery.debounce': {
		    deps: ['jquery']
	    },
	    'lang.wizard': {
		    exports : 'fgt_lang'
	    }
        }
    });


    require(['angular','jquery', 'jquery.smartmarquee','server_pool', 'policy_view', 'd3_bubble_fabric', 'lang'], function(angular){
        require(['app'], function(app){
             var $html = angular.element(document.documentElement);
                angular.element(document).ready(function() {
                    angular.bootstrap($html, [app.name]);
                });

        });
    });

})(require);
