/*globals define*/
define(['module', 'angular', './mainBase'],
function(module, angular, mainCtrl) {
	'use strict';

	/*jshint maxparams:10*/
	function FortiviewAPolicy($scope, $injector, $location, $q, fortiviewUtil,
		fortiviewSearchState,
		fortiviewFacets) {
		this.scope = $scope;
		$injector.invoke(this.init, this);
		fortiviewSearchState.disableRealtime();

		fortiviewUtil.onLangUpdatedApply($scope,
			'fortiview$root.category_title',
			'{{ "Threats Policy" | lang }}');

		this.watchSearchState();

		this.drilldownTo = function(entry) {
			$location.path($location.path() + '/' + entry.policy);
		};

		$scope.drilldownDisplayItems = this.getSummaryItems([
			'TNumber', 'TScore', 'actions', 'services', 'time'
		]);
		this.sourceSortBy = "TNumber";
		$scope.qlistOptions = this.makeQlistConfig({
			prefix: "qlist_threats",
			default_columns: ["policy", "TNumber", "TScore", "actions", "services"],
			columns: [
				{ selector: 'policy', lang_key: 'Server Policy'},
				{ selector: 'TNumber', lang_key: 'Threat Number'},
				{ selector: 'TScore', lang_key: 'Threat Score'},
				{ selector: 'actions', lang_key: 'Action (Block/Alert)'},
			],
			options: {
				sort_source_order: {
					selector: 'TNumber',
					direction: 'desc'
				}
			}
		});

		this.initQlist();
	}

	return function(providers, loader) {
		providers.$controller.register('FortiviewAPolicy', mainCtrl(FortiviewAPolicy));
		return loader.initModules(['../services/util'].concat(mainCtrl.requires), module);
	};

});
