/*globals define*/
define(['module', 'angular', './drilldownBase'], function(module, angular, drilldown) {
    'use strict';

    //FWB_CHANGE function ThreatPolicyDrilldown($scope, $injector, $interpolate, fortiviewUtil, fortiviewSessions) {
    function APolicyDrilldown($scope, $injector, $interpolate, fortiviewUtil, fortiviewSessions, fortiviewSearchState) {
        var blocked_tabs = [
            "sources",
            "policies",
            "destinations",
            "sessions",

            "tSource",
            "tCountry",
            "tDestination",
            "tPolicy",
            "tHttpHost",
            "tHttpMethod",
            "tHttpRetcode",
            "tHttpUrl",
	    // "threat",
	    // "source",
	    // "device",
	    // "country",
	    // "http_url",
	    // "http_method",
        ];
        $injector.invoke(this.init, this, {$scope: $scope, blocked_tabs: blocked_tabs});

        fortiviewSearchState.disableRealtime();//FWB_CHANGE

        $scope.drilldownDisplayItems = this.getSummaryItems([
            'TNumber', 'TScore', 'actions', 'services', 'time'
        ]);

        $scope.drilldownTabs.current = 'signature_cve_id';
        $scope.drilldownData = {
            threat: {qlistOptions: this.makeQlistConfig('threat')},
            country: {qlistOptions: this.makeQlistConfig('country')},
            action: {qlistOptions: this.makeQlistConfig('action')},
            source: {qlistOptions: this.makeQlistConfig('source')},
            device: {qlistOptions: this.makeQlistConfig('device')},
            http_method: {qlistOptions: this.makeQlistConfig('http_method')},
            http_url: {qlistOptions: this.makeQlistConfig('http_url')},
            signature_cve_id: {qlistOptions: this.makeQlistConfig('signature_cve_id')},
	    owasp_top10: {qlistOptions: this.makeQlistConfig('owasp_top10')},
        };
        this.reloadData();
    }
    return function(providers, loader) {
        providers.$controller
            .register('FortiviewAPolicyDrilldown', drilldown(APolicyDrilldown));
        return loader.initModules(drilldown.requires, module);
    };
});
