/*globals define*/
define(['module', 'angular', './mainBase', 'ng/services/lang',
    'ng/services/injector'
], function(module, angular, mainCtrl) {
    'use strict';

    //FWB_CHANGE function Country($injector, $scope, $location, fortiviewUtil) {
    function Country($injector, $scope, $location, fortiviewUtil, fortiviewSearchState) {
        this.scope = $scope;
        $injector.invoke(this.init, this);

        fortiviewSearchState.disableRealtime();//FWB_CHANGE

        fortiviewUtil.onLangUpdatedApply($scope,
            'fortiview$root.category_title', '{{ "Countries" | lang }}');

        this.watchSearchState();

        this.drilldownTo = function(entry) {
            //FWB_CHANGE $location.path($location.path() + '/' + encodeURIComponent(entry.country));
            $location.path($location.path() + '/' + encodeURIComponent(entry.srccountry));
        };

        /*FWB_CHANGE $scope.qlistOptions = this.makeQlistConfig({
            prefix: 'qlist_country',
            default_columns: ['country', 'data_bytes', 'sessions', 'data_bandwidth'],
            columns: [
                { selector: 'country', lang_key: 'country' }
            ],
            format_fn: {
                country: fortiviewUtil.format_fn.country
            }
        });*/
        $scope.drilldownDisplayItems = this.getSummaryItems([
            'TNumber', 'TScore', 'actions', 'services', 'time'
        ]);
        this.sourceSortBy = "TNumber";
        $scope.qlistOptions = this.makeQlistConfig({
            prefix: "qlist_country",
            default_columns: ["srccountry", "TNumber", "TScore", "actions", "services"],
            columns: [
                { selector: 'TNumber', lang_key: 'Threat Number'},
                { selector: 'TScore', lang_key: 'Threat Score'},
                { selector: 'actions', lang_key: 'Action (Block/Alert)'},
                { selector: 'srccountry', lang_key: 'Country'},
            ],
            options: {
                sort_source_order: {
                    selector: 'TNumber',
                    direction: 'desc'
                }
            }
        });

        this.initQlist();
    }

    return function register(providers, loader) {
        providers.$controller.register('FortiviewCountry', mainCtrl(Country));
        return loader.initModules([
            '../services/util', '../services/searchState'
        ].concat(mainCtrl.requires), module);

    };

});
