/*globals define*/
define(['module', 'angular', './drilldownBase'], function(module, angular, drilldown) {
    'use strict';

    //FWB_CHANGE function CountryDrilldown($scope, $injector, $interpolate, fortiviewUtil, fortiviewSessions) {
    function CountryDrilldown($scope, $injector, $interpolate, fortiviewUtil, fortiviewSessions, fortiviewSearchState) {
        var blocked_tabs = [
            "sources",
            "policies",
            "destinations",
            "sessions",
	    "aPolicy",
//	    "signature_cve_id",

            "tSource",
            "tCountry",
            "tDestination",
            "tPolicy",
            "tHttpHost",
            "tHttpMethod",
            "tHttpRetcode",
            "tHttpUrl"
        ];
        $injector.invoke(this.init, this, {$scope: $scope, blocked_tabs: blocked_tabs});

        fortiviewSearchState.disableRealtime();//FWB_CHANGE

        /*FWB_CHANGE $scope.drilldownDisplayItems = this.getSummaryItems([
            'app', 'cloud', 'web', 'threat_count', 'data', 'common'
        ]);*/
        $scope.drilldownDisplayItems = this.getSummaryItems([
            'TNumber', 'TScore', 'actions', 'services', 'time'
        ]);

        /*FWB_CHANGE $scope.drilldownData = {
            application: {qlistOptions: this.makeQlistConfig('application')},
            source: {qlistOptions: this.makeQlistConfig('source')},
            destination: {qlistOptions: this.makeQlistConfig('destination')},
            policy: {qlistOptions: this.makeQlistConfig('policy')},
            threat: {qlistOptions: this.makeQlistConfig('threat')},
            session: {qlistOptions: fortiviewSessions.createQlistConfig(this.reloadQlistData)}
        };
        fortiviewUtil.get_additional_drilldown_tabs().forEach(function(tab) {
            $scope.drilldownData[tab] = {qlistOptions: this.makeQlistConfig(tab)};
        }.bind(this));*/
        $scope.drilldownData = {
            threat: {qlistOptions: this.makeQlistConfig('threat')},
            action: {qlistOptions: this.makeQlistConfig('action')},
            source: {qlistOptions: this.makeQlistConfig('source')},
            device: {qlistOptions: this.makeQlistConfig('device')},
            http_method: {qlistOptions: this.makeQlistConfig('http_method')},
            http_url: {qlistOptions: this.makeQlistConfig('http_url')},
	    signature_cve_id: {qlistOptions: this.makeQlistConfig('signature_cve_id')},
	    owasp_top10: {qlistOptions: this.makeQlistConfig('owasp_top10')},
        };
        this.reloadData();
    }
    return function(providers, loader) {
        providers.$controller
            .register('FortiviewCountryDrilldown', drilldown(CountryDrilldown));
        return loader.initModules(drilldown.requires, module);
    };
});
