/*globals define*/
define([
    'angular', 'jquery', 'widgets', 'fweb.util/formatters', 'ng/services/injector',
    'qed_list', 'ng/services/ftnt', 'ng/filters/ftnt'
], function(angular, $, widgets, formatters, inject) {
    'use strict';

    // this controller inheritance roughly follows
    // http://jsfiddle.net/mhevery/u6s88/12/

    var exports, extendsDrilldownBase;

    var lazyPromise = function(target, args, transform) {
        var wrapper = {
            then: function() {
                var wrapped = wrapper.wrapped;
                if (wrapped == null) {
                    wrapper.wrapped = wrapped = target.apply(this, args || []);
                    wrapped.then(function() {
                        wrapper.resolved = true;
                    });
                    if (transform) {
                        wrapper.wrapped = wrapped = transform(wrapped);
                    }
                }
                return wrapped.then.apply(wrapped, arguments);
            }
        };
        return wrapper;
    };

    var Base = function() {};

    Base.prototype.init = function($scope, $q, injector, fortiviewSearchState,
                                   fortiviewVisualization, fortiviewData, fortiviewGraph, blocked_tabs) {
        var ss = fortiviewSearchState;

        injector.injectMarked(this, {$scope: $scope});
        this.scope = $scope;
        $scope.fortiview$root.view_type = null;
        $scope.fortiview$root.hide_all_view_types = false;
        ss.clear_timeframe_filter();
        $scope.summaryRows = this.summaryRows.bind(this);
        this.setCommonScopeValues(blocked_tabs);
        this.setPageTitle();

        $scope.drilldownTo = this.drilldownTo;
        $scope.excludeDrilldown = {
            session: true
        };

        $scope.visualization = fortiviewVisualization;
        $scope.excludeGraph = {
            session: true,
            files: true,
            videos: true,
            'sandbox-file': true
        };
	$scope.fortiviewData = fortiviewData;
	$scope.fortiviewGraph = fortiviewGraph;
        ss.drilldownValues = this.get_drilldown_values();
        var dataLoading = $q.defer();
        this.dataLoading = dataLoading.promise;
        this.reloadData = function() {
            var realtime = ss.state.timeframe === 'realtime';
            Object.keys(this.scope.drilldownData).forEach(function(key) {
                var data = this.scope.drilldownData[key];
                data.qlistOptions.columns.forEach(function(column) {
                    if (['score', 'level', 'duration'].indexOf(column.selector) >= 0) {
                        column.hidden = realtime;
                    }
                    if (['data_packets', 'tx_packets', 'rx_packets', 'data_bandwidth',
                         'data_shaper_drops']
                        .indexOf(column.selector) >= 0) {
                        column.hidden = !realtime;
                    }
                    /*FWB_CHANGE
                    if (column.selector === 'sessions') {
                        column.lang_key = realtime ? 'Sessions' : 'Sessions (Blocked/Allowed)';
                    }
                    */
                });
                data.d3TooltipFormatter = fortiviewVisualization.createTooltipFormatter(
                    data.qlistOptions);
                if (this.drilldownTo &&
                    (!$scope.excludeDrilldown || !$scope.excludeDrilldown[key])) {
                    data.d3Drilldown = function(entry) {
                        this.drilldownTo(entry, key);
                    }.bind(this);
                }
            }.bind(this));
            this.summaryLoaded = false;
            this.recalculateTimePeriod();
            this.watchAutoReload();
            this.reloadQlistData();
            dataLoading.resolve();
        }.bind(this);

        this.watchDrilldownFacet();
        this.watchSearchState();
        this.watchCurrentTab();
        this.updateLogViewOptions();

        // Default to 'Source' since 'Application' generally excludes unscanned
        // traffic and this looks like something is missing on first glance.
        angular.extend($scope.drilldownTabs, {
            //FWB_CHANGE current: 'source',
            current: 'threat',
            all: $scope.availableTabs
        });
        this.update_visible_tabs();
        this.tabsSortBy = {};

        $scope.$on('reload', function() {
        	// fortiviewSearchState.segmentData = null; //FWB_CHANGE
        	$scope.update_period(); //FWB_CHANGE
            $scope.graph = null;
            this.graphs = {};
            this.reloadData();
        }.bind(this));

        this.graphs = {};
        $scope.$on('updateGraph', function() {
            $scope.graph = null;
            var key = this.getGraphCacheKey($scope.drilldownTabs.current);
            if (key.indexOf('realtime') === 0) {
                $scope.graph = null;
            } else if (this.graphs[key]) {
                $scope.graph = this.graphs[key];
            }
        }.bind(this));

        // Sync current tab sortBy with scope
        $scope.sort = {value: this.sourceSortBy};
        $scope.$watch(function() {
            return this.currentSourceSortBy();
        }.bind(this), function(value) {
            this.scope.sort.value = value;
            this.scope.d3LegendValueFormatter =
                    fortiviewVisualization.createLegendValueFormatter(value);
        }.bind(this));
        this.scope.$watch('sort.value', function(value) {
            this.sourceSortBy = value;
            this.reloadQlistData();
        }.bind(this));
    };

    /**
     * @virtual
     */
    Base.prototype.get_drilldown_values = inject.mark(function($routeParams) {
        return function() {
            var values = {};
            values[this.getPrimaryFacet().id] = [decodeURIComponent($routeParams.drilldownValue)];
            return values;
        };
    });
    Base.prototype.setCommonScopeValues =
    /* jshint maxparams: 8 */
    inject.mark(function($scope, $q, $timeout, fortiviewSearchState, fortiviewFacets,
                         fortiviewRouteMetadata, fortiviewUtil, fortiviewVisualization) {
        var ss = fortiviewSearchState;
        return function(blocked_tabs) {
            var searchOptions = ss.searchOptions;
            searchOptions.entries = entries_getter;

            $scope.facets = fortiviewFacets.facets;

            $scope.fortiview$root.setSearchFacets(fortiviewFacets.forCurrent());
            var primary_facet = this.getPrimaryFacet();
            if (primary_facet) {
                ss.facets.forEach(function(sf) {
                    if (sf.id === primary_facet.id) {
                        sf.unique = true;
                    }
                });
            }

            $scope.drilldownTabs = {
                useLogView: {'session': true}
            };
            $scope.summary = {};

            // used to format the summary. this object is in the following format:
            $scope.drilldownDisplayItems = [
                // { text: '', key: ''},
                // { text: '', getter: function(object) {
                //                      return object.listdata.length } },
                // { text: '', templateUrl: 'path/to/tmpl.html', show: fn():bool },
                // not implemented. would be in directive
                // { text: '', expr: '{{ object.listdata.length }}' } },
            ];

            $scope.segment = fortiviewRouteMetadata.baseSegment();

            if ($scope.availableTabs == null) {
                var segment = fortiviewRouteMetadata.baseSegment(false);
                blocked_tabs = (blocked_tabs || [])
                    /*FWB_CHANGE .concat([
                        segment, 'web', 'cloud', 'system', 'admin', 'vpn', 'unauth', 'sandbox',
                        'wificlient', 'interface', 'device', 'shaper', 'learningReport'
                    ]);*/
                    .concat([segment]);
                $scope.availableTabs = fortiviewRouteMetadata
                                            .availableSegmentBases
                                            .filter(not(blocked_tabs));
                var additional_tabs = fortiviewUtil.get_additional_drilldown_tabs();
                $scope.availableTabs.push
                    .apply($scope.availableTabs, additional_tabs);
                $scope.availableTabs.sort(session_last);
                $scope.asb = fortiviewRouteMetadata.availableSegmentBases;
            }
            function session_last(a, b) {
                return (a === 'session' ? 1 : 0) + (b === 'session' ? -1 : 0);
            }

            this.get_default_sort = function(tab) {
                /*FWB_CHANGE var default_sort_map = {
                    'threat': 'score',
                    'web-search-phrase': 'search_count',
                    'web-search-phrase-detail': 'search_count'
                };*/
                var default_sort_map = {
                    'threat': 'Level',
                    "country": "TNumber",
                    "action": "TNumber",
                    "source": "TNumber",
                    "device": "TNumber",
                    "http_method": "TNumber",
		    "http_url": "TNumber",
		    "aPolicy": "TNumber",
		    "signature_cve_id": "TNumber",
		    "owasp_top10": "TNumber",

                    "policies": "sessions",
                    "sources": "sessions",
                    "destinations": "sessions",
                    "sessions": "Bytes",

                    "tSource": "HTNumber",
                    "tCountry": "HTNumber",
                    "tDestination": "HTNumber",
                    "tPolicy": "HTNumber",
                    "tHttpHost": "HTNumber",
                    "tHttpMethod": "HTNumber",
                    "tHttpRetcode": "HTNumber",
                    "tHttpUrl": "HTNumber",
                };
                //FWB_CHANGE return default_sort_map[tab] || 'bytes';
                return default_sort_map[tab] || 'TNumber';
            };

	    $scope.generate_pdf = function() {
		    var d = this.fortiviewData;
		    var g = this.fortiviewGraph;
		    var params = d.getUrlParamsForCurrentSegment().params || {};
		    params["sort_by"] = this.sort.value || '';
		    var tendby = g.getGraphKey(this.drilldownTabs.current);
		    params["tendby"] = tendby || '';
		    params['report_by'] = d.segmentToFieldName(this.drilldownTabs.current);

		    var sourcedata = [];
		    if($scope.drilldownData[$scope.drilldownTabs.current].qlistSource.wrapped)
			sourcedata = $scope.drilldownData[$scope.drilldownTabs.current].qlistSource.wrapped.$$state.value;
		    else
			sourcedata = $scope.drilldownData[$scope.drilldownTabs.current].qlistSource.$$state.value;
		    $scope.drilldownData[$scope.drilldownTabs.current].qlistSource.wrapped.$$state.value || [];
		    var details = [];
		    for(var i = 0; i < sourcedata.length; i++)
		    //for(var i = 0; i < this.detailsData.length; i++)
		    {
			    //var o = $.extend(true, {}, this.detailsData[i]);
			    var o = $.extend(true, {}, sourcedata[i]);
			    details.push(o);
		    }

		    if(details.length == 0)
		    {
			return;
		    }

		    // delete all _cache_id field in details data
		    details.forEach(function(obj) {
			    if(obj._cache_id)
				    delete obj._cache_id;
		    });
		    //var summary = $.extend(true, {}, this.summaryData);
		    var summary = {};
		    for(var o in this.summaryData)
		    {
			    summary[o] = this.summaryData[o];
		    }
		    if(summary.graph)
			    delete summary.graph;

		    var pdf_data = {
			    results: {
				summary: summary,
				details: details,
				params: params
			    }
		    };
		    var pdf_str = JSON.stringify(pdf_data);
		    pdf_str = encodeURIComponent(pdf_str);

		    var url = '/fortiview/statistics/genpdf';
		    url += "?session_id=" + session_id;
		    url += "&data=" + pdf_str;
		    $.submitPOST(url);
	    };

            $scope.changeDrilldownTab = function(tab) {
                var defaultKey = function() {
                    return this.get_default_sort(tab);
                }.bind(this);
                var previous = $scope.drilldownTabs.current;
                var data = $scope.drilldownData[tab];
                this.tabsSortBy = this.tabsSortBy || {};
                if (!this.tabsSortBy[tab]) {
                    this.tabsSortBy[tab] = defaultKey();
                }
                this.tabsSortBy[previous] = this.sourceSortBy ||
                    this.tabsSortBy[previous] || defaultKey();
                this.sourceSortBy = this.tabsSortBy[tab];
                if (data) {
                    if (!data.qlistOptions.options) {
                        data.qlistOptions.options = {};
                    }
                    data.qlistOptions.options.sort_source_order = {
                        selector: fortiviewUtil.server_to_client_sort_map[
                            this.tabsSortBy[tab]],
                        direction: 'desc'
                    };
                }
                $scope.drilldownTabs.current = tab;
                fortiviewVisualization.drilldownTab = tab;
                $scope.$emit('updateGraph');
		if($scope.segment != 'aPolicy' && $scope.segment != 'threat' && $scope.segment != 'country')
		    $('#pdf_btn').hide();
		else
		    $('#pdf_btn').show();

            }.bind(this);

            /*FWB_CHANGE $scope.tabTitles = {
                'application': 'Applications',
                'source':      'Sources',
                'destination': 'Destinations',
                'country': 'Countries',
                'threat': 'Threats',
                'files': 'Files',
                'videos': 'Videos',
                'session': 'Sessions',
                'web-domain': 'Domains',
                'web-category': 'Categories',
                'web-search-phrase': 'Search Phrases',
                'web-search-phrase-detail': 'Sources',
                'cloud-app': 'Cloud Applications',
                'cloud-user': 'Cloud Users',
                'vpn-user': 'Connections',
                'sandbox-file': 'Sandbox Files',
                'policy': 'Policies',
                'interface-srcintf': 'Source Interfaces',
                'interface-dstintf': 'Destination Interfaces'
            };*/
            $scope.tabTitles = {
                "threat": "Threats",
                "country": "Countries",
                "action": "Actions",
                "source": "Sources",
                "device": "Client Devices",
                "http_method": "HTTP Methods",
                "http_url": "URLs",
		"signature_cve_id": "CVE ID",
		"owasp_top10": "OWASP Top10",
		"aPolicy": "Server Policy",

                "sources": "Sources",
                "policies": "Policies",
                "destinations": "Destinations",
                "sessions": "Sessions",

                "tDestination": "Destinations",
                "tPolicy": "Policies",
                "tHttpHost": "Domains",
                "tHttpMethod": "HTTP Methods",
                "tHttpRetcode": "HTTP Response Codes",
                "tHttpUrl": "URLs",
            };

            $scope.drilldownTabs.lvOptionsGetter = this.getLogViewOptions;

            $scope.$on('beforeGoUp', this.returnToMain.bind(this));

            $scope.$watch(this.get_current_source.bind(this), function(value) {
                searchOptions.source = value;
                $scope.fortiview$root.haveLogViewDetails = value === 'history';
            });

            var current_entries_tab = null,
                entries = [],
                dataLoading = this.dataLoading;
            function entries_getter() {
                var tab = $scope.drilldownTabs.current,
                    data = $scope.drilldownData[tab];
                if (current_entries_tab !== tab) {
                    current_entries_tab = tab;
                    entries = [];
                    if (data && data.qlistSource) {
                        return $q.when(data.qlistSource)
                            .then(function(response) {
                                entries = response;
                                return response;
                            });
                    } else if (dataLoading) {
                        return dataLoading.then(function() {
                            //paranoia
                            dataLoading = false;
                            return entries_getter();
                        });
                    }
                }
                return entries;
            }
            function not(values) {
                return function(value) { return values.indexOf(value) === -1 };
            }
        };
    });

    Base.prototype.restartAutoReload = inject.mark(function($timeout, fortiviewVisualization) {
        return function(interval) {
            interval = interval || fortiviewVisualization.getAutoUpdateInterval();
            $timeout.cancel(this.autoUpdateTimeout);

            if (interval) {
                this.autoUpdateTimeout = $timeout(function() {
                    this.reloadQlistData();
                }.bind(this), interval * 1000);
            }
        };
    });

    Base.prototype.watchAutoReload = inject.mark(
    function($scope, $timeout, fortiviewVisualization) {
        return function() {
            var fn = fortiviewVisualization.getAutoUpdateInterval.bind(fortiviewVisualization);
            $scope.$watch(fn, function(interval) {
                this.restartAutoReload(interval);
            }.bind(this));

            $scope.$on('$destroy', function() {
                $timeout.cancel(this.autoUpdateTimeout);
            }.bind(this));
        };
    });

    Base.prototype.getLogViewOptions = inject.mark(function($scope, fortiviewFacets) {
        return function getLogViewOptions(tab) {
            var mods = this.logColumnMods && this.logColumnMods[tab];
            return fortiviewFacets.getLogViewOptions(tab, mods);
        };
    });

    Base.prototype.setDrilldownContext = inject.mark(function(fortiviewSearchState) {
        return function(entry, tab) {
            if (tab === 'application') {
                var app = entry.apps[0];
                fortiviewSearchState.drilldownContext.appName = app.name;
                fortiviewSearchState.drilldownContext.appID = app.id;
            }
        };
    });

    Base.prototype.drilldownTo = inject.mark(function($location, $routeParams, $route, ftntRoute,
                                                      fortiviewFacets, fortiviewUtil) {
        return function(entry, tab) {
            if (this.scope.excludeDrilldown && this.scope.excludeDrilldown[tab]) {
                return;
            }

            this.setDrilldownContext(entry, tab);

            var facet_ids = fortiviewFacets.primaryFacets(tab),
                facets = facet_ids.map(fortiviewFacets.byId.bind(fortiviewFacets)),
                source = this.get_current_source(),
                tabValue;
            if (facets.length > 1) {
                tabValue = facets.map(getFixedEncodedValue).join(':');
            } else {
                tabValue = facets.map(getEncodedValue)[0];
            }
            var originalPath = $route.current.$$route.originalPath;
            var path = ftntRoute.interpolate(originalPath, $routeParams);
            
            // Sources / Policies, drilldown to another path instead of session, added by Nan Mou
            var originalPaths = originalPath.split('/');
            if (originalPaths.length > 2 && (originalPaths[2] === "sources" || originalPaths[2] === "policies")) {
                $location.path(path + '/sessions/' + encodeURIComponent(tab) + '/' + tabValue);
            } else {
                $location.path(path + '/' + encodeURIComponent(tab) + '/' + tabValue);
            }

            function getFixedEncodedValue(facet) {
                return fortiviewUtil.encodeDrilldownValue(facet.getKey(entry, source));
            }
            function getEncodedValue(facet) {
                return encodeURIComponent(facet.getKey(entry, source));
            }
        };
    });

    Base.prototype.summaryRows = function() {
        var scope = this.scope;
        function format(item) {
            if (item.templateUrl) {
                return !item.show || item.show(scope.summary) ?
                    {text: item.text, templateUrl: item.templateUrl} : null;
            }
            var value = '';
            if (item.html) {
                value = item.html(scope.summary) || '';
            }
            if (angular.isFunction(item.getter)) {
                value += item.getter(scope.summary) || '';
            }
            if (item.key) {
                value += scope.summary[item.key] || '';
            }
            return value ? {text: item.text, value: value} : null;
        }
        function has_value(item) {
            return item &&
                (item.value &&
                 String(item.value).replace(/^\s*$/, '') ||
                 item.templateUrl);
        }

        var items = this.scope.drilldownDisplayItems.map(format);
        items = items.filter(has_value);

        //cache previous call and return the same array if it matches, otherwise
        //ng-repeat will cause diginf exceptions.
        this._summaryRows = angular.equals(items, this._summaryRows) ?
                                    this._summaryRows : items;
        return this._summaryRows;
    };
    Base.prototype.returnToMain = function() {
        var primaryFacet = this.getPrimaryFacet();
        delete this.scope.searchState.drilldownValues[primaryFacet.id];
    };
    Base.prototype.setPageTitle = inject.mark(function($scope, $routeParams) {
        return function() {
            var value = decodeURIComponent($routeParams.drilldownValue);
            $scope.drilldownText = value;
            $scope.fortiview$root.drilldown_title = value;
            $scope.update_title();
        };
    });

    Base.prototype.getPrimaryFacet = inject.mark(function(fortiviewFacets) {
        return function() {
            var facetId = fortiviewFacets.primaryForSegment()[0];
            return fortiviewFacets.byId(facetId);
        };
    });
    // if the search value is cleared, exit the drilldown view
    // this has a chance to go wrong, and if you get odd navigation issues, it's
    // probably here.
    Base.prototype.watchDrilldownFacet =
    inject.mark(function($scope, $route, $location, $routeParams, ftntRoute) {
        return function() {
            $scope.$watch('searchState.drilldownValues', function(values, old) {
                var originalPath, newPath, routeParams;
                if (values !== old) {
                    if (Object.keys(values).length === Object.keys(old).length) {
                        originalPath = $route.current.$$route.originalPath;
                        routeParams = angular.copy($routeParams);
                        routeParams.drilldownValue = Object.keys(values).map(function(id) {
                            return values[id];
                        }).join(':');
                        newPath = ftntRoute.interpolate(originalPath, routeParams);
                        $location.path(newPath);
                    } else if ($scope.canGoUp()) {
                        $scope.goUp();
                    }
                }
            }, true);
        };
    });

    Base.prototype.recalculateTimePeriod = function() {
        this.scope.timePeriod = this.scope.searchState.get_timeframe_as_range();
    };

    Base.prototype.currentSourceSortBy = function(tab) {
        //FWB_CHANGE return this.sourceSortBy || this.tabsSortBy[tab] || 'bytes';
        return this.sourceSortBy || this.tabsSortBy[tab] || this.get_default_sort(this.scope.drilldownTabs.current) || 'TNumber';
    };

    Base.prototype.getGraphKey = function(tab, sortBy, fortiviewGraph) {
        /*FWB_CHANGE var graphKey = sortBy;
        if (fortiviewGraph.EXEMPT_GRAPH[sortBy]) {
            graphKey = this.get_default_sort(tab);
        }
        return graphKey;*/
        return fortiviewGraph.getGraphKey(tab);
    };

    Base.prototype.getGraphCacheKey = function(tab, sortBy) {
        sortBy = sortBy || this.currentSourceSortBy(tab);
        var searchState = this.scope.searchState.state.timeframe;
        return searchState + ':' + tab + ':' + sortBy;
    };

    // Base.prototype.reloadSummaryData = inject.mark(function($scope, $q, fortiviewData, fortiviewRouteMetadata) {
    //     return function() {
    //         $scope.graph = null;
    //         var deferred = $q.defer();
    //         if (this.summaryLoaded) {
    //             deferred.resolve($scope.summary);
    //         } else {
    //             $scope.summary = {};
    //             //FWB_CHANGE fortiviewData.getDrilldownSummary().then(function(summary) {
    //             fortiviewData.getDrilldownSummary(this.get_default_sort(fortiviewRouteMetadata.baseSegment())).then(function(summary) {
    //                 $scope.summary = angular.extend($scope.summary, summary);
    //                 this.summaryLoaded = true;

    //                 // Sources / Policies, always reload real-time summary data, added by Nan Mou
    //                 var segment = fortiviewRouteMetadata.baseSegment();
    //                 if (segment === "sources" || segment === "policies") {
    //                     this.summaryLoaded = false;
    //                 }

    //                 deferred.resolve($scope.summary);
    //             }.bind(this));
    //         }
    //         return deferred.promise;
    //     };
    // });

    Base.prototype.reloadQlistData =
    /* jshint maxparams:8 */
    inject.mark(function($q, $log, $scope, fortiviewUtil, fortiviewData, fortiviewGraph,
                         fortiviewSessions, fortiviewVisualization) {
        var SUMMARY_EXTEND_SKIP = {
            count: true,
            rcvdbyte: true,
            sentbyte: true
        };

        return function(keepPeriod) {
            //FWB_CHANGE this.reloadSummaryData().then(function(summary) {
            // Fix bug 0494060, use a dummy promise to trigger digest, 
            // because reloadQlistData() called from qlist server sort not in digest loop
            function dummyPromise() {
                return $q(function(resolve) {
                    resolve();
                });
            }
            dummyPromise().then(function(){
                // used to correctly format the sessions and bytes bars
                this.maxValues = {};
                this.maxSumFields = {};

                var that = this,
                    //FWB_CHANGE applications = fortiviewUtil.get_applications(),
                    drilldownData = $scope.drilldownData;

                $scope.graph = null;
                $scope.summary = {};
                /*FWB_CHANGE if (!keepPeriod) {
                    $scope.update_period();
                }*/
                angular.forEach($scope.availableTabs, function(tab) {
                    if (!drilldownData || !(tab in drilldownData)) { return; }
                    this.maxValues[tab] = angular.copy(
                        drilldownData[tab].qlistOptions.maxValues || {});
                    this.maxSumFields[tab] = angular.copy(
                        drilldownData[tab].qlistOptions.maxSumFields || {});
                    var tabData;
                    if (tab === 'session') {
                        tabData = lazyPromise(fortiviewSessions.loadData);
                    } else {
                        var prefs = angular.extend(
                            //FWB_CHANGE tab === 'web-search-phrase' ? {} : {'view_level': 'drilldown'},
                            {'view_level': 'drilldown', 'tendby': that.getGraphKey(tab, null, fortiviewGraph)},
                            that.api_monitor_prefs);
                        tabData = lazyPromise(fortiviewData.getForDrilldownTab,
                        [tab, prefs, that.currentSourceSortBy.bind(this), $scope.summary],
                        function(p) {
                            var reqs = [/*FWB_CHANGE applications.$promise,*/ p];
                            var data_ready = $q.all(reqs).then(function(responses) {
                                //FWB_CHANGE var response = responses[1];
                                var response = responses[0];
                                var sortBy, key, graphType;

                                that.restartAutoReload();
                                if (response.summary) {
				    $scope.summaryData = response.summary;
                                    Object.keys(response.summary).forEach(function(key) {
                                        if (!SUMMARY_EXTEND_SKIP[key]) {
                                            $scope.summary[key] = response.summary[key];
                                        }
                                    });
                                }
                                if (response.graph) {
                                    // Generate graph
                                    sortBy = that.currentSourceSortBy(tab);
                                    key = that.getGraphCacheKey(tab, sortBy);
                                    graphType = that.getGraphKey(tab, sortBy, fortiviewGraph);
                                    that.graphs[key] = fortiviewGraph.generate_graph(
                                        response.graph, graphType, $scope);
                                }
                                that.scope.$emit('updateGraph');

                                if (response.details) {
				    $scope.detailsData = response.details;
                                    fortiviewUtil.calculateMaxima(that.maxValues[tab],
                                        response.details,
                                        that.maxSumFields[tab]);
                                }

                                var summary = response.summary.suminfo || {};
                                var start = response.summary.start;
                                var end = response.summary.end;
                                angular.extend(summary, {'start': start, 'end': end});
                                $scope.summary = summary;

				if($scope.segment != 'aPolicy' && $scope.segment != 'threat' && $scope.segment != 'country')
				    $('#pdf_btn').hide();
				else
				    $('#pdf_btn').show();

                                return {
                                    qlistSource: response.details,
                                    d3Source: fortiviewVisualization.processSource(
                                        response.details, that.sourceSortBy, tab)
                                };
                            });
                            return data_ready;
                        });

                    }

                    var d3Source;
                    var lazyData = function(fn) {
                        return lazyPromise(function() {
                            return tabData;
                        }, null, fn);
                    };

                    drilldownData[tab].qlistSource = lazyData(function(p) {
                        return p.then(function(data) {
                            return data.qlistSource || data;
                        });
                    });
                    d3Source = drilldownData[tab].d3Source = {};
                    fortiviewVisualization.TYPES_LIST.forEach(function(type) {
                        d3Source[type] = lazyData(function(p) {
                            return p.then(function(data) {
                                // Protect against type error during route transition
                                return data.d3Source ? data.d3Source[type] : null;
                            });
                        });
                    });

                }, this);
            }.bind(this));
            //FWB_CHANGE }.bind(this));
        };
    });

    Base.prototype.update_visible_tabs =
    inject.mark(function($scope, fortiviewSearchState, fortiviewVisualization) {
        return function() {
            var tab = $scope.drilldownTabs.current;
            $scope.drilldownTabs.all = $scope.availableTabs.filter(function(tab) {
                var realtime = fortiviewSearchState.state.timeframe === 'realtime';
                if (realtime) {
                    // Hidden tabs in realtime
                    return ['threat', 'web-search-phrase',
                            'web-search-phrase-detail'].indexOf(tab) < 0;
                } else {
                    return true;
                }
            });
            //make sure current tab is one of the visible ones
            if ($scope.drilldownTabs.all.indexOf(tab) === -1) {
                $scope.drilldownTabs.current = $scope.drilldownTabs.all[0];
            }
            fortiviewVisualization.drilldownTab = $scope.drilldownTabs.current;
        };
    });

    Base.prototype.updateLogViewOptions = inject
        .mark(function($scope, fortiviewSearchState) {
            var ss = fortiviewSearchState;
            return function() {
                var ddTabs = $scope.drilldownTabs,
                    vis = $scope.visualization,
                    tab = ddTabs.current,
                    useLogView = ddTabs.useLogView[tab] &&
                        (!vis || vis.getType() === vis.TYPES.TABLE);
                $scope.logViewOptions = useLogView && ddTabs.lvOptionsGetter(tab);
                if (useLogView) {
                    if (!this._unwatchFacetModel) {
                        this._unwatchFacetModel = $scope.$watch(
                                                        'logViewOptions.facetModel',
                                                        ss.logViewFacetModelWatchAction,
                                                        true);
                    }
                } else if (this._unwatchFacetModel) {
                    this._unwatchFacetModel();
                    this._unwatchFacetModel = null;
                }
            };
        });

    Base.prototype.watchCurrentTab =
    inject.mark(function($scope, fortiviewUtil, fortiviewRouteMetadata) {
        return function() {
            $scope.$watch('drilldownTabs.current', function(tab) {
                $scope.quarantineSourceIPColumnName =
                    fortiviewUtil.getQuarantineColumnNameForSegment(tab, 'saddr');
                this.updateLogViewOptions();

                // Sources / Policies, reload real-time data when changing tabs, added by Nan Mou
                var segment = fortiviewRouteMetadata.baseSegment();
                if (segment === "sources" || segment === "policies") {
                    $scope.refresh();
                }
                
            }.bind(this));
        };
    });

    // Sources / Policies, always reload real-time summary data, added by Nan Mou
                    

    Base.prototype.watchSearchState =
    inject.mark(function($scope, $location, fortiviewSearchState) {
        return function() {
            var ss = fortiviewSearchState;
            $scope.searchState = ss;
            $scope.$watch('searchState.state', function(state, old) {
                // Historical sessions is a log viewer
                $scope.drilldownTabs.useLogView.session = state.timeframe !== 'realtime';
                this.updateLogViewOptions();
                if (state !== old) {
                	// fortiviewSearchState.segmentData = null; //FWB_CHANGE
                    this.reloadData();
                    this.update_visible_tabs();
                    this.recalculateTimePeriod();
                }
            }.bind(this), true);
        };
    });

    Base.prototype.get_current_source = function() {
        var dd_tabs = this.scope.drilldownTabs,
            ss = this.scope.searchState;
        if (dd_tabs.useLogView[dd_tabs.current]) {
            var realtime = !ss.last_period.start;
            return realtime ? 'session' : 'history';
        } else {
            return 'monitor_api';
        }
    };

    Base.prototype.getCountryIconFn = inject.mark(function($sce) {
        return function(summary) {
            if (!summary.country_id || summary.country_id < 0xFF) {return '';}
            var html = widgets.gen_country_flag_icon_by_id(summary.country_id,
                                                           summary.country ||
                                                                '');
            return $sce.trustAsHtml(html);
        };
    });

    Base.prototype.makeQlistConfig =
    inject.mark(function($scope, lang, fortigateInfo, fortiviewUtil, fortiviewRouteMetadata,
            $injector) {
        return function(tab, config) {
            //don't worry about fortiviewSandbox unless it's available
            //FWB_CHANGE var fortiviewSandbox = $injector.get('fortiviewSandbox') || {};
            // extends a given qlist config with common attributes
            var include_drilldown = (!$scope.excludeDrilldown || !$scope.excludeDrilldown[tab]) &&
                this.drilldownTo;
            var drilldown = function(q, tr) {
                var index = angular.element(tr).data('sourceIndex');
                $scope.drilldownData[tab].qlistSource.then(function(source) {
                    this.drilldownTo(source[index], tab);
                }.bind(this));
            }.bind(this);

            //make sure these defaults are unique objects for each call!!
            //this map will be transformed to {selector:key,lang_key:value} if a
            //string is specified for a column definition below.
            //default_columns will be added automatically
            /* FWB_CHANGE var cols = {
                address: 'source',
                apps: 'application',
                category: 'category',
                clouduser: 'Cloud Users',
                country: 'Country',
                device: 'device',
                domain: 'domain',
                duration: 'Browsing Time',
                files: 'Files (Up/Down)',
                level: 'Threat Level',
                loginid: 'Cloud Login ID',
                risk: 'fv_risk',
                score: 'Threat Score (Blocked/Allowed)',
                threat: 'threat',
                username: 'user',
                utm: 'category',
                videos: 'Videos Played',
                vpnuser: 'username',
                keyword: 'Search Phrases'
            };*/
            var cols = {
                attack_type: "Threat",
                Level: 'Threat Level',
                action: 'action',
                actions: 'Action (Block/Alert)',
                TNumber: 'Threat Number',
                TScore: 'Threat Score',
                services: 'Service (HTTP/HTTPS)',
                srccountry: 'Country',
                src: 'src',
                dst: 'Destination',
                dev_id: 'Client Device',
                http_method: 'HTTP Method',
                http_url: 'http_url',
                policy: 'policy',
                policies: 'Policy',
                sources: 'Source',
                destinations: 'Destination',
                sessions: 'Sessions',
                requests: 'Requests',
                exist_time: 'Exists',
                HTNumber: 'HTTP Transactions',
                version: 'HTTP Version (HTTP1.X/HTTP2)',
                Bytes: 'Bytes (Sent/Received)',
                http_host: 'Domain',
                http_retcode: 'HTTP Response Code',
		signature_cve_id: 'CVE ID',
		owasp_top10: 'OWASP Top10'
            };

            function fill_columns(config) {
                if (!config.columns) {
                    config.columns = [];
                }
                var columns = config.columns,
                    def_columns = config.default_columns,
                    i, len;
                for (i = 0, len = columns.length; i < len; ++i) {
                    if (columns[i].constructor === String) {
                        columns[i] = make_column(columns[i]);
                    }
                }
                for (i = 0, len = def_columns.length; i < len; ++i) {
                    var col = def_columns[i];
                    if (!columns.some(find_column(col)) && (col in cols)) {
                        columns.push(make_column(col));
                    }
                }
                /*FWB_CHANGE if (columns.some(find_column('files'))) {
                    angular.extend(config, {
                        maxSumFields: {
                            files: ['files_uploaded', 'files_downloaded']
                        }
                    });
                }
                if (columns.some(find_column('videos'))) {
                    config.maxValues = config.maxValues || {};
                    config.maxValues.videos = 0;
                }*/
                function find_column(name) {
                    return function(col) { return col.selector === name };
                }
                function make_column(name) {
                    return { selector: name, lang_key: cols[name] };
                }
            }
            /*FWB_CHANGE var qlist_config_defaults = {
                application: {
                    default_columns: ['apps', 'data_bytes', 'sessions', 'data_bandwidth'],
                    columns: ['risk']
                },
                source: {
                    default_columns: ['address', 'device', 'srcintf', 'score', 'data_bytes',
                        'sessions', 'data_bandwidth'
                    ],
                    columns: [{ selector: 'srcintf', lang_key: 'srcintf'}]
                },
                policy: {
                    default_columns: ['policyid', 'srcintf', 'dstintf', 'data_bytes',
                        'session', 'data_bandwidth'
                    ],
                    columns: [
                        { selector: 'policyid', lang_key: 'Policy'},
                        { selector: 'policytype', lang_key: 'Policy Type'},
                        { selector: 'srcintf', lang_key: 'srcintf'},
                        { selector: 'dstintf', lang_key: 'dstintf'}
                    ]
                },
                'interface-srcintf': {
                    default_columns: ['srcintf', 'data_bytes', 'session', 'data_bandwidth'],
                    columns: [
                        { selector: 'srcintf', lang_key: 'srcintf'}
                    ]
                },
                'interface-dstintf': {
                    default_columns: ['dstintf', 'data_bytes', 'session', 'data_bandwidth'],
                    columns: [
                        { selector: 'dstintf', lang_key: 'dstintf'}
                    ]
                },
                destination: {
                    default_columns: ['address', 'score', 'data_bytes', 'sessions',
                        'data_bandwidth'
                    ],
                    columns: [
                        { selector: 'address', lang_key: 'destination' },
                        { selector: 'dstintf', lang_key: 'dstintf' }
                    ]
                },
                country: {
                    default_columns: ['country', 'data_bytes', 'sessions', 'data_bandwidth']
                },
                user: {
                    default_columns: ['username', 'device', 'address', 'data_bytes', 'sessions']
                },
                threat: {
                    default_columns: ['threat', 'utm', 'level', 'score', 'sessions'],
                    columns: [{ selector: 'sessions', lang_key: 'Sessions'}]
                },
                'web-category': {
                    default_columns: ['category', 'duration', 'score', 'data_bytes',
                        'sessions', 'data_bandwidth'
                    ]
                },
                'web-domain': {
                    default_columns: ['domain', 'duration', 'score', 'data_bytes',
                        'sessions', 'data_bandwidth'
                    ]
                },
                'web-search-phrase': {
                    default_columns: ['keyword', 'search_count'],
                    columns: [
                        { selector: 'keyword', lang_key: 'Search Phrases' },
                        { selector: 'search_count', lang_key: 'Frequency' }
                    ],
                    options: {
                        sort_source_order: {
                            selector: 'search_count',
                            direction: 'desc'
                        }
                    }
                },
                'web-search-phrase-detail': {
                    default_columns: ['search_phrase_source', 'search_count', 'hostname'],
                    columns: [
                        { selector: 'search_phrase_source', lang_key: 'Source' },
                        { selector: 'search_count', lang_key: 'Frequency' },
                        { selector: 'hostname', lang_key: 'Host Name' }
                    ],
                    options: {
                        sort_source_order: {
                            selector: 'search_count',
                            direction: 'desc'
                        }
                    }
                },
                'cloud-app': {
                    default_columns: ['apps', 'category', 'files', 'videos', 'risk', 'data_bytes']
                },
                'cloud-user': {
                    default_columns: [
                        'clouduser', 'address', 'files', 'videos', 'data_bytes', 'sessions'
                    ]
                },
                'vpn-user': {
                    default_columns: [
                        'connection_time', 'last_conn_time', 'to', 'srcip', 'sentbyte', 'vpntunnel',
                        'tunneltype', 'rcvdbyte', 'data_bytes', 'duration', 'tunnelid'
                    ],
                    columns: [
                        { selector: 'connection_time', lang_key: 'Connection Time' },
                        { selector: 'last_conn_time', lang_key: 'Last Connection Time'},
                        { selector: 'vpntunnel', lang_key: 'vpntunnel'},
                        { selector: 'tunneltype', lang_key: 'vpntype'},
                        { selector: 'srcip', lang_key: 'Connected From' },
                        { selector: 'duration', lang_key: 'field_duration' },
                        { selector: 'data_bytes', lang_key: 'total-bytes'}
                    ],
                    options: {
                        sort_source_order: {
                            selector: 'data_bytes',
                            direction: 'desc'
                        }
                    }
                },
                'sandbox-file': {
                    default_columns: ['filename', 'threat', 'submitted'],
                    columns: [
                        { selector: 'filename', lang_key: 'filename' },
                        { selector: 'threat', lang_key: 'status' },
                        { selector: 'submitted', lang_key: 'Submitted' },
                        { selector: 'checksum', lang_key: 'checksum' }
                    ],
                    format_fn: fortiviewSandbox.formatFn
                }
            };*/
            var qlist_config_defaults = {
                threat: {
                    default_columns: ['attack_type', 'Level', 'TNumber', 'TScore', 'actions', 'services'],
                    columns: ['attack_type', 'Level', 'TNumber', 'TScore', 'actions', 'services']
                },
                action: {
                    default_columns: ['action', 'TNumber', 'TScore', 'services'],
                    columns: ['action', 'TNumber', 'TScore', 'services']
                },
                country: {
                    default_columns: ['srccountry', 'TNumber', 'TScore', 'actions', 'services'],
                    columns: ['srccountry', 'TNumber', 'TScore', 'actions', 'services']
                },
                source: {
                    default_columns: ['src', 'TNumber', 'TScore', 'actions', 'services'],
                    columns: ['src', 'TNumber', 'TScore', 'actions', 'services']
                },
                device: {
                    default_columns: ['dev_id', 'TNumber', 'TScore', 'actions', 'services'],
                    columns: ['dev_id', 'TNumber', 'TScore', 'actions', 'services']
                },
                http_method: {
                    default_columns: ['http_method', 'TNumber', 'TScore', 'actions', 'services'],
                    columns: ['http_method', 'TNumber', 'TScore', 'actions', 'services']
                },
                http_url: {
                    default_columns: ['http_url', 'TNumber', 'TScore', 'actions', 'services'],
                    columns: ['http_url', 'TNumber', 'TScore', 'actions', 'services']
                },
                sources: {
                    default_columns: ['sources', 'sessions', 'requests', 'Bytes'],
                    columns: ['sources', 'Bytes', 'requests', 'sessions']
                },
                policies: {
                    default_columns: ['policies', 'sessions', 'requests', 'Bytes'],
                    columns: ['policies', 'Bytes', 'requests', 'sessions']
                },
                destinations: {
                    default_columns: ['destinations', 'sessions', 'requests', 'Bytes'],
                    columns: ['destinations', 'Bytes', 'requests', 'sessions']
                },
                sessions: {
                    default_columns: ['sources', 'sports', 'destinations', 'dports', 'Bytes', 'requests', 'exist_time'],
                    columns: ['sources', 'sports', 'destinations', 'dports', 'Bytes', 'requests', 'exist_time'],
                    remove_session_entries: true
                },
                policy: {
                    default_columns: ['sources', 'destinations', 'Bytes', 'requests'],
                    columns: ['sources', 'destinations', 'Bytes', 'requests']
                },
                domain: {
                    default_columns: ['sources', 'destinations', 'Bytes', 'requests'],
                    columns: ['sources', 'destinations', 'Bytes', 'requests']
                },
                http_code: {
                    default_columns: ['sources', 'destinations', 'Bytes', 'requests'],
                    columns: ['sources', 'destinations', 'Bytes', 'requests']
                },

                tDestination: {
                    default_columns: ['dst', 'HTNumber', 'services', 'version', 'Bytes'],
                    columns: ['dst', 'HTNumber', 'services', 'version', 'Bytes']
                },
                tPolicy: {
                    default_columns: ['policy', 'HTNumber', 'services', 'version', 'Bytes'],
                    columns: ['policy', 'HTNumber', 'services', 'version', 'Bytes']
                },
                tHttpHost: {
                    default_columns: ['http_host', 'HTNumber', 'services', 'version', 'Bytes'],
                    columns: ['http_host', 'HTNumber', 'services', 'version', 'Bytes']
                },
                tHttpMethod: {
                    default_columns: ['http_method', 'HTNumber', 'services', 'version', 'Bytes'],
                    columns: ['http_method', 'HTNumber', 'services', 'version', 'Bytes']
                },
                tHttpRetcode: {
                    default_columns: ['http_retcode', 'HTNumber', 'services', 'version', 'Bytes'],
                    columns: ['http_retcode', 'HTNumber', 'services', 'version', 'Bytes']
                },
                tHttpUrl: {
                    default_columns: ['http_url', 'HTNumber', 'services', 'version', 'Bytes'],
                    columns: ['http_url', 'HTNumber', 'services', 'version', 'Bytes']
                },
		aPolicy: {
		    default_columns: ['policy', 'TNumber', 'TScore', 'actions', 'services'],
		    columns: ['policy', 'TNumber', 'TScore', 'actions', 'services']
		},
		signature_cve_id: {
		    default_columns: ['signature_cve_id', 'TNumber', 'TScore', 'actions', 'services'],
		    columns: ['signature_cve_id', 'TNumber', 'TScore', 'actions', 'services']
		},
		owasp_top10: {
		    default_columns: ['owasp_top10', 'TNumber', 'TScore', 'actions', 'services'],
		    columns: ['owasp_top10', 'TNumber', 'TScore', 'actions', 'services']
		}
            };
            var insert_index;

            if (!config) {
                config = qlist_config_defaults[tab];
                fill_columns(config);
                config.prefix = 'qlist_' +
                    fortiviewRouteMetadata.baseSegment(true) + '_' + tab;
                /*FWB_CHANGE if (fortiviewRouteMetadata.baseSegment(false) === 'web' &&
                    ['threat', 'web-search-phrase-detail', 'web-search-phrase'].indexOf > -1 &&
                    config.default_columns.indexOf('duration') < 0) {
                    insert_index = config.default_columns.indexOf('device');
                    if (insert_index < 0) {
                        insert_index = 1;
                    } else {
                        insert_index += 1;
                    }
                    config.columns.push(
                        {selector: 'duration', lang_key: 'Browsing Time'});
                    config.default_columns.splice(insert_index, 0, 'duration');
                }*/
            }

            config.columns = config.columns || [];

            /*FWB_CHANGE if (['vpn-user', 'threat', 'sandbox-file', 'web-search-phrase-detail',
                 'web-search-phrase'].indexOf(tab) < 0) {
                var columns = [
                    { selector: 'data_bytes', lang_key: 'total-bytes'},
                    { selector: 'sessions', lang_key: 'Sessions'},
                    { selector: 'data_packets', lang_key: 'total-packets'},
                    { selector: 'data_bandwidth', lang_key: 'Bandwidth'},
                    { selector: 'data_shaper_drops', lang_key: 'Dropped Bytes'},
                    { selector: 'rcvdbyte', lang_key: 'received'},
                    { selector: 'sentbyte', lang_key: 'sent'},
                    { selector: 'rx_packets', lang_key: 'rcvdpkt'},
                    { selector: 'tx_packets', lang_key: 'sentpkt'}
                ].filter(fortiviewUtil.not_present(config.columns, 'selector'));
                config.columns.push.apply(config.columns, columns);
            }*/

            /*FWB_CHANGE config.format_fn = angular.extend({
                apps: fortiviewUtil.format_fn.apps,
                address: function(td, col, data) {
                    data = angular.extend({}, data, {
                        report_by: tab === 'destination' ? tab : 'source'
                    });
                    return fortiviewUtil.format_fn.address(td, col, data);
                },
                category: fortiviewUtil.format_fn.web_category,
                sessions: fortiviewUtil.format_fn.count_compare(function() {
                    return this.maxValues[tab].sessions;
                }.bind(this)),
                device: widgets.format_fn.device,
                duration: fortiviewUtil.format_fn.duration(function() {
                    return this.maxValues[tab].duration;
                }.bind(this)),
                domain: fortiviewUtil.format_fn.domain,
                data_bytes: fortiviewUtil.format_fn.bytes_compare(function() {
                    return this.maxValues[tab].data_bytes;
                }.bind(this)),
                data_packets: fortiviewUtil.format_fn.two_compare(function() {
                    return this.maxValues[tab].data_packets;
                }.bind(this), ['tx_packets', 'rx_packets']),
                data_bandwidth: fortiviewUtil.format_fn.two_compare(function() {
                    return this.maxValues[tab].data_bandwidth;
                }.bind(this), ['tx_bandwidth', 'rx_bandwidth'], formatters.metric_bits_per_second),
                data_shaper_drops: fortiviewUtil.format_fn.bytes_compare(function() {
                    return this.maxValues[tab].data_shaper_drops;
                }.bind(this), ['tx_shaper_drops', 'rx_shaper_drops']),
                country: fortiviewUtil.format_fn.country,
                files: fortiviewUtil.format_fn.cloudFiles(['files_uploaded', 'files_downloaded'],
                function() {
                    return this.maxValues[tab].files;
                }.bind(this)),
                level: fortiviewUtil.format_fn.level,
                risk: fortiviewUtil.format_fn.risk,
                sentbyte: fortiviewUtil.commonBytesFormatter,
                rcvdbyte: fortiviewUtil.commonBytesFormatter,
                bandwidth: fortiviewUtil.format_fn.bytes_compare(function() {
                    return this.maxValues[tab].bandwidth;
                }.bind(this), ['sentbyte', 'rcvdbyte']),
                score: fortiviewUtil.format_fn.two_compare(function() {
                    return this.maxValues[tab].score;
                }.bind(this), ['score_block', 'score_allow']),
                threat: fortiviewUtil.format_fn.threat,
                username: widgets.format_fn.username,
                utm: fortiviewUtil.format_fn.threat_type,
                videos: fortiviewUtil.format_fn.cloudFiles('videos',
                function() {
                    return this.maxValues[tab].videos;
                }.bind(this)),
                connection_time: fortiviewUtil.format_fn.connection_time('from', 'to'),
                count: fortiviewUtil.format_fn.one_compare(function() {
                    return this.maxValues.count;
                }.bind(this)),
                last_conn_time: fortiviewUtil.format_fn.last_conn_time,
                search_phrase_source: fortiviewUtil.format_fn.search_phrase_source
            }, config.format_fn);*/
            config.format_fn = angular.extend({
                srccountry: fortiviewUtil.format_fn.country,
                actions: fortiviewUtil.format_fn.fwb_count_compare(function() {
                    return this.maxValues[tab].actions;
                }.bind(this), ['Block', 'Alert']),
                services: fortiviewUtil.format_fn.fwb_count_compare(function() {
                    return this.maxValues[tab].services;
                }.bind(this), ['HTTP', 'HTTPS']),
                Level: fortiviewUtil.format_fn.level,
                src: fortiviewUtil.format_fn.address,
                dst: fortiviewUtil.format_fn.address,
                sources: fortiviewUtil.format_fn.address,
                destinations: fortiviewUtil.format_fn.address,
                version: fortiviewUtil.format_fn.fwb_count_compare(function() {
                    return this.maxValues[tab].version;
                }.bind(this), ['1.x', '2.0']),
                Bytes: fortiviewUtil.format_fn.fwb_bytes_compare(function() {
                    return this.maxValues[tab].Bytes;
                }.bind(this), ['Request', 'Response']),
                exist_time: fortiviewUtil.format_fn.exist_time
            }, config.format_fn);

            function after_format(cells) {
                var $scope = angular.element('.fortiview').scope();
                var $compile = angular.element(".fortiview").injector().get("$compile");
                $compile(cells)($scope);
            }

            config.after_format_fn = angular.extend({
                actions: after_format,
                services: after_format,
                version: after_format,
                Bytes: after_format,
            }, config.after_format_fn);

            config.sort_fn = fortiviewUtil.generateSortFn(this, this.get_default_sort(tab));

            config.options = angular.extend({
                hide_menu: true,
                hide_default_buttons: true,
                force_context_menu: true,
                sorting: true,
                /*FWB_CHANGE sort_columns: {
                    data_bytes: 'desc',
                    data_packets: 'desc',
                    data_bandwidth: 'desc',
                    data_shaper_drops: 'desc',
                    sessions: 'desc',
                    score: 'desc',
                    files: 'desc',
                    count: 'desc',
                    connections: 'desc',
                    bandwidth: 'desc',
                    last_conn_time: 'desc',
                    search_count: 'desc'
                },
                sort_source_order: {
                    selector: 'data_bytes',
                    direction: 'desc'
                }*/
                sort_columns: {
                    Level: 'desc',
                    TNumber: 'desc',
                    TScore: 'desc',
                    HTNumber: 'desc',
                    Bytes: 'desc',
                    requests: 'desc',
                    sessions: 'desc',
                },
                sort_source_order: {
                    selector: 'TNumber',
                    direction: 'desc'
                }
            }, config.options);
            config.enhanced_context = true;

            if (include_drilldown) {
                /* jshint scripturl:true */
                config.menu_items = angular.extend({
                    drilldown: {
                        url: 'javascript:void 0',
                        handler: drilldown,
                        label: lang('Drill Down to Details').toString()
                    }
                }, config.menu_items);
            }

            config.sort = angular.extend({
                'save_in_cookie': false
            }, config.sort);

            config.paging = angular.extend({
                enabled: true,
		// new added attribute for only show total count in paging
		only_show_total: true,
                page_lines: fortigateInfo.info.lines_per_page
            }, config.paging);

            if (config.callbacks == null) { config.callbacks = {}; }
            var load_callback = config.callbacks.load;
            config.callbacks.load = function() {
                if (angular.isFunction(load_callback)) {
                    load_callback.call(this);
                }
                widgets.callbacks.load.call(this);
            };
            if (include_drilldown) {
                config.callbacks.dblclick = drilldown;
            }

            return config;
        };
    });

    Base.prototype.getDeviceIcon = inject.mark(function($sce) {
        return function(summary, nonSkip) {
            if (!summary.device && !nonSkip) { return '' }
            var config = {
                device: summary.device,
                mac: summary.mac,
                hostname: summary.hostname,
                alias: summary.alias
            };
            //sigh
            var span = document.createElement('span');
            var html = widgets.format_fn.device(span, null, config);
            span.innerHTML = html;
            return $sce.trustAsHtml(span.outerHTML);
        };
    });

    /**
    * @param {Object} Current summary object
    * @returns {String} Formatted summary HTML for current item
    */
    Base.prototype.getCmdbSummaryHtml = function(summary) {
        var val = summary && summary.cmdb ? summary.cmdb[this.cmdb_key] : null;
        var result = '';

        if (Array.isArray(val)) {
            val.forEach(function(v) {
                if (v.name !== '') {
                    result += v.name + '<br>';
                }
            });
        } else if (val) {
            result += val;
        }

        return result;
    };

    /**
    * @param {String[]} groups Groups that should be included in the result.
    * @returns {Object[]} Array of summary item definitions.
    */
    Base.prototype.getSummaryItems = inject.mark(function(
        $interpolate, $parse, lang, loader, fortiviewUtil) {
        return function(groups) {
            /*FWB_CHANGE var items = {
                user: [
                    // { text: 'Last Seen',  key: 'timeago' },
                    // { text: 'Reputation', key: 'reputation' },
                    // TODO: add icon if historical provides 'auth'
                    { text: 'Last User',             key: 'last_user' },
                    { text: 'Login User',            key: 'username' }
                ],
                source: [{
                    text: 'Address',
                    html: this.getCountryIconFn,
                    key: 'source'
                }],
                device: [{
                    text: 'Device',
                    html: this.getDeviceIcon
                }],
                app: [{
                    text: 'Applications Detected',
                    getter: $interpolate('{{ apps.length | number }}')
                }],
                policyname: [{
                    text: 'Policy Name',
                    cmdb_key: 'name',
                    html: this.getCmdbSummaryHtml
                }],
                policyid: [{
                    text: 'Policy ID',
                    cmdb_key: 'policyid',
                    html: this.getCmdbSummaryHtml
                }],
                srcintf: [{
                    text: 'Source Interface',
                    cmdb_key: 'srcintf',
                    html: this.getCmdbSummaryHtml
                }],
                'dstintf': [{
                    text: 'Destination Interface',
                    cmdb_key: 'dstintf',
                    html: this.getCmdbSummaryHtml
                }],
                data: [
                    {
                        text: 'Bytes (Sent/Received)',
                        templateUrl: loader
                            .base_path('ng/fortiview/partials/summary_bytes.html'),
                        show: function(value) {
                            return value.sentbyte || value.rcvdbyte;
                        }
                    },
                    {
                        text: 'Bandwidth',
                        templateUrl: loader
                            .base_path('ng/fortiview/partials/summary_total_bandwidth.html'),
                        show: function(value) {
                            return value.tx_bandwidth || value.rx_bandwidth;
                        }
                    },
                    {
                        text: 'Dropped Bytes',
                        templateUrl: loader
                            .base_path('ng/fortiview/partials/summary_shaper_drops.html'),
                        show: function(value) {
                            return value.tx_shaper_drops || value.rx_shaper_drops;
                        }
                    }
                ],
                threat: [
                    {
                        text: 'Threat Score',
                        key: 'utm_score'
                    },
                    {
                        text: 'Threat Type',
                        getter: $interpolate('{{ threattype | lang }}')
                    }
                ],
                common: [
                    {
                        text: 'Sessions',
                        getter: $interpolate('{{ sessions | number }}')
                    },
                    {
                        text: 'Time Period',
                        templateUrl: loader
                            .base_path('ng/fortiview/partials/summary_period.html')
                    }
                ],
                // TODO: (awaiting backend) enable the below listings
                // threat_count: [{
                //   text: 'Threats Discovered',
                //   getter: $interpolate('{{ threats.length | number }}') }],
                'cloud-user': [
                    {
                        text: 'Cloud Apps Detected',
                        getter: $interpolate('{{ apps.length | number }}')
                    }
                ],
                'cloud-app': [
                    {
                        text: 'Category',
                        key: 'category'
                    }
                ],
                cloud: [
                    {
                        text: lang('Files (Up/Down)'),
                        templateUrl: loader
                            .base_path('fortiview/partials/summary_files.html'),
                        show: function(value) {
                            return value.files_uploaded || value.files_downloaded;
                        }
                    }, {
                        text: lang('Videos Played'),
                        key: 'videos'
                    }
                ],
                'vpn-user': [
                    {
                        text: lang('Connections'),
                        getter: $interpolate('{{ connections | number }}')
                    },
                    {
                        text: lang('Connected IPs'),
                        getter: $interpolate('{{ srcip_count  | number }}')
                    },
                    {
                        text: 'Bytes (Sent/Received)',
                        templateUrl: loader
                            .base_path('ng/fortiview/partials/summary_bytes.html'),
                        show: function(value) {
                            return value.sentbyte || value.rcvdbyte;
                        }
                    },
                    {
                        text: lang('Total Duration'),
                        html: function(summary) {
                            return fortiviewUtil.humanize_seconds(summary.duration);
                        }
                    },
                    {
                        text: lang('Last Connection Time'),
                        html: function(summary) {
                            return fortiviewUtil.format_fn.last_conn_time(
                                null, null, summary);
                        }
                    }
                ],
                'mac_address': [
                    {
                        text: 'mac_address',
                        html: function(summary) {
                            var result = '';
                            if (summary && summary.device && summary.mac) {
                                result = summary.mac;
                            }
                            return result;
                        }
                    }
                ],
                'wifiuser': [
                    {
                        text: 'user',
                        key: 'wifiuser'
                    }
                ],
                'wifi-client': [
                    {
                        text: 'ssid',
                        html: function(summary) {
                            var result = '';
                            if (summary && summary.srcssid) {
                                var ssids = summary.srcssid.split(', ');
                                ssids.forEach(function(v) {
                                    if (v !== '') {
                                        result += v + '<br>';
                                    }
                                });
                            }
                            return result;
                        }
                    },
                    {
                        text: 'band',
                        html: function(summary) {
                            var result = '';
                            if (summary && summary.radioband) {
                                var bands = summary.radioband.split(', ');
                                bands.forEach(function(v) {
                                    if (v !== '') {
                                        result += lang(v) + '<br>';
                                    }
                                });
                            }
                            return result;
                        }
                    },
                    {
                        text: 'channel',
                        html: function(summary) {
                            var result = '';
                            if (summary && summary.channel) {
                                return summary.channel;
                            }
                            return result;
                        }
                    },
                    {
                        text: 'ap',
                        html: function(summary) {
                            var result = '';
                            if (summary && summary.ap) {
                                var aps = summary.ap.split(', ');
                                aps.forEach(function(v) {
                                    if (v !== '') {
                                        result += v + '<br>';
                                    }
                                });
                            }
                            return result;
                        }
                    }
                ],
                'bytes': [
                    {
                        text: 'Bytes (Sent/Received)',
                        templateUrl: loader
                            .base_path('ng/fortiview/partials/summary_bytes.html'),
                        show: function(value) {
                            return value.sentbyte || value.rcvdbyte;
                        }
                    }
                ],
                'search-phrase': [
                    {
                        text: 'Frequency',
                        getter: $parse('search_count|number')
                    }
                ]
                // web: [{
                //    text: 'Websites Visited',
                //    getter: $interpolate('{{ websites.length | number }}') }]
            };*/
            var items = {
                'Level': [
                    {
                        text: 'Threat Level',
                        html: function(summary) {
                            var level_idmap = ["off", "low", "medium", "high", "critical"];
                            if(summary.Level && summary.Level != ""){
                                var level = level_idmap[summary.Level];
                                return ["<span class='severity-label wide severity-", level, "'>", $.getInfo(level), "</span>"].join("")
                            } else {
                                return "";
                            }
                        }
                    }
                ],
                'TNumber': [
                    {
                        text: 'Threat Number',
                        key: 'TNumber'
                    }
                ],
                'TScore': [
                    {
                        text: 'Threat Score',
                        key: 'TScore'
                    }
                ],
                'actions': [
                    {
                        text: 'Action (Block/Alert)',
                        templateUrl: loader
                            .base_path('ng/fortiview/partials/summary_actions.html'),
                        show: function(value) {
                            return value.Block || value.Alert;
                        }
                    }
                ],
                'services': [
                    {
                        text: 'Service (HTTP/HTTPS)',
                        templateUrl: loader
                            .base_path('ng/fortiview/partials/summary_services.html'),
                        show: function(value) {
                            return value.HTTP || value.HTTPS;
                        }
                    }
                ],
                'time': [
                    {
                        text: 'Time Period',
                        templateUrl: loader
                            .base_path('ng/fortiview/partials/summary_period.html')
                    }
                ],
                'source': [
                    {
                        text: 'Source',
                        key: 'src'
                    }
                ],
                'requests': [
                    {
                        text: 'Requests',
                        key: 'requests'
                    }
                ],
                'sessions': [
                    {
                        text: 'Sessions',
                        key: 'sessions'
                    }
                ],
                'HTNumber': [
                    {
                        text: 'HTTP Transactions',
                        key: 'HTNumber'
                    }
                ],
                'version': [
                    {
                        text: 'HTTP Version (HTTP1.X/HTTP2)',
                        templateUrl: loader
                            .base_path('ng/fortiview/partials/summary_version.html'),
                        show: function(value) {
                            return value['1.x'] || value['2.0'];
                        }
                    }
                ],
                'Bytes': [
                    {
                        text: 'Bytes (Sent/Received)',
                        templateUrl: loader
                            .base_path('ng/fortiview/partials/summary_bytes.html'),
                        show: function(value) {
                            return value.Request || value.Response;
                        }
                    }
                ],
		'policy': [
		    {
			text: 'Server Policy',
			key: 'policy'
		    }
		]
            };
            return [].concat.apply([], groups.map(get_group));
            //ignore missing groups for now
            function get_group(group) { return items[group] || [] }
        };
    });

    exports = extendsDrilldownBase = function(Controller, extra) {
        var prototype = Controller.prototype;
        Controller.prototype = new Base();
        Controller.prototype.constructor = Base;
        angular.extend(Controller.prototype, extra, prototype);
        return Controller;
    };
    exports.constructor = Base;
    extendsDrilldownBase.requires = [
        '/ng/directives/tabs', '/ng/directives/d3',
        '/ng/directives/compare_bar', '../directives/visualization_controls',
        '/ng/directives/menu/quarantine',
        //FWB_CHANGE '/ng/directives/menu/quarantine-options',
        '../services/facets', '../services/sessions', '../services/visualization',
        '../services/graph', '../services/routeMetadata', '../services/searchState',
        '../services/data', '../services/util', '/ng/log/view/f-log-view'
    ];
    return extendsDrilldownBase;

});
