/*globals define*/
define([
    'module', 'angular', 'widgets', 'fweb.util/functional', 'fweb.util/formatters',
    'ng/services/injector', 'notify', 'ng/services/state'
], function(module, angular, widgets, fweb_util_f, formatters, inject, Notify) {
    'use strict';

    var Base = function() {};

    function forwardLogBasedSegment(seg) {
        // add sources & policies, so that their filters are not global, by Nan Mou
        return ['system', 'admin', 'vpn', 'unauth', 'sandbox', 'sources', 'policies', 'sessions'].indexOf(seg) < 0;
    }

    Base.prototype.init = function(injector, fortiviewSearchState, fortiviewInterfaceLookup, fortiviewRouteMetadata) {
        injector.injectMarked(this);

        this.setCommonScopeValues();
        this.setSearchBarData();

        this.scope.update_title();
        this.scope.$emit('base_init');

        this.scope.drilldownTo = function() {
            this.drilldownTo.apply(this, arguments);
        }.bind(this);

        // Sync controller sortBy property with scope
        this.sourceSortBy = 'Bytes';

        // Sources & Policies, level 1 data sort by sessions as default, added by Nan Mou
        var segment = fortiviewRouteMetadata.baseSegment();
        if (segment === "sources" || segment === "policies") {
            this.sourceSortBy = 'sessions';
        }

        this.scope.sort = {value: this.sourceSortBy};
        this.scope.$watch(function() {
            return this.sourceSortBy;
        }.bind(this), function(value) {
            this.scope.sort.value = value;
        }.bind(this));
        this.scope.$watch('sort.value', function(value) {
            this.sourceSortBy = value;
            this.reloadQlistData();
        }.bind(this));

        this.watchAutoReload();

        //add extra keys to be calculated to this object.
        this.maxValues = this.maxValues || {};
        fortiviewSearchState.drilldownContext = {};
        fortiviewInterfaceLookup.invalidate();
    };

    Base.prototype.setCommonScopeValues =
    inject.mark(function(fortiviewData, fortiviewSearchState, fortiviewRouteMetadata,
                         fortiviewVisualization, fortiviewUtil) {
        var ss = fortiviewSearchState;
        return function() {
            this.scope.visualization = fortiviewVisualization;
            this.scope.fortiview$root.drilldown_title = null;
            this.scope.fortiview$root.view_type = null;
            this.scope.fortiview$root.hide_all_view_types = false;
            this.scope.fortiview$root.haveLogViewDetails = false;

            this.scope.summary = {};//FWB_CHANGE
            this.scope.drilldownDisplayItems = [];//FWB_CHANGE
            this.scope.summaryRows = this.summaryRows.bind(this);//FWB_CHANGE

            ss.drilldownValues = null;
            ss.clear_timeframe_filter();
            // currenty filters are global and
            // not cleared in forward log based views by design
            // FIXME: filter out filters that don't apply to event logs
            //        in facets.js
            if (!forwardLogBasedSegment(fortiviewRouteMetadata.baseSegment())) {
                // prevent forward log filters being used
                // when drilling down to event logs
                ss.clear_filters();
                this.scope.$on('$destroy', function() {
                    // prevent event log filters being used
                    // when drilling down to session logs
                    fortiviewSearchState.clear_filters();
                });
            }

            this.scope.quarantineSourceIPColumnName = fortiviewUtil
            .getQuarantineColumnNameForSegment(
                fortiviewRouteMetadata.baseSegment(false), 'saddr');
        };

    });

    // Top search bar
    Base.prototype.setSearchBarData = inject.mark(function(fortiviewFacets, fortiviewSearchState) {
        return function() {
            var searchOptions = fortiviewSearchState.searchOptions;
            var that = this;

            searchOptions.entries = entries_getter;
            searchOptions.source = 'monitor_api';
            this.scope.fortiview$root.setSearchFacets(fortiviewFacets.forCurrent());
            function entries_getter() {
                return that.scope.qlistSource;
            }
        };
    });

    Base.prototype.update_qlist_realtime_columns = inject.mark(function(fortiviewSearchState) {
        return function(config) {
            var realtime = fortiviewSearchState.state.timeframe === 'realtime';
            config.columns.forEach(function(column) {
                if (['score', 'level', 'duration'].indexOf(column.selector) >= 0) {
                    column.hidden = realtime;
                }
                if (['data_packets', 'tx_packets', 'rx_packets', 'data_bandwidth',
                     'data_shaper_drops']
                    .indexOf(column.selector) >= 0) {
                    column.hidden = !realtime;
                }
                /*FWB_CHANGE
                if (column.selector === 'sessions') {
                    column.lang_key = realtime ? 'Sessions' : 'Sessions (Blocked/Allowed)';
                }
                */
            });
        };
    });

    /**
    * @virtual
    */
    Base.prototype.initQlist = inject.mark(function(fortiviewVisualization) {
        return function() {
            var tooltipOptions = this.scope.visualizationOptions || this.scope.qlistOptions;
            this.scope.d3TooltipFormatter = fortiviewVisualization.createTooltipFormatter(
                tooltipOptions
            );
            this.reloadQlistData();
            this.scope.$on('reload', function() {
                this.reloadQlistData();
            }.bind(this));
        };
    });

    Base.prototype.restartAutoReload = inject.mark(function($timeout, fortiviewVisualization) {
        return function(interval) {
            interval = interval || fortiviewVisualization.getAutoUpdateInterval();
            $timeout.cancel(this.autoUpdateTimeout);

            if (interval) {
                this.autoUpdateTimeout = $timeout(function() {
                    this.reloadQlistData();
                }.bind(this), interval * 1000);
            }
        };
    });

    Base.prototype.watchAutoReload = inject.mark(function($timeout, fortiviewVisualization) {
        return function() {
            var fn = fortiviewVisualization.getAutoUpdateInterval.bind(fortiviewVisualization);
            this.scope.$watch(fn, function(interval) {
                this.restartAutoReload(interval);
            }.bind(this));

            this.scope.$on('$destroy', function() {
                $timeout.cancel(this.autoUpdateTimeout);
            }.bind(this));
        };
    });

    /**
     * @virtual
     */
    Base.prototype.reloadQlistData = inject.mark(
    function($q, fortiviewUtil, fortiviewRouteMetadata, fortiviewVisualization,
             fortiviewSearchState, adminEvent, fortiviewInterfaceLookup) {
        return function(keepPeriod) {
            this.scope.d3Source = null;
            for (var k in this.maxValues) {
                this.maxValues[k] = 0;
            }
            if (!keepPeriod) {
                this.scope.update_period();
            }

            this.update_qlist_realtime_columns(this.scope.qlistOptions);
            this.scope.d3LegendValueFormatter = fortiviewVisualization.createLegendValueFormatter(
                this.sourceSortBy);

            //FWB_CHANGE var prefs = this.api_monitor_prefs;
            var prefs = {};
            var reqs = [this.getCurrentData(prefs)];
            // var reqs = [this.getCurrentData(prefs), this.reloadSummaryData(prefs)];
            /*FWB_CHANGE if (forwardLogBasedSegment(fortiviewRouteMetadata.baseSegment())) {
                reqs.push(fortiviewUtil.get_applications().$promise);
            }*/

            if (fortiviewRouteMetadata.baseSegment(false) === 'interface') {
                reqs.push(fortiviewInterfaceLookup.init());
            }

            if (fortiviewRouteMetadata.baseSegment() === 'admin') {
                reqs.push(adminEvent.get(fortiviewSearchState.get_timeframe_as_range(),
                                      fortiviewSearchState.filters));
            }

            var promise = $q.all(reqs);
            promise.then(function() {
                this.restartAutoReload();
            }.bind(this));
            this.scope.qlistSource = promise.then(function(data) {
                var details = data[0].data.results.details;
                var sum = this.maxSumFields;
                fortiviewUtil.calculateMaxima(this.maxValues, details, sum);
                return details;
            }.bind(this));
            promise.then(function(data) {
                this.scope.d3Source = fortiviewVisualization.processSource(
                    data[0].data.results.details, this.sourceSortBy, null, data);
            }.bind(this));
        };
    });

    Base.prototype.getGraphKey = function(sortBy, fortiviewGraph, fortiviewRouteMetadata) {
        /*FWB_CHANGE var graphKey = sortBy;
        if (fortiviewGraph.EXEMPT_GRAPH[sortBy]) {
            graphKey = this.scope.qlistOptions.options.sort_source_order.selector;
        }
        return graphKey;*/
        var segment = fortiviewRouteMetadata.baseSegment();
        return fortiviewGraph.getGraphKey(segment);
    };

    Base.prototype.getUrlParamsForCurrentData = inject.mark(function($injector, fortiviewGraph,
                                                                     fortiviewData, state,
                                                                     fortiviewSearchState) {
        return function(params) {
            var sort = this.sourceSortBy || 'Bytes';
            var ex_params = {
                sort_by: sort,
                vdom: state.current_vdom
            };
            if (!fortiviewSearchState.is_realtime()) {
                ex_params.count = fortiviewData.getRequestCount();
            }
            return fortiviewData.getUrlParamsForCurrentSegment(angular.extend(ex_params, params));
        };
    });

    Base.prototype.getCurrentData = inject.mark(function($injector, fortiviewGraph, fortiviewData,
                                                         fortiviewSearchState, fortiviewRouteMetadata) {
        return function(params) {
            var sort = this.sourceSortBy || 'Bytes';
            var graphType = this.getGraphKey(sort, fortiviewGraph, fortiviewRouteMetadata);
            var ex_params = {
                tendby: graphType,//FWB_CHANGE
                sort_by: sort
            };
            if (!fortiviewSearchState.is_realtime()) {
                ex_params.count = fortiviewData.getRequestCount();
            }

            this.scope.summary = {};

            return fortiviewData.getForCurrentSegment(angular.extend(ex_params, params))
            // return fortiviewSearchState.segmentData =fortiviewData.getForCurrentSegment(angular.extend(ex_params, params))
            .then(function(result) {
                this.scope.graph = fortiviewGraph.generate_graph(result.data.results.summary.graph,
                                                                 graphType, this.scope);

                var summary = result.data.results.summary.suminfo || {};
                var start = result.data.results.summary.start;
                var end = result.data.results.summary.end;

                angular.extend(summary, {'start': start, 'end': end});
                this.scope.summary = summary;

                return result;
            }.bind(this), fail);

            function fail(error) {
                return $injector.invoke(function($log, $q) {
                    Notify.post(error.message, 'error');
                    //$log.error(error);
                    return $q.reject(error);
                });
            }
        };
    });

    Base.prototype.watchSearchState = inject.mark(function($location) {
        return function() {
            if (this.scope.fortiview$root.view_type) {
                this.scope.$watch('view_type', function(value, oldValue) {
                    if (value !== oldValue) {
                        var parent = $location.path().split('/').slice(0, -1).join('/');
                        $location.path(parent + '/' + value);
                    }
                });
            }
            this.scope.$watch('searchState.state', function(state, old) {
                if (state !== old) {
                    this.reloadQlistData();
                }
            }.bind(this), true);
        };
    });

    // extends a given qlist config with common attributes
    Base.prototype.makeQlistConfig = inject.mark(
    function(lang, fortiviewRouteMetadata, fortiviewUtil, fortigateInfo) {
        return function(config, viewType) {

            config.columns = config.columns || [];
            /* FWB_CHANGE var columns = [
                { selector: 'sessions', lang_key: 'Sessions'},
                { selector: 'data_bytes', lang_key: 'total-bytes'},
                { selector: 'data_packets', lang_key: 'total-packets'},
                { selector: 'data_bandwidth', lang_key: 'Bandwidth'},
                { selector: 'data_shaper_drops', lang_key: 'Dropped Bytes'},
                { selector: 'rcvdbyte', lang_key: 'received'},
                { selector: 'sentbyte', lang_key: 'sent'},
                { selector: 'rx_packets', lang_key: 'rcvdpkt'},
                { selector: 'tx_packets', lang_key: 'sentpkt'}
            ].filter(fortiviewUtil.not_present(config.columns, 'selector'));*/
            var columns = [
                //{ selector: 'attack_type', lang_key: 'Threat'},
                //{ selector: 'Level', lang_key: 'Threat Level'},
                // { selector: 'TNumber', lang_key: 'Threat Number'},
                // { selector: 'TScore', lang_key: 'Threat Score'},
                // { selector: 'actions', lang_key: 'Action (Block/Alert)'},
                { selector: 'services', lang_key: 'Service (HTTP/HTTPS)'},
            ].filter(fortiviewUtil.not_present(config.columns, 'selector'));
            var baseSegment = fortiviewRouteMetadata.baseSegment(false);
            //FWB_CHANGE if (forwardLogBasedSegment(baseSegment) && baseSegment !== 'threat' &&
            if (forwardLogBasedSegment(baseSegment) &&
                ['search-phrase', 'search-phrase-detail'].indexOf(viewType) === -1) {
                config.columns.push.apply(config.columns, columns);
            }

            this.update_qlist_realtime_columns(config);

            /*FWB_CHANGE config.format_fn = angular.extend({
                apps: fortiviewUtil.format_fn.apps,
                username: widgets.format_fn.username,
                address: fortiviewUtil.format_fn.address,
                device: widgets.format_fn.device,
                data_bytes: fortiviewUtil.format_fn.bytes_compare(function() {
                    return this.maxValues.data_bytes;
                }.bind(this)),
                sessions: fortiviewUtil.format_fn.count_compare(function() {
                    return this.maxValues.sessions;
                }.bind(this)),
                data_packets: fortiviewUtil.format_fn.two_compare(function() {
                    return this.maxValues.data_packets;
                }.bind(this), ['tx_packets', 'rx_packets']),
                data_bandwidth: fortiviewUtil.format_fn.two_compare(function() {
                    return this.maxValues.data_bandwidth;
                }.bind(this), ['tx_bandwidth', 'rx_bandwidth'], formatters.metric_bits_per_second),
                data_shaper_drops: fortiviewUtil.format_fn.bytes_compare(function() {
                    return this.maxValues.data_shaper_drops;
                }.bind(this), ['tx_shaper_drops', 'rx_shaper_drops']),
                count: fortiviewUtil.format_fn.one_compare(function() {
                    return this.maxValues.count;
                }.bind(this)),
                score: fortiviewUtil.format_fn.two_compare(function() {
                    return this.maxValues.score;
                }.bind(this), ['score_block', 'score_allow']),
                level: fortiviewUtil.format_fn.level,
                rcvdbyte: fortiviewUtil.commonBytesFormatter,
                sentbyte: fortiviewUtil.commonBytesFormatter,
                duration: fortiviewUtil.format_fn.duration(function() {
                    return this.maxValues.duration;
                }.bind(this)),
                search_count: fortiviewUtil.format_fn.one_compare(function() {
                    return this.maxValues.search_count;
                }.bind(this), 'search_count')
            }, config.format_fn);*/
            config.format_fn = angular.extend({
                actions: fortiviewUtil.format_fn.fwb_count_compare(function() {
                    return this.maxValues.actions;
                }.bind(this), ['Block', 'Alert']),
                services: fortiviewUtil.format_fn.fwb_count_compare(function() {
                    return this.maxValues.services;
                }.bind(this), ['HTTP', 'HTTPS']),
                Level: fortiviewUtil.format_fn.level,
                srccountry: fortiviewUtil.format_fn.country,
                version: fortiviewUtil.format_fn.fwb_count_compare(function() {
                    return this.maxValues.version;
                }.bind(this), ['1.x', '2.0']),
                Bytes: fortiviewUtil.format_fn.fwb_bytes_compare(function() {
                    return this.maxValues.Bytes;
                }.bind(this), ['Request', 'Response']),
            }, config.format_fn);

            function after_format(cells) {
                var $scope = angular.element('.fortiview').scope();
                var $compile = angular.element(".fortiview").injector().get("$compile");
                $compile(cells)($scope);
            }

            config.after_format_fn = angular.extend({
                actions: after_format,
                services: after_format,
                version: after_format,
                Bytes: after_format,
            }, config.after_format_fn);

            config.sort_fn = config.sort_fn || fortiviewUtil.generateSortFn(this);

            config.options = angular.extend({
                hide_menu: true,
                hide_default_buttons: true,
                force_context_menu: true,
                sorting: true,
                /*FWB_CHANGE sort_columns: {
                    data_bytes: 'desc',
                    data_packets: 'desc',
                    data_bandwidth: 'desc',
                    data_shaper_drops: 'desc',
                    sessions: 'desc',
                    count: 'desc',
                    score: 'desc',
                    files: 'desc',
                    connections: 'desc',
                    bandwidth: 'desc',
                    'login_count': 'desc',
                    'failure_count': 'desc',
                    'config_changes': 'desc',
                    'last_conn_time': 'desc',
                    'failure_attempt': 'desc',
                    'search_count': 'desc'
                },
                sort_source_order: {
                    selector: 'data_bytes',
                    direction: 'desc'
                }*/
                sort_columns: {
                    Level: 'desc',
                    TNumber: 'desc',
                    TScore: 'desc',
                    HTNumber: 'desc',
                    Bytes: 'desc',
                    sessions: 'desc',
                },
                sort_source_order: {
                    selector: 'TNumber',
                    direction: 'desc'
                }
            }, config.options);
            config.enhanced_context = true;

            config.sort = angular.extend({
                'save_in_cookie': false
            }, config.sort);

            config.paging = angular.extend({
                enabled: true,
		// new added attribute for only show total count in paging
		only_show_total: true,
                page_lines: fortigateInfo.info.lines_per_page
            }, config.paging);

            if (config.callbacks == null) { config.callbacks = {}; }
            var load_callback = config.callbacks.load;
            config.callbacks.load = function() {
                if (angular.isFunction(load_callback)) {
                    load_callback.call(this);
                }
                widgets.callbacks.load.call(this);
            };
            return config;
        };
    });

    /* FWB_CHANGE */
    Base.prototype.summaryRows = function() {
        var scope = this.scope;
        function format(item) {
            if (item.templateUrl) {
                return !item.show || item.show(scope.summary) ?
                    {text: item.text, templateUrl: item.templateUrl} : null;
            }
            var value = '';
            if (item.html) {
                value = item.html(scope.summary) || '';
            }
            if (angular.isFunction(item.getter)) {
                value += item.getter(scope.summary) || '';
            }
            if (item.key) {
                value += scope.summary[item.key] || '';
            }
            return value ? {text: item.text, value: value} : null;
        }
        function has_value(item) {
            return item &&
                (item.value &&
                 String(item.value).replace(/^\s*$/, '') ||
                 item.templateUrl);
        }

        var items = this.scope.drilldownDisplayItems.map(format);
        items = items.filter(has_value);

        //cache previous call and return the same array if it matches, otherwise
        //ng-repeat will cause diginf exceptions.
        this._summaryRows = angular.equals(items, this._summaryRows) ?
                                    this._summaryRows : items;
        return this._summaryRows;
    };

    /* FWB_CHANGE */
    Base.prototype.getSummaryItems = inject.mark(function(
        $interpolate, $parse, lang, loader, fortiviewUtil) {
        return function(groups) {
            var items = {
                'TNumber': [
                    {
                        text: 'Threat Number',
                        key: 'TNumber'
                    }
                ],
                'TScore': [
                    {
                        text: 'Threat Score',
                        key: 'TScore'
                    }
                ],
                'actions': [
                    {
                        text: 'Action (Block/Alert)',
                        templateUrl: loader
                            .base_path('ng/fortiview/partials/summary_actions.html'),
                        show: function(value) {
                            return value.Block || value.Alert;
                        }
                    }
                ],
                'services': [
                    {
                        text: 'Service (HTTP/HTTPS)',
                        templateUrl: loader
                            .base_path('ng/fortiview/partials/summary_services.html'),
                        show: function(value) {
                            return value.HTTP || value.HTTPS;
                        }
                    }
                ],
                'time': [
                    {
                        text: 'Time Period',
                        templateUrl: loader
                            .base_path('ng/fortiview/partials/summary_period.html')
                    }
                ],
                'HTNumber': [
                    {
                        text: 'HTTP Transactions',
                        key: 'HTNumber'
                    }
                ],
                'version': [
                    {
                        text: 'HTTP Version (HTTP1.X/HTTP2)',
                        templateUrl: loader
                            .base_path('ng/fortiview/partials/summary_version.html'),
                        show: function(value) {
                            return value['1.x'] || value['2.0'];
                        }
                    }
                ],
                'Bytes': [
                    {
                        text: 'Bytes (Sent/Received)',
                        templateUrl: loader
                            .base_path('ng/fortiview/partials/summary_bytes.html'),
                        show: function(value) {
                            return value.Request || value.Response;
                        }
                    }
                ],
            };
            return [].concat.apply([], groups.map(get_group));
            //ignore missing groups for now
            function get_group(group) { return items[group] || [] }
        };
    });

    /* FWB_CHANGE */
    // Base.prototype.reloadSummaryData = inject.mark(function($q, fortiviewData, fortiviewGraph, fortiviewRouteMetadata, fortiviewSearchState) {
    //     return function(params) {
    //         var sort = this.sourceSortBy || 'Bytes';
    //         var graphType = this.getGraphKey(sort, fortiviewGraph, fortiviewRouteMetadata);
    //         var ex_params = {
    //             tendby: graphType,
    //             sort_by: sort
    //         };
    //         if (!fortiviewSearchState.is_realtime()) {
    //             ex_params.count = fortiviewData.getRequestCount();
    //         }

    //         this.scope.summary = {};
    //         return fortiviewData.getSummary(angular.extend(ex_params, params))
    //         .then(function(summary) {
    //             this.scope.summary = angular.extend(this.scope.summary, summary);

    //             return summary;
    //         }.bind(this));
    //     };
    // });

    var exports, extendsBase;
    exports = extendsBase = function(Controller, extra) {
        var prototype = Controller.prototype;
        Controller.prototype = new Base();
        Controller.prototype.constructor = Base;
        angular.extend(Controller.prototype, extra, prototype);
        return Controller;
    };
    exports.constructor = Base;

    extendsBase.requires = [
        '/ng/directives/d3',
        '/ng/directives/d3_bubble_cluster', '/ng/services/icon_code',
        '/ng/directives/compare_bar',//FWB_CHANGE
        /*FWB_CHANGE '/ng/services/csf',*/ '/ng/services/chart/csf_chart', '/ng/services/chart/cloud_svg',
        '../directives/visualization_controls',
        '/ng/directives/menu/quarantine',
        //FWB_CHANGE '/ng/directives/menu/quarantine-options',
        '../services/facets', '../services/data', '../services/searchState',
        '../services/util', '../services/graph', '../services/visualization',
        '../services/adminEvent', '../directives/graph_dropdown',
        '../services/learningReport'
    ];
    return extendsBase;

});
