/*globals define*/
define(['module', 'angular', './mainBase', 'qed_list',
    'widgets', 'ng/services/lang', 'ng/services/injector'
], function(module, angular, mainCtrl) {
    'use strict';

    function Policies($injector, $scope, $location, fortiviewUtil, fortiviewSearchState) {
        this.scope = $scope;
        $injector.invoke(this.init, this);
        
        fortiviewSearchState.showRightMenu = false;

        fortiviewUtil.onLangUpdatedApply($scope,
            'fortiview$root.category_title', '{{ "Policies" | lang }}');

        this.watchSearchState();

        this.drilldownTo = function(entry) {
            $location.path($location.path() + '/' + encodeURIComponent(entry.policies));
        };

        $scope.noSummary = true;

        $scope.qlistOptions = this.makeQlistConfig({
            prefix: 'qlist_policies',
            default_columns: ['policies', 'sessions', 'requests', 'Bytes'],
            columns: [
                { selector: 'policies', lang_key: 'Policy'},
                { selector: 'Bytes', lang_key: 'Bytes (Sent/Received)'},
                { selector: 'requests', lang_key: 'Requests'},
                { selector: 'sessions', lang_key: 'Sessions'}
            ],
            options: {
                sort_source_order: {
                    selector: 'sessions',
                    direction: 'desc'
                },
                sort_columns: {
                    Bytes: 'desc',
                    requests: 'desc',
                    sessions: 'desc',
                },
            },
        });

        this.initQlist();
    }

    return function(providers, loader) {
        providers.$controller.register('FortiviewPolicies', mainCtrl(Policies));
        return loader.initModules([
            '../services/util', '../services/searchState', '../services/visualization'
        ].concat(mainCtrl.requires), module);
    };
});
