/*globals define*/
define(['module', 'angular', './drilldownBase', 'fweb.util'],
function(module, angular, drilldown, fweb_util) {
    'use strict';

    function PoliciesDrilldown($scope, $injector, $interpolate, fortiviewUtil, fortiviewSessions, fortiviewSearchState) {
        var blocked_tabs = ['threat', 'action', 'country', 'source', 'destination', 'device', 'http_method', 'http_url', 'tDestination', 'tPolicy', 'tHttpHost', 'tHttpMethod', 'tHttpRetcode', 'tHttpUrl', "aPolicy", "signature_cve_id", "owasp_top10"];
        $injector.invoke(this.init, this, {$scope: $scope, blocked_tabs: blocked_tabs});

        fortiviewSearchState.showRightMenu = false;

        $scope.noGraph = true;
        $scope.drilldownTabs.current = 'sources';

        $scope.drilldownDisplayItems = this.getSummaryItems([
            'Bytes', 'requests', 'sessions'
        ]);

        angular.extend($scope.excludeDrilldown, {
            'sessions': true
        });

        $scope.drilldownData = {
            sources: {qlistOptions: this.makeQlistConfig('sources')},
            destinations: {qlistOptions: this.makeQlistConfig('destinations')},
            sessions: {qlistOptions: this.makeQlistConfig('sessions')},
        };

        this.reloadData();
    }

    return function(providers, loader) {
        providers.$controller.register('FortiviewPoliciesDrilldown', drilldown(PoliciesDrilldown));
        return loader.initModules(drilldown.requires, module);
    };

});
