/*globals define*/
define(['notify', 'jquery', 'jquery.util'], function(Notify, $) {
    'use strict';

    function RemoveSessions($scope, $http, lang) {

        $scope.removeSessions = function(entries) {
            var confirmParams = {
                message: lang('confirm_end_sessions').toString(),
                ok_text: lang('OK').toString(),
                cancel_text: lang('Cancel').toString(),
            };
            $.confirm(confirmParams)
                .then(function() {
                    var data ={'json':  entries.map(function(entry) {
                        //FWB_CHANGE
                        // return {
                        //     path: 'firewall',
                        //     name: 'session',
                        //     action: 'close',
                        //     pro: entry.proto,
                        //     saddr: entry.saddr,
                        //     daddr: entry.daddr,
                        //     sport: entry.sport,
                        //     dport: entry.dport
                        // };
                        return {
                            sip: entry.sources,
                            sport: entry.sports,
                            work_idx: entry.work_idx,
                            sid: entry.sid
                        };
                    })};

                    $http.post('/fortiview/sessions/delete' , JSON.stringify(data)).then(function() {
                        $scope.refresh();
                        Notify.post(lang('Session(s) ended successfully').toString());
                    });
                });
        };

        //FWB_CHANGE: back-end not supported yet.
        // $scope.removeAllSessions = function() {
        //     $.confirm(lang('confirm_end_all_sessions').toString()).then(function() {
        //         var data = {path: 'firewall', name: 'session', action: 'clear-session'};
        //         // Removing all sessions will cause the HTTP response to fail, so we just have to
        //         // assume that everything was removed properly
        //         $http.post('/api/monitor?json=' + JSON.stringify(data)).finally(function() {
        //             $scope.refresh();
        //             Notify.post(lang('All sessions have ended').toString());
        //         });
        //     });
        // };

        $scope.removeAllSessions = function(qlistSource) {
            var entries;
            if (qlistSource.wrapped) {
                entries = qlistSource.wrapped.$$state.value;
            } else {
                entries = qlistSource.$$state.value;
            }
            if (!entries)
                return;
            var confirmParams = {
                message: lang('confirm_end_all_sessions').toString(),
                ok_text: lang('OK').toString(),
                cancel_text: lang('Cancel').toString(),
            };
            $.confirm(confirmParams).then(function() {
                var data = {'json': entries.map(function(entry) {
                    return {
                        sip: entry.sources,
                        sport: entry.sports,
                        work_idx: entry.work_idx,
                        sid: entry.sid
                    };
                })};

                $http.post('/fortiview/sessions/delete' , JSON.stringify(data)).then(function() {
                    $scope.refresh();
                    Notify.post(lang('All sessions ended').toString());
                });
            });
        };
    }

    return function(providers) {
        providers.$controller.register('RemoveSessions', RemoveSessions);
    };
});
