/*globals define*/
define(['module', 'angular', 'jquery', 'fweb.util/datetime', 'notify'],
function(module, angular, $, util_datetime, Notify) {
    'use strict';

    /**
     * Setup / Controller for root scope
     */

    /*jshint maxparams:14*/
    function Root($scope, $location, $rootScope, $injector, $routeParams, $timeout,
             lang, fortiviewSearchState, fortiviewUtil, fortiviewData, fortiviewLoading,
             /*FWB_CHANGE fortiviewDependencies,*/ fortigateInfo, loader, dialog, $window) {

        fortiviewData.clearCache();
        fortiviewLoading.init();

        // Setup the page title
        fortiviewUtil.onLangUpdatedApply($scope, 'page_title',
                                         '{{ "FortiView" | lang }}');

        $scope.$on('$routeChangeSuccess', function(event, current, previous) {
            // Route segment doesn't reload on search properly, so we need to detect that ourselves
            // and do it manually. This happens when switching VDOMs.
            if (current.$$route === previous.$$route) {
                //FWB_CHANGE fortiviewDependencies.update(null, $scope.view_type, null, true);
                $scope.refresh();
            }
        });

        $window.onunload = function() {
            fortiviewData.abort();
        }

        $scope.category_title = null;
        $scope.drilldown_title = null;
        // TODO: (cleanup) just setup a watcher, it'll be cleaner
        $scope.update_title = function() {
            // TODO: when f-lang uses interpolation, rather than eval, remove
            //       the surrounding quotes
            var parts = [$scope.page_title],
                format = '{0}';
            if ($scope.category_title) {
                parts.push($scope.category_title);
                format += ': {1}';
                if ($scope.category_title_value) {
                    format += ' {2}';
                    parts
                        .push(new lang.Translated($scope.category_title_value));
                }
                if ($scope.drilldown_title) {
                    format += ' > {' + parts.length + '}';
                    parts.push($scope.drilldown_title);
                    if ($scope.drilldown_title_value) {
                        format += ' {' + parts.length + '}';
                        parts.push(new lang
                                    .Translated($scope.drilldown_title_value));
                    }
                }
            }
            var title = lang.format(format, parts.map(lang_map));
            $rootScope.page_title = new lang.Translated(title);
            function lang_map(id) { return lang(id) }
        };
        $scope.update_title();

        $scope.fortiview$root = $scope;

        // Basic navigation -- TODO put in a directive
        var SEP = '/';
        $scope.canGoUp = function() {
            var path = $location.path().replace(/\/(web|cloud|sandbox|interface|device)\//, '/');
            var pathSections = path.split(SEP).length - 1;
            return pathSections > 2;
        };
        $scope.goUp = function(additional) {
            var returnPath = $location.search()['return'];
            if (returnPath) {
                $location.search('return', null);
                $location.path(returnPath);
            } else {
                var location = $location.path().split(SEP),
                    amount = (location.length >= 6 ? 2 : 1) + (additional || 0);

                // Sessions go up, added by Nan Mou
                if (location.length == 7 && location[4] == 'sessions') {
                    amount = 3 + (additional || 0);
                }

                // Sources & Policies drilldown go up, remove empty filters, added by Nan Mou
                if (location.length == 4 && (location[2] == "sources" || location[2] == "policies")) {
                    angular.element('.f-faceted-search').scope().$cancel();
                }

                location = location.slice(0, -amount).map(fortiviewUtil.decodeDrilldownValue);
                $scope.$broadcast('beforeGoUp');
                $location.path(location.join(SEP));
            }
        };
        $scope.refresh = function() {
            fortiviewData.clearCache();
            $scope.$broadcast('reload');
        };
        $scope.loadSettings = function() {
            var model = $injector.get('fortiviewSettings');
            // Change it back to its last saved state when opened
            model.reset();
            dialog.open('fortiview_settings', {
                template: loader.base_path('/ng/fortiview/partials/settings.html'),
                title: lang('FortiView Settings').toString(),
                model: model,
                button_labels: [lang('apply')],
                disable_cancel_button: true
            }).then(function() {
                model.save().then(function() {
                    $scope.refresh();
                    Notify.post(lang('Settings updated successfully').toString());
                });
            });
        };
        $scope.setSearchFacets = function(searchFacets) {
            this._searchFacets = searchFacets;
            update_search_facets();
        };

        function update_search_facets() {
            if ($scope._searchFacets) {
                var realtime = fortiviewSearchState.state.timeframe === 'realtime';
                var key = realtime ? 'realtime' : 'historical';
                fortiviewSearchState.facets = $scope._searchFacets.filter(function(facet) {
                    var meta = facet.meta || {};
                    return meta[key] != null ? meta[key] : true;
                });
            }
        }

        //FWB_CHANGE $scope.fortigateHasDisk = fortigateInfo.info.capabilities.disk_logging_supported;

        // Bind searchState.state.timeframe to the timescale slider's value
        $scope.searchState = fortiviewSearchState;
        $scope.fortiviewUtil = fortiviewUtil;

        // options for the VisualSearch input
        $scope.searchOptions = {};

        var initialized = false;
        $timeout(function() { initialized = true; });

        $scope.$watch('searchState.state.timeframe', update_period);

        function update_period(value) {
            var split;
            //sometimes called directly with no argument.
            value = value || $scope.searchState.state.timeframe;
            if (value.indexOf('custom') === 0) {
                split = value.split(':');
                $scope.searchState.last_period = {
                    start: split[1],
                    end: split[2]
                };
            } else {
                $scope.searchState.last_period = fortiviewUtil.fixTimeRange(
                    util_datetime.timeframeRange(value), fortigateInfo.info.timeinfo.offset);
            }
            //FWB_CHANGE fortiviewDependencies.update(null, $scope.view_type, value);
            update_search_facets();
        }
        $scope.update_period = update_period;

        /*FWB_CHANGE $scope.$on('base_init', function() {
            fortiviewDependencies.update(null, $scope.view_type, null, true);
        });*/
    }

    return function(providers, loader) {
        providers.$controller.register('Fortiview', Root);
        return loader.initModules(['removeSessions', /* FWB_CHANGE '../services/dependencies', */
            '../services/searchState', '../services/util', '../services/data', '../services/loading',
            'settings', '/ng/directives/faceted_search/faceted_search',
            /* FWB_CHANGE '../directives/dependencies_warning',*/ '../directives/timeframe_options',
            '../directives/visualization_options',
            '../directives/bubble_cluster_options',
            '../directives/f-learning-report-sections',
            '../directives/f-learning-report-display-options'
        ], module);
    };
});
