/*globals define*/
define([
    'module', 'angular', 'widgets',
    'ng/services/injector'
], function(module, angular, widgets, inject) {
    'use strict';

    /**
     * Setup / Controller for root scope
     */

    var PERSIST_KEY = 'Fortiview.ScannerIntegration';
    var TYPE_OPEN = 0;
    var TYPE_MITIGATED = 1;

    var SUMMARY_TYPE_SEVERITY = '0';
    var SUMMARY_TYPE_SCAN = '1';

    var URL_SUMMARY = 'api/v1.0/Fortiview/Fabric/ScannerIntegration';
    var URL_LIST = 'api/v1.0/Fortiview/Fabric/ScannerIntegrationList';
    var URL_COLUMN = '/wvs/integration/column';

    function ScannerIntegrationController(Facets, $q, injector, $scope, persistentStorage, facetedSearchUtil) {
        injector.injectMarked(this);
        this.scope = $scope;
        $scope.facetedSearch = {};
        $scope.summary_type = SUMMARY_TYPE_SEVERITY;
        $scope.summary_level = 1;
        $scope.list_type = TYPE_MITIGATED;
        $scope.graph_data = [];
        $scope.previous_graph = null;
        $scope.select_types = [
            TYPE_MITIGATED, TYPE_OPEN
        ];
        $scope.select_options = [
            {value: SUMMARY_TYPE_SEVERITY, name: $.getInfo('severity')},
            {value: SUMMARY_TYPE_SCAN, name: $.getInfo('scanner_type')},
        ];
        $scope.currnent_key = [];
        $scope.back = function() {
            if($scope.summary_level > 1)
            {
                $scope.summary_level--;
                $scope.currnent_key.pop();
                $scope.graph = this.generateGraph($scope.graph_data[$scope.summary_level-1], $scope.summary_level);
            }

        }.bind(this);
        $scope.refresh = function() {
            this.reloadData();
        }.bind(this);
        $scope.setType = function(type) {
            $scope.list_type = type;
            this.reloadQlistData();
        }.bind(this);

        this.facets = {},

        this.setSearchBarData();
        this.setWatch();

        this.getColumns().then(function(columns) {

            this.columns = columns;
            this.reloadData();

        }.bind(this))
    }

    ScannerIntegrationController.prototype = {

        setWatch: inject.mark(function($location) {
            return function() {
                this.scope.$watch('facetedSearch.model', function(state, old) {
                    if (state !== old) {
                        this.reloadQlistData();
                    }
                }.bind(this), true);

                this.scope.$watch('summary_type', function(type, old) {
                    if (type !== old && this.scope.summary_level == 2) {
                        var params = {summary_type: this.scope.summary_type};

                        this.get(URL_SUMMARY, params).then(function(data) {
                            var currnet_data = data.data[this.scope.currnent_key[0]];
                            this.scope.graph_data = [data.data, currnet_data];
                            this.scope.graph = this.generateGraph(currnet_data, this.scope.summary_level);
                        }.bind(this));
                    }
                }.bind(this), true);
            };
        }),



        processSummary: function(data) {
            var result = {data:{}, total:data.total, max:0};

            ['Mitigated', 'Open'].forEach(function(status) {
                var d = data[status] || {};
                var status_data = {data:[], sum: d.sum || 0, percent:d.percent || 0};
                ['High', 'Medium', 'Low'].forEach(function(severity) {
                    var severity_data = {key: severity};
                    if(d[severity]) {
                        severity_data.count = d[severity]['count'];
                        severity_data.percent = d[severity]['count']/data.total*100;
                    } else {
                        severity_data.count = 0;
                        severity_data.percent = 0;
                    }

                    status_data.data.push(severity_data);
                    if(severity_data.count > result.max)
                            result.max = severity_data.count;
                });
                result.data[status] = status_data;
            });

            return result;
        },

        getColumns: function() {
            function filterableColumn(column) {
                return !column.disabled && !column.alias_of;
            }

            var getQlistConfig = function(argument) {
                return this.scope.qlistOptions;
            }.bind(this);

            function highlight() {
                var qlistConfig = getQlistConfig();
                var chosen = false;
                //     scm = LogFormatters.smartColumnMap,
                //     selector = this.selectors.history;
                // if (qlistConfig && qlistConfig.chosen_columns) {
                //     chosen = qlistConfig.chosen_columns.indexOf(selector) > -1;
                //     if (!chosen && scm && (selector in scm)) {
                //         selector = scm[selector];
                //         chosen = qlistConfig.chosen_columns.indexOf(selector) > -1;
                //     }
                // }
                return chosen;
            }

            return this.get(URL_COLUMN, {}).then(function(response) {
                var data = response.data;

                data.columns.forEach(function(entry, index, columns) {
                    if(entry.selector == '#')
                        entry.selector = "id";
                    else if(entry.selector == 'miti_status')
                        delete columns[index];
                    else if(entry.selector == 'rel_time')
                        entry.type = 'date_time';

                });

                data.default_columns.forEach(function(entry, index, default_columns) {
                    if(entry == '#')
                        entry = 'id';
                    else if(entry == 'miti_status')
                        delete default_columns[index];
                });

                var facet_columns = data.columns.filter(function(column) {
                    var filter_disable_columns = ['id', 'rule_name'];
                    return filter_disable_columns.indexOf(column.selector) === -1;
                }); 
                this.scope.facetedSearch.facets = this.initFacets(facet_columns, highlight);

                return data;
            }.bind(this));
        },


        setSearchBarData: inject.mark(function(persistentStorage, $q) {
            return function() {
                
                var that = this;
                this.scope.facetedSearch.options = {};
                this.scope.facetedSearch = {
                    facets: null,
                    model: persistentStorage.get(PERSIST_KEY) || {},
                    options: {
                        entries: entries_getter,
                        source: 'history'
                    },
                };

                function entries_getter() {
                    return that.scope.qlistSource;                    
                }
            };
        }),

        reloadData: inject.mark(function($q) {
            return function() {

                this.loading = {
                    list: this.reloadQlistData(),
                    summary: this.reloadSummaryData()
                };

                $q.all(this.loading).then(resolveResponses.bind(this), rejectResponses);

                function resolveResponses(responses) {
                    // this.qlist.source = responses.data.source;
                    // this._updateQlistOptions();
                }
                function rejectResponses() {
                    console.error('ERROR OCCURRED:', arguments);
                }
            };
        }),

        reloadSummaryData: inject.mark(function($q) {
            return function() {
                var params = {summary_type: SUMMARY_TYPE_SEVERITY};

                var summary = this.get(URL_SUMMARY, params).then(function(data) {
                        this.scope.summary_level = 1;
                        this.scope.summary_type = SUMMARY_TYPE_SEVERITY;
                        this.scope.currnent_key = [];
                        this.scope.summary = this.processSummary(data.data);
                        this.scope.graph_data = [data.data];
                        this.scope.graph = this.generateGraph(data.data, 1);
                }.bind(this));
            };
        }),

        generateGraph: function(data, level) {
            var that = this;
            var config = null;
            var pie_config = {
                credits: {
                    enabled: false
                },
                chart: {
                    type: 'pie',
                    margin: [0, 0, 0, 0],
                    spacingTop: 0,
                    spacingBottom: 0,
                    spacingLeft: 0,
                    spacingRight: 0
                    // options3d: {
                    //     enabled: true,
                    //     alpha: 45,
                    //     beta: 0
                    // }
                },
                colors: ['#BD1F08','#E8A02B','#FFE326','#BDEA2D','#31BD4C','#32A2A6','#2A60A6','#434348','#7429A6','#A63077','#A6602D'],
                legend: {
                    align: 'right',
                    verticalAlign: 'top',
                    layout: 'vertical',
                    itemMarginTop: 5,
                    itemMarginBottom: 5,
                    width: 100,
                    x: -127,
                    y: 60
                },
                title: {
                    text: ''
                },
                tooltip: {
                    headerFormat: '{point.key}<br>',
                    // pointFormat: '{series.name}: <b>{point.y}</b>'
                },
                plotOptions: {
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        showInLegend: true,
                        depth: 35,
                        center: [160, "50%"],
                        size: 160,
                        innerSize: '75%',
                        // dataLabels: {
                        //     enabled: true,
                        //     format: '<b>{point.name}</b> ({point.percent}%)',
                        //     style: {
                        //         color: (Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black'
                        //     }
                        // }
                        dataLabels: {
                            enabled: true,
                            distance: 3,
                            format: '{point.percent:.1f}%',
                            style: {
                                fontWeight: 'bold',
                                color: 'black'
                            }
                        },
                    },
                    series: {
                        cursor: 'pointer',
                        point: {
                            events: {
                                click: function () {
                                    that.scope.$apply(function() {
                                        var key = this.name;
                                        var level = that.scope.summary_level;
                                        var data = that.scope.graph_data[level-1][key];
                                        if(data){
                                            that.scope.currnent_key.push(key);
                                            that.scope.graph_data[level] = data;
                                            that.scope.summary_level++;
                                            that.scope.graph = that.generateGraph(that.scope.graph_data[that.scope.summary_level-1], that.scope.summary_level);
                                        }
                                    }.bind(this))
                                }
                            }
                        }
                    }
                },
                series: []
            }

            var column_config = {
                credits: {
                    enabled: false
                },
                chart: {
                    type: 'column',
                    // options3d: {
                    //     enabled: true,
                    //     alpha: 0,
                    //     beta: 0,
                    //     depth: 50,
                    //     viewDistance: 25
                    // }
                },
                colors: ['#BD1F08','#E8A02B','#FFE326','#BDEA2D','#31BD4C','#32A2A6','#2A60A6','#434348','#7429A6','#A63077','#A6602D'],
                legend: {
                    enabled: false
                },
                xAxis: {
                    type: 'category'
                },
                yAxis: {
                    title: {
                        text: $.getInfo('Counts')
                    }
                },
                title: {
                    text: ''
                },
                tooltip: {
                    headerFormat: '{point.key}<br>',
                },
                plotOptions: {
                    column: {
                        depth: 25
                    },
                    series: { pointWidth: 30 }
                },
                series: []
            };

            var chart_data = [];
            if(level == 1)
            {
                ['Mitigated', 'Open'].forEach(function(key) {
                    var color = (key == 'Mitigated') ? '#97D417':'#FFCA5C';
                    if(data[key] && data[key]['sum'])
                        chart_data.push({name:key, y:data[key]['sum'], percent:data[key]['percent'], color:color});
                });

                config = pie_config;
            }
            else if(level == 2)
            {
                Object.keys(data).forEach(function(key) {
                    if(['percent','sum'].indexOf(key) < 0)
                    {
                    	var entry = {
                            name:key,
                            y:data[key]['count'],
                            percent:data[key]['percent']
                        };

                        if(['High','Medium', 'Low'].indexOf(key) >= 0) {
                        	var colors = {
                        		'High': '#BD1F08','Medium': '#E8A02B', 'Low': '#FFE326'
                        	};
                        	entry.color = colors[key];
                        }

                        chart_data.push(entry);
                    }
                });

                config = pie_config;
            }
            else if(level == 3)
            {
                var vuln_nodes = data.vuln_nodes;
                vuln_nodes.forEach(function(node) {
                    chart_data.push({name:node.name, y:node.count});
                });

                config = column_config;
            }


            config.series = [{
                name: $.getInfo('Counts'),
                colorByPoint: true,
                data: chart_data
            }];

            return config;
        },

        reloadQlistData: inject.mark(function($q, fortigateInfo, facetedSearchUtil) {
            return function() {
                var filter = this.facets.makeQlistFilters(this.scope.facetedSearch.model);

                var ex_params = {
                    page: 1,
                    count: fortigateInfo.info.lines_per_page,
                    filter: JSON.stringify(filter)
                };

                // var open = this.get(URL_LIST, angular.extend({status: TYPE_OPEN}, ex_params));
                // open.then(function(data) {
                //     var config = angular.extend({}, this.columns);
                //     config.paging = {total_lines: data.data.total_lines};
                //     this.scope.qlistOptionsOpen = this.getQlistOptions(config, TYPE_OPEN);

                //     this.scope.qlistSourceOpen = data.data.source;
                // }.bind(this));

                // var mitigated = this.get(URL_LIST, angular.extend({status: TYPE_MITIGATED}, ex_params));
                // mitigated.then(function(data) {
                //     var config = angular.extend({}, this.columns);
                //     config.paging = {total_lines: data.data.total_lines};
                //     this.scope.qlistOptionsMitigated = this.getQlistOptions(config, TYPE_MITIGATED);

                //     this.scope.qlistSourceMitigated = data.data.source;
                // }.bind(this));

                // return [open, mitigated];
                var type = this.scope.list_type;
                var req = this.get(URL_LIST, angular.extend({status: type}, ex_params));
                req.then(function(data) {
                    var config = angular.extend({}, this.columns);
                    config.paging = {total_lines: data.data.total_lines};
                    this.scope.qlistOptions = this.getQlistOptions(config, type);

                    this.scope.qlistSource = data.data.source;
                }.bind(this));

                return req;
            };
        }),

        getQlistOptions: inject.mark(function(lang, fortigateInfo, fortiviewUtil) {
            return function(config, type) {
                config.format_fn = angular.extend({
                    'rel_time': function(el, column, data) {
                        var value = data[column.selector] || '';
                        var date = fortiviewUtil.formatLocalTime(value * 1000, 'yyyy-MM-dd HH:mm')
                        return '<span title="' + date + '">' + date + '</span>';
                    },
                    'severity': function(el, column, data) {
                        var value = data[column.selector] || '';
                        var html = '';
                        html += '<img src="/images/' + value.toLowerCase() + '.png" title="' + value + '">&nbsp;';
                        html += '<nobr>' + $j.getInfo(value.toLowerCase()) + '</nobr>';
                        return html;
                    },
                    'miti_status': function(el, column, data) {
                        var value = data[column.selector] || '';
                        var html = '';
                        if(value === 'Open')
                            html += '<img src="/images/status_table.png" title="' + value +  '">&nbsp;';
                        else
                            html += '<img src="/images/status_tb.png" title="' + value + '">&nbsp;';

                        html += '<nobr>' + value + '</nobr>';
                        return html;
                    },
                }, config.format_fn);

                config.options = angular.extend({
                    hide_menu: true,
                    hide_default_buttons: true,
                    force_context_menu: true,
                    sorting: false,
                }, config.options);
                config.enhanced_context = true;

                config.paging = angular.extend({
                    enabled: true,
                    server_side: true,
                    page_lines: fortigateInfo.info.lines_per_page,
                    fetch: this.qlistPageFetch(type),
                }, config.paging);

                if (config.callbacks == null) { config.callbacks = {}; }
                var load_callback = config.callbacks.load;
                config.callbacks.load = function() {
                    if (angular.isFunction(load_callback)) {
                        load_callback.call(this);
                    }
                    widgets.callbacks.load.call(this);
                };
                return config;
            };
        }),

        qlistPageFetch: inject.mark(function(lang, fortigateInfo) {
            return function(type) {
                var that = this;
                return function(page_num, cb) {
                    var filter = that.facets.makeQlistFilters(that.scope.facetedSearch.model);
                    
                    var params = {
                        page: page_num,
                        count: fortigateInfo.info.lines_per_page,
                        status: type,
                        filter: JSON.stringify(filter)
                    };

                    that.get(URL_LIST, params).then(function(data) {
                        if (cb) {
                            cb(data.data);
                        }
                        var source = data.data.source;
                        var args = [0, 0].concat(source);

                        that.scope.qlistSource.length = 0;
                        that.scope.qlistSource.splice.apply(that.scope.qlistSource, args);
                        that.scope.qlistSource.totalPagedLines = data.data.total_lines;


                    }.bind(that));


                };
            };
        }),

        get: inject.mark(function($http) {
            return function(uri, params) {
                function getURL(uri, params) {
                    function serializeValue(v) {
                        if (angular.isObject(v)) {
                            return angular.isDate(v) ? v.toISOString() : angular.toJson(v);
                        }
                        return v;
                    }

                    if(uri == URL_COLUMN)
                    	return uri;
                    
                    var parts = [];
                    angular.forEach(params, function(value, key) {
                        if (value === null || angular.isUndefined(value)) return;
                        if (angular.isArray(value)) {
                            angular.forEach(value, function(v) {
                                parts.push(encodeURIComponent(key)  + '=' + encodeURIComponent(serializeValue(v)));
                            });
                        } else {
                            parts.push(encodeURIComponent(key) + '=' + encodeURIComponent(serializeValue(value)));
                        }
                    });

                    return '/rest_redir?uri='+ encodeURIComponent(uri + '?' + parts.join('&'));
                }

                var httpPromise = $http({
                    method: 'GET',
                    url: getURL(uri, params) 
                });

                var result = httpPromise.then(function(response) {
                    response.params = params;
                    return response;
                });

                return result;
            };
        }),

        initFacets: inject.mark(function(SearchFacet, Facets) {
            return function forLogType(columns, highlight) {
                var facets = this.facets = new Facets(),
                    result = facets.facetDefs.map(makeFacet),
                    selectors = result.map(pluckSelector);
                columns = (columns || []).filter(selectorNotIn(selectors));
                var extraFacets = facets.genericFacets(columns, highlight);
                facets.addFacets(extraFacets);
                return result.concat(extraFacets);

                function hasLogType(facetDef) {
                    return facetDef.meta.logTypes === true ||
                        (facetDef.meta.logTypes || []).indexOf(logType) > -1;
                }
                function makeFacet(facetDef) {
                    return new SearchFacet(angular.extend({highlight: highlight}, facetDef));
                }
                function pluckSelector(facet) { return facet.selectors.history }
                function selectorNotIn(selectors) {
                    return function(column) { return selectors.indexOf(column.selector) === -1 };
                }
            };
        }),
    };

    return function(providers, loader) {
        providers.$controller.register('ScannerIntegrationController', ScannerIntegrationController);
        return loader.initModules([
            '/ng/directives/faceted_search/faceted_search', '/ng/services/facets',
            '../directives/f-highcharts', '/ng/directives/compare_bar'
        ], module);
    };
});
