/*globals define*/
define(['module', 'angular', 'ng/services/injector', 'fweb.util/datetime'], function(module, angular, inject, util_datetime) {
    'use strict';

    function FortiviewSessions($scope, $routeParams, injector, fortiviewUtil, fortigateInfo,
                               fortiviewSearchState, fortiviewSessions, fortiviewFacets) {
        injector.injectMarked(this, {$scope: $scope});

        //FWB_CHANGE var no_realtime_regex = RegExp.prototype.test.bind(/^(web|cloud|threat$|vpn)/);
        var no_realtime_regex = RegExp.prototype.test.bind(/^(threat|country|tSource|tCountry|aPolicy)/);
        var no_historical_regex = RegExp.prototype.test.bind(/^(shaper)/);

        $scope.noSummary = true; //FWB_CHANGE
        $scope.fortiview$root.view_type = null;
        fortiviewSearchState.clear_timeframe_filter();

        if ([$routeParams.tab, $routeParams.segment].some(no_realtime_regex)) {
            fortiviewSearchState.disableRealtime();
        }

        if ([$routeParams.tab, $routeParams.segment].some(no_historical_regex)) {
            fortiviewSearchState.disableHistorical();
        }

        $scope.quarantineSourceIPColumnName = 'saddr';
        $scope.menus = {};

        this.max_values = {};
        $scope.facets = fortiviewFacets.facets;
        $scope.qlistOptions = fortiviewSessions.createQlistConfig(this.load_qlist_data);
        $scope.qlistSource = null;
        $scope.disableDrilldown = true;

        this.set_drilldown_value();
        this.set_page_title();
        this.init_watch();
        fortiviewSearchState.init_context_filters($scope);

        $scope.$on('reload', function() {
            if (fortiviewSearchState.state.timeframe === 'realtime') {
                this.load_qlist_data();
            }
            /* FWB_CHANGE */
            else
            {
                var split;
                var value =  $scope.searchState.state.timeframe;
                if (value.indexOf('custom') === 0) {
                    split = value.split(':');
                    $scope.searchState.last_period = {
                        start: split[1],
                        end: split[2]
                    };
                } else {
                    $scope.searchState.last_period = fortiviewUtil.fixTimeRange(
                        util_datetime.timeframeRange(value), fortigateInfo.info.timeinfo.offset);
                }
                $scope.logViewOptions = fortiviewFacets.getLogViewOptions("session");
            }
        }.bind(this));
        $scope.$emit('base_init');
    }

    function updateAppDrilldownValue(ss, realtime) {
        if ('application' in ss.drilldownValues && 'appName' in ss.drilldownContext) {
            ss.drilldownValues.application[0] = realtime ? ss.drilldownContext.appID :
                ss.drilldownContext.appName;
        }
    }


    FortiviewSessions.prototype.init_watch =
    inject.mark(function($scope, $location, fortiviewSearchState, fortiviewFacets,
                         fortiviewSessions) {
        var ss = fortiviewSearchState;
        return function() {
            var previous_timeframe,
                unwatchFacetModel = angular.noop;
            var update = function(state) {
                var realtime = state.timeframe === 'realtime';
                var source = realtime ? 'session' : 'history';
                $scope.logViewOptions = null;
                if (state.timeframe !== previous_timeframe) {
                    updateAppDrilldownValue(ss, realtime);
                    this.set_drilldown_value();
                    ss.searchOptions.source = source;
                    this.set_facets(source);
                    if (realtime) {
                        ss.searchOptions.entries = fortiviewSessions.getEntries;
                    } else {
                        ss.searchOptions.entries = logEntriesGetter;
                    }
                    previous_timeframe = state.timeframe;
                }
                unwatchFacetModel();
                if (realtime) {
                    this.load_qlist_data();
                } else {
                    $scope.logViewOptions = fortiviewFacets
                        .getLogViewOptions('session');
                    unwatchFacetModel = $scope
                        .$watch(
                            'logViewOptions.facetModel',
                            ss.logViewFacetModelWatchAction,
                            true);
                }
                $scope.fortiview$root.haveLogViewDetails = !!$scope.logViewOptions;

            }.bind(this);

            $scope.$watch('searchState.state', update, true);
            $scope.$watch(function() {
                return $location.url();
            }, function(url, old) {
                if (url !== old) {
                    update(ss.state);
                }
            });

            function logEntriesGetter() {
                var entries = $scope.fortiview$root.logViewEntries || [];
                return entries.map(function(entry) {
                    return tweakEntry(angular.copy(entry));
                });
                function tweakEntry(entry) {
                    var ipExpr = /^([a-f\d\.:\[\]]*).*/i;
                    //remove hostname from ip fields
                    ['srcip', 'dstip'].forEach(function(prop) {
                        if (entry[prop]) {
                            entry[prop] = entry[prop].replace(ipExpr, '$1');
                        }
                    });
                    return entry;
                }

            }
        };
    });

    FortiviewSessions.prototype.load_qlist_data = inject.mark(function($scope, fortiviewSessions) {
        return function() {
            $scope.qlistSource = fortiviewSessions.loadData();
        };
    });

    FortiviewSessions.prototype.set_facets =
    inject.mark(function($scope, $q, fortiviewSearchState, fortiviewFacets, $routeParams) {
        var ss = fortiviewSearchState;
        return function(source) {
            var primary_facet_ids = fortiviewFacets.primaryFacets($routeParams.segment),
                tab_facet_ids = fortiviewFacets.primaryFacets($routeParams.tab),
                unique_ids = primary_facet_ids.concat(tab_facet_ids);
            ss.facets = fortiviewFacets.forSource(source);
            ss.facets.forEach(function(facet) {
                if (unique_ids.indexOf(facet.id) > -1) {
                    facet.unique = true;
                }
            });
        };
    });

    FortiviewSessions.prototype.set_page_title = inject.mark(function($scope, $routeParams) {
        return function() {
            $scope.fortiview$root.drilldown_title = $routeParams.tab;
            $scope.fortiview$root.category_title = $routeParams.segment || 'Sessions';
            $scope.fortiview$root.category_title_value = decodeURIComponent(
                $routeParams.drilldownValue);
            $scope.fortiview$root.drilldown_title_value = decodeURIComponent(
                $routeParams.drilldownTabValue);
            $scope.update_title();
        };
    });

    // sets the value defined in the drilldown in the search bar on the top
    // of the page
    /* jshint maxparams:9 */
    FortiviewSessions.prototype.set_drilldown_value =
    inject.mark(function(fortiviewSearchState, fortiviewFacets, $location, ftntRoute, $route,
                         $routeParams, $scope, fortiviewUtil) {
        var ss = fortiviewSearchState;

        var addDrilldownValues = function(object, facetIds, values) {
            if (facetIds.length > 1) {
                values = fortiviewUtil.splitDrilldownValues(values);
            } else {
                values = [decodeURIComponent(values)];
            }
            facetIds.forEach(function(id, index) {
                object[id] = [values[index]];
            });
        };

        var getDrilldownValue = function(object, facetIds) {
            function getValue(id) {
                return object[id][0];
            }

            function getEscapeValue(id) {
                return fortiviewUtil.escapeDrilldownValue(object[id][0]);
            }

            return facetIds.length > 1 ? facetIds.map(getEscapeValue).join(':') :
                facetIds.map(getValue);
        };

        var getSegment = function() {
            var segment;
            if ($routeParams.segment) {
                segment = $routeParams.segment + ($routeParams.type ?
                    ('-' + $routeParams.type) : '');
            }
            return segment;
        };

        return function() {
            var drilldownValues = {};
            var segment = getSegment();
            var searchFacets = fortiviewFacets.primaryFacets(segment);
            var tabFacets = fortiviewFacets.primaryFacets($routeParams.tab);

            if (searchFacets.length) {
                addDrilldownValues(drilldownValues, searchFacets,
                                   decodeURIComponent($routeParams.drilldownValue));
            }
            if (tabFacets.length) {
                addDrilldownValues(drilldownValues, tabFacets,
                                   decodeURIComponent($routeParams.drilldownTabValue));
            }
            ss.drilldownValues = drilldownValues;

            $scope.$watch('searchState.drilldownValues', function(values, old) {
                var originalPath, routeParams;
                var additional = 0;
                var missing = [];
                if (values !== old) {
                    Object.keys(old).forEach(function(id) {
                        if (!values[id]) {
                            missing.push(id);
                        }
                    });
                    if (!missing.length) {
                        originalPath = $route.current.$$route.originalPath;
                        routeParams = angular.copy($routeParams);
                        routeParams.drilldownValue = getDrilldownValue(values, searchFacets);
                        routeParams.drilldownTabValue = getDrilldownValue(values, tabFacets);
                        $location.path(ftntRoute.interpolate(originalPath, routeParams));
                    } else if ($scope.canGoUp()) {
                        missing.forEach(function(id) {
                            if (tabFacets.indexOf(id) < 0) {
                                additional = 1;
                            }
                        });
                        $scope.goUp(additional);
                    }
                }
            }, true);
        };
    });

    return function register(providers, loader) {
        providers.$controller.register('FortiviewSessions', FortiviewSessions);
        return loader.initModules([
            '../services/routeMetadata', '../services/facets', '../services/sessions',
            '../services/util',
            //FWB_CHANGE '/ng/directives/menu/quarantine-options',
            '/ng/log/view/f-log-view'
        ], module);
    };

});
